/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.graph;

import de.grogra.graph.Attribute;
import de.grogra.graph.AttributeChangeEvent;
import de.grogra.graph.AttributeChangeListener;
import de.grogra.graph.ChangeBoundaryListener;
import de.grogra.graph.EdgeChangeListener;
import de.grogra.graph.GraphState;
import de.grogra.graph.ObjectMap;
import de.grogra.reflect.FieldChain;
import de.grogra.xl.util.ObjectList;
import java.util.Comparator;

public class EventSupport {
    static final Integer ACL = 0;
    static final Integer ECL = 1;
    static final Integer CBL = 2;
    static Comparator CBL_COMPARATOR = new Comparator(){

        public int compare(Object object, Object object2) {
            return ((ChangeBoundaryListener)object).getPriority() - ((ChangeBoundaryListener)object2).getPriority();
        }
    };
    Object[] listeners = null;
    ObjectMap objectListeners;
    final ObjectList listenersCopy = new ObjectList();
    private final ObjectList eventPool = new ObjectList();

    static Object[] addListener(Integer n, Object[] objectArray, Object object, Comparator comparator) {
        block14: {
            int n2;
            int n3;
            if (objectArray != null) {
                n3 = -1;
                n2 = objectArray.length;
                while (n2 > 0) {
                    if (objectArray[--n2] == object & objectArray[--n2] == n) {
                        return objectArray;
                    }
                    if (objectArray[n2] != null) continue;
                    n3 = n2;
                }
                if (n3 < 0) {
                    Object[] objectArray2 = objectArray;
                    n3 = objectArray.length;
                    objectArray = new Object[n3 + 4];
                    System.arraycopy(objectArray2, 0, objectArray, 0, n3);
                }
            } else {
                objectArray = new Object[4];
                n3 = 0;
            }
            objectArray[n3] = n;
            objectArray[n3 + 1] = object;
            if (comparator == null) break block14;
            n2 = 0;
            while (n2 < objectArray.length) {
                if (objectArray[n2] == n) {
                    if (objectArray[++n2] != object && comparator.compare(object, objectArray[n2]) < 0) {
                        --n2;
                        break;
                    }
                    ++n2;
                    continue;
                }
                n2 += 2;
            }
            if (n2 < n3) {
                while (n2 <= n3) {
                    if (objectArray[n2] == n) {
                        Object object2 = objectArray[n2 + 1];
                        objectArray[n2 + 1] = object;
                        object = object2;
                    }
                    n2 += 2;
                }
            } else {
                n2 -= 2;
                while (n2 >= n3) {
                    if (objectArray[n2] == n) {
                        Object object3 = objectArray[n2 + 1];
                        objectArray[n2 + 1] = object;
                        object = object3;
                    }
                    n2 -= 2;
                }
            }
        }
        return objectArray;
    }

    static Object[] removeListener(Integer n, Object[] objectArray, Object object) {
        if (objectArray != null) {
            int n2 = objectArray.length;
            int n3 = n2 - 2;
            while (n2 > 0) {
                if (objectArray[--n2] == object) {
                    if (objectArray[--n2] != n) continue;
                    if (n2 == 0 && (n3 == 0 || objectArray[2] == null)) {
                        return null;
                    }
                    if (n2 < n3) {
                        System.arraycopy(objectArray, n2 + 2, objectArray, n2, n3 - n2);
                    }
                    objectArray[n3] = null;
                    objectArray[n3 + 1] = null;
                    return objectArray;
                }
                --n2;
            }
        }
        return objectArray;
    }

    public EventSupport(ObjectMap objectMap) {
        this.objectListeners = objectMap;
    }

    protected void finalize() {
        this.listeners = null;
        if (this.objectListeners != null) {
            this.objectListeners.dispose();
        }
    }

    public synchronized void addChangeBoundaryListener(ChangeBoundaryListener changeBoundaryListener) {
        this.listeners = EventSupport.addListener(CBL, this.listeners, changeBoundaryListener, CBL_COMPARATOR);
    }

    public synchronized void removeChangeBoundaryListener(ChangeBoundaryListener changeBoundaryListener) {
        this.listeners = EventSupport.removeListener(CBL, this.listeners, changeBoundaryListener);
    }

    public synchronized void addAttributeChangeListener(AttributeChangeListener attributeChangeListener) {
        this.listeners = EventSupport.addListener(ACL, this.listeners, attributeChangeListener, null);
    }

    public synchronized void addEdgeChangeListener(EdgeChangeListener edgeChangeListener) {
        this.listeners = EventSupport.addListener(ECL, this.listeners, edgeChangeListener, null);
    }

    public synchronized void removeAttributeChangeListener(AttributeChangeListener attributeChangeListener) {
        this.listeners = EventSupport.removeListener(ACL, this.listeners, attributeChangeListener);
    }

    public synchronized void removeEdgeChangeListener(EdgeChangeListener edgeChangeListener) {
        this.listeners = EventSupport.removeListener(ECL, this.listeners, edgeChangeListener);
    }

    synchronized int copyListeners(Integer n, Object[] objectArray) {
        int n2 = this.listenersCopy.size;
        if (objectArray == null) {
            return n2;
        }
        int n3 = objectArray.length;
        while (n3 > 0) {
            Object object = objectArray[--n3];
            if (objectArray[--n3] != n) continue;
            this.listenersCopy.add(object);
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireBeginChange(GraphState graphState) {
        int n = this.copyListeners(CBL, this.listeners);
        try {
            while (this.listenersCopy.size > n) {
                ((ChangeBoundaryListener)this.listenersCopy.pop()).beginChange(graphState);
            }
        }
        finally {
            this.listenersCopy.setSize(n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireEndChange(GraphState graphState) {
        int n = this.copyListeners(CBL, this.listeners);
        try {
            while (this.listenersCopy.size > n) {
                ((ChangeBoundaryListener)this.listenersCopy.pop()).endChange(graphState);
            }
        }
        finally {
            this.listenersCopy.setSize(n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireAttributeChanged(Integer n, Object[] objectArray, AttributeChangeEvent attributeChangeEvent) {
        if (objectArray == null) {
            return;
        }
        int n2 = this.copyListeners(n, objectArray);
        try {
            while (this.listenersCopy.size > n2) {
                ((AttributeChangeListener)this.listenersCopy.pop()).attributeChanged(attributeChangeEvent);
            }
        }
        finally {
            this.listenersCopy.setSize(n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireEdgeChanged(Integer n, Object[] objectArray, Object object, Object object2, Object object3, GraphState graphState) {
        if (objectArray == null) {
            return;
        }
        int n2 = this.copyListeners(n, objectArray);
        try {
            while (this.listenersCopy.size > n2) {
                ((EdgeChangeListener)this.listenersCopy.pop()).edgeChanged(object, object2, object3, graphState);
            }
        }
        finally {
            this.listenersCopy.setSize(n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireEdgeChanged(Object object, Object object2, Object object3, GraphState graphState) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3;
        EventSupport eventSupport = this;
        synchronized (eventSupport) {
            objectArray3 = (Object[])this.objectListeners.getObject(object, true);
            objectArray2 = (Object[])this.objectListeners.getObject(object2, true);
            objectArray = object3 == null ? null : (Object[])this.objectListeners.getObject(object3, false);
        }
        if (objectArray != null) {
            this.fireEdgeChanged(ECL, objectArray, object, object2, object3, graphState);
        }
        if (objectArray3 != null) {
            this.fireEdgeChanged(ECL, objectArray3, object, object2, object3, graphState);
        }
        if (objectArray2 != null) {
            this.fireEdgeChanged(ECL, objectArray2, object, object2, object3, graphState);
        }
        objectArray3 = this.listeners;
        if (this.listeners != null) {
            this.fireEdgeChanged(ECL, objectArray3, object, object2, object3, graphState);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireAttributeChanged(Object object, boolean bl, Attribute attribute, FieldChain fieldChain, int[] nArray, GraphState graphState) {
        Object[] objectArray;
        Object object2 = this;
        synchronized (object2) {
            objectArray = (Object[])this.objectListeners.getObject(object, bl);
        }
        object2 = null;
        if (objectArray != null) {
            object2 = this.eventPool.isEmpty() ? new AttributeChangeEvent(graphState) : (AttributeChangeEvent)this.eventPool.pop();
            ((AttributeChangeEvent)object2).object = object;
            ((AttributeChangeEvent)object2).node = bl;
            ((AttributeChangeEvent)object2).attr = attribute;
            ((AttributeChangeEvent)object2).field = fieldChain;
            ((AttributeChangeEvent)object2).indices = nArray;
            ((AttributeChangeEvent)object2).dependent = attribute != null ? graphState.getGraph().getDependent(object, bl, attribute) : null;
            this.fireAttributeChanged(ACL, objectArray, (AttributeChangeEvent)object2);
        }
        objectArray = this.listeners;
        if (this.listeners != null) {
            if (object2 == null) {
                object2 = this.eventPool.isEmpty() ? new AttributeChangeEvent(graphState) : (AttributeChangeEvent)this.eventPool.pop();
                ((AttributeChangeEvent)object2).object = object;
                ((AttributeChangeEvent)object2).node = bl;
                ((AttributeChangeEvent)object2).attr = attribute;
                ((AttributeChangeEvent)object2).field = fieldChain;
                ((AttributeChangeEvent)object2).indices = nArray;
                ((AttributeChangeEvent)object2).dependent = attribute != null ? graphState.getGraph().getDependent(object, bl, attribute) : null;
            }
            this.fireAttributeChanged(ACL, objectArray, (AttributeChangeEvent)object2);
        }
        if (object2 != null) {
            this.eventPool.push(object2);
        }
    }

    private synchronized void addListener(Object object, boolean bl, Integer n, Object objectArray) {
        Object[] objectArray2 = (Object[])this.objectListeners.getObject(object, bl);
        if (objectArray2 != (objectArray = EventSupport.addListener(n, objectArray2, objectArray, null))) {
            this.objectListeners.putObject(object, bl, objectArray);
        }
    }

    private synchronized void removeListener(Object object, boolean bl, Integer n, Object objectArray) {
        Object[] objectArray2 = (Object[])this.objectListeners.getObject(object, bl);
        if (objectArray2 != (objectArray = EventSupport.removeListener(n, objectArray2, objectArray))) {
            this.objectListeners.putObject(object, bl, objectArray);
        }
    }

    public void addAttributeChangeListener(Object object, boolean bl, AttributeChangeListener attributeChangeListener) {
        this.addListener(object, bl, ACL, attributeChangeListener);
    }

    public void removeAttributeChangeListener(Object object, boolean bl, AttributeChangeListener attributeChangeListener) {
        this.removeListener(object, bl, ACL, attributeChangeListener);
    }

    public void addEdgeChangeListener(Object object, boolean bl, EdgeChangeListener edgeChangeListener) {
        this.addListener(object, bl, ECL, edgeChangeListener);
    }

    public void removeEdgeChangeListener(Object object, boolean bl, EdgeChangeListener edgeChangeListener) {
        this.removeListener(object, bl, ECL, edgeChangeListener);
    }

    public class Queue
    extends ObjectList {
        public void postAttributeChanged(Object object, boolean bl, Attribute attribute, FieldChain fieldChain, int[] nArray) {
            int n = this.size;
            this.setSize(n + 5);
            this.elements[n] = bl ? ACL : this;
            this.elements[n + 1] = object;
            this.elements[n + 2] = attribute;
            this.elements[n + 3] = fieldChain;
            this.elements[n + 4] = nArray == null || nArray.length == 0 ? nArray : (int[])nArray.clone();
        }

        public void postEdgeChanged(Object object, Object object2, Object object3) {
            int n = this.size;
            this.setSize(n + 3);
            this.elements[n] = object;
            this.elements[n + 1] = object2;
            this.elements[n + 2] = object3;
        }

        private GraphState clearIfProcessed(GraphState graphState, int n) {
            if (n == this.size) {
                this.clear();
            }
            return graphState;
        }

        public void fire(GraphState graphState, boolean bl) {
            if (this.size == 0) {
                return;
            }
            if (bl) {
                EventSupport.this.fireBeginChange(graphState);
            }
            int n = 0;
            while (n < this.size) {
                Object object = this.elements[n];
                boolean bl2 = object == ACL;
                if (bl2 || object == this) {
                    EventSupport.this.fireAttributeChanged(this.elements[n + 1], bl2, (Attribute)this.elements[n + 2], (FieldChain)this.elements[n + 3], (int[])this.elements[(n += 5) + 4], this.clearIfProcessed(graphState, n));
                    continue;
                }
                EventSupport.this.fireEdgeChanged(this.elements[n], this.elements[n + 1], this.elements[n + 2], this.clearIfProcessed(graphState, n += 3));
            }
            this.clear();
            if (bl) {
                EventSupport.this.fireEndChange(graphState);
            }
        }
    }
}

