/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.graph;

import de.grogra.graph.ArrayPath;
import de.grogra.graph.Attribute;
import de.grogra.graph.BooleanAttribute;
import de.grogra.graph.BooleanAttributeAccessor;
import de.grogra.graph.ByteAttribute;
import de.grogra.graph.ByteAttributeAccessor;
import de.grogra.graph.CharAttribute;
import de.grogra.graph.CharAttributeAccessor;
import de.grogra.graph.DoubleAttribute;
import de.grogra.graph.DoubleAttributeAccessor;
import de.grogra.graph.FloatAttribute;
import de.grogra.graph.FloatAttributeAccessor;
import de.grogra.graph.Graph;
import de.grogra.graph.IntAttribute;
import de.grogra.graph.IntAttributeAccessor;
import de.grogra.graph.LongAttribute;
import de.grogra.graph.LongAttributeAccessor;
import de.grogra.graph.ObjectAttribute;
import de.grogra.graph.ObjectAttributeAccessor;
import de.grogra.graph.Path;
import de.grogra.graph.ShortAttribute;
import de.grogra.graph.ShortAttributeAccessor;
import de.grogra.reflect.FieldChain;
import de.grogra.util.Int2ObjectMap;
import de.grogra.util.NoSuchKeyException;
import de.grogra.util.ThreadContext;
import de.grogra.xl.util.EHashMap;
import de.grogra.xl.util.IntHashMap;
import de.grogra.xl.util.IntList;
import de.grogra.xl.util.ObjectList;
import java.lang.ref.WeakReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class GraphState {
    private static int nextPropertyId = 0;
    final ObjectList treeAttributeStack = new ObjectList();
    final IntHashMap attributeMap;
    private Graph graph;
    private ThreadContext ctx;
    private boolean disposed;
    private final Int2ObjectMap userProperties = new Int2ObjectMap();
    private int instancingCount = 0;
    private boolean instancingBegin = false;
    private ArrayPath instancingPath;
    private final ObjectList instanceAttributes = new ObjectList(32);
    private final IntList instanceAttributesIndex = new IntList(32);
    private final IntList instancingPoints = new IntList(32);
    private int curInstanceIndex = -1;
    private Object curInstance = null;
    private int curAttributeBegin = -1;
    private int curAttributeEnd = -1;
    private final EHashMap.IdentityEntry[] cachePool = new EHashMap.IdentityEntry[1];
    private final EHashMap.IdentityEntry cacheKey = new EHashMap.IdentityEntry();
    private ObjectContext objectContext = new ObjectContext(null, false, 0, this.cachePool, this.cacheKey);

    public static synchronized int allocatePropertyId() {
        return nextPropertyId++;
    }

    protected GraphState() {
        this.attributeMap = new IntHashMap(64, 0.2f);
    }

    GraphState(GraphState graphState) {
        this.attributeMap = graphState.attributeMap;
    }

    protected void initialize(Graph graph, ThreadContext threadContext) {
        this.graph = graph;
        this.ctx = threadContext;
        this.instancingPath = new ArrayPath(graph);
        if (graph.getStateMap().put(threadContext, new WeakReference<GraphState>(this)) != null) {
            throw new IllegalStateException();
        }
    }

    public void dispose() {
        if (this.disposed) {
            return;
        }
        this.disposed = true;
        this.graph.getStateMap().remove(this.ctx);
        this.graph = null;
        this.ctx = null;
    }

    protected void finalize() {
        this.dispose();
    }

    public Object setUserProperty(int n, Object object) {
        return this.userProperties.synchronizedPut(n, object);
    }

    public Object getUserProperty(int n) {
        return this.userProperties.synchronizedGet(n);
    }

    public GraphState forContext(ThreadContext threadContext) {
        GraphState graphState = GraphState.get(this.graph, threadContext);
        return graphState != null ? graphState : this.createDelegate(threadContext);
    }

    protected abstract GraphState createDelegate(ThreadContext var1);

    public static GraphState get(Graph graph, ThreadContext threadContext) {
        WeakReference weakReference = (WeakReference)graph.getStateMap().get(threadContext);
        return weakReference != null ? (GraphState)weakReference.get() : null;
    }

    public static GraphState current(Graph graph) {
        return GraphState.get(graph, ThreadContext.current());
    }

    public final Graph getGraph() {
        return this.graph;
    }

    public final ThreadContext getContext() {
        return this.ctx;
    }

    public void setObjectContext(Object object, boolean bl) {
        this.objectContext.object = object;
        this.objectContext.asNode = bl;
        if (this.curInstanceIndex > 0) {
            if (object != null && bl != ((this.curInstanceIndex & 1) == 0)) {
                throw new IllegalStateException();
            }
            this.objectContext.instanceIndex = this.curInstanceIndex;
        } else {
            this.objectContext.instanceIndex = 0;
        }
        this.objectContext.cache.clear();
        this.objectContext.stamp = this.graph.getStamp();
    }

    public ObjectContext getObjectContext() {
        if (this.objectContext.stamp != this.graph.getStamp()) {
            this.objectContext.stamp = this.graph.getStamp();
            this.objectContext.cache.clear();
        }
        return this.objectContext;
    }

    public void setObjectContext(ObjectContext objectContext) {
        this.objectContext = objectContext;
        this.objectContext.stamp = this.graph.getStamp();
        if (this.instancingCount > 0) {
            this.moveToInstance(objectContext.instanceIndex);
        }
    }

    public ObjectContext createObjectState(Object object, boolean bl) {
        if (this.curInstanceIndex > 0 && bl != ((this.curInstanceIndex & 1) == 0)) {
            throw new IllegalStateException();
        }
        return new ObjectContext(object, bl, this.curInstanceIndex, this.cachePool, this.cacheKey);
    }

    public abstract void setEdgeBits(Object var1, int var2);

    public abstract void fireAttributeChanged(Object var1, boolean var2, Attribute var3, FieldChain var4, int[] var5);

    protected abstract void fireEdgeChanged(Object var1, Object var2, Object var3);

    public abstract boolean containsInTree(Object var1, boolean var2);

    public Path getInstancingPath() {
        return this.instancingCount > 0 ? this.instancingPath : null;
    }

    public int getInstancingPathIndex() {
        return this.curInstanceIndex;
    }

    void setInstancingTreeAttribute(Attribute attribute, int n, Object object) {
    }

    Object getInstancingTreeAttribute(Attribute attribute, int n) {
        return null;
    }

    boolean wasTreeAttributeValid() {
        return false;
    }

    public void beginInstancing(Object object, long l) {
        if (++this.instancingCount == 1) {
            this.instancingPath.pushNode(object, l);
            this.instanceAttributes.clear();
            this.curInstanceIndex = 0;
            this.curAttributeEnd = 0;
        }
        this.instancingPoints.push(this.instancingPath.getNodeAndEdgeCount());
        this.instancingBegin = true;
    }

    public void endInstancing() {
        int n;
        this.instancingBegin = false;
        int n2 = this.instancingPath.getNodeAndEdgeCount() - this.instancingPoints.pop();
        if (n2 > 0) {
            while (n2 > 0) {
                this.instancingPath.popNode();
                this.instancingPath.popEdgeSet();
                n2 -= 2;
            }
            this.curAttributeBegin = this.instanceAttributesIndex.get(this.instancingPath.getNodeAndEdgeCount() + 2 >> 1);
        }
        if ((n = this.instancingPath.getNodeAndEdgeCount() - 1) > 0) {
            this.moveToInstance(n);
            this.instanceAttributes.setSize(this.curAttributeEnd);
        } else {
            this.curInstanceIndex = -1;
            this.curInstance = null;
            this.instanceAttributes.clear();
        }
        if (--this.instancingCount == 0) {
            this.instancingPath.popNode();
        }
    }

    public void instantiate(Object object, boolean bl, long l) {
        if (this.curInstanceIndex + 1 != this.instancingPath.getNodeAndEdgeCount() || (this.curInstanceIndex & 1) == 0 == bl) {
            throw new IllegalStateException();
        }
        if (bl) {
            this.instancingPath.pushNode(object, l);
        } else {
            this.instancingPath.pushEdgeSet(object, l, this.instancingBegin);
            this.instancingBegin = false;
        }
        this.curInstance = object;
        this.curAttributeBegin = this.curAttributeEnd;
        this.instanceAttributesIndex.set(++this.curInstanceIndex, this.curAttributeBegin);
    }

    public void instantiateEdge(int n, boolean bl, long l) {
        if (this.curInstanceIndex + 1 != this.instancingPath.getNodeAndEdgeCount() || (this.curInstanceIndex & 1) != 0) {
            throw new IllegalStateException();
        }
        this.instancingPath.pushEdges(n, bl, l, this.instancingBegin);
        this.instancingBegin = false;
        this.curInstance = null;
        this.curAttributeBegin = this.curAttributeEnd;
        this.instanceAttributesIndex.set(++this.curInstanceIndex, this.curAttributeBegin);
    }

    public void deinstantiate() {
        if (this.curInstanceIndex + 1 != this.instancingPath.getNodeAndEdgeCount()) {
            throw new IllegalStateException();
        }
        if ((this.curInstanceIndex & 1) == 0) {
            this.instancingPath.popNode();
        } else {
            this.instancingPath.popEdgeSet();
        }
        this.moveToInstance(this.curInstanceIndex - 1);
    }

    public void setInstanceAttribute(Attribute attribute, Object object) {
        if (this.instanceAttributes.size() != this.curAttributeEnd) {
            throw new IllegalStateException();
        }
        this.instanceAttributes.push(attribute).push((Attribute)object);
        this.curAttributeEnd += 2;
    }

    public void moveToPreviousInstance() {
        int n = this.curInstanceIndex - 1;
        if (n < 0) {
            throw new IllegalStateException();
        }
        this.curAttributeEnd = this.curAttributeBegin;
        this.curAttributeBegin = this.instanceAttributesIndex.get(n);
        this.curInstanceIndex = n;
        this.curInstance = this.instancingPath.getObject(n);
    }

    public void moveToNextInstance() {
        int n = this.curInstanceIndex + 1;
        if (n >= this.instancingPath.getNodeAndEdgeCount()) {
            throw new IllegalStateException();
        }
        this.curAttributeBegin = this.curAttributeEnd;
        this.curAttributeEnd = n + 1 == this.instancingPath.getNodeAndEdgeCount() ? this.instanceAttributes.size() : this.instanceAttributesIndex.get(n + 1);
        this.curInstanceIndex = n;
        this.curInstance = this.instancingPath.getObject(n);
    }

    public void moveToInstance(int n) {
        if (n < 0 || n >= this.instancingPath.getNodeAndEdgeCount()) {
            throw new IllegalStateException();
        }
        this.curAttributeBegin = this.instanceAttributesIndex.get(n);
        this.curAttributeEnd = n + 1 == this.instancingPath.getNodeAndEdgeCount() ? this.instanceAttributes.size() : this.instanceAttributesIndex.get(n + 1);
        this.curInstanceIndex = n;
        this.curInstance = this.instancingPath.getObject(n);
    }

    public <T> T getObject(Object object, boolean bl, ObjectAttribute<T> objectAttribute) {
        return this.getObject(object, bl, null, objectAttribute);
    }

    public boolean checkBoolean(Object object, boolean bl, BooleanAttribute booleanAttribute, boolean bl2) {
        if (this.instancingCount == 0 || object != this.curInstance || bl != ((this.curInstanceIndex & 1) == 0)) {
            return bl2;
        }
        Object[] objectArray = this.instanceAttributes.elements;
        for (int i = this.curAttributeBegin; i < this.curAttributeEnd; i += 2) {
            if (booleanAttribute != objectArray[i]) continue;
            return (Boolean)objectArray[i + 1];
        }
        return bl2;
    }

    public boolean getBooleanDefault(Object object, boolean bl, BooleanAttribute booleanAttribute, boolean bl2) {
        Object[] objectArray;
        if (booleanAttribute.isDerived()) {
            return booleanAttribute.getDerived(object, bl, this);
        }
        if (this.instancingCount > 0 && object == this.curInstance && bl == ((this.curInstanceIndex & 1) == 0)) {
            objectArray = this.instanceAttributes.elements;
            for (int i = this.curAttributeBegin; i < this.curAttributeEnd; i += 2) {
                if (booleanAttribute != objectArray[i]) continue;
                return (Boolean)objectArray[i + 1];
            }
        }
        if (object != null && (objectArray = this.graph.getAccessor(object, bl, booleanAttribute)) != null) {
            return ((BooleanAttributeAccessor)objectArray).getBoolean(object, this);
        }
        return bl2;
    }

    public boolean getBoolean(Object object, boolean bl, BooleanAttribute booleanAttribute) {
        Object[] objectArray;
        if (booleanAttribute.isDerived()) {
            return booleanAttribute.getDerived(object, bl, this);
        }
        if (this.instancingCount > 0 && object == this.curInstance && bl == ((this.curInstanceIndex & 1) == 0)) {
            objectArray = this.instanceAttributes.elements;
            for (int i = this.curAttributeBegin; i < this.curAttributeEnd; i += 2) {
                if (booleanAttribute != objectArray[i]) continue;
                return (Boolean)objectArray[i + 1];
            }
        }
        if (object != null && (objectArray = this.graph.getAccessor(object, bl, booleanAttribute)) != null) {
            return ((BooleanAttributeAccessor)objectArray).getBoolean(object, this);
        }
        throw new NoSuchKeyException(object, booleanAttribute);
    }

    public byte checkByte(Object object, boolean bl, ByteAttribute byteAttribute, byte by) {
        if (this.instancingCount == 0 || object != this.curInstance || bl != ((this.curInstanceIndex & 1) == 0)) {
            return by;
        }
        Object[] objectArray = this.instanceAttributes.elements;
        for (int i = this.curAttributeBegin; i < this.curAttributeEnd; i += 2) {
            if (byteAttribute != objectArray[i]) continue;
            return ((Number)objectArray[i + 1]).byteValue();
        }
        return by;
    }

    public byte getByteDefault(Object object, boolean bl, ByteAttribute byteAttribute, byte by) {
        Object[] objectArray;
        if (byteAttribute.isDerived()) {
            return byteAttribute.getDerived(object, bl, this);
        }
        if (this.instancingCount > 0 && object == this.curInstance && bl == ((this.curInstanceIndex & 1) == 0)) {
            objectArray = this.instanceAttributes.elements;
            for (int i = this.curAttributeBegin; i < this.curAttributeEnd; i += 2) {
                if (byteAttribute != objectArray[i]) continue;
                return ((Number)objectArray[i + 1]).byteValue();
            }
        }
        if (object != null && (objectArray = this.graph.getAccessor(object, bl, byteAttribute)) != null) {
            return ((ByteAttributeAccessor)objectArray).getByte(object, this);
        }
        return by;
    }

    public byte getByte(Object object, boolean bl, ByteAttribute byteAttribute) {
        Object[] objectArray;
        if (byteAttribute.isDerived()) {
            return byteAttribute.getDerived(object, bl, this);
        }
        if (this.instancingCount > 0 && object == this.curInstance && bl == ((this.curInstanceIndex & 1) == 0)) {
            objectArray = this.instanceAttributes.elements;
            for (int i = this.curAttributeBegin; i < this.curAttributeEnd; i += 2) {
                if (byteAttribute != objectArray[i]) continue;
                return ((Number)objectArray[i + 1]).byteValue();
            }
        }
        if (object != null && (objectArray = this.graph.getAccessor(object, bl, byteAttribute)) != null) {
            return ((ByteAttributeAccessor)objectArray).getByte(object, this);
        }
        throw new NoSuchKeyException(object, byteAttribute);
    }

    public short checkShort(Object object, boolean bl, ShortAttribute shortAttribute, short s) {
        if (this.instancingCount == 0 || object != this.curInstance || bl != ((this.curInstanceIndex & 1) == 0)) {
            return s;
        }
        Object[] objectArray = this.instanceAttributes.elements;
        for (int i = this.curAttributeBegin; i < this.curAttributeEnd; i += 2) {
            if (shortAttribute != objectArray[i]) continue;
            return ((Number)objectArray[i + 1]).shortValue();
        }
        return s;
    }

    public short getShortDefault(Object object, boolean bl, ShortAttribute shortAttribute, short s) {
        Object[] objectArray;
        if (shortAttribute.isDerived()) {
            return shortAttribute.getDerived(object, bl, this);
        }
        if (this.instancingCount > 0 && object == this.curInstance && bl == ((this.curInstanceIndex & 1) == 0)) {
            objectArray = this.instanceAttributes.elements;
            for (int i = this.curAttributeBegin; i < this.curAttributeEnd; i += 2) {
                if (shortAttribute != objectArray[i]) continue;
                return ((Number)objectArray[i + 1]).shortValue();
            }
        }
        if (object != null && (objectArray = this.graph.getAccessor(object, bl, shortAttribute)) != null) {
            return ((ShortAttributeAccessor)objectArray).getShort(object, this);
        }
        return s;
    }

    public short getShort(Object object, boolean bl, ShortAttribute shortAttribute) {
        Object[] objectArray;
        if (shortAttribute.isDerived()) {
            return shortAttribute.getDerived(object, bl, this);
        }
        if (this.instancingCount > 0 && object == this.curInstance && bl == ((this.curInstanceIndex & 1) == 0)) {
            objectArray = this.instanceAttributes.elements;
            for (int i = this.curAttributeBegin; i < this.curAttributeEnd; i += 2) {
                if (shortAttribute != objectArray[i]) continue;
                return ((Number)objectArray[i + 1]).shortValue();
            }
        }
        if (object != null && (objectArray = this.graph.getAccessor(object, bl, shortAttribute)) != null) {
            return ((ShortAttributeAccessor)objectArray).getShort(object, this);
        }
        throw new NoSuchKeyException(object, shortAttribute);
    }

    public char checkChar(Object object, boolean bl, CharAttribute charAttribute, char c) {
        if (this.instancingCount == 0 || object != this.curInstance || bl != ((this.curInstanceIndex & 1) == 0)) {
            return c;
        }
        Object[] objectArray = this.instanceAttributes.elements;
        for (int i = this.curAttributeBegin; i < this.curAttributeEnd; i += 2) {
            if (charAttribute != objectArray[i]) continue;
            return ((Character)objectArray[i + 1]).charValue();
        }
        return c;
    }

    public char getCharDefault(Object object, boolean bl, CharAttribute charAttribute, char c) {
        Object[] objectArray;
        if (charAttribute.isDerived()) {
            return charAttribute.getDerived(object, bl, this);
        }
        if (this.instancingCount > 0 && object == this.curInstance && bl == ((this.curInstanceIndex & 1) == 0)) {
            objectArray = this.instanceAttributes.elements;
            for (int i = this.curAttributeBegin; i < this.curAttributeEnd; i += 2) {
                if (charAttribute != objectArray[i]) continue;
                return ((Character)objectArray[i + 1]).charValue();
            }
        }
        if (object != null && (objectArray = this.graph.getAccessor(object, bl, charAttribute)) != null) {
            return ((CharAttributeAccessor)objectArray).getChar(object, this);
        }
        return c;
    }

    public char getChar(Object object, boolean bl, CharAttribute charAttribute) {
        Object[] objectArray;
        if (charAttribute.isDerived()) {
            return charAttribute.getDerived(object, bl, this);
        }
        if (this.instancingCount > 0 && object == this.curInstance && bl == ((this.curInstanceIndex & 1) == 0)) {
            objectArray = this.instanceAttributes.elements;
            for (int i = this.curAttributeBegin; i < this.curAttributeEnd; i += 2) {
                if (charAttribute != objectArray[i]) continue;
                return ((Character)objectArray[i + 1]).charValue();
            }
        }
        if (object != null && (objectArray = this.graph.getAccessor(object, bl, charAttribute)) != null) {
            return ((CharAttributeAccessor)objectArray).getChar(object, this);
        }
        throw new NoSuchKeyException(object, charAttribute);
    }

    public int checkInt(Object object, boolean bl, IntAttribute intAttribute, int n) {
        if (this.instancingCount == 0 || object != this.curInstance || bl != ((this.curInstanceIndex & 1) == 0)) {
            return n;
        }
        Object[] objectArray = this.instanceAttributes.elements;
        for (int i = this.curAttributeBegin; i < this.curAttributeEnd; i += 2) {
            if (intAttribute != objectArray[i]) continue;
            return ((Number)objectArray[i + 1]).intValue();
        }
        return n;
    }

    public int getIntDefault(Object object, boolean bl, IntAttribute intAttribute, int n) {
        Object[] objectArray;
        if (intAttribute.isDerived()) {
            return intAttribute.getDerived(object, bl, this);
        }
        if (this.instancingCount > 0 && object == this.curInstance && bl == ((this.curInstanceIndex & 1) == 0)) {
            objectArray = this.instanceAttributes.elements;
            for (int i = this.curAttributeBegin; i < this.curAttributeEnd; i += 2) {
                if (intAttribute != objectArray[i]) continue;
                return ((Number)objectArray[i + 1]).intValue();
            }
        }
        if (object != null && (objectArray = this.graph.getAccessor(object, bl, intAttribute)) != null) {
            return ((IntAttributeAccessor)objectArray).getInt(object, this);
        }
        return n;
    }

    public int getInt(Object object, boolean bl, IntAttribute intAttribute) {
        Object[] objectArray;
        if (intAttribute.isDerived()) {
            return intAttribute.getDerived(object, bl, this);
        }
        if (this.instancingCount > 0 && object == this.curInstance && bl == ((this.curInstanceIndex & 1) == 0)) {
            objectArray = this.instanceAttributes.elements;
            for (int i = this.curAttributeBegin; i < this.curAttributeEnd; i += 2) {
                if (intAttribute != objectArray[i]) continue;
                return ((Number)objectArray[i + 1]).intValue();
            }
        }
        if (object != null && (objectArray = this.graph.getAccessor(object, bl, intAttribute)) != null) {
            return ((IntAttributeAccessor)objectArray).getInt(object, this);
        }
        throw new NoSuchKeyException(object, intAttribute);
    }

    public long checkLong(Object object, boolean bl, LongAttribute longAttribute, long l) {
        if (this.instancingCount == 0 || object != this.curInstance || bl != ((this.curInstanceIndex & 1) == 0)) {
            return l;
        }
        Object[] objectArray = this.instanceAttributes.elements;
        for (int i = this.curAttributeBegin; i < this.curAttributeEnd; i += 2) {
            if (longAttribute != objectArray[i]) continue;
            return ((Number)objectArray[i + 1]).longValue();
        }
        return l;
    }

    public long getLongDefault(Object object, boolean bl, LongAttribute longAttribute, long l) {
        Object[] objectArray;
        if (longAttribute.isDerived()) {
            return longAttribute.getDerived(object, bl, this);
        }
        if (this.instancingCount > 0 && object == this.curInstance && bl == ((this.curInstanceIndex & 1) == 0)) {
            objectArray = this.instanceAttributes.elements;
            for (int i = this.curAttributeBegin; i < this.curAttributeEnd; i += 2) {
                if (longAttribute != objectArray[i]) continue;
                return ((Number)objectArray[i + 1]).longValue();
            }
        }
        if (object != null && (objectArray = this.graph.getAccessor(object, bl, longAttribute)) != null) {
            return ((LongAttributeAccessor)objectArray).getLong(object, this);
        }
        return l;
    }

    public long getLong(Object object, boolean bl, LongAttribute longAttribute) {
        Object[] objectArray;
        if (longAttribute.isDerived()) {
            return longAttribute.getDerived(object, bl, this);
        }
        if (this.instancingCount > 0 && object == this.curInstance && bl == ((this.curInstanceIndex & 1) == 0)) {
            objectArray = this.instanceAttributes.elements;
            for (int i = this.curAttributeBegin; i < this.curAttributeEnd; i += 2) {
                if (longAttribute != objectArray[i]) continue;
                return ((Number)objectArray[i + 1]).longValue();
            }
        }
        if (object != null && (objectArray = this.graph.getAccessor(object, bl, longAttribute)) != null) {
            return ((LongAttributeAccessor)objectArray).getLong(object, this);
        }
        throw new NoSuchKeyException(object, longAttribute);
    }

    public float checkFloat(Object object, boolean bl, FloatAttribute floatAttribute, float f) {
        if (this.instancingCount == 0 || object != this.curInstance || bl != ((this.curInstanceIndex & 1) == 0)) {
            return f;
        }
        Object[] objectArray = this.instanceAttributes.elements;
        for (int i = this.curAttributeBegin; i < this.curAttributeEnd; i += 2) {
            if (floatAttribute != objectArray[i]) continue;
            return ((Number)objectArray[i + 1]).floatValue();
        }
        return f;
    }

    public float getFloatDefault(Object object, boolean bl, FloatAttribute floatAttribute, float f) {
        Object[] objectArray;
        if (floatAttribute.isDerived()) {
            return floatAttribute.getDerived(object, bl, this);
        }
        if (this.instancingCount > 0 && object == this.curInstance && bl == ((this.curInstanceIndex & 1) == 0)) {
            objectArray = this.instanceAttributes.elements;
            for (int i = this.curAttributeBegin; i < this.curAttributeEnd; i += 2) {
                if (floatAttribute != objectArray[i]) continue;
                return ((Number)objectArray[i + 1]).floatValue();
            }
        }
        if (object != null && (objectArray = this.graph.getAccessor(object, bl, floatAttribute)) != null) {
            return ((FloatAttributeAccessor)objectArray).getFloat(object, this);
        }
        return f;
    }

    public float getFloat(Object object, boolean bl, FloatAttribute floatAttribute) {
        Object[] objectArray;
        if (floatAttribute.isDerived()) {
            return floatAttribute.getDerived(object, bl, this);
        }
        if (this.instancingCount > 0 && object == this.curInstance && bl == ((this.curInstanceIndex & 1) == 0)) {
            objectArray = this.instanceAttributes.elements;
            for (int i = this.curAttributeBegin; i < this.curAttributeEnd; i += 2) {
                if (floatAttribute != objectArray[i]) continue;
                return ((Number)objectArray[i + 1]).floatValue();
            }
        }
        if (object != null && (objectArray = this.graph.getAccessor(object, bl, floatAttribute)) != null) {
            return ((FloatAttributeAccessor)objectArray).getFloat(object, this);
        }
        throw new NoSuchKeyException(object, floatAttribute);
    }

    public double checkDouble(Object object, boolean bl, DoubleAttribute doubleAttribute, double d) {
        if (this.instancingCount == 0 || object != this.curInstance || bl != ((this.curInstanceIndex & 1) == 0)) {
            return d;
        }
        Object[] objectArray = this.instanceAttributes.elements;
        for (int i = this.curAttributeBegin; i < this.curAttributeEnd; i += 2) {
            if (doubleAttribute != objectArray[i]) continue;
            return ((Number)objectArray[i + 1]).doubleValue();
        }
        return d;
    }

    public double getDoubleDefault(Object object, boolean bl, DoubleAttribute doubleAttribute, double d) {
        Object[] objectArray;
        if (doubleAttribute.isDerived()) {
            return doubleAttribute.getDerived(object, bl, this);
        }
        if (this.instancingCount > 0 && object == this.curInstance && bl == ((this.curInstanceIndex & 1) == 0)) {
            objectArray = this.instanceAttributes.elements;
            for (int i = this.curAttributeBegin; i < this.curAttributeEnd; i += 2) {
                if (doubleAttribute != objectArray[i]) continue;
                return ((Number)objectArray[i + 1]).doubleValue();
            }
        }
        if (object != null && (objectArray = this.graph.getAccessor(object, bl, doubleAttribute)) != null) {
            return ((DoubleAttributeAccessor)objectArray).getDouble(object, this);
        }
        return d;
    }

    public double getDouble(Object object, boolean bl, DoubleAttribute doubleAttribute) {
        Object[] objectArray;
        if (doubleAttribute.isDerived()) {
            return doubleAttribute.getDerived(object, bl, this);
        }
        if (this.instancingCount > 0 && object == this.curInstance && bl == ((this.curInstanceIndex & 1) == 0)) {
            objectArray = this.instanceAttributes.elements;
            for (int i = this.curAttributeBegin; i < this.curAttributeEnd; i += 2) {
                if (doubleAttribute != objectArray[i]) continue;
                return ((Number)objectArray[i + 1]).doubleValue();
            }
        }
        if (object != null && (objectArray = this.graph.getAccessor(object, bl, doubleAttribute)) != null) {
            return ((DoubleAttributeAccessor)objectArray).getDouble(object, this);
        }
        throw new NoSuchKeyException(object, doubleAttribute);
    }

    public <T> T checkObject(Object object, boolean bl, ObjectAttribute<? extends T> objectAttribute, T t) {
        if (this.instancingCount == 0 || object != this.curInstance || bl != ((this.curInstanceIndex & 1) == 0)) {
            return t;
        }
        Object[] objectArray = this.instanceAttributes.elements;
        for (int i = this.curAttributeBegin; i < this.curAttributeEnd; i += 2) {
            if (objectAttribute != objectArray[i]) continue;
            return objectAttribute.valueOf(objectArray[i + 1]);
        }
        return t;
    }

    public <T> T getObjectDefault(Object object, boolean bl, ObjectAttribute<? extends T> objectAttribute, T t) {
        Object[] objectArray;
        if (objectAttribute.isDerived()) {
            return objectAttribute.getDerived(object, bl, null, this);
        }
        if (this.instancingCount > 0 && object == this.curInstance && bl == ((this.curInstanceIndex & 1) == 0)) {
            objectArray = this.instanceAttributes.elements;
            for (int i = this.curAttributeBegin; i < this.curAttributeEnd; i += 2) {
                if (objectAttribute != objectArray[i]) continue;
                return objectAttribute.valueOf(objectArray[i + 1]);
            }
        }
        if (object != null && (objectArray = this.graph.getAccessor(object, bl, objectAttribute)) != null) {
            return objectAttribute.valueOf(((ObjectAttributeAccessor)objectArray).getObject(object, this));
        }
        return t;
    }

    public <T> T getObject(Object object, boolean bl, T t, ObjectAttribute<T> objectAttribute) {
        Object[] objectArray;
        if (objectAttribute.isDerived()) {
            return objectAttribute.getDerived(object, bl, null, this);
        }
        if (this.instancingCount > 0 && object == this.curInstance && bl == ((this.curInstanceIndex & 1) == 0)) {
            objectArray = this.instanceAttributes.elements;
            for (int i = this.curAttributeBegin; i < this.curAttributeEnd; i += 2) {
                if (objectAttribute != objectArray[i]) continue;
                return objectAttribute.valueOf(objectArray[i + 1]);
            }
        }
        if (object != null && (objectArray = this.graph.getAccessor(object, bl, objectAttribute)) != null) {
            return objectAttribute.valueOf(((ObjectAttributeAccessor)objectArray).getObject(object, t, this));
        }
        throw new NoSuchKeyException(object, objectAttribute);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class ObjectContext {
        Object object;
        boolean asNode;
        int instanceIndex;
        int stamp;
        final EHashMap cache;
        final EHashMap.IdentityEntry<Object, Object> key;

        ObjectContext(Object object, boolean bl, int n, EHashMap.IdentityEntry<Object, Object>[] identityEntryArray, EHashMap.IdentityEntry<Object, Object> identityEntry) {
            this.object = object;
            this.asNode = bl;
            this.instanceIndex = n;
            this.cache = new EHashMap(identityEntryArray, 32, 0.75f);
            this.key = identityEntry;
        }

        public Object getObject() {
            return this.object;
        }

        public boolean isNode() {
            return this.asNode;
        }

        public Object getValue(Object identityEntry) {
            this.key.setKey(identityEntry);
            identityEntry = this.cache.get(this.key);
            return identityEntry != null ? identityEntry.value : null;
        }

        public void setValue(Object object, Object object2) {
            EHashMap.IdentityEntry identityEntry = (EHashMap.IdentityEntry)this.cache.popEntryFromPool();
            if (identityEntry == null) {
                identityEntry = new EHashMap.IdentityEntry();
            }
            identityEntry.setKey(object);
            identityEntry.value = object2;
            this.cache.put(identityEntry);
        }
    }
}

