/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.graph;

import de.grogra.graph.BooleanMap;
import de.grogra.graph.ChangeBoundaryListener;
import de.grogra.graph.EdgeChangeListener;
import de.grogra.graph.EdgePattern;
import de.grogra.graph.EdgePatternImpl;
import de.grogra.graph.Graph;
import de.grogra.graph.GraphException;
import de.grogra.graph.GraphState;
import de.grogra.graph.GraphUtils;
import de.grogra.graph.ObjectAttribute;
import de.grogra.graph.ObjectMap;
import de.grogra.reflect.Type;
import de.grogra.xl.util.ObjectList;

public class ParentAttribute
extends ObjectAttribute
implements ChangeBoundaryListener,
EdgeChangeListener {
    public static final ParentAttribute TREE = new ParentAttribute(EdgePatternImpl.TREE, "tree");
    private final EdgePattern pattern;

    public ParentAttribute(EdgePattern edgePattern, String string) {
        super(Type.OBJECT, false, null);
        this.initializeName(string);
        this.pattern = edgePattern;
    }

    public boolean isDerived() {
        return true;
    }

    public boolean contains(Object object, boolean bl, GraphState graphState) {
        if (object == null) {
            return false;
        }
        this.getDerived(graphState.getGraph().getRoot("MainGraph"), true, (Object)null, graphState);
        return ((BooleanMap)((Object[])this.getAttributeState(graphState))[0]).getBoolean(object, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object getDerived(Object object, boolean bl, Object object2, GraphState graphState) {
        Object[] objectArray = this;
        synchronized (this) {
            Object[] objectArray2 = (Object[])this.getAttributeState(graphState);
            if (objectArray2 == null) {
                objectArray2 = new Object[]{graphState.getGraph().createBooleanMap(), graphState.getGraph().createObjectMap(), new ObjectList(32)};
                this.setAttributeState(graphState, objectArray2);
                graphState.getGraph().addChangeBoundaryListener((ChangeBoundaryListener)this);
                graphState.getGraph().addEdgeChangeListener((EdgeChangeListener)this);
            }
            // ** MonitorExit[var6_5] (shouldn't be in output)
            objectArray = objectArray2;
            synchronized (objectArray2) {
                BooleanMap booleanMap = (BooleanMap)objectArray2[0];
                if (booleanMap.getBoolean(object, bl)) {
                    // ** MonitorExit[var6_5] (shouldn't be in output)
                    return ((ObjectMap)objectArray2[1]).getObject(object, bl);
                }
                if (!booleanMap.getBoolean(graphState.getGraph().getRoot("MainGraph"), true)) {
                    super.recalculate(graphState.getGraph().getRoot("MainGraph"), null, graphState.getGraph(), (BooleanMap)objectArray2[0], (ObjectMap)objectArray2[1], graphState.treeAttributeStack);
                }
                if (!booleanMap.getBoolean(object, bl)) {
                    // ** MonitorExit[var6_5] (shouldn't be in output)
                    return null;
                }
                // ** MonitorExit[var6_5] (shouldn't be in output)
                return ((ObjectMap)objectArray2[1]).getObject(object, bl);
            }
        }
    }

    private void recalculate(Object object, Object object2, Graph graph, BooleanMap booleanMap, ObjectMap objectMap, ObjectList objectList) {
        int n = objectList.size;
        Object object3 = null;
        boolean bl = false;
        try {
            block4: while (true) {
                if (!bl) {
                    if (booleanMap.putBoolean(object, true, true)) {
                        throw new GraphException("Node " + object + " has more than one tree path to root.");
                    }
                    objectMap.putObject(object, true, object2);
                    object3 = graph.getFirstEdge(object);
                }
                while (object3 != null) {
                    if (!bl && object3 != object2) {
                        Object object4 = graph.getTargetNode(object3);
                        boolean bl2 = object4 != object;
                        if (!bl2) {
                            object4 = graph.getSourceNode(object3);
                        }
                        if (GraphUtils.matches(this.pattern, graph, object3, bl2)) {
                            booleanMap.putBoolean(object3, false, true);
                            objectMap.putObject(object3, false, object);
                            objectList.push(object).push(object2).push(object3);
                            object = object4;
                            object2 = object3;
                            continue block4;
                        }
                    }
                    bl = false;
                    object3 = graph.getNextEdge(object3, object);
                }
                if (objectList.size == n) {
                    return;
                }
                object3 = objectList.pop();
                object2 = objectList.pop();
                object = objectList.pop();
                bl = true;
            }
        }
        finally {
            objectList.setSize(n);
        }
    }

    public void beginChange(GraphState graphState) {
        Object[] objectArray = (Object[])this.getAttributeState(graphState);
        ((ObjectList)objectArray[2]).clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endChange(GraphState graphState) {
        Object[] objectArray;
        Object[] objectArray2 = objectArray = (Object[])this.getAttributeState(graphState);
        synchronized (objectArray) {
            BooleanMap booleanMap = (BooleanMap)objectArray[0];
            ObjectMap objectMap = (ObjectMap)objectArray[1];
            Graph graph = graphState.getGraph();
            ObjectList objectList = (ObjectList)objectArray[2];
            objectArray = objectList.elements;
            int n = objectList.size;
            block3: while (n > 0) {
                boolean bl;
                Object object = objectArray[--n];
                Object object2 = objectArray[--n];
                boolean bl2 = bl = objectArray[--n] == null;
                if (!booleanMap.getBoolean(object2, true)) continue;
                Object object3 = graph.getFirstEdge(object2);
                while (object3 != null) {
                    if (bl ? graph.getTargetNode(object3) == object && this.pattern.matches(object2, object, graph.getEdgeBits(object3), true) : graph.getSourceNode(object3) == object && this.pattern.matches(object, object2, graph.getEdgeBits(object3), false)) {
                        booleanMap.putBoolean(object3, false, true);
                        objectMap.putObject(object3, false, object2);
                        if (booleanMap.getBoolean(object, true)) continue block3;
                        this.recalculate(object, object3, graph, booleanMap, objectMap, graphState.treeAttributeStack);
                        continue block3;
                    }
                    object3 = graph.getNextEdge(object3, object2);
                }
            }
            objectList.clear();
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    public int getPriority() {
        return 10;
    }

    public void edgeChanged(Object object, Object object2, Object object3, GraphState graphState) {
        Object v;
        Object[] objectArray = (Object[])this.getAttributeState(graphState);
        BooleanMap booleanMap = (BooleanMap)objectArray[0];
        ObjectMap objectMap = (ObjectMap)objectArray[1];
        if ((object3 == null || !this.pattern.matches(object, object2, graphState.getGraph().getEdgeBits(object3), true)) && booleanMap.getBoolean(object2, true) && (v = objectMap.getObject(object2, true)) != null && object == objectMap.getObject(v, false)) {
            this.invalidateChildren(object2, v, booleanMap, objectMap, graphState, graphState.treeAttributeStack);
        } else if ((object3 == null || !this.pattern.matches(object, object2, graphState.getGraph().getEdgeBits(object3), false)) && booleanMap.getBoolean(object, true) && (v = objectMap.getObject(object, true)) != null && object2 == objectMap.getObject(v, false)) {
            this.invalidateChildren(object, v, booleanMap, objectMap, graphState, graphState.treeAttributeStack);
        }
        if (object3 != null) {
            if (GraphUtils.matches(this.pattern, graphState.getGraph(), object3, true) && booleanMap.getBoolean(object, true)) {
                ((ObjectList)objectArray[2]).push(null).push(object).push(object2);
            } else if (GraphUtils.matches(this.pattern, graphState.getGraph(), object3, false) && booleanMap.getBoolean(object2, true)) {
                ((ObjectList)objectArray[2]).push(this).push((ParentAttribute)object2).push((ParentAttribute)object);
            }
        }
    }

    private void invalidateChildren(Object object, Object object2, BooleanMap booleanMap, ObjectMap objectMap, GraphState graphState, ObjectList objectList) {
        Graph graph = graphState.getGraph();
        int n = objectList.size;
        Object object3 = null;
        boolean bl = false;
        try {
            block4: while (true) {
                if (!bl) {
                    booleanMap.putBoolean(object2, false, false);
                    graphState.fireAttributeChanged(object2, false, this, null, null);
                    booleanMap.putBoolean(object, true, false);
                    graphState.fireAttributeChanged(object, true, this, null, null);
                    object3 = graph.getFirstEdge(object);
                }
                while (object3 != null) {
                    if (!bl && object3 != object2) {
                        Object v;
                        Object object4 = graph.getTargetNode(object3);
                        if (object4 == object) {
                            object4 = graph.getSourceNode(object3);
                        }
                        if (booleanMap.getBoolean(object4, true) && booleanMap.getBoolean(v = objectMap.getObject(object4, true), false) && objectMap.getObject(v, false) == object) {
                            objectList.push(object).push(object2).push(object3);
                            object = object4;
                            object2 = v;
                            continue block4;
                        }
                    }
                    bl = false;
                    object3 = graph.getNextEdge(object3, object);
                }
                if (objectList.size == n) {
                    return;
                }
                object3 = objectList.pop();
                object2 = objectList.pop();
                object = objectList.pop();
                bl = true;
            }
        }
        finally {
            objectList.setSize(n);
        }
    }
}

