/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.http;

import de.grogra.util.Utils;
import java.io.BufferedInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public final class Request {
    private final String method;
    private final String uri;
    private final String version;
    private final Map headerFields;
    private final byte[] content;

    public Request(String string, String string2, String string3, Map map, byte[] byArray) {
        this.method = string;
        this.uri = string2;
        this.version = string3;
        this.headerFields = map;
        this.content = byArray;
    }

    public static Request parse(BufferedInputStream bufferedInputStream) throws IOException {
        byte[] byArray;
        int n;
        String string;
        Request.skipWS(bufferedInputStream);
        try {
            string = Request.readToken(bufferedInputStream, -1);
        }
        catch (EOFException eOFException) {
            return null;
        }
        String string2 = Request.readToken(bufferedInputStream, -1);
        String string3 = Request.readToken(bufferedInputStream, -1);
        Request.consumeCRLF(bufferedInputStream);
        HashMap hashMap = new HashMap();
        block7: while (true) {
            bufferedInputStream.mark(1);
            n = bufferedInputStream.read();
            bufferedInputStream.reset();
            switch (n) {
                case 10: 
                case 13: {
                    break block7;
                }
                default: {
                    Request.parseField(bufferedInputStream, hashMap);
                    continue block7;
                }
            }
            break;
        }
        Request.consumeCRLF(bufferedInputStream);
        n = -1;
        try {
            n = Integer.parseInt((String)hashMap.get("content-length"));
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        if (n >= 0) {
            byArray = new byte[n];
            Utils.readFully(bufferedInputStream, byArray);
        } else {
            byArray = null;
        }
        return new Request(string, string2, string3, hashMap, byArray);
    }

    private static void consumeCRLF(BufferedInputStream bufferedInputStream) throws IOException {
        int n = bufferedInputStream.read();
        switch (n) {
            case 10: {
                return;
            }
            case 13: {
                bufferedInputStream.mark(1);
                if (bufferedInputStream.read() != 10) {
                    bufferedInputStream.reset();
                }
                return;
            }
        }
        throw new IOException("Illegal request: #" + Integer.toHexString(n) + " instead of CRLF");
    }

    private static void skipWS(BufferedInputStream bufferedInputStream) throws IOException {
        int n;
        do {
            bufferedInputStream.mark(1);
        } while ((n = bufferedInputStream.read()) >= 0 && Character.isWhitespace((char)n));
        bufferedInputStream.reset();
    }

    private static String readToken(BufferedInputStream bufferedInputStream, int n) throws IOException {
        Request.skipWS(bufferedInputStream);
        StringBuffer stringBuffer = new StringBuffer();
        while (true) {
            bufferedInputStream.mark(1);
            int n2 = bufferedInputStream.read();
            if (n2 < 0 || n2 == n || Character.isWhitespace((char)n2)) {
                bufferedInputStream.reset();
                if (n2 < 0 && stringBuffer.length() == 0) {
                    throw new EOFException();
                }
                return stringBuffer.toString();
            }
            stringBuffer.append((char)n2);
        }
    }

    private static void parseField(BufferedInputStream bufferedInputStream, HashMap hashMap) throws IOException {
        String string = Request.readToken(bufferedInputStream, 58).toLowerCase();
        if (bufferedInputStream.read() != 58) {
            throw new IOException("Expected :");
        }
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = true;
        block4: while (true) {
            bufferedInputStream.mark(1);
            int n = bufferedInputStream.read();
            switch (n) {
                case 10: 
                case 13: {
                    bufferedInputStream.reset();
                    Request.consumeCRLF(bufferedInputStream);
                    bufferedInputStream.mark(1);
                    n = bufferedInputStream.read();
                    bufferedInputStream.reset();
                    if (n == 32) continue block4;
                    if (n == 9) continue block4;
                    String string2 = (String)hashMap.get(string);
                    if (string2 != null) {
                        stringBuffer.insert(0, ',').insert(0, string2);
                    }
                    hashMap.put(string, stringBuffer.toString().trim());
                    return;
                }
                case -1: {
                    throw new EOFException();
                }
                default: {
                    if (Character.isWhitespace((char)n)) {
                        if (bl) continue block4;
                        bl = true;
                        stringBuffer.append(' ');
                        break;
                    }
                    bl = false;
                    stringBuffer.append((char)n);
                }
            }
        }
    }

    public String getMethod() {
        return this.method;
    }

    public String getURI() {
        return this.uri;
    }

    public String getPath() {
        int n = this.uri.indexOf(63);
        return n >= 0 ? this.uri.substring(0, n) : this.uri;
    }

    public String getQuery() {
        int n = this.uri.indexOf(63);
        return n >= 0 ? this.uri.substring(n + 1) : null;
    }

    public String getVersion() {
        return this.version;
    }

    public String getHeaderField(String string) {
        return (String)this.headerFields.get(string);
    }

    public byte[] getContent() {
        return this.content;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.method + " " + this.uri + " " + this.version);
        for (Map.Entry entry : this.headerFields.entrySet()) {
            stringBuffer.append("\n  ").append(entry.getKey()).append(" = ").append(entry.getValue());
        }
        if (this.content != null) {
            int n;
            stringBuffer.append("\n  content = ");
            int n2 = Math.min(this.content.length, 500);
            for (n = 0; n < n2; ++n) {
                String string = Integer.toHexString((char)this.content[n]);
                if (string.length() == 1) {
                    stringBuffer.append('0');
                }
                stringBuffer.append(string);
                stringBuffer.append(' ');
            }
            if (n2 < this.content.length) {
                stringBuffer.append("...");
            }
            stringBuffer.append("\n  content = ");
            for (n = 0; n < n2; ++n) {
                stringBuffer.append((char)this.content[n]);
            }
            if (n2 < this.content.length) {
                stringBuffer.append("...");
            }
        }
        stringBuffer.append('\n');
        return stringBuffer.toString();
    }
}

