/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.persistence;

import de.grogra.persistence.ManageableType;
import de.grogra.persistence.PersistenceBindings;
import de.grogra.persistence.PersistenceInputStream;
import de.grogra.persistence.PersistenceOutputStream;
import de.grogra.persistence.SharedObjectProvider;
import de.grogra.util.StringMap;
import de.grogra.xl.util.ObjectList;
import java.io.IOException;

public final class BindingsCache {
    public static final int STRING = 0;
    public static final int TYPE = 1;
    public static final int SO_PROVIDER = 2;
    private static final int IO_BINDINGS_BEGIN = 119;
    private static final int IO_BINDINGS_END = 18;
    private final PersistenceBindings bindings;
    private final short cacheId;
    private final SingleCache[] caches = new SingleCache[]{new SingleCache(), new SingleCache(), new SingleCache()};

    public BindingsCache(PersistenceBindings persistenceBindings, short s) {
        this.bindings = persistenceBindings;
        this.cacheId = s;
    }

    public short getCacheId() {
        return this.cacheId;
    }

    public PersistenceBindings getBindings() {
        return this.bindings;
    }

    synchronized void write(PersistenceOutputStream persistenceOutputStream) throws IOException {
        this.writeUnsync(persistenceOutputStream);
    }

    private void writeUnsync(PersistenceOutputStream persistenceOutputStream) throws IOException {
        persistenceOutputStream.write(119);
        int[] nArray = persistenceOutputStream.getWrittenHandles(this.cacheId);
        for (int i = 0; i <= 2; ++i) {
            SingleCache singleCache = this.caches[i];
            int n = nArray[i];
            int n2 = singleCache.handleToName.size() - n;
            persistenceOutputStream.writeInt(n2);
            if (n2 <= 0) continue;
            persistenceOutputStream.writeInt(n);
            while (--n2 >= 0) {
                persistenceOutputStream.writeUTF((String)singleCache.handleToName.get(n++));
            }
            nArray[i] = n;
        }
        persistenceOutputStream.write(18);
    }

    void read(PersistenceInputStream persistenceInputStream) throws IOException {
        persistenceInputStream.check(119);
        for (int i = 0; i <= 2; ++i) {
            SingleCache singleCache = this.caches[i];
            int n = persistenceInputStream.readInt();
            if (n <= 0) continue;
            int n2 = singleCache.handleToName.size();
            persistenceInputStream.checkInt(n2);
            while (--n >= 0) {
                Object object;
                String string = persistenceInputStream.readUTF();
                singleCache.nameToHandle.put(string, (Object)n2);
                singleCache.handleToName.set(n2, string);
                switch (i) {
                    case 0: {
                        object = string;
                        break;
                    }
                    case 1: {
                        object = this.bindings.resolveType(string);
                        break;
                    }
                    case 2: {
                        object = this.bindings.getSOBinding().lookup(string);
                        break;
                    }
                    default: {
                        throw new AssertionError();
                    }
                }
                assert (object != null);
                singleCache.handleToObject.set(n2, object);
                ++n2;
            }
        }
        persistenceInputStream.check(18);
    }

    public int getHandle(ManageableType manageableType) {
        return this.getHandle(this.caches[1], manageableType, manageableType.getBinaryName());
    }

    public int getHandle(SharedObjectProvider sharedObjectProvider) {
        return this.getHandle(this.caches[2], sharedObjectProvider, sharedObjectProvider.getProviderName());
    }

    private synchronized int getHandle(SingleCache singleCache, Object object, String string) {
        Object object2 = singleCache.nameToHandle.get(string);
        if (object2 != null) {
            return (Integer)object2;
        }
        int n = singleCache.nameToHandle.size();
        singleCache.nameToHandle.put(string, (Object)n);
        singleCache.handleToName.set(n, string);
        singleCache.handleToObject.set(n, object);
        return n;
    }

    private void getHandleAndWrite(SingleCache singleCache, Object object, String string, PersistenceOutputStream persistenceOutputStream) throws IOException {
        Object object2 = singleCache.nameToHandle.get(string);
        if (object2 != null) {
            persistenceOutputStream.writeInt((Integer)object2);
        } else {
            int n = singleCache.nameToHandle.size();
            singleCache.nameToHandle.put(string, (Object)n);
            singleCache.handleToName.set(n, string);
            singleCache.handleToObject.set(n, object);
            persistenceOutputStream.writeInt(-1);
            this.writeUnsync(persistenceOutputStream);
            persistenceOutputStream.writeInt(n);
        }
    }

    public synchronized void write(ManageableType manageableType, PersistenceOutputStream persistenceOutputStream) throws IOException {
        this.getHandleAndWrite(this.caches[1], manageableType, manageableType.getBinaryName(), persistenceOutputStream);
    }

    public synchronized void write(SharedObjectProvider sharedObjectProvider, PersistenceOutputStream persistenceOutputStream) throws IOException {
        this.getHandleAndWrite(this.caches[2], sharedObjectProvider, sharedObjectProvider.getProviderName(), persistenceOutputStream);
    }

    public String getString(int n) {
        return (String)this.caches[0].handleToObject.get(n);
    }

    public ManageableType getType(int n) {
        return (ManageableType)this.caches[1].handleToObject.get(n);
    }

    public SharedObjectProvider getSOProvider(int n) {
        return (SharedObjectProvider)this.caches[2].handleToObject.get(n);
    }

    public ManageableType readType(PersistenceInputStream persistenceInputStream) throws IOException {
        return (ManageableType)this.readHandle(this.caches[1], persistenceInputStream);
    }

    public SharedObjectProvider readSOProvider(PersistenceInputStream persistenceInputStream) throws IOException {
        return (SharedObjectProvider)this.readHandle(this.caches[2], persistenceInputStream);
    }

    private Object readHandle(SingleCache singleCache, PersistenceInputStream persistenceInputStream) throws IOException {
        Object e;
        int n = persistenceInputStream.readInt();
        if (n == -1) {
            this.read(persistenceInputStream);
            n = persistenceInputStream.readInt();
        }
        if ((e = singleCache.handleToObject.get(n)) == null) {
            throw new IOException("No object for handle " + n + " in " + this);
        }
        return e;
    }

    static class SingleCache {
        StringMap nameToHandle = new StringMap();
        ObjectList handleToObject = new ObjectList();
        ObjectList handleToName = new ObjectList();

        SingleCache() {
        }
    }
}

