/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.persistence;

import de.grogra.persistence.ManageableType;
import de.grogra.persistence.SharedObjectProvider;
import de.grogra.reflect.Type;
import de.grogra.reflect.TypeLoader;
import java.util.Hashtable;

public final class PersistenceBindings {
    private final TypeLoader loader;
    private final SharedObjectProvider.Binding soBinding;
    private final Hashtable types = new Hashtable();

    public PersistenceBindings(TypeLoader typeLoader, SharedObjectProvider.Binding binding) {
        this.loader = typeLoader;
        this.soBinding = binding;
    }

    public TypeLoader getTypeLoader() {
        return this.loader;
    }

    public SharedObjectProvider.Binding getSOBinding() {
        return this.soBinding;
    }

    public Type typeForName(String string, boolean bl) throws ClassNotFoundException {
        Type type = this.loader.typeForName(string);
        if (!bl) {
            return type;
        }
        ManageableType manageableType = this.resolveType(type);
        return manageableType != null ? manageableType : type;
    }

    public ManageableType resolveType(String string) {
        ManageableType manageableType = (ManageableType)this.types.get(string);
        if (manageableType != null) {
            return manageableType;
        }
        manageableType = ManageableType.forName(string);
        if (manageableType != null) {
            this.types.put(string, manageableType);
            return manageableType;
        }
        try {
            return this.resolveType(this.loader.typeForName(string));
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    public ManageableType resolveType(Type type) {
        String string = type.getBinaryName();
        ManageableType manageableType = (ManageableType)this.types.get(string);
        if (manageableType == null && (manageableType = ManageableType.forType(type)) != null) {
            this.types.put(string, manageableType);
        }
        return manageableType;
    }

    public ManageableType resolveType(Class clazz) {
        String string = clazz.getName();
        ManageableType manageableType = (ManageableType)this.types.get(string);
        if (manageableType == null && (manageableType = ManageableType.forClass(clazz)) != null) {
            this.types.put(string, manageableType);
        }
        return manageableType;
    }
}

