/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.persistence;

import de.grogra.persistence.BindingsCache;
import de.grogra.persistence.ManageableType;
import de.grogra.persistence.PersistenceBindings;
import de.grogra.persistence.PersistenceCapable;
import de.grogra.persistence.PersistenceInput;
import de.grogra.persistence.PersistenceManager;
import de.grogra.persistence.ResolvableReference;
import de.grogra.persistence.Shareable;
import de.grogra.reflect.Type;
import de.grogra.util.IOWrapException;
import de.grogra.xl.util.ClassLoaderObjectInputStream;
import de.grogra.xl.util.ObjectList;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.StreamCorruptedException;

public class PersistenceInputStream
extends FilterInputStream
implements PersistenceInput,
DataInput {
    static final int MANAGEABLE_WITH_TYPE = 108;
    private final PersistenceBindings bindings;
    private final DataInputStream dataIn;
    private final ObjectInputStream objectIn;
    private PersistenceManager manager;
    private BindingsCache cache;
    private ObjectList bindingsCaches = new ObjectList();
    private int objectType = -1;

    public PersistenceInputStream(PersistenceBindings persistenceBindings, DataInputStream dataInputStream) throws IOException {
        super(dataInputStream);
        this.bindings = persistenceBindings;
        this.dataIn = dataInputStream;
        if (dataInputStream.readInt() != -623199554) {
            throw new StreamCorruptedException("Invalid MAGIC number");
        }
        this.objectIn = new ClassLoaderObjectInputStream((InputStream)dataInputStream, persistenceBindings.getTypeLoader());
    }

    public BindingsCache getCache(short s) throws IOException {
        BindingsCache bindingsCache = (BindingsCache)this.bindingsCaches.get(s);
        if (bindingsCache == null) {
            bindingsCache = new BindingsCache(this.bindings, s);
            this.bindingsCaches.set(s, bindingsCache);
        }
        return bindingsCache;
    }

    public BindingsCache readCache() throws IOException {
        this.cache = this.getCache(this.readShort());
        this.cache.read(this);
        return this.cache;
    }

    public void beginExtent(PersistenceManager persistenceManager) throws IOException {
        this.checkInt(-2042464975);
        this.readCache();
        this.manager = persistenceManager;
    }

    public PersistenceBindings getBindings() {
        return this.bindings;
    }

    public void endExtent() throws IOException {
        this.checkInt(-19088744);
        this.manager = null;
    }

    public final void checkInt(int n) throws IOException {
        int n2 = this.readInt();
        if (n2 != n) {
            throw new StreamCorruptedException("Expected 0x" + Integer.toHexString(n) + ", read 0x" + Integer.toHexString(n2));
        }
    }

    public final void check(int n) throws IOException {
        int n2 = this.dataIn.readUnsignedByte();
        if (n2 != n) {
            throw new StreamCorruptedException("Expected 0x" + Integer.toHexString(n) + ", read 0x" + Integer.toHexString(n2));
        }
    }

    public final boolean markSupported() {
        return false;
    }

    public final void reset() throws IOException {
        throw new IOException("reset not supported");
    }

    public void readFully(byte[] byArray) throws IOException {
        this.dataIn.readFully(byArray);
    }

    public void readFully(byte[] byArray, int n, int n2) throws IOException {
        this.dataIn.readFully(byArray, n, n2);
    }

    public int skipBytes(int n) throws IOException {
        return this.dataIn.skipBytes(n);
    }

    public boolean readBoolean() throws IOException {
        return this.dataIn.readBoolean();
    }

    public byte readByte() throws IOException {
        return this.dataIn.readByte();
    }

    public int readUnsignedByte() throws IOException {
        return this.dataIn.readUnsignedByte();
    }

    public short readShort() throws IOException {
        return this.dataIn.readShort();
    }

    public int readUnsignedShort() throws IOException {
        return this.dataIn.readUnsignedShort();
    }

    public char readChar() throws IOException {
        return this.dataIn.readChar();
    }

    public int readInt() throws IOException {
        int n = 0;
        int n2 = 0;
        int n3;
        while (((n3 = this.dataIn.readUnsignedByte()) & 0x80) != 0) {
            n |= (n3 & 0x7F) << n2;
            n2 += 7;
        }
        return n | n3 << n2;
    }

    public long readLong() throws IOException {
        return (long)this.readInt() << 32 | (long)this.readInt() & 0xFFFFFFFFL;
    }

    public float readFloat() throws IOException {
        return this.dataIn.readFloat();
    }

    public double readDouble() throws IOException {
        return this.dataIn.readDouble();
    }

    public String readLine() throws IOException {
        return this.dataIn.readLine();
    }

    public String readUTF() throws IOException {
        return this.dataIn.readUTF();
    }

    public String readName() throws IOException {
        return this.dataIn.readUTF();
    }

    public String readString() throws IOException {
        return this.dataIn.readUTF();
    }

    public int getNextObjectKind() throws IOException {
        byte by = this.dataIn.readByte();
        this.objectType = by;
        return by == 108 ? 104 : (int)by;
    }

    private int nextByte() throws IOException {
        int n = this.objectType;
        if (n >= 0) {
            this.objectType = -1;
            return n;
        }
        return this.dataIn.readByte();
    }

    private void consume(int n) throws IOException {
        int n2 = this.nextByte();
        if (n2 != n) {
            throw new StreamCorruptedException("Expected " + n + ", read " + n2);
        }
    }

    public Object readObject(int n, Type type) throws IOException {
        switch (n) {
            case 101: {
                this.consume(101);
                return null;
            }
            case 102: {
                this.consume(102);
                return this.dataIn.readUTF();
            }
            case 103: {
                try {
                    return this.objectIn.readObject();
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new IOWrapException(classNotFoundException);
                }
            }
        }
        throw new AssertionError();
    }

    public Shareable readSharedObject() throws IOException {
        this.consume(105);
        ResolvableReference resolvableReference = this.cache.readSOProvider(this).readReference(this);
        return resolvableReference.resolve();
    }

    public PersistenceCapable readPersistentObject() throws IOException {
        this.consume(106);
        long l = this.readLong();
        Object object = this.manager.getObject(l);
        if (object == null) {
            this.check(5);
            object = ManageableType.read(this, null);
            this.manager.makePersistentImpl((PersistenceCapable)object, l, null);
        }
        return object;
    }

    public long readPersistentObjectId() throws IOException {
        return this.readPersistentObject().getId();
    }

    public int beginArray() throws IOException {
        this.consume(107);
        return this.readInt();
    }

    public boolean beginComponent(ManageableType.ArrayComponent arrayComponent, int n) {
        return true;
    }

    public void endComponent() {
    }

    public void endArray() {
    }

    public ManageableType beginManaged() throws IOException {
        switch (this.nextByte()) {
            case 108: {
                return this.cache.readType(this);
            }
            case 104: {
                return null;
            }
        }
        throw new AssertionError();
    }

    public boolean areFieldsProvided() {
        return true;
    }

    public ManageableType.Field beginField(ManageableType manageableType, ManageableType.Field field) throws IOException {
        short s = this.readShort();
        return s < 0 ? null : manageableType.getManagedField(s);
    }

    public void endField() {
    }

    public void endManaged() {
    }

    public void setNested(boolean bl) {
    }

    public PersistenceCapable resolveId(long l) {
        return this.manager.getObject(l);
    }
}

