/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.pf.boot;

import de.grogra.graph.impl.Node;
import de.grogra.pf.io.IO;
import de.grogra.pf.registry.Application;
import de.grogra.pf.registry.Argument;
import de.grogra.pf.registry.Executable;
import de.grogra.pf.registry.Item;
import de.grogra.pf.registry.ItemCriterion;
import de.grogra.pf.registry.PluginClassLoader;
import de.grogra.pf.registry.PluginDescriptor;
import de.grogra.pf.registry.PluginPrerequisite;
import de.grogra.pf.registry.Prerequisite;
import de.grogra.pf.registry.Registry;
import de.grogra.pf.registry.expr.Expression;
import de.grogra.util.DelegatingClassLoader;
import de.grogra.util.I18NBundle;
import de.grogra.util.PathListIterator;
import de.grogra.util.ResourceConverter;
import de.grogra.util.SplashScreen;
import de.grogra.util.StringMap;
import de.grogra.util.Utils;
import de.grogra.util.XPropertyResourceBundle;
import de.grogra.vfs.LocalFileSystem;
import de.grogra.xl.util.ObjectList;
import java.awt.Button;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.TextArea;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Properties;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;

public final class Main {
    private static final String DEBUG = "debug";
    private static final String PROJECT_TREE = "project-tree";
    private static final String BOOT_PATH = "boot";
    private static final String SYSTEM_PLUGIN_PATH = "system-plugins";
    private static final String USER_PLUGIN_PATH = "user-plugins";
    private static final String PLUGIN_PATH = "plugins";
    private static final String DISABLE_PLUGIN = "disable";
    private static final String CONFIGURATION = "config";
    public static final String HEADLESS = "headless";
    private static final String DISABLE_SPLASH = "disable-splash";
    private static final String SPLASH_CLASS = "splash-class";
    private static final String SPLASH_BACKGROUND = "splash-background";
    private static final String SPLASH_FOREGROUND = "splash-foreground";
    private static final String SPLASH_LOGO = "splash-logo";
    private static final String SPLASH_BAR_LEFT = "splash-bar-left";
    private static final String SPLASH_BAR_RIGHT = "splash-bar-right";
    private static final String SPLASH_TITLE = "splash-title";
    private static final String SPLASH_TEXT_LOCATION = "splash-text-location";
    private static final String SPLASH_TEXT_COLOR = "splash-text-color";
    private static final String SPLASH_BAR_BOUNDS = "splash-bar-bounds";
    private static final String APPLICATION = "application";
    public static final Integer SCREEN_PROPERTY_ID = Registry.allocatePropertyId();
    public static final String SCREEN_PROPERTY = "screen";
    private static final String[] OPTIONS = new String[]{"* debug", "  project-tree", "* boot", "* system-plugins", "*puser-plugins", "* plugins", "* disable", "*cconfig", "  headless", "  disable-splash", "* splash-class", "* splash-background", "* splash-bar-left", "* splash-bar-right", "* splash-bar-bounds", "* splash-title", "* splash-text-location", "* splash-text-color", "* screen", "*aapplication"};
    private static Main MAIN;
    private final int argStart;
    private final String[] args;
    private final Properties props;
    private final File configurationDirectory;
    private Registry registry;
    private Application application;
    private Logger logger;
    private File rootDirectory = null;
    private boolean usesProjectTree = false;
    private ClassLoader loaderForAll;
    private I18NBundle i18n;
    private Item streamHandlerDir;
    private String version;
    private SplashScreen splash = null;
    private boolean disableSplash = false;
    private volatile long splashWillClose;

    public static Main getInstance() {
        return MAIN;
    }

    public static void main(String[] stringArray) {
        MAIN = new Main(stringArray);
        URL.setURLStreamHandlerFactory(new URLStreamHandlerFactory(){

            public URLStreamHandler createURLStreamHandler(String string) {
                return Main.getInstance().createURLStreamHandler(string);
            }
        });
        MAIN.run();
    }

    public static void exit() {
        Registry registry = Main.getInstance().registry;
        for (PluginDescriptor pluginDescriptor = (PluginDescriptor)registry.getPluginDirectory().getBranchTail(); pluginDescriptor != null; pluginDescriptor = (PluginDescriptor)pluginDescriptor.getPredecessor()) {
            if (pluginDescriptor.getPluginState() != 5) continue;
            try {
                pluginDescriptor.getPlugin().shutdown();
                continue;
            }
            catch (Exception exception) {
                Main.logSevere(exception);
            }
        }
        System.exit(0);
    }

    private Main(String[] stringArray) {
        Object object;
        Object object2;
        Object object3;
        Properties properties = new Properties();
        Properties properties2 = new Properties(properties);
        int n = stringArray.length;
        block6: for (int i = 0; i < stringArray.length; ++i) {
            int n2;
            int n3;
            object3 = stringArray[i];
            if (((String)object3).equals("--")) {
                n = i + 1;
                break;
            }
            if (((String)object3).startsWith("--")) {
                n3 = ((String)object3).indexOf(61);
                object2 = n3 < 0 ? ((String)object3).substring(2) : ((String)object3).substring(2, n3);
                for (n2 = 0; n2 < OPTIONS.length; ++n2) {
                    if (!OPTIONS[n2].substring(2).equals(object2)) continue;
                    Main.addOption(n2, n3 >= 0 ? ((String)object3).substring(n3 + 1) : null, properties2, '\u0000');
                    continue block6;
                }
                System.err.println("Unknown option " + (String)object3);
            } else if (((String)object3).startsWith("-X")) {
                if (((String)object3).length() == 2) {
                    System.err.println("X-Option not specified");
                } else {
                    n3 = ((String)object3).indexOf(61);
                    properties2.setProperty(n3 < 0 ? ((String)object3).substring(2) : ((String)object3).substring(2, n3), n3 < 0 ? "true" : ((String)object3).substring(n3 + 1));
                }
            } else if (((String)object3).startsWith("-") && !((String)object3).equals("-")) {
                n3 = ((String)object3).charAt(1);
                for (int j = 0; j < OPTIONS.length; ++j) {
                    if (OPTIONS[j].charAt(1) != n3) continue;
                    if (OPTIONS[j].charAt(0) == '*') {
                        if (((String)object3).length() == 2) {
                            stringArray[i] = null;
                            Main.addOption(j, ++i == stringArray.length ? null : stringArray[i], properties2, (char)n3);
                            continue block6;
                        }
                        Main.addOption(j, ((String)object3).substring(2), properties2, (char)n3);
                        continue block6;
                    }
                    block9: for (n2 = 1; n2 < ((String)object3).length(); ++n2) {
                        n3 = ((String)object3).charAt(n2);
                        for (j = 0; j < OPTIONS.length; ++j) {
                            if (OPTIONS[j].charAt(1) != n3) continue;
                            Main.addOption(j, null, properties2, (char)n3);
                            continue block9;
                        }
                        System.err.println("Unknown option " + (char)n3);
                    }
                    continue block6;
                }
                System.err.println("Unknown option " + (String)object3);
            } else {
                n = i;
                break;
            }
            stringArray[i] = null;
        }
        this.props = properties2;
        this.args = stringArray;
        this.argStart = n;
        String string = properties2.getProperty(CONFIGURATION);
        Object object4 = object3 = string != null ? IO.toLocalFile(string) : new File(System.getProperty("user.home"), ".grogra.de-platform");
        if (object3 != null && !((File)object3).isDirectory() && !((File)object3).mkdirs()) {
            object3 = null;
        }
        this.configurationDirectory = object3;
        this.logger = Logger.getLogger("de.grogra.pf");
        this.logger.setLevel(Level.CONFIG);
        this.logger.setUseParentHandlers(false);
        if (object3 != null && (((File)(object3 = new File((File)object3, "log"))).isDirectory() || ((File)object3).mkdir())) {
            try {
                FileHandler fileHandler = new FileHandler(((File)object3).getAbsolutePath() + "/platform%u-%g.xml", 0, 10, false);
                fileHandler.setLevel(Level.ALL);
                this.logger.addHandler(fileHandler);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        ConsoleHandler consoleHandler = new ConsoleHandler();
        consoleHandler.setLevel(Level.WARNING);
        if (properties2.containsKey(DEBUG)) {
            try {
                consoleHandler.setLevel(Level.parse(properties2.getProperty(DEBUG)));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                System.err.println("Invalid DEBUG-Level " + properties2.getProperty(DEBUG));
            }
        }
        this.logger.addHandler(consoleHandler);
        this.logger.config("configurationDirectory = " + this.configurationDirectory);
        this.logProperties();
        if (properties2.getProperty(BOOT_PATH) == null) {
            object2 = this.getClass().getProtectionDomain().getCodeSource().getLocation();
            this.logger.config("codeSource = " + object2);
            if (!"file".equals(((URL)object2).getProtocol())) {
                Main.error("Platform must be loaded from filesystem.");
            }
            if (((File)(object3 = Utils.urlToFile((URL)object2))).isFile()) {
                if (!((File)object3).getName().toLowerCase().endsWith(".jar")) {
                    Main.error("Boot classes loaded from unknown file format.");
                }
                object3 = ((File)object3).getParentFile();
            } else if (!((File)object3).isDirectory()) {
                Main.error("Boot classes loaded from unknown file.");
            }
            this.setProperty(BOOT_PATH, ((File)object3).getAbsolutePath());
        }
        if (((File)(object2 = new File(properties2.getProperty(BOOT_PATH), "grogra.de-platform.properties"))).isFile()) {
            try {
                Properties properties3 = new Properties();
                properties3.load(new FileInputStream((File)object2));
                object = properties3.keys();
                while (object.hasMoreElements()) {
                    Object object5 = object.nextElement();
                    if (properties2.containsKey(object5)) continue;
                    properties2.put(object5, properties3.get(object5));
                }
            }
            catch (IOException iOException) {
                this.logger.log(Level.INFO, "", iOException);
            }
        }
        this.rootDirectory = new File(properties2.getProperty(BOOT_PATH));
        if (properties2.getProperty(PROJECT_TREE) != null) {
            this.usesProjectTree = true;
            this.rootDirectory = this.rootDirectory.getParentFile().getParentFile();
        }
        if (!this.rootDirectory.isDirectory()) {
            Main.error("Cannot find root of installation.");
        }
        this.logger.config("rootDirectory = " + this.rootDirectory);
        if (properties2.getProperty(DISABLE_SPLASH) != null) {
            this.disableSplash = true;
        }
        if (properties2.getProperty(SYSTEM_PLUGIN_PATH) == null) {
            if (properties2.getProperty(PROJECT_TREE) == null) {
                this.setProperty(SYSTEM_PLUGIN_PATH, new File(this.rootDirectory, PLUGIN_PATH).toString());
            } else {
                File[] fileArray = this.rootDirectory.listFiles();
                object = new StringBuffer();
                if (fileArray != null) {
                    for (int i = 0; i < fileArray.length; ++i) {
                        if (!fileArray[i].isDirectory() || !((File)(object3 = new File(fileArray[i], "build"))).isDirectory()) continue;
                        ((StringBuffer)object).append(((File)object3).getAbsolutePath()).append(File.pathSeparatorChar);
                    }
                }
                if (((File)(object3 = new File(this.rootDirectory, PLUGIN_PATH))).isDirectory()) {
                    ((StringBuffer)object).append(((File)object3).getAbsolutePath());
                }
                this.setProperty(SYSTEM_PLUGIN_PATH, ((StringBuffer)object).toString());
            }
        }
        if (properties2.getProperty(PLUGIN_PATH) == null) {
            this.setProperty(PLUGIN_PATH, properties2.getProperty(SYSTEM_PLUGIN_PATH) + File.pathSeparatorChar + properties2.getProperty(USER_PLUGIN_PATH, ""));
        }
    }

    private static String getDisableKey(String string) {
        return "disable:" + string;
    }

    private static void addOption(int n, String string, Properties properties, char c) {
        String string2;
        String string3 = OPTIONS[n].substring(2);
        String string4 = string2 = c > '\u0000' ? String.valueOf(c) : string3;
        if (OPTIONS[n].charAt(0) == '*') {
            if (string == null) {
                System.err.println("Option " + string2 + " specified without option value.");
            } else {
                if (string3.equals(DISABLE_PLUGIN)) {
                    string3 = Main.getDisableKey(string);
                }
                properties.setProperty(string3, string);
            }
        } else if (string != null) {
            System.err.println("Option " + string2 + " specified with option value.");
        } else {
            properties.setProperty(string3, "true");
        }
    }

    public static Logger getLogger() {
        return Main.getInstance().logger;
    }

    public static void logWarning(Throwable throwable) {
        Main.getInstance().logger.log(Level.WARNING, "", throwable);
    }

    public static void logSevere(Throwable throwable) {
        Main.getInstance().logger.log(Level.SEVERE, "", throwable);
    }

    public void setProperty(String string, String string2) {
        this.props.setProperty(string, string2);
        this.logger.config(string + " := " + string2);
    }

    public static String getProperty(String string) {
        return Main.getInstance().props.getProperty(string);
    }

    public static String getProperty(String string, String string2) {
        return Main.getInstance().props.getProperty(string, string2);
    }

    public static int getArgCount() {
        Main main = Main.getInstance();
        return main.args.length - main.argStart;
    }

    public static String getArg(int n) {
        Main main = Main.getInstance();
        return main.args[n + main.argStart];
    }

    public static String getVersion() {
        return Main.getInstance().version;
    }

    public static boolean usesProjectTree() {
        return Main.getInstance().usesProjectTree;
    }

    public static Registry getRegistry() {
        return Main.getInstance().registry;
    }

    public static boolean isInitialized() {
        return Main.getInstance() != null;
    }

    public static I18NBundle getI18NBundle(String string) {
        return Main.getInstance().registry.getPluginDescriptor(string).getI18NBundle();
    }

    public static I18NBundle getI18NBundle() {
        return Main.getInstance().i18n;
    }

    public static Object getFromResource(String string) {
        return Main.getApplication().getFromResource(string);
    }

    public static Application getApplication() {
        return Main.getInstance().application;
    }

    public static ClassLoader getLoaderForAll() {
        return Main.getInstance().loaderForAll;
    }

    public static File getConfigurationDirectory() {
        return Main.getInstance().configurationDirectory;
    }

    public static void closeSplashScreen() {
        Main main = Main.getInstance();
        SplashScreen splashScreen = main.splash;
        if (splashScreen != null) {
            main.setProgress(1.0f, main.i18n.msg("splash.running"));
        }
        main.splashWillClose = System.currentTimeMillis() + 1500L;
    }

    public static void error(String string) {
        Main.closeSplashScreen();
        Main.showMessage(string, true);
    }

    public static void error(Throwable throwable) {
        throwable.printStackTrace();
        Main.error("Unexpected exception " + throwable);
    }

    private void logProperties() {
        if (!this.logger.isLoggable(Level.CONFIG)) {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer("Properties:\n");
        Enumeration<Object> enumeration = this.props.keys();
        while (enumeration.hasMoreElements()) {
            Object object = enumeration.nextElement();
            stringBuffer.append(object).append(" = ").append(this.props.get(object)).append('\n');
        }
        this.logger.config(stringBuffer.toString());
    }

    private void setProgress(float f, String string) {
        if (this.splash != null) {
            this.splash.setInitializationProgress(f, this.i18n.msg("splash.progress", string, this.version));
        }
    }

    private URL toURL(String string) {
        String string2 = this.props.getProperty(string);
        URL uRL = null;
        if (string2 != null) {
            try {
                uRL = new URL(Utils.fileToURL(new File(this.props.getProperty(BOOT_PATH))), string2);
            }
            catch (MalformedURLException malformedURLException) {
                this.logger.log(Level.INFO, "", malformedURLException);
            }
        }
        return uRL;
    }

    private Locale getCurrentLocale() {
        Preferences preferences = Preferences.userRoot().node(this.getClass().getName());
        if (preferences == null) {
            return Locale.getDefault();
        }
        Preferences preferences2 = preferences.node("/de/grogra/options/ui/options");
        if (preferences2 == null) {
            return Locale.getDefault();
        }
        try {
            switch (Integer.parseInt(preferences2.get("languages", null))) {
                case 0: {
                    return new Locale("en", "GB");
                }
                case 1: {
                    return new Locale("zh", "CN");
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return Locale.getDefault();
    }

    private void run() {
        Object object;
        int n;
        boolean bl;
        boolean bl2;
        Object object2;
        Comparable<File> comparable;
        Locale.setDefault(this.getCurrentLocale());
        this.i18n = I18NBundle.getInstance(this.getClass());
        I18NBundle.addResourceConverter(ResourceConverter.CAT);
        I18NBundle.addResourceConverter(ResourceConverter.LINK);
        this.version = this.i18n.getString("pluginVersion");
        URL uRL = this.toURL(SPLASH_BACKGROUND);
        if (uRL != null) {
            String string = this.props.getProperty(SPLASH_CLASS, this.props.getProperty(HEADLESS) != null ? "de.grogra.util.ConsoleSplashScreen" : "de.grogra.util.AWTSplashScreen");
            try {
                this.splash = (SplashScreen)Class.forName(string).newInstance();
                this.splash.init(this.props.getProperty(SPLASH_TITLE, "grogra.de"), uRL, this.toURL(SPLASH_FOREGROUND), this.toURL(SPLASH_LOGO), Utils.parseRectangle(this.props.getProperty(SPLASH_BAR_BOUNDS)), this.toURL(SPLASH_BAR_LEFT), this.toURL(SPLASH_BAR_RIGHT), Utils.parsePoint(this.props.getProperty(SPLASH_TEXT_LOCATION, "+10+20")), new Font("SansSerif", 0, 12), Utils.parseColor(this.props.getProperty(SPLASH_TEXT_COLOR, "0 0 0")), false, Main.getInstance().i18n);
            }
            catch (Exception exception) {
                this.logger.log(Level.INFO, "", exception);
                this.splash = null;
            }
            if (this.splash != null && !this.disableSplash) {
                this.setProgress(0.125f, this.i18n.msg("splash.initializing"));
                this.splash.show();
            }
        }
        long l = System.currentTimeMillis();
        this.splashWillClose = l + 20000L;
        int n2 = 0;
        ObjectList<PluginDescriptor> objectList = new ObjectList<PluginDescriptor>();
        final HashMap<String, PluginDescriptor> hashMap = new HashMap<String, PluginDescriptor>();
        PathListIterator pathListIterator = new PathListIterator(this.props.getProperty(PLUGIN_PATH));
        while (pathListIterator.hasNext()) {
            File[] fileArray;
            comparable = pathListIterator.nextPath();
            this.logger.config("Checking plugin-path " + comparable);
            if (!((File)comparable).isDirectory() || (fileArray = ((File)comparable).listFiles()) == null) continue;
            for (int i = 0; i < fileArray.length; ++i) {
                PluginDescriptor pluginDescriptor;
                object2 = null;
                if (fileArray[i].isDirectory()) {
                    object2 = fileArray[i];
                } else if (fileArray[i].isFile() && fileArray[i].getName().equalsIgnoreCase("plugin.xml")) {
                    object2 = comparable;
                }
                if (object2 == null || (pluginDescriptor = this.loadPluginFromDirectory((File)object2)) == null) continue;
                hashMap.put(pluginDescriptor.getName(), pluginDescriptor);
                objectList.add(pluginDescriptor);
                if (this.props.getProperty(Main.getDisableKey(pluginDescriptor.getName())) == null) continue;
                pluginDescriptor.setPluginState(1);
                this.logger.config("Plugin " + pluginDescriptor.getName() + " was disabled by command line option");
                ++n2;
            }
        }
        comparable = new StringBuffer();
        do {
            bl2 = false;
            for (int i = 0; i < objectList.size(); ++i) {
                PluginDescriptor pluginDescriptor = (PluginDescriptor)objectList.get(i);
                if (pluginDescriptor.getPluginState() != 0 || ((Item[])(object2 = pluginDescriptor.findAll(new ItemCriterion(){

                    public boolean isFulfilled(Item item, Object object) {
                        if (item instanceof PluginPrerequisite) {
                            PluginDescriptor pluginDescriptor = (PluginDescriptor)hashMap.get(((PluginPrerequisite)item).getName());
                            return pluginDescriptor == null || pluginDescriptor.getPluginState() != 0;
                        }
                        return item instanceof Prerequisite && !((Prerequisite)item).isFulfilled();
                    }

                    public String getRootDirectory() {
                        return null;
                    }
                }, null, false))).length <= 0) continue;
                pluginDescriptor.setPluginState(3);
                ++n2;
                bl2 = true;
                for (int j = 0; j < ((Item[])object2).length; ++j) {
                    ((Prerequisite)object2[j]).addMessage((StringBuffer)comparable, pluginDescriptor.getPluginName());
                    ((StringBuffer)comparable).append(System.getProperty("line.separator"));
                }
            }
        } while (bl2);
        Registry registry = Registry.create(null);
        File file = new File(this.rootDirectory, "ext");
        if (!file.isDirectory()) {
            file = null;
        }
        this.logger.config("extensionDirectory = " + file);
        object2 = PluginDescriptor.createCoreDescriptor(file);
        ObjectList<PluginClassLoader> objectList2 = new ObjectList<PluginClassLoader>();
        int n3 = 0;
        Item item = registry.getDirectory("/plugins", null);
        item.add((Item)object2);
        do {
            bl = false;
            for (n = 0; n < objectList.size(); ++n) {
                object = (PluginDescriptor)objectList.get(n);
                if (((PluginDescriptor)object).getPluginState() != 0 || ((Item)object).findFirst(new ItemCriterion(){

                    public boolean isFulfilled(Item item, Object object) {
                        if (item instanceof PluginPrerequisite) {
                            PluginDescriptor pluginDescriptor = (PluginDescriptor)hashMap.get(((PluginPrerequisite)item).getName());
                            return pluginDescriptor == null || pluginDescriptor.getPluginState() < 4;
                        }
                        return false;
                    }

                    public String getRootDirectory() {
                        return null;
                    }
                }, null, false) != null) continue;
                this.setProgress(0.25f + 0.65f * (float)n3 / (float)(objectList.size() - n2), this.i18n.msg("splash.loading-plugin", ((PluginDescriptor)object).getPluginName()));
                this.logger.config("Loading " + object);
                if (((PluginDescriptor)object).loadPlugin(registry, ((PluginDescriptor)object2).getClassLoader())) {
                    bl = true;
                    Registry.PLUGIN_FILE_SYSTEMS.addFileSystem(((PluginDescriptor)object).getFileSystem(), ((Node)object).getName(), ((PluginDescriptor)object).getPluginDirectory());
                    objectList2.add(((PluginDescriptor)object).getPluginClassLoader());
                    item.add((Item)object);
                }
                ++n3;
            }
        } while (bl);
        this.setProgress(0.95f, this.i18n.msg("splash.launching"));
        for (n = 0; n < objectList.size(); ++n) {
            object = (PluginDescriptor)objectList.get(n);
            if (((PluginDescriptor)object).getPluginState() != 0) continue;
            System.err.println("Cycle in " + object);
        }
        this.loaderForAll = objectList2.isEmpty() ? this.getClass().getClassLoader() : new DelegatingClassLoader(objectList2.toArray(new ClassLoader[objectList2.size()]));
        this.registry = registry;
        Executable.runExecutables(registry, "/hooks/postboot", registry, new StringMap());
        this.streamHandlerDir = registry.getItem("/io/streamhandlers");
        registry.startup();
        item = registry.getItem("/applications");
        if (item == null) {
            ((StringBuffer)comparable).append(this.i18n.msg("boot.no-application"));
            Main.error(((StringBuffer)comparable).toString());
        }
        String string = this.props.getProperty(APPLICATION);
        for (item = (Item)item.getBranch(); item != null; item = (Item)item.getSuccessor()) {
            if (!(item instanceof Application) || string != null && !item.hasName(string)) continue;
            for (object = (Item)item.getBranch(); object != null; object = (Item)((Node)object).getSuccessor()) {
                if (!(object instanceof Argument) || this.props.getProperty(((Node)object).getName()) != null && !((Argument)object).isOverride()) continue;
                this.props.setProperty(((Node)object).getName(), ((Argument)object).getValue());
            }
            object = this.props.getProperty(SCREEN_PROPERTY);
            if (object != null) {
                try {
                    Integer n4 = Integer.valueOf((String)object);
                    registry.setUserProperty(SCREEN_PROPERTY_ID, n4);
                }
                catch (NumberFormatException numberFormatException) {
                    ((StringBuffer)comparable).append(this.i18n.msg("commandline.invalid", "screen=" + (String)object));
                    Main.error(((StringBuffer)comparable).toString());
                }
            }
            this.application = (Application)item;
            this.logger.config("Starting application " + this.application);
            this.logProperties();
            new Thread((Runnable)this.application, "Application").start();
            break;
        }
        if (item == null) {
            ((StringBuffer)comparable).append(string != null ? this.i18n.msg("boot.application-not-found", string) : this.i18n.msg("boot.no-application"));
            Main.error(((StringBuffer)comparable).toString());
        }
        if (((StringBuffer)comparable).length() > 0) {
            Main.showMessage(((StringBuffer)comparable).toString(), false);
        }
        if (this.splash != null) {
            try {
                long l2;
                while ((l2 = 3000L + l - System.currentTimeMillis()) > 0L) {
                    Thread.sleep(l2);
                }
                while (this.splashWillClose > System.currentTimeMillis()) {
                    Thread.sleep(100L);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.splash.close();
        }
    }

    private PluginDescriptor loadPluginFromDirectory(File file) {
        StringBuffer stringBuffer = new StringBuffer("Looking for plugin in ").append(file).append('\n');
        file = file.getAbsoluteFile();
        Node node = null;
        File file2 = new File(file, "plugin.xml");
        IOException iOException = null;
        if (file2.isFile()) {
            stringBuffer.append("plugin.xml found in ").append(file).append('\n');
            FileInputStream fileInputStream = null;
            try {
                fileInputStream = new FileInputStream(file2);
                node = PluginDescriptor.read(file2.getAbsolutePath(), new BufferedInputStream(fileInputStream), new LocalFileSystem("local", file.getParentFile()), file);
            }
            catch (IOException iOException2) {
                iOException = iOException2;
            }
            if (fileInputStream != null) {
                try {
                    ((InputStream)fileInputStream).close();
                }
                catch (IOException iOException3) {
                    iOException3.printStackTrace();
                }
            }
            if (node == null) {
                stringBuffer.append("Failed reading plugin.xml");
            } else {
                stringBuffer.append("Found plugin ").append(node.getName()).append(' ').append(((PluginDescriptor)node).getPluginVersion()).append('\n');
                File[] fileArray = file.listFiles();
                Locale locale = Locale.getDefault();
                String[] stringArray = new String[]{"plugin", locale.getLanguage(), locale.getCountry(), locale.getVariant()};
                for (int i = 1; i < 4; ++i) {
                    if (stringArray[i] == null) continue;
                    stringArray[i] = stringArray[i - 1] + '_' + stringArray[i];
                }
                XPropertyResourceBundle[] xPropertyResourceBundleArray = new XPropertyResourceBundle[4];
                for (int i = 0; i < fileArray.length; ++i) {
                    String string = fileArray[i].getName();
                    if (!string.endsWith(".properties")) continue;
                    string = string.substring(0, string.length() - 11);
                    for (int j = 0; j < 4; ++j) {
                        if (!string.equals(stringArray[j])) continue;
                        fileInputStream = null;
                        try {
                            fileInputStream = new FileInputStream(fileArray[i]);
                            xPropertyResourceBundleArray[j] = new XPropertyResourceBundle(fileInputStream);
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                        if (fileInputStream == null) continue;
                        try {
                            ((InputStream)fileInputStream).close();
                            continue;
                        }
                        catch (IOException iOException4) {
                            // empty catch block
                        }
                    }
                }
                XPropertyResourceBundle xPropertyResourceBundle = null;
                for (int i = 0; i < 4; ++i) {
                    if (xPropertyResourceBundleArray[i] == null) continue;
                    xPropertyResourceBundleArray[i].setParent(xPropertyResourceBundle);
                    xPropertyResourceBundle = xPropertyResourceBundleArray[i];
                }
                ((PluginDescriptor)node).setI18NBundle(new I18NBundle(xPropertyResourceBundle, node.getName()));
            }
        } else {
            stringBuffer.append("plugin.xml not found in ").append(file);
        }
        this.logger.config(stringBuffer.toString());
        if (iOException != null) {
            this.logger.log(Level.WARNING, "Failure is due to", iOException);
        }
        return node;
    }

    private URLStreamHandler createURLStreamHandler(String string) {
        Item item;
        if ("plugin".equals(string)) {
            return new URLStreamHandler(){

                protected URLConnection openConnection(URL uRL) throws IOException {
                    Serializable serializable;
                    ClassLoader classLoader;
                    String string = uRL.getPath();
                    if (string.charAt(0) == '/') {
                        throw new IOException("Invalid format of URL " + uRL);
                    }
                    int n = string.indexOf(47);
                    if (n < 0) {
                        throw new IOException("Invalid format of URL " + uRL);
                    }
                    if (n == 1) {
                        classLoader = this.getClass().getClassLoader();
                    } else {
                        serializable = Main.getRegistry().getPluginDescriptor(string.substring(0, n));
                        if (serializable == null) {
                            throw new IOException("Plugin of " + uRL + " does not exist");
                        }
                        classLoader = ((PluginDescriptor)serializable).getClassLoader();
                    }
                    serializable = classLoader.getResource(string.substring(n + 1));
                    if (serializable == null) {
                        throw new IOException("Resource " + uRL + " does not exist");
                    }
                    return ((URL)serializable).openConnection();
                }
            };
        }
        if ("project".equals(string)) {
            return Registry.ALL_FILE_SYSTEMS.getURLStreamHandler();
        }
        if (this.streamHandlerDir != null && (item = this.streamHandlerDir.getItem(string)) instanceof Expression) {
            return (URLStreamHandler)((Expression)item).evaluate(this.registry, new StringMap());
        }
        return null;
    }

    public static void showMessage(String string, final boolean bl) {
        System.err.println(string);
        I18NBundle i18NBundle = Main.getInstance().i18n;
        final Frame frame = new Frame(i18NBundle.msg("boot.messages"));
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class Listener
        extends WindowAdapter
        implements ActionListener {
            Listener() {
            }

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                this.actionPerformed(null);
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                frame.dispose();
                if (bl) {
                    System.exit(1);
                }
            }
        }
        Listener listener = new Listener();
        frame.addWindowListener(listener);
        TextArea textArea = new TextArea(string, 20, 80);
        frame.add((Component)textArea, "Center");
        Button button = new Button(i18NBundle.msg("boot.close-messages"));
        button.addActionListener(listener);
        frame.add((Component)button, "South");
        frame.pack();
        frame.setVisible(true);
        if (bl) {
            while (true) {
                try {
                    while (true) {
                        Thread.sleep(1000L);
                    }
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }
    }
}

