/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.pf.io;

import de.grogra.pf.io.FileReaderSource;
import de.grogra.pf.io.FilterSourceBase;
import de.grogra.pf.io.IO;
import de.grogra.pf.io.IOFlavor;
import de.grogra.pf.io.InputStreamSource;
import de.grogra.pf.io.ReaderSource;
import de.grogra.pf.io.VirtualFileReaderSource;
import de.grogra.pf.registry.Registry;
import de.grogra.pf.registry.RegistryContext;
import de.grogra.util.CountingInputStream;
import de.grogra.util.MimeType;
import de.grogra.util.ModifiableMap;
import de.grogra.vfs.FSFile;
import de.grogra.vfs.FileSystem;
import de.grogra.vfs.LocalFileSystem;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;

public class FileSource
extends FilterSourceBase
implements InputStreamSource,
ReaderSource,
FileReaderSource,
VirtualFileReaderSource,
CountingInputStream.Monitor {
    private final FileSystem fs;
    private final Object file;
    private final String systemId;
    private long fileSize;
    private String progrText;

    public FileSource(FileSystem fileSystem, Object object, String string, MimeType mimeType, Registry registry, ModifiableMap modifiableMap) {
        super(new IOFlavor(mimeType, 0x205 | (object instanceof File ? 32 : 0), null), registry, modifiableMap);
        fileSystem.getClass();
        object.getClass();
        this.fs = fileSystem;
        this.file = object;
        this.systemId = string;
    }

    public FileSource(FileSystem fileSystem, Object object, RegistryContext registryContext, ModifiableMap modifiableMap) {
        this(fileSystem, object, IO.toSystemId(fileSystem, object), fileSystem.getMimeType(object), registryContext.getRegistry(), modifiableMap);
    }

    public FileSource(File file, MimeType mimeType, Registry registry, ModifiableMap modifiableMap) {
        this(LocalFileSystem.FILE_ADAPTER, file, IO.toSystemId(file), mimeType, registry, modifiableMap);
    }

    public FileSystem getFileSystem() {
        return this.fs;
    }

    public Object getFile() {
        return this.file;
    }

    public String getSystemId() {
        return this.systemId;
    }

    public boolean isReadOnly() {
        return this.fs.isReadOnly(this.file);
    }

    public InputStream getInputStream() throws IOException {
        CountingInputStream countingInputStream = new CountingInputStream(this.fs.getInputStream(this.file));
        this.progrText = IO.I18N.msg("progress.reading", this.fs.getName(this.file));
        this.fileSize = this.fs.getSize(this.file);
        countingInputStream.setMonitor(this, this.fileSize >> 10);
        return countingInputStream;
    }

    public long length() {
        return this.fs.getSize(this.file);
    }

    public void bytesRead(long l) {
        if (this.useAutoProgress()) {
            this.setProgress0(this.progrText, (float)l / (float)this.fileSize);
        }
    }

    public void streamClosed() {
        if (this.useAutoProgress()) {
            this.setProgress0(IO.I18N.msg("progress.done", this.fs.getName(this.file)), 2.0f);
        }
    }

    public OutputStream getOutputStream(boolean bl) throws IOException {
        return this.fs.getOutputStream(this.file, bl);
    }

    public Writer getWriter(boolean bl) throws IOException {
        return this.fs.getWriter(this.file, bl);
    }

    public Reader getReader() throws IOException {
        return new InputStreamReader(this.getInputStream(), this.fs.getCharset(this.file));
    }

    public File getInputFile() {
        return (File)this.file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StringBuffer readContent() throws IOException {
        Reader reader = null;
        try {
            int n;
            reader = this.getReader();
            StringBuffer stringBuffer = new StringBuffer();
            while ((n = reader.read()) >= 0) {
                stringBuffer.append((char)n);
            }
            StringBuffer stringBuffer2 = stringBuffer;
            return stringBuffer2;
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
    }

    public URL toURL() {
        String string = Registry.ALL_FILE_SYSTEMS.getFileSystemName(this.fs);
        if (string == null) {
            return this.fs.toURL(this.file);
        }
        return Registry.ALL_FILE_SYSTEMS.toURL(Registry.ALL_FILE_SYSTEMS.getFile(string + this.fs.getPathWithLeadingSlash(this.file)));
    }

    public static FileSource createFileSource(String string, MimeType mimeType, RegistryContext registryContext, ModifiableMap modifiableMap) {
        FSFile fSFile = IO.toFile(registryContext, string);
        return new FileSource(fSFile.fileSystem, fSFile.file, string, mimeType, registryContext.getRegistry(), modifiableMap);
    }
}

