/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.pf.io;

import de.grogra.graph.impl.GraphManager;
import de.grogra.graph.impl.Node;
import de.grogra.graph.impl.XMLGraphWriter;
import de.grogra.persistence.PersistenceOutputListener;
import de.grogra.pf.io.IOFlavor;
import de.grogra.pf.io.SAXSourceBase;
import de.grogra.pf.registry.Registry;
import de.grogra.util.MimeType;
import de.grogra.util.Utils;
import java.io.IOException;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;

public class GraphXMLSource
extends SAXSourceBase {
    public static final MimeType MIME_TYPE = new MimeType("application/x-grogra-graph+xml", null);
    static final IOFlavor FLAVOR = new IOFlavor(MIME_TYPE, 16, null);
    private final GraphManager graph;
    private final PersistenceOutputListener ol;
    private final boolean writeOnlyReferences;
    private Node root;

    public GraphXMLSource(GraphManager graphManager, Registry registry, PersistenceOutputListener persistenceOutputListener) {
        this(graphManager, registry, persistenceOutputListener, false);
    }

    public GraphXMLSource(GraphManager graphManager, Registry registry, PersistenceOutputListener persistenceOutputListener, Node node) {
        this(graphManager, registry, persistenceOutputListener, false);
        this.root = node;
    }

    public GraphXMLSource(GraphManager graphManager, Registry registry, PersistenceOutputListener persistenceOutputListener, boolean bl) {
        super(FLAVOR, registry, null);
        this.graph = graphManager;
        this.ol = persistenceOutputListener;
        this.writeOnlyReferences = bl;
    }

    public String getSystemId() {
        return "graph";
    }

    public void parse(ContentHandler contentHandler, ErrorHandler errorHandler, LexicalHandler lexicalHandler, DTDHandler dTDHandler, EntityResolver entityResolver) throws SAXException {
        if (contentHandler != null) {
            contentHandler.startDocument();
            try {
                this.graph.writeExtent(new XMLGraphWriter(contentHandler, this.ol, this.writeOnlyReferences), this.root);
            }
            catch (IOException iOException) {
                throw Utils.newSAXException(iOException);
            }
            contentHandler.endDocument();
        }
    }
}

