/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.pf.registry;

import de.grogra.graph.AccessorMap;
import de.grogra.graph.Attribute;
import de.grogra.graph.AttributeAccessor;
import de.grogra.graph.BooleanAttributeAccessor;
import de.grogra.graph.ByteAttributeAccessor;
import de.grogra.graph.CharAttributeAccessor;
import de.grogra.graph.DoubleAttributeAccessor;
import de.grogra.graph.FloatAttributeAccessor;
import de.grogra.graph.GraphState;
import de.grogra.graph.IntAttributeAccessor;
import de.grogra.graph.LongAttributeAccessor;
import de.grogra.graph.ObjectAttributeAccessor;
import de.grogra.graph.ShortAttributeAccessor;
import de.grogra.graph.impl.Edge;
import de.grogra.graph.impl.Node;
import de.grogra.persistence.ManageableType;
import de.grogra.persistence.PersistenceBindings;
import de.grogra.persistence.Transaction;
import de.grogra.persistence.XMLPersistenceWriter;
import de.grogra.pf.boot.Main;
import de.grogra.pf.registry.Directory;
import de.grogra.pf.registry.ItemComparator;
import de.grogra.pf.registry.ItemCriterion;
import de.grogra.pf.registry.ItemVisitor;
import de.grogra.pf.registry.Option;
import de.grogra.pf.registry.PluginClassLoader;
import de.grogra.pf.registry.PluginDescriptor;
import de.grogra.pf.registry.Registry;
import de.grogra.pf.registry.RegistryContext;
import de.grogra.pf.registry.XMLSerializer;
import de.grogra.reflect.Field;
import de.grogra.reflect.FieldChain;
import de.grogra.reflect.Reflection;
import de.grogra.reflect.Type;
import de.grogra.util.Described;
import de.grogra.util.I18NBundle;
import de.grogra.util.Map;
import de.grogra.util.StringMap;
import de.grogra.util.TreeDiff;
import de.grogra.util.Utils;
import de.grogra.util.WrapException;
import de.grogra.xl.util.ObjectList;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.MissingResourceException;
import javax.swing.event.TreeModelEvent;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class Item
extends Node
implements Described,
RegistryContext {
    static final Item[] ITEM_0 = new Item[0];
    private static final ThreadLocal DERIVED_SOURCE = new ThreadLocal();
    private static final int ST_PROGRAM = 0;
    private static final int ST_USER = 1;
    private static final int ST_DERIVED = 2;
    private static final int ST_PLUGIN = 3;
    private Registry registry = null;
    private String absoluteName = null;
    private boolean isDirectory = false;
    private boolean optionCategory = false;
    private int sourceType = 0;
    private PluginDescriptor pluginDescriptor = null;
    private int stamp = 0;
    final ObjectList oldChildren = new ObjectList(4, false);
    private TreeDiff.DiffInfo diffInfo;
    private ObjectList derivedItems = null;
    private String[][] elements = null;
    private boolean activated = false;
    private StringMap descriptions = null;
    private AccessorMap attributes = null;
    private Described description;
    private Described defaultDescription;
    public static final Node.NType $TYPE = new Node.NType(new Item());
    private static final ItemVisitor ACTIVATOR;

    protected Node.NType getNTypeImpl() {
        return $TYPE;
    }

    protected Node newInstance() {
        return new Item();
    }

    private Item() {
        this(null, false);
    }

    public Item(String string, boolean bl) {
        this.setName(string);
        this.isDirectory = bl;
        Item item = (Item)DERIVED_SOURCE.get();
        if (item != null) {
            if (item.derivedItems == null) {
                item.derivedItems = new ObjectList(10);
            }
            item.derivedItems.add(this);
        }
    }

    public Item(String string) {
        this(string, false);
    }

    public static Item resolveItem(RegistryContext registryContext, String string) {
        for (Registry registry = registryContext.getRegistry(); registry != null; registry = registry.getParentRegistry()) {
            Item item = registry.getItem(string);
            if (item == null) continue;
            return item.resolveLink(registryContext);
        }
        return null;
    }

    public Item resolveLink(RegistryContext registryContext) {
        return this;
    }

    public final Object getLock() {
        return this.getRegistry() == null ? this : this.registry.getLock();
    }

    public final Object getWriteLock() {
        return this.getRegistry() == null ? this : this.registry.getWriteLock();
    }

    TreeDiff.DiffInfo getDiffInfo() {
        if (this.diffInfo == null) {
            this.diffInfo = new TreeDiff.DiffInfo(this);
        }
        return this.diffInfo;
    }

    protected void dupUnmanagedFields(Node node) {
        Item item = (Item)node;
        this.isDirectory = item.isDirectory;
    }

    public Object getDefaultValue(Node.NType.Field field) {
        return field.get(this.getNType().getRepresentative(), null);
    }

    public I18NBundle getI18NBundle() {
        return this.pluginDescriptor != null ? this.pluginDescriptor.getI18NBundle() : null;
    }

    public Object getFromResource(String string) {
        return this.getI18NBundle().getObject(string, null);
    }

    public Class classForName(String string, boolean bl) throws ClassNotFoundException {
        return Class.forName(string, bl, this.pluginDescriptor.getClassLoader());
    }

    protected void setDirectory() {
        this.isDirectory = true;
    }

    public boolean isDirectory() {
        return this.isDirectory;
    }

    public final Item makeUserItem(boolean bl) {
        this.sourceType = 1;
        if (bl) {
            for (Node node = this.getBranch(); node != null; node = node.getSuccessor()) {
                ((Item)node).makeUserItem(true);
            }
        }
        return this;
    }

    public final boolean isUserItem() {
        return this.sourceType == 1;
    }

    public void setName(String string) {
        boolean bl = this.getName() != null;
        super.setName(string);
        this.absoluteName = null;
        if (bl) {
            this.descriptions = null;
        }
    }

    protected static final void setNameIfNull(Item item, String string) {
        if (item.getName() == null) {
            item.setName(string);
        }
    }

    public final boolean isPluginItem(String string, String string2) {
        return this.hasName(string2) && (string == null || this.getPluginDescriptor() != null && string.equals(this.getPluginDescriptor().getName()));
    }

    private void updateDerived() {
        Item item = (Item)this.getAxisParent();
        String string = this.getName();
        if (string.indexOf(47) >= 0 || string.indexOf(92) >= 0) {
            string = Utils.escape(string, "/\\");
        }
        this.absoluteName = item == null ? string : item.getAbsoluteName() + '/' + string;
        this.stamp = this.getRegistry().stamp;
    }

    public final String getAbsoluteName() {
        if (this.absoluteName == null || this.stamp != this.getRegistry().stamp) {
            this.updateDerived();
        }
        return this.absoluteName;
    }

    public final Item getRoot() {
        Item item = this;
        while (item.getAxisParent() != null) {
            item = (Item)item.getAxisParent();
        }
        return item;
    }

    public void setDescription(Described described) {
        this.description = described;
    }

    public void setDefaultDescription(Described described) {
        this.defaultDescription = described;
    }

    public void setDescription(String string, Object object) {
        if (this.descriptions == null) {
            this.descriptions = new StringMap(8);
        }
        this.descriptions.put(string, object);
    }

    /*
     * Enabled aggressive block sorting
     */
    public final Object getDescription(String string) {
        Object object;
        block17: {
            StringBuffer stringBuffer;
            block18: {
                block16: {
                    if (this.descriptions != null && (object = this.descriptions.get(string)) != null) {
                        if (object == this) {
                            return null;
                        }
                        Object object2 = object;
                        return object2;
                    }
                    object = this.getDerivedDescription(string);
                    if (object != null) {
                        return object;
                    }
                    if (this.descriptions == null) {
                        this.descriptions = new StringMap(8);
                    }
                    if ((object = this.getDescriptionImpl(string)) == null) {
                        object = this.getDefaultDescription(string);
                    }
                    if (!"Name".equals(string)) break block16;
                    if (object == null || object == this.getName()) break block17;
                    stringBuffer = new StringBuffer(object.toString());
                    break block18;
                }
                if ("MnemonicKey".equals(string) && object == null) {
                    this.getDescription("Name");
                    object = this.descriptions.get("MnemonicKey");
                    if (object != null) {
                        if (object == this) {
                            return null;
                        }
                        Object object3 = object;
                        return object3;
                    }
                }
                break block17;
            }
            block4: for (int i = 0; i < stringBuffer.length(); ++i) {
                switch (stringBuffer.charAt(i)) {
                    case '\\': {
                        stringBuffer.delete(i, i + 1);
                        break;
                    }
                    case '&': {
                        stringBuffer.delete(i, i + 1);
                        if (this.descriptions.containsKey("MnemonicKey")) break block4;
                        object = this.getDescriptionImpl("MnemonicKey");
                        if (object != null) {
                            this.descriptions.put("MnemonicKey", object);
                            break block4;
                        }
                        char c = stringBuffer.charAt(i);
                        if (c >= 'a' && c <= 'z') {
                            c = (char)(c - 32);
                        }
                        if (c >= '0' && c <= '9' || c >= 'A' && c <= 'Z') {
                            this.descriptions.put("MnemonicKey", (Object)c);
                            break block4;
                        }
                        this.descriptions.put("MnemonicKey", (Object)this);
                        break block4;
                    }
                }
            }
            object = stringBuffer.toString();
        }
        this.descriptions.put(string, object == null ? this : object);
        return object;
    }

    protected Object getDerivedDescription(String string) {
        return null;
    }

    protected Object getDefaultDescription(String string) {
        Object object;
        if (this.defaultDescription != null && (object = this.defaultDescription.getDescription(string)) != null) {
            return object;
        }
        return "Name".equals(string) ? this.getName() : (Utils.isStringDescription(string) ? this.getDescription("Name") : null);
    }

    protected Object getDescriptionImpl(String string) {
        if (this.description != null) {
            return this.description.getDescription(string);
        }
        I18NBundle i18NBundle = this.getI18NBundle();
        if (i18NBundle != null) {
            try {
                return i18NBundle.getObject(this.getAbsoluteName() + '.' + string);
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        return null;
    }

    protected Map getParentMap() {
        return null;
    }

    public synchronized AttributeAccessor getAccessor(Attribute attribute) {
        AttributeAccessor attributeAccessor = super.getAccessor(attribute);
        if (attributeAccessor == null) {
            if (this.attributes != null) {
                attributeAccessor = this.attributes.getAccessor(attribute);
                if (attributeAccessor != null) {
                    return attributeAccessor;
                }
            } else {
                this.attributes = new AccessorMap(false);
            }
            attributeAccessor = new AdditionalAccessor(attribute);
            this.attributes.add(attributeAccessor);
        }
        return attributeAccessor;
    }

    public synchronized AttributeAccessor getAccessor(String string) {
        AttributeAccessor attributeAccessor = super.getAccessor(string);
        if (attributeAccessor == null && this.attributes != null) {
            attributeAccessor = this.attributes.find(string);
        }
        return attributeAccessor;
    }

    public synchronized Attribute[] getAttributes() {
        Attribute[] attributeArray = super.getAttributes();
        if (this.attributes != null && this.attributes.size() != 0) {
            attributeArray = this.attributes.getAttributes(attributeArray);
        }
        return attributeArray;
    }

    public Object get(Object object, Object object2) {
        Object object3;
        if (object instanceof Attribute) {
            object = ((Attribute)object).getKey();
        }
        if ((object3 = super.get(object, DEFAULT_VALUE)) == DEFAULT_VALUE) {
            Option option;
            if (this.getParentMap() != null) {
                object3 = this.getParentMap().get(object, DEFAULT_VALUE);
            }
            if (object3 == DEFAULT_VALUE && object instanceof String && (option = Option.get(this, (String)object)) != null && (object3 = option.getObject()) == null) {
                object3 = DEFAULT_VALUE;
            }
            if (object3 == DEFAULT_VALUE) {
                if (object instanceof String && (object.equals("Name") || object.equals("ShortDescription") || object.equals("Title") || object.equals("Icon"))) {
                    return this.getDescription((String)object);
                }
                return object2;
            }
        }
        return object3;
    }

    public void setOption(String string, Object object) {
        Option option = Option.get(this, string);
        if (option != null) {
            option.setOptionValue(object);
        }
    }

    public Item initPluginDescriptor(PluginDescriptor pluginDescriptor) {
        if (this.pluginDescriptor == null) {
            this.sourceType = 3;
            this.pluginDescriptor = pluginDescriptor;
        }
        return this;
    }

    public final PluginDescriptor getPluginDescriptor() {
        return this.pluginDescriptor;
    }

    public ClassLoader getClassLoader() {
        return this.pluginDescriptor != null ? this.pluginDescriptor.getClassLoader() : Main.getLoaderForAll();
    }

    public final boolean isActivated() {
        return this.activated;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final ObjectList deriveItems(ItemVisitor itemVisitor, Object object) {
        Object t = DERIVED_SOURCE.get();
        DERIVED_SOURCE.set(this);
        try {
            itemVisitor.visit(this, object);
            if (this.derivedItems != null) {
                for (int i = this.derivedItems.size() - 1; i >= 0; --i) {
                    Item item = (Item)this.derivedItems.get(i);
                    if (item == item.getNType().getRepresentative() || item instanceof Directory && ((Directory)item).autoGenerated) {
                        this.derivedItems.remove(i);
                        continue;
                    }
                    item.sourceType = 2;
                }
            }
        }
        finally {
            DERIVED_SOURCE.set(t);
        }
        return this.derivedItems;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void removeDerivedItems(Registry registry, ObjectList objectList) {
        if (objectList != null && !objectList.isEmpty()) {
            Object object = registry.getWriteLock();
            synchronized (object) {
                registry.beginXA();
                try {
                    Object object2 = registry.getLock();
                    synchronized (object2) {
                        for (int i = objectList.size() - 1; i >= 0; --i) {
                            Item item = (Item)objectList.get(i);
                            Item item2 = (Item)item.getAxisParent();
                            if (item2 == null) continue;
                            item.removeFromChain(registry.getTransaction());
                        }
                    }
                    while (!objectList.isEmpty()) {
                        ((Item)objectList.pop()).deactivate();
                    }
                }
                finally {
                    registry.commitXA(false);
                }
            }
        }
    }

    public final void activate() {
        assert (!this.activated);
        this.activated = true;
        if (this.getName() == null) {
            this.setName(((Item)this.getAxisParent()).getUniqueName("_", false));
        }
        this.deriveItems(ACTIVATOR, null);
    }

    public final void deactivate() {
        if (this.activated) {
            this.activated = false;
            this.deactivateImpl();
        }
        Item.removeDerivedItems(this.getRegistry(), this.derivedItems);
    }

    protected void activateImpl() {
    }

    protected void deactivateImpl() {
    }

    final void setRegistry(Registry registry) {
        this.registry = registry;
    }

    public final Registry getRegistry() {
        Node node;
        if (this.registry == null && (node = this.getAxisParent()) != null) {
            this.registry = ((Item)node).getRegistry();
        }
        return this.registry;
    }

    public boolean validate() {
        return true;
    }

    public final Item getItem(CharSequence charSequence) {
        if (charSequence != null) {
            for (Item item = (Item)this.getBranch(); item != null; item = (Item)item.getSuccessor()) {
                if (!Utils.contentEquals(charSequence, item.getName())) continue;
                return item;
            }
        }
        return null;
    }

    final Item getItem(CharSequence charSequence, int n, boolean bl) {
        block0: for (Item item = (Item)this.getBranch(); item != null; item = (Item)item.getSuccessor()) {
            if (item.getName() == null) continue;
            int n2 = n;
            String string = item.getName();
            for (int i = 0; i < string.length(); ++i) {
                char c;
                if (n2 >= charSequence.length()) continue block0;
                if ((c = charSequence.charAt(n2++)) == '\\') {
                    if (n2 == charSequence.length()) continue block0;
                    c = charSequence.charAt(n2++);
                }
                if (c != string.charAt(i)) continue block0;
            }
            if (n2 != charSequence.length() && (!bl || n2 >= charSequence.length() || charSequence.charAt(n2) != '/')) continue;
            return item;
        }
        return null;
    }

    public boolean isEditable(Field field) {
        return false;
    }

    public boolean equals(ManageableType.Field field, Object object, Object object2) {
        return object == object2 || object != null && object.equals(object2);
    }

    final void updateChildren(boolean bl) {
        this.oldChildren.clear();
        for (Item item = (Item)this.getBranch(); item != null; item = (Item)item.getSuccessor()) {
            this.oldChildren.add(item);
            if (!bl) continue;
            item.updateChildren(true);
        }
    }

    public final Item[] getPath() {
        Item[] itemArray;
        int n = 0;
        for (itemArray = this; itemArray != null; itemArray = itemArray.getAxisParent()) {
            ++n;
        }
        itemArray = new Item[n];
        for (Object object = this; object != null; object = object.getAxisParent()) {
            itemArray[--n] = (Item)object;
        }
        return itemArray;
    }

    final TreeModelEvent createTreeModelEvent(Item item) {
        Object[] objectArray;
        int[] nArray;
        Object[] objectArray2 = this.getPath();
        if (item == null) {
            nArray = null;
        } else {
            int[] nArray2 = new int[1];
            nArray = nArray2;
            nArray2[0] = item.getIndex();
        }
        if (item == null) {
            objectArray = null;
        } else {
            Object[] objectArray3 = new Object[1];
            objectArray = objectArray3;
            objectArray3[0] = item;
        }
        return new TreeModelEvent((Object)this, objectArray2, nArray, objectArray);
    }

    public final void beginXA() {
        Registry registry = this.getRegistry();
        if (registry != null) {
            registry.beginXA();
        }
    }

    public final Transaction getTransaction() {
        Registry registry = this.getRegistry();
        return registry != null ? registry.getTransaction() : null;
    }

    public final void commitXA(boolean bl) {
        Registry registry = this.getRegistry();
        if (registry != null) {
            registry.commitXA(bl);
        }
    }

    public final Item addUserItem(Item item) {
        return this.add(item.makeUserItem(false));
    }

    public final Item addUserItemWithUniqueName(Item item, String string) {
        return this.addWithUniqueName(item.makeUserItem(false), string, true);
    }

    public final Item add(Item item) {
        return this.add(Integer.MAX_VALUE, item);
    }

    public final Item addWithUniqueName(Item item, String string, boolean bl) {
        item.setName(this.getUniqueName(item.getName() != null ? item.getName() : string, bl));
        return this.add(item);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Item add(int n, Item item) {
        Object object = this.getWriteLock();
        synchronized (object) {
            this.beginXA();
            Object object2 = this.getLock();
            synchronized (object2) {
                this.insertBranchNode(n, item, this.getTransaction());
            }
            this.commitXA(true);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void substitute(Item item) {
        Object object = this.getWriteLock();
        synchronized (object) {
            this.beginXA();
            Object object2 = this.getLock();
            synchronized (object2) {
                Edge edge = item.getFirstEdge();
                while (edge != null) {
                    Edge edge2 = edge.getNext(item);
                    Node node = edge.getSource();
                    Node node2 = edge.getTarget();
                    int n = edge.getEdgeBits();
                    edge.remove(null);
                    if (node == item) {
                        this.addEdgeBitsTo(node2, n, this.getTransaction());
                    } else {
                        node.addEdgeBitsTo(this, n, this.getTransaction());
                    }
                    edge = edge2;
                }
            }
            this.commitXA(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void remove() {
        Object object = this.getWriteLock();
        synchronized (object) {
            this.beginXA();
            Object object2 = this.getLock();
            synchronized (object2) {
                this.removeFromChain(this.getTransaction());
            }
            this.commitXA(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void set(ManageableType.Field field, int[] nArray, Object object) {
        Object object2 = this.getWriteLock();
        synchronized (object2) {
            this.beginXA();
            Object object3 = this.getLock();
            synchronized (object3) {
                field.setObject(this, nArray, object, this.getTransaction());
            }
            this.commitXA(false);
        }
    }

    public Item findFirst(ItemCriterion itemCriterion, Object object, boolean bl) {
        Item item;
        if (itemCriterion.isFulfilled(this, object)) {
            return this;
        }
        Item item2 = item = bl ? this.resolveLink(this) : this;
        if (item != this) {
            if (item == null) {
                return null;
            }
            if (itemCriterion.isFulfilled(item, object)) {
                return item;
            }
        }
        for (item = (Item)item.getBranch(); item != null; item = (Item)item.getSuccessor()) {
            Item item3 = item.findFirst(itemCriterion, object, bl);
            if (item3 == null) continue;
            return item3;
        }
        return null;
    }

    public Item[] findAll(ItemCriterion itemCriterion, Object object, boolean bl) {
        ObjectList objectList = new ObjectList(20);
        this.findAll(itemCriterion, object, objectList, bl);
        if (objectList.size == 0) {
            return ITEM_0;
        }
        Item[] itemArray = new Item[objectList.size];
        objectList.toArray(itemArray);
        return itemArray;
    }

    private void findAll(ItemCriterion itemCriterion, Object object, ObjectList objectList, boolean bl) {
        Item item;
        if (itemCriterion.isFulfilled(this, object)) {
            objectList.add(this);
        }
        Item item2 = item = bl ? this.resolveLink(this) : this;
        if (item != this) {
            if (item == null) {
                return;
            }
            if (itemCriterion.isFulfilled(item, object)) {
                objectList.add(item);
            }
        }
        for (item = (Item)item.getBranch(); item != null; item = (Item)item.getSuccessor()) {
            item.findAll(itemCriterion, object, objectList, bl);
        }
    }

    public void forAll(ItemCriterion itemCriterion, Object object, ItemVisitor itemVisitor, Object object2, boolean bl) {
        Item item;
        if (itemCriterion == null || itemCriterion.isFulfilled(this, object)) {
            itemVisitor.visit(this, object2);
        }
        Item item2 = item = bl ? this.resolveLink(this) : this;
        if (item != this) {
            if (item == null) {
                return;
            }
            if (itemCriterion == null || itemCriterion.isFulfilled(item, object)) {
                itemVisitor.visit(item, object2);
            }
        }
        item = (Item)item.getBranch();
        while (item != null) {
            Item item3 = (Item)item.getSuccessor();
            item.forAll(itemCriterion, object, itemVisitor, object2, bl);
            item = item3;
        }
    }

    public Item findMax(ItemComparator itemComparator, Object object, boolean bl) {
        return this.findMax(itemComparator, null, object, bl);
    }

    private Item findMax(ItemComparator itemComparator, Item item, Object object, boolean bl) {
        Item item2;
        if (itemComparator.compare(this, item, object) > 0) {
            item = this;
        }
        Item item3 = item2 = bl ? this.resolveLink(this) : this;
        if (item2 != this) {
            if (item2 == null) {
                return item;
            }
            if (itemComparator.compare(item2, item, object) > 0) {
                item = item2;
            }
        }
        for (item2 = (Item)item2.getBranch(); item2 != null; item2 = (Item)item2.getSuccessor()) {
            String string = item2.getName();
            if (string != null && string.length() != 0 && string.charAt(0) == '.') continue;
            item = item2.findMax(itemComparator, item, object, bl);
        }
        return item;
    }

    public static Item findFirst(Item item, ItemCriterion itemCriterion, Object object, boolean bl) {
        return item == null ? null : item.findFirst(itemCriterion, object, bl);
    }

    public static Item findFirst(RegistryContext registryContext, String string, ItemCriterion itemCriterion, Object object, boolean bl) {
        return Item.findFirst(Item.resolveItem(registryContext, string), itemCriterion, object, bl);
    }

    public static Item[] findAll(Item item, ItemCriterion itemCriterion, Object object, boolean bl) {
        return item == null ? ITEM_0 : item.findAll(itemCriterion, object, bl);
    }

    public static Item[] findAll(RegistryContext registryContext, String string, ItemCriterion itemCriterion, Object object, boolean bl) {
        return Item.findAll(Item.resolveItem(registryContext, string), itemCriterion, object, bl);
    }

    public static void forAll(Item item, ItemCriterion itemCriterion, Object object, ItemVisitor itemVisitor, Object object2, boolean bl) {
        if (item != null) {
            item.forAll(itemCriterion, object, itemVisitor, object2, bl);
        }
    }

    public static void forAll(RegistryContext registryContext, String string, ItemCriterion itemCriterion, Object object, ItemVisitor itemVisitor, Object object2, boolean bl) {
        Item.forAll(Item.resolveItem(registryContext, string), itemCriterion, object, itemVisitor, object2, bl);
    }

    public static Item findMax(Item item, ItemComparator itemComparator, Object object, boolean bl) {
        return item == null ? null : item.findMax(itemComparator, object, bl);
    }

    public static Item findMax(RegistryContext registryContext, String string, ItemComparator itemComparator, Object object, boolean bl) {
        return Item.findMax(Item.resolveItem(registryContext, string), itemComparator, object, bl);
    }

    public String getUniqueName(String string, boolean bl) {
        if (this.getItem(string) == null) {
            return string;
        }
        int n = bl ? 2 : 0;
        StringBuffer stringBuffer = new StringBuffer(string);
        if (bl) {
            stringBuffer.append(' ');
        }
        int n2 = stringBuffer.length();
        while (true) {
            stringBuffer.append(n++);
            if (this.getItem(stringBuffer) == null) {
                return stringBuffer.toString();
            }
            stringBuffer.setLength(n2);
        }
    }

    protected String paramString() {
        return this.getName();
    }

    String getXMLElementName() {
        return this.getClass().getName();
    }

    protected void getAttributes(AttributesImpl attributesImpl, XMLPersistenceWriter xMLPersistenceWriter) throws SAXException {
        try {
            xMLPersistenceWriter.getAttributes(this, attributesImpl);
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    void accept(XMLSerializer xMLSerializer) throws SAXException {
        AttributesImpl attributesImpl = xMLSerializer.startElement(this);
        if (this.sourceType == 1) {
            this.getAttributes(attributesImpl, xMLSerializer.writer);
            xMLSerializer.setAttributes(attributesImpl);
        }
        for (Item item = (Item)this.getBranch(); item != null; item = (Item)item.getSuccessor()) {
            item.accept(xMLSerializer);
        }
        xMLSerializer.endElement();
    }

    protected boolean readAttribute(String string, String string2, String string3) throws SAXException {
        if ("".equals(string)) {
            if ("name".equals(string2)) {
                this.setName(string3);
                return true;
            }
            if ("i18nkey".equals(string2)) {
                return true;
            }
            if ("optionCategory".equals(string2)) {
                this.optionCategory = "true".equals(string3);
                if (this.optionCategory) {
                    this.isDirectory = true;
                }
                return true;
            }
            if ("dir".equals(string2)) {
                this.isDirectory = "true".equals(string3);
                return true;
            }
            if ("elements".equals(string2)) {
                ObjectList<String> objectList = new ObjectList<String>();
                int n = 0;
                while (true) {
                    char c;
                    if (Character.isWhitespace(c = string3.charAt(n)) || "{},".indexOf(c) >= 0) {
                        if (++n != string3.length()) continue;
                        break;
                    }
                    int n2 = n;
                    while (!Character.isWhitespace(c = string3.charAt(n)) && "{},".indexOf(c) < 0) {
                        ++n;
                    }
                    objectList.add(string3.substring(n2, n));
                }
                n = objectList.size() / 2;
                this.elements = new String[n][];
                while (--n >= 0) {
                    this.elements[n] = new String[]{(String)objectList.get(2 * n), (String)objectList.get(2 * n + 1)};
                }
                return true;
            }
        }
        return false;
    }

    protected Item createItem(PersistenceBindings persistenceBindings, String string) throws InvocationTargetException, InstantiationException, IllegalAccessException, ClassNotFoundException {
        Item item;
        if (this.elements != null) {
            for (int i = this.elements.length - 1; i >= 0; --i) {
                if (!this.elements[i][0].equals(string)) continue;
                return (Item)persistenceBindings.typeForName(this.elements[i][1], true).newInstance();
            }
        }
        return (item = (Item)this.getAxisParent()) == null ? null : item.createItem(persistenceBindings, string);
    }

    public void addRequiredFiles(Collection collection) {
    }

    public void addPluginPrerequisites(Collection collection) {
        Item.addPluginPrerequisite(collection, this.getClass());
        if (this.getPluginDescriptor() != null) {
            collection.add(this.getPluginDescriptor());
        }
    }

    protected static void addPluginPrerequisite(Collection collection, Class clazz) {
        ClassLoader classLoader = clazz.getClassLoader();
        if (classLoader instanceof PluginClassLoader) {
            collection.add(((PluginClassLoader)classLoader).getPluginDescriptor());
        }
    }

    public boolean hasEditableOptions() {
        return Option.hasEditableOptions(this);
    }

    public boolean isOptionCategory() {
        return this.optionCategory;
    }

    static {
        $TYPE.validate();
        ACTIVATOR = new ItemVisitor(){

            public void visit(Item item, Object object) {
                item.activateImpl();
            }
        };
    }

    private static final class AdditionalAccessor
    implements AttributeAccessor,
    BooleanAttributeAccessor,
    ByteAttributeAccessor,
    ShortAttributeAccessor,
    CharAttributeAccessor,
    IntAttributeAccessor,
    LongAttributeAccessor,
    FloatAttributeAccessor,
    DoubleAttributeAccessor,
    ObjectAttributeAccessor {
        private final Attribute attribute;
        private Object value;

        AdditionalAccessor(Attribute attribute) {
            this.attribute = attribute;
        }

        public Type getType() {
            return this.attribute.getType();
        }

        public Attribute getAttribute() {
            return this.attribute;
        }

        public Field getField() {
            return null;
        }

        public boolean isWritable(Object object, GraphState graphState) {
            return true;
        }

        public boolean getBoolean(Object object, GraphState graphState) {
            return this.value != null ? (Boolean)this.value : false;
        }

        public boolean setBoolean(Object object, boolean bl, GraphState graphState) {
            this.value = bl ? Boolean.TRUE : Boolean.FALSE;
            return bl;
        }

        public byte getByte(Object object, GraphState graphState) {
            return this.value != null ? ((Number)this.value).byteValue() : (byte)0;
        }

        public byte setByte(Object object, byte by, GraphState graphState) {
            this.value = by;
            return by;
        }

        public short getShort(Object object, GraphState graphState) {
            return this.value != null ? ((Number)this.value).shortValue() : (short)0;
        }

        public short setShort(Object object, short s, GraphState graphState) {
            this.value = s;
            return s;
        }

        public char getChar(Object object, GraphState graphState) {
            return this.value != null ? ((Character)this.value).charValue() : (char)'\u0000';
        }

        public char setChar(Object object, char c, GraphState graphState) {
            this.value = Character.valueOf(c);
            return c;
        }

        public int getInt(Object object, GraphState graphState) {
            return this.value != null ? ((Number)this.value).intValue() : 0;
        }

        public int setInt(Object object, int n, GraphState graphState) {
            this.value = n;
            return n;
        }

        public long getLong(Object object, GraphState graphState) {
            return this.value != null ? ((Number)this.value).longValue() : 0L;
        }

        public long setLong(Object object, long l, GraphState graphState) {
            this.value = l;
            return l;
        }

        public float getFloat(Object object, GraphState graphState) {
            return this.value != null ? ((Number)this.value).floatValue() : 0.0f;
        }

        public float setFloat(Object object, float f, GraphState graphState) {
            this.value = Float.valueOf(f);
            return f;
        }

        public double getDouble(Object object, GraphState graphState) {
            return this.value != null ? ((Number)this.value).doubleValue() : 0.0;
        }

        public double setDouble(Object object, double d, GraphState graphState) {
            this.value = d;
            return d;
        }

        public Object getObject(Object object, GraphState graphState) {
            return this.getObject(object, (Object)null, graphState);
        }

        public Object getObject(Object object, Object object2, GraphState graphState) {
            return this.value;
        }

        public Object setObject(Object object, Object object2, GraphState graphState) {
            this.value = object2;
            return object2;
        }

        public Object setSubfield(Object object, FieldChain fieldChain, int[] nArray, Object object2, GraphState graphState) {
            Object object3 = this.value;
            try {
                int n;
                for (n = 0; n < fieldChain.length() - 1; ++n) {
                    object3 = fieldChain.getField(n).getObject(object3);
                }
                Reflection.set(object3, fieldChain.getField(n), object2);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new WrapException(illegalAccessException);
            }
            return object2;
        }
    }
}

