/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.pf.registry;

import de.grogra.pf.registry.PluginClassLoader;
import de.grogra.pf.registry.PluginDescriptor;
import de.grogra.vfs.FileSystem;
import java.io.File;
import java.net.URL;
import java.util.Arrays;

class LibraryClassLoader
extends PluginClassLoader {
    private final String[] prefixes;
    private Object dir;

    private static URL[] toURL(Object[] objectArray, PluginDescriptor pluginDescriptor) {
        URL[] uRLArray = new URL[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            uRLArray[i] = pluginDescriptor.getFileSystem().toURL(objectArray[i]);
        }
        return uRLArray;
    }

    LibraryClassLoader(Object[] objectArray, PluginClassLoader pluginClassLoader, String[] stringArray) {
        this(LibraryClassLoader.toURL(objectArray, pluginClassLoader.getPluginDescriptor()), pluginClassLoader, stringArray);
        FileSystem fileSystem = pluginClassLoader.getPluginDescriptor().getFileSystem();
        if (objectArray.length > 0) {
            Object object = this.dir = fileSystem.isLeaf(objectArray[0]) ? fileSystem.getParent(objectArray[0]) : objectArray[0];
            if (fileSystem.isLeaf(this.dir)) {
                this.dir = null;
            }
        }
    }

    LibraryClassLoader(URL[] uRLArray, PluginClassLoader pluginClassLoader, String[] stringArray) {
        this(uRLArray, pluginClassLoader, pluginClassLoader.descriptor, stringArray);
    }

    LibraryClassLoader(Object[] objectArray, Object object, PluginDescriptor pluginDescriptor) {
        this(LibraryClassLoader.toURL(objectArray, pluginDescriptor), pluginDescriptor.getClass().getClassLoader(), pluginDescriptor, new String[]{""});
        this.dir = object;
    }

    private LibraryClassLoader(URL[] uRLArray, ClassLoader classLoader, PluginDescriptor pluginDescriptor, String[] stringArray) {
        super(uRLArray, classLoader, pluginDescriptor);
        this.prefixes = stringArray;
    }

    protected String findLibrary(String string) {
        File file;
        if (this.dir instanceof File && (file = new File((File)this.dir, System.mapLibraryName(string))).exists()) {
            return file.getAbsolutePath();
        }
        return null;
    }

    protected boolean shouldLookForClass(String string) {
        for (int i = this.prefixes.length - 1; i >= 0; --i) {
            if (!string.startsWith(this.prefixes[i])) continue;
            return this.findResource(string.replace('.', '/') + ".class") != null;
        }
        return false;
    }

    protected Class findClassNull(String string) {
        if (this.shouldLookForClass(string)) {
            Class clazz;
            if (!string.equals(this.descriptor.getPluginClass())) {
                this.descriptor.activatePlugin();
            }
            return (clazz = this.findLoadedClass(string)) != null ? clazz : this.superFindClassNull(string);
        }
        return null;
    }

    Class loadClassParentsSelf(String string) {
        ClassLoader classLoader = this.getParent();
        if (!(classLoader instanceof PluginClassLoader)) {
            return null;
        }
        Class clazz = ((PluginClassLoader)classLoader).loadClassParentsSelf(string);
        return clazz != null ? clazz : this.loadClassNull(string, false);
    }

    public URL getPluginResource(String string) {
        URL uRL = this.findResource(string);
        if (uRL != null) {
            return uRL;
        }
        if (this.getParent() instanceof LibraryClassLoader) {
            return ((LibraryClassLoader)this.getParent()).getPluginResource(string);
        }
        return null;
    }

    public String toString() {
        return "Lib@" + Integer.toHexString(this.hashCode()) + Arrays.toString(this.getURLs()) + Arrays.toString(this.prefixes);
    }
}

