/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.pf.registry;

import de.grogra.graph.impl.Node;
import de.grogra.persistence.XMLPersistenceWriter;
import de.grogra.pf.registry.Item;
import de.grogra.pf.registry.ItemVisitor;
import de.grogra.pf.registry.Link;
import de.grogra.pf.registry.OptionGroup;
import de.grogra.pf.registry.Value;
import de.grogra.reflect.Type;
import de.grogra.util.KeyDescription;
import de.grogra.util.Quantity;
import java.util.ArrayList;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import org.xml.sax.SAXException;

public class Option
extends Value
implements KeyDescription {
    private boolean editable = true;
    private boolean transient_ = false;
    private Quantity quantity;
    public static final Node.NType $TYPE = new Node.NType(new Option());

    protected Node.NType getNTypeImpl() {
        return $TYPE;
    }

    protected Node newInstance() {
        return new Option();
    }

    public Option() {
        super((String)null, false);
    }

    boolean storesAsString() {
        return true;
    }

    protected boolean getTypeFromObject() {
        return false;
    }

    public static Option createNoneditableOption(String string, Object object) {
        Option option = new Option();
        option.setName(string);
        option.editable = false;
        option.setOptionValue(object);
        return option;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public boolean isTransient() {
        return this.transient_;
    }

    public static void setPreference(Item item, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        Preferences preferences = Option.getPreferences(item, stringBuffer, true, false);
        if (preferences != null) {
            preferences.put(stringBuffer.toString(), string);
        }
    }

    public static String getPreference(Item item) {
        StringBuffer stringBuffer = new StringBuffer();
        Preferences preferences = Option.getPreferences(item, stringBuffer, false, false);
        return preferences != null ? preferences.get(stringBuffer.toString(), null) : null;
    }

    private static Preferences getPreferences(Item item, StringBuffer stringBuffer, boolean bl, boolean bl2) {
        stringBuffer.setLength(0);
        do {
            if (stringBuffer.length() > 0) {
                stringBuffer.insert(0, '.');
            }
            stringBuffer.insert(0, item.getName());
        } while ((item = (Item)item.getAxisParent()) instanceof OptionGroup);
        if (bl2) {
            return null;
        }
        String string = "/de/grogra/options" + item.getAbsoluteName();
        Preferences preferences = Preferences.userRoot();
        try {
            return bl || preferences.nodeExists(string) ? preferences.node(string) : null;
        }
        catch (BackingStoreException backingStoreException) {
            backingStoreException.printStackTrace();
            return null;
        }
    }

    public boolean belongsToGroup(Item item) {
        return item == this.getAxisParent() || !(item instanceof OptionGroup) && Option.get(item, this.getKey()) == this;
    }

    public String getKey() {
        StringBuffer stringBuffer = new StringBuffer();
        Option.getPreferences(this, stringBuffer, false, true);
        return stringBuffer.toString();
    }

    public Type getType() {
        return this.getObjectType();
    }

    public Quantity getQuantity() {
        return this.quantity;
    }

    public void setOptionValue(Object object) {
        this.set(value$FIELD, null, object);
        if (this.editable) {
            Option.setPreference(this, this.getValueAsString(new XMLPersistenceWriter(null, null)));
        }
    }

    protected void activateImpl() {
        if (!this.editable) {
            return;
        }
        String string = Option.getPreference(this);
        if (string != null) {
            this.setValueAsString(string);
        }
    }

    protected boolean readAttribute(String string, String string2, String string3) throws SAXException {
        if ("".equals(string)) {
            if ("editable".equals(string2)) {
                this.editable = "true".equals(string3);
                return true;
            }
            if ("transient".equals(string2)) {
                this.transient_ = "true".equals(string3);
                if (this.transient_) {
                    this.editable = false;
                }
                return true;
            }
            if ("quantity".equals(string2)) {
                this.quantity = Quantity.get(string3);
                return true;
            }
        }
        return super.readAttribute(string, string2, string3);
    }

    public static Option get(Item item, String string) {
        int n = 0;
        int n2 = string.indexOf(47);
        if (n2 < 0) {
            n2 = string.length();
        }
        while (item != null) {
            Item item2 = (Item)item.getBranch();
            item = null;
            while (item2 != null) {
                if (item2.getName().regionMatches(0, string, n, n2 - n)) {
                    if (item2 instanceof Option) {
                        return (Option)item2;
                    }
                    if (item2 instanceof OptionGroup) {
                        item2 = (Item)item2.getBranch();
                        n = n2 + 1;
                        if (n >= string.length()) {
                            return null;
                        }
                        n2 = string.indexOf(47, n);
                        if (n2 >= 0) continue;
                        n2 = string.length();
                        continue;
                    }
                }
                if (item2 instanceof Link && ((Link)item2).hasName("options")) {
                    item = ((Link)item2).resolveLink((Link)item2);
                }
                item2 = (Item)item2.getSuccessor();
            }
        }
        return null;
    }

    public static boolean hasEditableOptions(Item item) {
        for (Node node = item.getBranch(); node != null; node = node.getSuccessor()) {
            if (!(node instanceof Option && ((Option)node).isEditable() || node instanceof OptionGroup && ((OptionGroup)node).hasEditableOptions()) && (!(node instanceof Link) || !((Link)node).hasName("options") || !((Link)node).resolveLink(item).hasEditableOptions())) continue;
            return true;
        }
        return false;
    }

    public static Option[] getEditableOptions(Item item, final boolean bl) {
        final ArrayList arrayList = new ArrayList();
        item.forAll(null, null, new ItemVisitor(){

            public void visit(Item item, Object object) {
                Option option;
                if (item instanceof Link && item.hasName("options")) {
                    if ((item = item.resolveLink(item)) != null) {
                        item.forAll(null, null, this, object, false);
                    }
                } else if (item instanceof Option && ((option = (Option)item).isEditable() || bl && option.isTransient())) {
                    arrayList.add(option);
                }
            }
        }, null, false);
        return arrayList.toArray(new Option[arrayList.size()]);
    }

    static {
        $TYPE.validate();
    }
}

