/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.pf.registry;

import de.grogra.persistence.PersistenceBindings;
import de.grogra.persistence.XMLPersistenceReader;
import de.grogra.pf.registry.Directory;
import de.grogra.pf.registry.Item;
import de.grogra.pf.registry.Library;
import de.grogra.pf.registry.OptionalPackage;
import de.grogra.pf.registry.PluginDescriptor;
import de.grogra.pf.registry.PluginPrerequisite;
import de.grogra.pf.registry.Registry;
import de.grogra.util.Utils;
import de.grogra.xl.util.ObjectList;
import java.lang.reflect.InvocationTargetException;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

class XMLRegistryReader
extends XMLPersistenceReader
implements ContentHandler {
    private final Registry registry;
    private final PluginDescriptor plugin;
    private final boolean processRegistry;
    private final boolean readUserItems;
    private final ObjectList stack = new ObjectList(32);
    private Item root = null;

    XMLRegistryReader(Registry registry, PluginDescriptor pluginDescriptor, PersistenceBindings persistenceBindings) {
        this(registry, pluginDescriptor, persistenceBindings, registry == null ? null : (Item)registry.getRoot(), false);
    }

    XMLRegistryReader(Registry registry, PluginDescriptor pluginDescriptor, PersistenceBindings persistenceBindings, Item item, boolean bl) {
        super(persistenceBindings);
        this.registry = registry;
        this.plugin = pluginDescriptor;
        this.root = item;
        this.processRegistry = registry != null || pluginDescriptor != null;
        this.readUserItems = bl;
    }

    private static Item replaceReference(Item item, String string) {
        if (item.getName().equals("project") && string.equals("natures")) {
            return null;
        }
        Item item2 = null;
        if (item.getName().equals("3d") && string.equals("materials")) {
            item2 = item.getItem("shaders");
        }
        if (item2 == null) {
            System.err.println("reference " + string + " cannot be resolved in " + item);
        }
        return item2;
    }

    Item createItem(String string, String string2, Attributes attributes, Item item) throws InvocationTargetException, InstantiationException, IllegalAccessException, ClassNotFoundException {
        Item item2 = null;
        if ("http://grogra.de/registry".equals(string)) {
            if ("plugin".equals(string2)) {
                if (this.registry != null) {
                    return null;
                }
                PluginDescriptor pluginDescriptor = new PluginDescriptor();
                pluginDescriptor.initPluginDescriptor(null);
                return pluginDescriptor;
            }
            if (this.registry != null && "project".equals(string2)) {
                for (int i = 0; i < attributes.getLength(); ++i) {
                    this.registry.importAttributes.put(attributes.getLocalName(i), (Object)attributes.getValue(i));
                }
                return null;
            }
            if ("import".equals(string2)) {
                if (this.registry != null) {
                    return null;
                }
                PluginPrerequisite pluginPrerequisite = new PluginPrerequisite();
                item.appendBranchNode(pluginPrerequisite);
                pluginPrerequisite.initPluginDescriptor((PluginDescriptor)item);
                return pluginPrerequisite;
            }
            if ("library".equals(string2)) {
                if (this.registry != null) {
                    return null;
                }
                Library library = new Library();
                item.appendBranchNode(library);
                library.initPluginDescriptor((PluginDescriptor)item);
                return library;
            }
            if ("optpackage".equals(string2)) {
                if (this.registry != null) {
                    return null;
                }
                OptionalPackage optionalPackage = new OptionalPackage();
                item.appendBranchNode(optionalPackage);
                optionalPackage.initPluginDescriptor((PluginDescriptor)item);
                return optionalPackage;
            }
            if (!this.processRegistry) {
                return null;
            }
            if ("registry".equals(string2)) {
                return this.root;
            }
            if ("ref".equals(string2)) {
                String string3 = attributes.getValue("", "name");
                if (string3 == null) {
                    throw new InstantiationException("reference " + string2 + " has no 'name'-attribute");
                }
                item2 = item.getItem(string3);
                if (item2 == null) {
                    item2 = XMLRegistryReader.replaceReference(item, string3);
                }
                return item2;
            }
            if ("directory".equals(string2)) {
                item2 = new Directory(null);
            } else if ("item".equals(string2)) {
                item2 = (Item)this.getBindings().typeForName(attributes.getValue("", "class"), true).newInstance();
            } else {
                item2 = item.createItem(this.getBindings(), string2);
                if (item2 == null) {
                    item2 = (Item)this.getBindings().typeForName(string2, true).newInstance();
                }
            }
        }
        if (item2 != null) {
            item.add(item2);
            if (this.plugin != null) {
                item2.initPluginDescriptor(this.plugin);
            } else if (this.readUserItems) {
                item2.makeUserItem(false);
            }
            return item2;
        }
        throw new InstantiationException(string + ':' + string2);
    }

    public void startDocument() throws SAXException {
    }

    public void endDocument() throws SAXException {
    }

    public Item getRoot() {
        return this.root;
    }

    private static String unquote(String string) {
        return string == null || string.equals("null") ? null : Utils.unquote(string);
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        Item item;
        Item item2;
        Item item3 = item2 = this.stack.isEmpty() ? null : (Item)this.stack.peek(1);
        if (item2 == null) {
            item2 = new Item("");
        }
        try {
            item = this.createItem(string, string2, attributes, item2);
        }
        catch (Exception exception) {
            throw Utils.newSAXException(exception);
        }
        if (!(item == null || "ref".equals(string2) && "http://grogra.de/registry".equals(string))) {
            String string4 = XMLRegistryReader.unquote(attributes.getValue("", "name"));
            if (string4 != null && (item2 = item2.getItem(string4)) != null && item2 != item) {
                throw new SAXException("Duplicate item " + item2);
            }
            if (this.root == null) {
                this.root = item;
            }
            boolean bl = "http://grogra.de/registry".equals(string) && "item".equals(string2);
            int n = attributes.getLength();
            for (int i = 0; i < n; ++i) {
                string4 = attributes.getValue(i);
                if (bl && "".equals(attributes.getURI(i)) && "class".equals(attributes.getLocalName(i)) || item.readAttribute(attributes.getURI(i), attributes.getLocalName(i), XMLRegistryReader.unquote(string4))) continue;
                this.readAttribute(item, attributes.getURI(i), attributes.getLocalName(i), string4);
            }
        }
        this.stack.push(item);
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        this.stack.pop();
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
    }

    public void ignorableWhitespace(char[] cArray, int n, int n2) {
    }

    public void startPrefixMapping(String string, String string2) throws SAXException {
    }

    public void endPrefixMapping(String string) throws SAXException {
    }

    public void skippedEntity(String string) throws SAXException {
    }

    public void setDocumentLocator(Locator locator) {
    }

    public void processingInstruction(String string, String string2) throws SAXException {
    }
}

