/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.reflect;

import de.grogra.reflect.Annotation;
import de.grogra.reflect.CloneMethod;
import de.grogra.reflect.Field;
import de.grogra.reflect.LengthField;
import de.grogra.reflect.Member;
import de.grogra.reflect.Method;
import de.grogra.reflect.Reflection;
import de.grogra.reflect.Type;
import de.grogra.reflect.TypeImpl;
import de.grogra.xl.util.ObjectList;
import java.io.Serializable;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ClassAdapter<T>
extends TypeImpl<T> {
    private static final HashMap<String, ClassAdapter> globalPool = new HashMap(200);
    final Class<T> cls;
    final boolean pooled;
    private Field[] declaredFields = null;
    private Method[] declaredMethods = null;
    private Type[] interfaces = null;
    private Type[] declaredTypes = null;
    private Object array0 = null;
    static final ObjectList<Annotation> NO_ANNOTATIONS;
    private static final Type[] ARRAY_INTERFACES;

    static ObjectList<Annotation> getAnnotations(java.lang.annotation.Annotation[] annotationArray) {
        ObjectList<Annotation> objectList = null;
        for (int i = 0; i < annotationArray.length; ++i) {
            if (objectList == null) {
                objectList = new ObjectList<Annotation>();
            }
            objectList.add(new AnnotationAdapter<java.lang.annotation.Annotation>(annotationArray[i]));
        }
        if (objectList != null) {
            objectList.trimToSize();
            return objectList;
        }
        return NO_ANNOTATIONS;
    }

    private static <T> Type<? super T> supertype(Class<T> clazz, boolean bl) {
        if (clazz.isInterface()) {
            return Type.OBJECT;
        }
        if (clazz.isPrimitive()) {
            if (clazz == Byte.TYPE || clazz == Short.TYPE || clazz == Integer.TYPE || clazz == Long.TYPE || clazz == Character.TYPE) {
                return Type.INTEGRAL;
            }
            if (clazz == Float.TYPE || clazz == Double.TYPE) {
                return Type.FLOATING_POINT;
            }
            return null;
        }
        return clazz.getSuperclass() == null ? null : ClassAdapter.wrap(clazz.getSuperclass(), bl);
    }

    private ClassAdapter(Class<T> clazz, int n, boolean bl) {
        super(n, clazz.isArray() ? ClassAdapter.getDescriptor(clazz) : clazz.getName(), ClassAdapter.getDescriptor(clazz), clazz.getModifiers() & 0x1FFF | (clazz.isArray() ? 0x100000 : 0), clazz.getDeclaringClass() == null ? null : ClassAdapter.wrap(clazz.getDeclaringClass(), bl), ClassAdapter.supertype(clazz, bl), clazz.isArray() ? ClassAdapter.wrap(clazz.getComponentType(), bl) : null);
        this.pooled = bl;
        this.cls = clazz;
    }

    public static synchronized <T> ClassAdapter<T> wrap(Class<T> clazz) {
        ClassLoader classLoader = clazz.getClassLoader();
        return ClassAdapter.create(clazz, classLoader instanceof ClassLoaderWithPool ? ((ClassLoaderWithPool)((Object)classLoader)).getClassAdapterPool() : globalPool);
    }

    public static <T> ClassAdapter<T> wrap(Class<T> clazz, boolean bl) {
        return bl ? ClassAdapter.wrap(clazz) : ClassAdapter.create(clazz, null);
    }

    <T2> ClassAdapter<T2> create0(Class<T2> clazz) {
        return this.pooled ? ClassAdapter.wrap(clazz) : ClassAdapter.create(clazz, null);
    }

    private static <T> ClassAdapter<T> create(Class<T> clazz, Map<String, ClassAdapter> map) {
        ClassAdapter<T> classAdapter;
        block12: {
            int n;
            String string;
            block14: {
                block13: {
                    string = clazz.getName();
                    if (clazz.isPrimitive()) {
                        string = string + ' ';
                    }
                    ClassAdapter<T> classAdapter2 = classAdapter = map != null ? map.get(string) : null;
                    if (classAdapter != null) break block12;
                    if (!clazz.isPrimitive()) break block13;
                    switch (string.charAt(0)) {
                        case 'v': {
                            n = 1;
                            break block14;
                        }
                        case 'b': {
                            n = string.charAt(1) == 'o' ? 2 : 3;
                            break block14;
                        }
                        case 's': {
                            n = 4;
                            break block14;
                        }
                        case 'c': {
                            n = 5;
                            break block14;
                        }
                        case 'i': {
                            n = 6;
                            break block14;
                        }
                        case 'l': {
                            n = 7;
                            break block14;
                        }
                        case 'f': {
                            n = 8;
                            break block14;
                        }
                        case 'd': {
                            n = 9;
                            break block14;
                        }
                        default: {
                            throw new AssertionError();
                        }
                    }
                }
                n = 0;
            }
            classAdapter = new ClassAdapter<T>(clazz, n, map != null);
            if (map != null) {
                map.put(string, classAdapter);
            }
        }
        return classAdapter;
    }

    public static Type[] wrap(Class[] classArray, boolean bl) {
        Type[] typeArray = new Type[classArray.length];
        for (int i = classArray.length - 1; i >= 0; --i) {
            typeArray[i] = ClassAdapter.wrap(classArray[i], bl);
        }
        return typeArray;
    }

    public static String getDescriptor(Class clazz) {
        if (clazz.isArray()) {
            return '[' + ClassAdapter.getDescriptor(clazz.getComponentType());
        }
        if (clazz.isPrimitive()) {
            if (clazz == Boolean.TYPE) {
                return "Z";
            }
            if (clazz == Long.TYPE) {
                return "J";
            }
            return String.valueOf(Character.toUpperCase(clazz.getName().charAt(0)));
        }
        return 'L' + clazz.getName().replace('.', '/') + ';';
    }

    @Override
    public boolean isInstance(Object object) {
        return this.cls.isInstance(object);
    }

    @Override
    public Class<T> getImplementationClass() {
        return this.cls;
    }

    private synchronized Field[] getDeclaredFields() {
        if (this.declaredFields == null) {
            if (this.cls.isArray()) {
                this.declaredFields = new Field[]{new LengthField(this)};
            } else {
                java.lang.reflect.Field[] fieldArray = this.cls.getDeclaredFields();
                this.declaredFields = new Field[fieldArray.length];
                for (int i = fieldArray.length - 1; i >= 0; --i) {
                    this.declaredFields[i] = new FieldAdapter(fieldArray[i]);
                }
            }
        }
        return this.declaredFields;
    }

    @Override
    public int getDeclaredFieldCount() {
        return this.getDeclaredFields().length;
    }

    @Override
    public Field getDeclaredField(int n) {
        return this.getDeclaredFields()[n];
    }

    private synchronized Method[] getDeclaredMethods() {
        if (this.declaredMethods == null) {
            if (this.cls.isArray()) {
                this.declaredMethods = new Method[]{new CloneMethod(this)};
            } else {
                int n;
                java.lang.reflect.Method[] methodArray = this.cls.getDeclaredMethods();
                Constructor<?>[] constructorArray = this.cls.getDeclaredConstructors();
                this.declaredMethods = new Method[methodArray.length + constructorArray.length];
                for (n = methodArray.length - 1; n >= 0; --n) {
                    this.declaredMethods[n] = new MethodAdapter(methodArray[n]);
                }
                for (n = constructorArray.length - 1; n >= 0; --n) {
                    this.declaredMethods[methodArray.length + n] = new ConstructorAdapter(constructorArray[n]);
                }
            }
        }
        return this.declaredMethods;
    }

    @Override
    public int getDeclaredMethodCount() {
        return this.getDeclaredMethods().length;
    }

    @Override
    public Method getDeclaredMethod(int n) {
        return this.getDeclaredMethods()[n];
    }

    private synchronized Type[] getInterfaces() {
        if (this.interfaces == null) {
            if (this.cls.isArray()) {
                this.interfaces = ARRAY_INTERFACES;
            } else {
                Class<?>[] classArray = this.cls.getInterfaces();
                this.interfaces = new Type[classArray.length];
                for (int i = classArray.length - 1; i >= 0; --i) {
                    this.interfaces[i] = this.create0(classArray[i]);
                }
            }
        }
        return this.interfaces;
    }

    @Override
    public int getDeclaredInterfaceCount() {
        return this.getInterfaces().length;
    }

    @Override
    public Type<?> getDeclaredInterface(int n) {
        return this.getInterfaces()[n];
    }

    private synchronized Type[] getDeclaredTypes() {
        if (this.declaredTypes == null) {
            int n;
            Class<?>[] classArray;
            try {
                classArray = this.cls.getDeclaredClasses();
                n = classArray.length;
            }
            catch (SecurityException securityException) {
                classArray = this.cls.getClasses();
                n = 0;
                for (int i = classArray.length; i > 0; --i) {
                    if (classArray[n].getDeclaringClass() == this.cls) {
                        ++n;
                        continue;
                    }
                    System.arraycopy(classArray, n + 1, classArray, n, i - 1);
                }
            }
            this.declaredTypes = new Type[n];
            for (int i = n - 1; i >= 0; --i) {
                this.declaredTypes[i] = this.create0(classArray[i]);
            }
        }
        return this.declaredTypes;
    }

    @Override
    public int getDeclaredTypeCount() {
        return this.getDeclaredTypes().length;
    }

    @Override
    public Type<?> getDeclaredType(int n) {
        return this.getDeclaredTypes()[n];
    }

    @Override
    public Type<?> getArrayType() {
        return this.create0(Array.newInstance(this.cls, 0).getClass());
    }

    @Override
    public synchronized int getDeclaredAnnotationCount() {
        if (this.annots == null) {
            this.annots = ClassAdapter.getAnnotations(this.cls.getDeclaredAnnotations());
        }
        return super.getDeclaredAnnotationCount();
    }

    @Override
    public Annotation getDeclaredAnnotation(int n) {
        this.getDeclaredAnnotationCount();
        return super.getDeclaredAnnotation(n);
    }

    @Override
    public Object createArray(int n) {
        if (this.cls.isArray()) {
            if (n == 0) {
                if (this.array0 == null) {
                    this.array0 = Array.newInstance(this.cls.getComponentType(), 0);
                }
                return this.array0;
            }
            return Array.newInstance(this.cls.getComponentType(), n);
        }
        throw new UnsupportedOperationException(this + " is not an array class");
    }

    @Override
    public T newInstance() throws InvocationTargetException, InstantiationException, IllegalAccessException {
        return this.cls.newInstance();
    }

    static {
        if (Type.TYPE_0 == null) {
            throw new AssertionError();
        }
        NO_ANNOTATIONS = new ObjectList();
        ARRAY_INTERFACES = new Type[]{ClassAdapter.wrap(Cloneable.class), ClassAdapter.wrap(Serializable.class)};
    }

    private final class ConstructorAdapter
    extends InvokableAdapter {
        private final String descriptor;

        ConstructorAdapter(Constructor constructor) {
            super(constructor, constructor.getParameterTypes(), constructor.getExceptionTypes());
            this.descriptor = Reflection.getMethodDescriptor("<init>", Type.VOID, this.parameterTypes);
        }

        public String getDescriptor() {
            return this.descriptor;
        }

        public String getSimpleName() {
            return "<init>";
        }

        public Type getReturnType() {
            return ClassAdapter.this;
        }

        public Object invoke(Object object, Object[] objectArray) throws InvocationTargetException {
            try {
                return ((Constructor)this.member).newInstance(objectArray);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new InvocationTargetException(illegalAccessException);
            }
            catch (InstantiationException instantiationException) {
                throw new InvocationTargetException(instantiationException);
            }
        }

        java.lang.annotation.Annotation[][] getParameterAnnotations() {
            return ((Constructor)this.member).getParameterAnnotations();
        }
    }

    private final class MethodAdapter
    extends InvokableAdapter {
        private final Type returnType;
        private final String descriptor;

        MethodAdapter(java.lang.reflect.Method method) {
            super(method, method.getParameterTypes(), method.getExceptionTypes());
            this.returnType = ClassAdapter.this.create0(method.getReturnType());
            this.descriptor = Reflection.getMethodDescriptor(method.getName(), this.returnType, this.parameterTypes);
        }

        public String getDescriptor() {
            return this.descriptor;
        }

        public Type getReturnType() {
            return this.returnType;
        }

        public Object invoke(Object object, Object[] objectArray) throws InvocationTargetException {
            try {
                return ((java.lang.reflect.Method)this.member).invoke(object, objectArray);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new InvocationTargetException(illegalAccessException);
            }
        }

        java.lang.annotation.Annotation[][] getParameterAnnotations() {
            return ((java.lang.reflect.Method)this.member).getParameterAnnotations();
        }
    }

    private abstract class InvokableAdapter
    extends MemberAdapter
    implements Method {
        final Type[] parameterTypes;
        final Type[] exceptionTypes;
        ObjectList<Annotation>[] paramAnnots;

        InvokableAdapter(java.lang.reflect.Member member, Class[] classArray, Class[] classArray2) {
            super(member);
            this.parameterTypes = ClassAdapter.wrap(classArray, ClassAdapter.this.pooled);
            this.exceptionTypes = ClassAdapter.wrap(classArray2, ClassAdapter.this.pooled);
        }

        public int getParameterCount() {
            return this.parameterTypes.length;
        }

        public Type getParameterType(int n) {
            return this.parameterTypes[n];
        }

        public int getExceptionCount() {
            return this.exceptionTypes.length;
        }

        public Type getExceptionType(int n) {
            return this.exceptionTypes[n];
        }

        abstract java.lang.annotation.Annotation[][] getParameterAnnotations();

        public synchronized int getParameterAnnotationCount(int n) {
            if (this.paramAnnots == null) {
                java.lang.annotation.Annotation[][] annotationArray = this.getParameterAnnotations();
                this.paramAnnots = new ObjectList[annotationArray.length];
                for (int i = 0; i < annotationArray.length; ++i) {
                    this.paramAnnots[i] = ClassAdapter.getAnnotations(annotationArray[i]);
                }
            }
            return this.paramAnnots[n].size();
        }

        public Annotation getParameterAnnotation(int n, int n2) {
            this.getParameterAnnotationCount(n);
            return this.paramAnnots[n].get(n2);
        }
    }

    private final class FieldAdapter
    extends MemberAdapter
    implements Field {
        private final String descriptor;
        private final java.lang.reflect.Field field;
        private final Type type;

        FieldAdapter(java.lang.reflect.Field field) {
            super(field);
            this.field = field;
            this.type = ClassAdapter.this.create0(field.getType());
            this.descriptor = Reflection.getFieldDescriptor(field.getName(), this.type);
        }

        public String getDescriptor() {
            return this.descriptor;
        }

        public Type getType() {
            return this.type;
        }

        public boolean getBoolean(Object object) throws IllegalAccessException {
            if (object != null && !ClassAdapter.this.cls.isInstance(object)) {
                throw new ClassCastException(ClassAdapter.this.cls.getName());
            }
            return this.field.getBoolean(object);
        }

        public void setBoolean(Object object, boolean bl) throws IllegalAccessException {
            if (object != null && !ClassAdapter.this.cls.isInstance(object)) {
                throw new ClassCastException(ClassAdapter.this.cls.getName());
            }
            this.field.setBoolean(object, bl);
        }

        public byte getByte(Object object) throws IllegalAccessException {
            if (object != null && !ClassAdapter.this.cls.isInstance(object)) {
                throw new ClassCastException(ClassAdapter.this.cls.getName());
            }
            return this.field.getByte(object);
        }

        public void setByte(Object object, byte by) throws IllegalAccessException {
            if (object != null && !ClassAdapter.this.cls.isInstance(object)) {
                throw new ClassCastException(ClassAdapter.this.cls.getName());
            }
            this.field.setByte(object, by);
        }

        public short getShort(Object object) throws IllegalAccessException {
            if (object != null && !ClassAdapter.this.cls.isInstance(object)) {
                throw new ClassCastException(ClassAdapter.this.cls.getName());
            }
            return this.field.getShort(object);
        }

        public void setShort(Object object, short s) throws IllegalAccessException {
            if (object != null && !ClassAdapter.this.cls.isInstance(object)) {
                throw new ClassCastException(ClassAdapter.this.cls.getName());
            }
            this.field.setShort(object, s);
        }

        public char getChar(Object object) throws IllegalAccessException {
            if (object != null && !ClassAdapter.this.cls.isInstance(object)) {
                throw new ClassCastException(ClassAdapter.this.cls.getName());
            }
            return this.field.getChar(object);
        }

        public void setChar(Object object, char c) throws IllegalAccessException {
            if (object != null && !ClassAdapter.this.cls.isInstance(object)) {
                throw new ClassCastException(ClassAdapter.this.cls.getName());
            }
            this.field.setChar(object, c);
        }

        public int getInt(Object object) throws IllegalAccessException {
            if (object != null && !ClassAdapter.this.cls.isInstance(object)) {
                throw new ClassCastException(ClassAdapter.this.cls.getName());
            }
            return this.field.getInt(object);
        }

        public void setInt(Object object, int n) throws IllegalAccessException {
            if (object != null && !ClassAdapter.this.cls.isInstance(object)) {
                throw new ClassCastException(ClassAdapter.this.cls.getName());
            }
            this.field.setInt(object, n);
        }

        public long getLong(Object object) throws IllegalAccessException {
            if (object != null && !ClassAdapter.this.cls.isInstance(object)) {
                throw new ClassCastException(ClassAdapter.this.cls.getName());
            }
            return this.field.getLong(object);
        }

        public void setLong(Object object, long l) throws IllegalAccessException {
            if (object != null && !ClassAdapter.this.cls.isInstance(object)) {
                throw new ClassCastException(ClassAdapter.this.cls.getName());
            }
            this.field.setLong(object, l);
        }

        public float getFloat(Object object) throws IllegalAccessException {
            if (object != null && !ClassAdapter.this.cls.isInstance(object)) {
                throw new ClassCastException(ClassAdapter.this.cls.getName());
            }
            return this.field.getFloat(object);
        }

        public void setFloat(Object object, float f) throws IllegalAccessException {
            if (object != null && !ClassAdapter.this.cls.isInstance(object)) {
                throw new ClassCastException(ClassAdapter.this.cls.getName());
            }
            this.field.setFloat(object, f);
        }

        public double getDouble(Object object) throws IllegalAccessException {
            if (object != null && !ClassAdapter.this.cls.isInstance(object)) {
                throw new ClassCastException(ClassAdapter.this.cls.getName());
            }
            return this.field.getDouble(object);
        }

        public void setDouble(Object object, double d) throws IllegalAccessException {
            if (object != null && !ClassAdapter.this.cls.isInstance(object)) {
                throw new ClassCastException(ClassAdapter.this.cls.getName());
            }
            this.field.setDouble(object, d);
        }

        public Object getObject(Object object) throws IllegalAccessException {
            if (object != null && !ClassAdapter.this.cls.isInstance(object)) {
                throw new ClassCastException(ClassAdapter.this.cls.getName());
            }
            return this.field.get(object);
        }

        public void setObject(Object object, Object object2) throws IllegalAccessException {
            if (object != null && !ClassAdapter.this.cls.isInstance(object)) {
                throw new ClassCastException(ClassAdapter.this.cls.getName());
            }
            this.field.set(object, object2);
        }

        public String toString() {
            return Reflection.toString(this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class AnnotationAdapter<A extends java.lang.annotation.Annotation>
    implements Annotation<A> {
        final A annot;
        final ClassAdapter<A> type;

        AnnotationAdapter(A a) {
            this.annot = a;
            this.type = ClassAdapter.wrap(a.annotationType(), false);
        }

        @Override
        public Type<A> annotationType() {
            return this.type;
        }

        @Override
        public Object value(String string) {
            Method method = Reflection.getElementMethod(this.type, string);
            if (method == null) {
                throw new NoSuchMethodError(this.type + " " + string);
            }
            try {
                return AnnotationAdapter.convert(method.invoke(this.annot, null));
            }
            catch (Exception exception) {
                IllegalAccessError illegalAccessError = new IllegalAccessError();
                illegalAccessError.initCause(exception);
                throw illegalAccessError;
            }
        }

        private static Object convert(Object object) {
            if (object instanceof Class) {
                return ClassAdapter.wrap((Class)object);
            }
            if (object instanceof java.lang.annotation.Annotation) {
                return new AnnotationAdapter<java.lang.annotation.Annotation>((java.lang.annotation.Annotation)object);
            }
            if (object instanceof Enum) {
                return ((Enum)object).name();
            }
            if (object instanceof Object[]) {
                Object[] objectArray;
                int n = ((Object[])object).length;
                if (object instanceof Class[]) {
                    objectArray = new Type[n];
                } else if (object instanceof java.lang.annotation.Annotation) {
                    objectArray = new Annotation[n];
                } else if (object instanceof Enum[]) {
                    objectArray = new String[n];
                } else {
                    return object;
                }
                for (int i = 0; i < n; ++i) {
                    objectArray[i] = AnnotationAdapter.convert(((Object[])object)[i]);
                }
                return objectArray;
            }
            return object;
        }
    }

    private abstract class MemberAdapter
    implements Member {
        final java.lang.reflect.Member member;
        ObjectList<Annotation> memberAnnots;

        MemberAdapter(java.lang.reflect.Member member) {
            this.member = member;
        }

        public Type getDeclaringType() {
            return ClassAdapter.this;
        }

        public int getModifiers() {
            return this.member.getModifiers() & 0x1FFF;
        }

        public String getName() {
            return this.member.getName();
        }

        public String getSimpleName() {
            return this.member.getName();
        }

        public String toString() {
            return this.member.toString();
        }

        public synchronized int getDeclaredAnnotationCount() {
            if (this.memberAnnots == null) {
                this.memberAnnots = ClassAdapter.getAnnotations(((AccessibleObject)((Object)this.member)).getDeclaredAnnotations());
            }
            return this.memberAnnots.size();
        }

        public Annotation getDeclaredAnnotation(int n) {
            this.getDeclaredAnnotationCount();
            return this.memberAnnots.get(n);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class URLClassLoaderWithPool
    extends URLClassLoader
    implements ClassLoaderWithPool {
        private final HashMap<String, ClassAdapter> pool = new HashMap();

        public URLClassLoaderWithPool(URL[] uRLArray, ClassLoader classLoader) {
            super(uRLArray, classLoader);
        }

        @Override
        public Map<String, ClassAdapter> getClassAdapterPool() {
            return this.pool;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface ClassLoaderWithPool {
        public Map<String, ClassAdapter> getClassAdapterPool();
    }
}

