/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.reflect;

import de.grogra.reflect.Annotation;
import de.grogra.reflect.Field;
import de.grogra.reflect.Lookup;
import de.grogra.reflect.Method;
import de.grogra.reflect.Reflection;
import de.grogra.reflect.Type;
import de.grogra.reflect.TypeLoader;
import de.grogra.reflect.XArray;
import de.grogra.reflect.XField;
import de.grogra.reflect.XObject;
import de.grogra.reflect.XObjectImpl;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XClass<T>
extends XObjectImpl
implements Type<T> {
    private final String name;
    private final String binaryName;
    private final String descriptor;
    private final String simpleName;
    private int modifiers;
    private final Type<?> declaringClass;
    private TypeLoader loader;
    private Type<? super T> superclass;
    private boolean superclassSet = false;
    private ArrayList<Annotation> declaredAnnotations = new ArrayList();
    private final boolean metaClass;
    private final boolean writable;
    private ArrayList<XField> declaredFields = new ArrayList();
    private ArrayList<Method> declaredMethods = new ArrayList();
    private ArrayList<Type<?>> declaredTypes = new ArrayList();
    private ArrayList<Type<?>> interfaces = new ArrayList();
    private boolean initialized;
    private int syntheticCount;
    int isize;
    int lsize;
    int fsize;
    int dsize;
    int asize;
    private Lookup lookup;

    public XClass(String string, String string2, int n, Type<?> type, boolean bl) {
        this.simpleName = string;
        this.binaryName = string2;
        this.name = type != null ? type.getName() + '.' + string : string2;
        this.descriptor = 'L' + string2.replace('.', '/') + ';';
        this.modifiers = n;
        this.declaringClass = type;
        this.metaClass = false;
        this.writable = bl;
    }

    public void initSupertype(Type<? super T> type) {
        if (this.superclassSet) {
            throw new IllegalStateException();
        }
        this.superclassSet = true;
        this.superclass = type;
    }

    private XClass(XClass xClass) {
        this.initSupertype(xClass);
        this.name = null;
        this.binaryName = null;
        this.simpleName = null;
        this.descriptor = null;
        this.modifiers = 0;
        this.declaringClass = null;
        this.metaClass = true;
        this.writable = false;
    }

    public void initTypeLoader(TypeLoader typeLoader) {
        this.loader = typeLoader;
    }

    public synchronized void initialize() {
        XClass<? extends XObject> xClass;
        XClass xClass2;
        if (this.initialized) {
            return;
        }
        this.initialized = true;
        Type<T> type = this.getSupertype();
        if (type instanceof XClass) {
            xClass2 = (XClass)type;
            xClass2.initialize();
            this.isize = xClass2.isize;
            this.lsize = xClass2.lsize;
            this.fsize = xClass2.fsize;
            this.dsize = xClass2.dsize;
            this.asize = xClass2.asize;
            xClass = xClass2.getXClass();
        } else {
            this.isize = 0;
            this.lsize = 0;
            this.fsize = 0;
            this.dsize = 0;
            this.asize = 0;
            xClass = null;
        }
        if (!this.metaClass) {
            xClass2 = new XClass(xClass);
            xClass2.initialize();
            for (int i = this.declaredFields.size() - 1; i >= 0; --i) {
                int n;
                XField xField = this.declaredFields.get(i);
                XClass xClass3 = Reflection.isStatic(xField) ? xClass2 : this;
                switch (xField.getType().getTypeId()) {
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: {
                        ++xClass3.isize;
                        break;
                    }
                    case 7: {
                        ++xClass3.lsize;
                        break;
                    }
                    case 8: {
                        ++xClass3.fsize;
                        break;
                    }
                    case 9: {
                        ++xClass3.dsize;
                        break;
                    }
                    case 0: {
                        ++xClass3.asize;
                        break;
                    }
                    default: {
                        throw new AssertionError();
                    }
                }
                xField.index = n;
            }
            this.initXClass(xClass2);
        }
        if ((xClass2 = Reflection.getDeclaredMethod(this, "<clinit>")) != null) {
            try {
                xClass2.invoke(null, null);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new ExceptionInInitializerError(invocationTargetException.getCause());
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new ExceptionInInitializerError(illegalAccessException);
            }
        }
    }

    private void check(int n) {
        if (this.initialized && (n & 0x1000) == 0) {
            if (this.writable) {
                if ((n & 8) == 0) {
                    throw new IllegalStateException("Only static members can be modified after the initialization of class " + this);
                }
            } else {
                throw new IllegalStateException("Can't change the declaration of the non-writable class " + this);
            }
        }
    }

    public XField declareSyntheticField(String string, int n, Type<?> type) {
        return this.declareField(string + '$' + this.syntheticCount++, n | 0x1000, type);
    }

    public XField declareAuxField(String string, int n, Type<?> type) {
        String string2 = string;
        int n2 = 0;
        while (this.getDeclaredField(string) != null) {
            string = string2 + ++n2;
        }
        return this.declareField(string, n | 0x1000, type);
    }

    public XField declareField(String string, int n, Type<?> type) {
        this.check(n);
        XField xField = new XField(this, string, n, type);
        if ((n & 8) != 0 && this.initialized) {
            switch (type.getTypeId()) {
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    xField.index = this.getXData().addIField();
                    break;
                }
                case 7: {
                    xField.index = this.getXData().addLField();
                    break;
                }
                case 8: {
                    xField.index = this.getXData().addFField();
                    break;
                }
                case 9: {
                    xField.index = this.getXData().addDField();
                    break;
                }
                case 0: {
                    xField.index = this.getXData().addAField();
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
        }
        this.declaredFields.add(xField);
        this.updateLookup();
        return xField;
    }

    public void removeField(Field field) {
        this.check(field.getModifiers());
        this.declaredFields.remove(field);
        this.updateLookup();
    }

    public void makeVisible(XField xField) {
        this.check(xField.getModifiers());
        int n = this.declaredFields.size() - 1;
        for (int i = 0; i <= n; ++i) {
            if (this.declaredFields.get(i) != xField) continue;
            if (i != n) {
                this.declaredFields.remove(i);
                this.declaredFields.add(xField);
                this.updateLookup();
            }
            return;
        }
        throw new RuntimeException("Field " + xField + " not found");
    }

    public void declareMethod(Method method) {
        this.check(method.getModifiers());
        this.declaredMethods.add(method);
        this.updateLookup();
    }

    public void removeMethod(Method method) {
        this.check(method.getModifiers());
        this.declaredMethods.remove(method);
        this.updateLookup();
    }

    public void declareType(XClass<?> xClass) {
        this.check(xClass.getModifiers());
        this.declaredTypes.add(xClass);
        this.updateLookup();
    }

    public void addInterface(Type<?> type) {
        this.check(0);
        this.interfaces.add(type);
        this.updateLookup();
    }

    public List<Annotation> getDeclaredAnnotations() {
        return this.declaredAnnotations;
    }

    @Override
    public T newInstance() throws InvocationTargetException, InstantiationException, IllegalAccessException {
        Method method = Reflection.getDefaultConstructor(this);
        if (method == null) {
            throw new InstantiationException(this.getName());
        }
        return (T)method.invoke(null, null);
    }

    @Override
    public int getTypeId() {
        return 0;
    }

    @Override
    public String getPackage() {
        String string = this.getBinaryName();
        return string.substring(0, Math.max(0, string.lastIndexOf(46)));
    }

    @Override
    public int getModifiers() {
        return this.modifiers;
    }

    public void setPublic() {
        this.modifiers = this.modifiers & 0xFFFFFFF8 | 1;
    }

    @Override
    public Type<?> getDeclaringType() {
        return this.declaringClass;
    }

    public boolean hasSupertypeBeenSet() {
        return this.superclassSet;
    }

    @Override
    public Type<? super T> getSupertype() {
        if (!this.superclassSet) {
            return Type.OBJECT;
        }
        return this.superclass;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getBinaryName() {
        return this.binaryName;
    }

    @Override
    public String getDescriptor() {
        return this.descriptor;
    }

    @Override
    public boolean isInstance(Object object) {
        return object instanceof XObject && this.getImplementationClass().isInstance(object) && Reflection.isSupertypeOrSame(this, ((XObject)object).getXClass());
    }

    @Override
    public Class<T> getImplementationClass() {
        return this.getSupertype().getImplementationClass();
    }

    @Override
    public TypeLoader getTypeLoader() {
        return this.loader;
    }

    @Override
    public int getDeclaredInterfaceCount() {
        return this.interfaces.size();
    }

    @Override
    public Type<?> getDeclaredInterface(int n) {
        return this.interfaces.get(n);
    }

    @Override
    public int getDeclaredTypeCount() {
        return this.declaredTypes.size();
    }

    @Override
    public Type<?> getDeclaredType(int n) {
        return this.declaredTypes.get(n);
    }

    @Override
    public int getDeclaredFieldCount() {
        return this.declaredFields.size();
    }

    @Override
    public Field getDeclaredField(int n) {
        return this.declaredFields.get(n);
    }

    public XField getDeclaredField(String string) {
        for (int i = this.declaredFields.size() - 1; i >= 0; --i) {
            if (!this.declaredFields.get(i).getSimpleName().equals(string)) continue;
            return this.declaredFields.get(i);
        }
        return null;
    }

    @Override
    public int getDeclaredMethodCount() {
        return this.declaredMethods.size();
    }

    @Override
    public Method getDeclaredMethod(int n) {
        return this.declaredMethods.get(n);
    }

    @Override
    public int getDeclaredAnnotationCount() {
        return this.declaredAnnotations.size();
    }

    @Override
    public Annotation getDeclaredAnnotation(int n) {
        return this.declaredAnnotations.get(n);
    }

    @Override
    public String getSimpleName() {
        return this.simpleName;
    }

    @Override
    public Type<?> getComponentType() {
        return null;
    }

    @Override
    public Type<?> getArrayType() {
        return new XArray(this);
    }

    @Override
    public Object createArray(int n) {
        throw new AssertionError();
    }

    public String toString() {
        return this.name;
    }

    @Override
    public boolean isStringSerializable() {
        return false;
    }

    @Override
    public T valueOf(String string) {
        throw new UnsupportedOperationException();
    }

    @Override
    public T cloneObject(T t, boolean bl) {
        return t;
    }

    @Override
    public final synchronized Lookup getLookup() {
        if (this.lookup == null) {
            this.lookup = new Lookup(this);
        }
        return this.lookup;
    }

    protected final void updateLookup() {
        if (this.lookup != null) {
            this.lookup.update();
        }
    }

    @Override
    public Object getDefaultElementValue(String string) {
        return null;
    }
}

