/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.util;

import de.grogra.icon.IconSource;
import de.grogra.util.Described;
import de.grogra.util.DetailedException;
import de.grogra.util.I18NBundle;
import de.grogra.util.UserException;
import de.grogra.util.Utils;
import java.awt.Dimension;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;

public class HTMLLoggingFormatter
extends Formatter {
    protected final Dimension iconSize;
    protected final I18NBundle i18n;

    public HTMLLoggingFormatter(I18NBundle i18NBundle, Dimension dimension) {
        this.i18n = i18NBundle;
        this.iconSize = dimension;
    }

    public String format(LogRecord logRecord) {
        Object object;
        StringBuffer stringBuffer = new StringBuffer("<br>");
        int n = stringBuffer.length();
        Utils.formatDateAndName(logRecord, stringBuffer);
        Utils.escapeForXML(stringBuffer, n);
        stringBuffer.append("<h3>");
        Level level = logRecord.getLevel();
        int n2 = level.intValue();
        String string = n2 < Level.WARNING.intValue() ? "log.info" : (n2 < Level.SEVERE.intValue() ? "log.warning" : "log.severe");
        IconSource iconSource = (IconSource)(level instanceof Described ? ((Described)((Object)level)).getDescription("Icon") : this.i18n.getObject(string + ".Icon"));
        if (iconSource != null && (object = iconSource.getIcon(this.iconSize, 0)) != null && object.getImageSource() != null) {
            stringBuffer.append("&nbsp;<img src=\"").append(object.getImageSource()).append("\" alt=\"\">&nbsp;&nbsp;&nbsp;");
        }
        n = stringBuffer.length();
        stringBuffer.append(level instanceof Described ? ((Described)((Object)level)).getDescription("Name") : Utils.get(this.i18n, string, "Name", level.getLocalizedName()));
        Utils.escapeForXML(stringBuffer, n);
        stringBuffer.append("</h3>");
        if (logRecord.getMessage().length() > 0) {
            n = stringBuffer.length();
            stringBuffer.append(logRecord.getMessage());
            if (logRecord.getMessage().startsWith("<html>")) {
                stringBuffer.delete(n, n + 6);
                n = stringBuffer.lastIndexOf("</html>");
                if (n >= 0) {
                    stringBuffer.delete(n, n + 7);
                }
            } else {
                Utils.escapeForXML(stringBuffer, n);
                for (int i = stringBuffer.length() - 1; i >= n; --i) {
                    if (stringBuffer.charAt(i) != '\n') continue;
                    stringBuffer.replace(i, i + 1, "<br>");
                }
            }
            stringBuffer.append("<br>");
        }
        if ((object = Utils.getMainException(logRecord.getThrown())) instanceof DetailedException) {
            stringBuffer.append(((DetailedException)object).getDetailedMessage(true));
        } else if (object instanceof UserException) {
            n = stringBuffer.length();
            stringBuffer.append(((Throwable)object).getLocalizedMessage());
            Utils.escapeForXML(stringBuffer, n);
        } else if (object != null) {
            Object object2 = object;
            while (object2 != null) {
                n = stringBuffer.length();
                String string2 = object2.getClass().getName();
                stringBuffer.append(string2.substring(string2.lastIndexOf(46) + 1));
                string2 = ((Throwable)object2).getLocalizedMessage();
                if (string2 != null) {
                    stringBuffer.append(": ").append(string2);
                }
                Utils.escapeForXML(stringBuffer, n);
                stringBuffer.append("<br>");
                if ((object2 = ((Throwable)object2).getCause()) == null) continue;
                stringBuffer.append("Caused by ");
            }
            stringBuffer.append("<br>Stack Trace:<br>");
            n = stringBuffer.length();
            stringBuffer.append(Utils.getStackTrace((Throwable)object));
            Utils.escapeForXML(stringBuffer, n);
            int n3 = stringBuffer.length();
            for (int i = stringBuffer.length() - 1; i >= n; --i) {
                int n4;
                int n5;
                boolean bl;
                boolean bl2 = bl = stringBuffer.charAt(i) == '\n';
                if ((bl || i == n) && stringBuffer.charAt(n3 - 1) == ')' && (n5 = stringBuffer.lastIndexOf("(", n3 - 1)) >= i && (n4 = stringBuffer.lastIndexOf(":", n3 - 1)) >= n5) {
                    String string3 = stringBuffer.substring(n5 + 1, n4);
                    String string4 = stringBuffer.substring(n4 + 1, n3 - 1);
                    try {
                        int n6 = Math.max(Integer.valueOf(string4) - 1, 0);
                        stringBuffer.insert(n3 - 1, "</a>");
                        stringBuffer.insert(n5 + 1, "<a href=\"" + string3 + '#' + n6 + "\">");
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                if (!bl) continue;
                stringBuffer.replace(i, i + 1, "<br>&nbsp;&nbsp;&nbsp;&nbsp;");
                n3 = i;
            }
        }
        return stringBuffer.append("<br>").toString();
    }

    public String getHead(Handler handler) {
        return "<html><body>";
    }

    public String getTail(Handler handler) {
        return "</body></html>";
    }
}

