/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.util;

import de.grogra.xl.util.IntList;
import java.lang.reflect.Array;

public class Int2ObjectMap {
    private int[] keys;
    private Object[] values;
    private int size;

    public Int2ObjectMap(int n) {
        if (n < 4) {
            n = 4;
        }
        this.keys = new int[n];
        this.values = new Object[n];
    }

    public Int2ObjectMap() {
        this(16);
    }

    public Int2ObjectMap(int[] nArray, int n, int n2) {
        this(n2);
        System.arraycopy(nArray, n, this.keys, 0, n2);
        this.size = n2;
    }

    public Int2ObjectMap dup() {
        Int2ObjectMap int2ObjectMap = new Int2ObjectMap(this.size);
        System.arraycopy(this.keys, 0, int2ObjectMap.keys, 0, this.size);
        System.arraycopy(this.values, 0, int2ObjectMap.values, 0, this.size);
        int2ObjectMap.size = this.size;
        return int2ObjectMap;
    }

    public int[] getKeys(int[] nArray) {
        if (nArray == null || nArray.length < this.size) {
            nArray = new int[this.size];
        }
        System.arraycopy(this.keys, 0, nArray, 0, this.size);
        return nArray;
    }

    public Object[] getValues(Object[] objectArray) {
        if (objectArray == null) {
            objectArray = new Object[this.size];
        } else if (objectArray.length < this.size) {
            objectArray = (Object[])Array.newInstance(objectArray.getClass().getComponentType(), this.size);
        }
        System.arraycopy(this.values, 0, objectArray, 0, this.size);
        return objectArray;
    }

    public final synchronized Object synchronizedPut(int n, Object object) {
        return this.put(n, object);
    }

    public final Object put(int n, Object object) {
        int n2 = IntList.binarySearch(this.keys, n, 0, this.size);
        if (n2 >= 0) {
            Object object2 = this.values[n2];
            this.values[n2] = object;
            return object2;
        }
        n2 ^= 0xFFFFFFFF;
        if (this.keys.length == this.size) {
            this.keys = new int[2 * this.size];
            System.arraycopy(this.keys, 0, this.keys, 0, this.size);
            this.values = new Object[2 * this.size];
            System.arraycopy(this.values, 0, this.values, 0, this.size);
        }
        if (n2 < this.size) {
            System.arraycopy(this.keys, n2, this.keys, n2 + 1, this.size - n2);
            System.arraycopy(this.values, n2, this.values, n2 + 1, this.size - n2);
        }
        this.keys[n2] = n;
        this.values[n2] = object;
        ++this.size;
        return null;
    }

    public final Object get(int n) {
        int n2 = IntList.binarySearch(this.keys, n, 0, this.size);
        return n2 >= 0 ? this.values[n2] : null;
    }

    public final synchronized Object synchronizedGet(int n) {
        return this.get(n);
    }

    public final Object remove(int n) {
        int n2 = IntList.binarySearch(this.keys, n, 0, this.size);
        if (n2 >= 0) {
            Object object = this.values[n2];
            --this.size;
            System.arraycopy(this.keys, n2 + 1, this.keys, n2, this.size - n2);
            System.arraycopy(this.values, n2 + 1, this.values, n2, this.size - n2);
            this.values[this.size] = null;
            return object;
        }
        return null;
    }

    public final synchronized Object synchronizedRemove(int n) {
        return this.remove(n);
    }

    public int size() {
        return this.size;
    }

    public void clear() {
        for (int i = this.size - 1; i >= 0; --i) {
            this.values[i] = null;
        }
        this.size = 0;
    }

    public int getKeyAt(int n) {
        return this.keys[n];
    }

    public Object getValueAt(int n) {
        return this.values[n];
    }

    public int findIndex(int n) {
        return IntList.binarySearch(this.keys, n, 0, this.size);
    }

    public void setValueAt(int n, Object object) {
        this.values[n] = object;
    }
}

