/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.util;

import de.grogra.util.Lock;
import de.grogra.util.LockProtectedRunnable;
import de.grogra.util.Lockable;
import de.grogra.util.Utils;
import de.grogra.xl.util.BooleanList;
import de.grogra.xl.util.LongList;
import de.grogra.xl.util.ObjectList;

public class LockableImpl
implements Lockable {
    private final Object mutex = new Object();
    private final ObjectList<LockProtectedRunnable> tasks = new ObjectList();
    private final BooleanList isWriterTask = new BooleanList();
    private final LongList times = new LongList();
    private Thread writeLockOwner = null;
    private int activeWriteLocks = 0;
    private int retainedWriteLocks = 0;
    private int activeReadLocks = 0;
    private int retainedReadLocks = 0;
    private int deadLockRiskCounter = 0;
    private final ThreadLocal<int[]> lockCounts = new ThreadLocal();
    private int waitingWriters = 0;
    private static final int READ = 0;
    private static final int WRITE = 1;

    private int[] getLockCounts() {
        int[] nArray = this.lockCounts.get();
        if (nArray == null) {
            nArray = new int[2];
            this.lockCounts.set(nArray);
        }
        return nArray;
    }

    private LockImpl lock(boolean bl, boolean bl2) {
        assert (Thread.holdsLock(this.mutex));
        Thread thread = Thread.currentThread();
        int[] nArray = this.getLockCounts();
        if (thread == this.writeLockOwner) {
            ++this.activeWriteLocks;
            nArray[1] = nArray[1] + 1;
            return new LockImpl(true);
        }
        if (this.activeWriteLocks == 0 && (bl || this.retainedWriteLocks == 0)) {
            if (bl2) {
                if (this.activeReadLocks == nArray[0] && (bl || nArray[0] > 0 || this.retainedReadLocks == 0)) {
                    assert (this.writeLockOwner == null);
                    this.writeLockOwner = thread;
                    ++this.activeWriteLocks;
                    nArray[1] = nArray[1] + 1;
                    return new LockImpl(true);
                }
            } else if (bl || nArray[0] > 0 || this.retainedReadLocks == 0 && this.waitingWriters == 0) {
                ++this.activeReadLocks;
                nArray[0] = nArray[0] + 1;
                return new LockImpl(false);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(LockProtectedRunnable lockProtectedRunnable, boolean bl) {
        LockImpl lockImpl;
        lockProtectedRunnable.getClass();
        Object object = this.mutex;
        synchronized (object) {
            lockImpl = this.lock(false, bl);
            if (lockImpl == null) {
                this.enqueue(lockProtectedRunnable, bl);
            }
        }
        if (lockImpl != null) {
            this.executeImpl(lockProtectedRunnable, lockImpl);
        }
    }

    private void enqueue(LockProtectedRunnable lockProtectedRunnable, boolean bl) {
        this.tasks.add(lockProtectedRunnable);
        this.times.add(System.currentTimeMillis());
        this.isWriterTask.add(bl);
        if (bl) {
            ++this.waitingWriters;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeImpl(LockProtectedRunnable lockProtectedRunnable, LockImpl lockImpl) {
        boolean bl = true;
        Throwable throwable = null;
        int[] nArray = this.getLockCounts();
        while (lockProtectedRunnable != null) {
            boolean bl2;
            boolean bl3 = bl2 = lockImpl.write && nArray[1] == 1;
            if (bl2) {
                try {
                    this.enterWriteLock();
                }
                catch (Throwable throwable2) {
                    throwable2.printStackTrace();
                }
            }
            try {
                this.invokeRun0(lockProtectedRunnable, bl, lockImpl);
            }
            catch (Throwable throwable3) {
                throwable = throwable3;
            }
            bl = false;
            lockProtectedRunnable = null;
            if (bl2) {
                try {
                    this.leaveWriteLock();
                }
                catch (Throwable throwable4) {
                    throwable4.printStackTrace();
                }
            }
            Object object = this.mutex;
            synchronized (object) {
                if (!lockImpl.retained) {
                    lockImpl.dispose();
                }
                if (lockImpl.write) {
                    --this.activeWriteLocks;
                    nArray[1] = nArray[1] - 1;
                    if (nArray[1] == 0) {
                        this.writeLockOwner = null;
                    }
                    assert (this.activeWriteLocks == 0 == (this.writeLockOwner == null));
                } else {
                    --this.activeReadLocks;
                    nArray[0] = nArray[0] - 1;
                }
                this.mutex.notifyAll();
                if (!this.tasks.isEmpty() && (lockImpl = this.lock(true, this.isWriterTask.get(0))) != null) {
                    lockProtectedRunnable = this.tasks.removeAt(0);
                    if (this.isWriterTask.removeAt(0)) {
                        --this.waitingWriters;
                    }
                    this.times.removeAt(0);
                }
            }
        }
        Utils.rethrow(throwable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(LockProtectedRunnable lockProtectedRunnable, Lock lock) {
        lockProtectedRunnable.getClass();
        LockImpl lockImpl = null;
        boolean bl = ((LockImpl)lock).write;
        Object object = this.mutex;
        synchronized (object) {
            ((LockImpl)lock).use();
            lockImpl = this.lock(true, bl);
            if (lockImpl == null) {
                this.enqueue(lockProtectedRunnable, bl);
            }
        }
        if (lockImpl != null) {
            this.executeImpl(lockProtectedRunnable, lockImpl);
        }
    }

    private void checkThread(boolean bl) {
        if (!this.isAllowedThread(bl)) {
            throw new IllegalStateException("Current thread is not allowed to obtain a " + (bl ? "write" : "read") + " lock on " + this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeForcedly(LockProtectedRunnable lockProtectedRunnable, boolean bl) throws InterruptedException, Lockable.DeadLockException {
        this.checkThread(bl);
        lockProtectedRunnable.getClass();
        LockImpl lockImpl = null;
        int[] nArray = this.getLockCounts();
        Object object = this.mutex;
        synchronized (object) {
            boolean bl2;
            boolean bl3 = bl2 = bl && nArray[1] == 0 && nArray[0] > 0;
            if (bl2) {
                if (this.deadLockRiskCounter != 0) {
                    throw new Lockable.DeadLockException();
                }
                this.deadLockRiskCounter = 1;
            }
            try {
                while ((lockImpl = this.lock(false, bl)) == null) {
                    if (bl2 && this.deadLockRiskCounter > 1) {
                        throw new Lockable.DeadLockException();
                    }
                    this.mutex.wait();
                }
            }
            finally {
                if (bl2) {
                    --this.deadLockRiskCounter;
                }
            }
        }
        this.executeImpl(lockProtectedRunnable, lockImpl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeForcedly(LockProtectedRunnable lockProtectedRunnable, Lock lock) throws InterruptedException {
        boolean bl = ((LockImpl)lock).write;
        this.checkThread(bl);
        lockProtectedRunnable.getClass();
        LockImpl lockImpl = null;
        Object object = this.mutex;
        synchronized (object) {
            while ((lockImpl = this.lock(true, bl)) == null) {
                this.mutex.wait();
            }
            ((LockImpl)lock).use();
        }
        this.executeImpl(lockProtectedRunnable, lockImpl);
    }

    public boolean isLocked(boolean bl) {
        int[] nArray = this.getLockCounts();
        return nArray[1] > 0 || !bl && nArray[0] > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getQueueLength() {
        Object object = this.mutex;
        synchronized (object) {
            return this.tasks.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getMaxWaitingTime() {
        Object object = this.mutex;
        synchronized (object) {
            return this.times.isEmpty() ? -1L : System.currentTimeMillis() - this.times.get(0);
        }
    }

    protected boolean isAllowedThread(boolean bl) {
        return true;
    }

    protected void executeInAllowedThread(Runnable runnable) {
        throw new UnsupportedOperationException("Not implemented in " + this.getClass());
    }

    private void invokeRun0(final LockProtectedRunnable lockProtectedRunnable, boolean bl, Lock lock) {
        final boolean bl2 = lock.isWriteLock();
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class Helper
        implements Runnable,
        LockProtectedRunnable {
            private boolean executed;
            private Lock retainedLock;

            Helper() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Helper helper = this;
                synchronized (helper) {
                    LockableImpl.this.execute((LockProtectedRunnable)this, bl2);
                    if (this.executed) {
                        return;
                    }
                    while (this.retainedLock == null) {
                        try {
                            this.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            interruptedException.printStackTrace();
                        }
                    }
                }
                try {
                    LockableImpl.this.executeForcedly(lockProtectedRunnable, this.retainedLock);
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run(boolean bl, Lock lock) {
                if (LockableImpl.this.isAllowedThread(lock.isWriteLock())) {
                    this.executed = true;
                    LockableImpl.this.invokeRun(lockProtectedRunnable, false, lock);
                } else {
                    lock.retain();
                    this.retainedLock = lock;
                    Helper helper = this;
                    synchronized (helper) {
                        this.notifyAll();
                    }
                }
            }
        }
        if (lockProtectedRunnable instanceof Helper) {
            lockProtectedRunnable.run(bl, lock);
        } else if (this.isAllowedThread(bl2)) {
            this.invokeRun(lockProtectedRunnable, bl, lock);
        } else {
            this.executeInAllowedThread(new Helper());
        }
    }

    protected void invokeRun(LockProtectedRunnable lockProtectedRunnable, boolean bl, Lock lock) {
        lockProtectedRunnable.run(bl, lock);
    }

    protected void enterWriteLock() {
    }

    protected void leaveWriteLock() {
    }

    private final class LockImpl
    implements Lock {
        boolean write;
        boolean retained = false;
        boolean used = false;
        private AssertionError trace;

        LockImpl(boolean bl) {
            this.write = bl;
        }

        public Lockable getLockable() {
            return LockableImpl.this;
        }

        private boolean getStackTrace() {
            this.trace = new AssertionError();
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void retain() {
            Object object = LockableImpl.this.mutex;
            synchronized (object) {
                if (this.retained) {
                    throw new IllegalStateException("Lock has already been retained");
                }
                this.retained = true;
                if (this.write) {
                    LockableImpl.this.retainedWriteLocks++;
                } else {
                    LockableImpl.this.retainedReadLocks++;
                }
            }
            assert (this.getStackTrace());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void executeWithoutWriteLock(Runnable runnable) throws InterruptedException {
            Thread thread = Thread.currentThread();
            int[] nArray = LockableImpl.this.getLockCounts();
            if (!this.write || thread != LockableImpl.this.writeLockOwner || nArray[1] != 1) {
                throw new IllegalStateException("The current thread has no write lock, or there exists more than one write lock");
            }
            Object object = LockableImpl.this.mutex;
            synchronized (object) {
                assert (nArray[1] == 1 && LockableImpl.this.activeWriteLocks == 1);
                nArray[0] = nArray[0] + 1;
                LockableImpl.this.activeReadLocks++;
                nArray[1] = 0;
                LockableImpl.this.activeWriteLocks = 0;
                LockableImpl.this.writeLockOwner = null;
                this.write = false;
                LockableImpl.this.mutex.notifyAll();
            }
            runnable.run();
            object = LockableImpl.this.mutex;
            synchronized (object) {
                assert (nArray[1] == 0);
                assert (LockableImpl.this.activeWriteLocks == 0);
                try {
                    LockableImpl.this.deadLockRiskCounter++;
                    LockableImpl.this.waitingWriters++;
                    LockableImpl.this.mutex.notifyAll();
                    while (nArray[0] != LockableImpl.this.activeReadLocks) {
                        LockableImpl.this.mutex.wait();
                    }
                    nArray[0] = nArray[0] - 1;
                    LockableImpl.this.activeReadLocks--;
                    nArray[1] = 1;
                    LockableImpl.this.activeWriteLocks = 1;
                    LockableImpl.this.writeLockOwner = thread;
                    this.write = true;
                }
                finally {
                    LockableImpl.this.deadLockRiskCounter--;
                    LockableImpl.this.waitingWriters--;
                    LockableImpl.this.mutex.notifyAll();
                }
            }
        }

        public boolean isWriteLock() {
            return this.write;
        }

        protected void finalize() {
            if (this.retained && !this.used) {
                System.err.println("Lock " + this + " has not been used as argument to Lockable.execute");
                if (this.trace != null) {
                    ((Throwable)((Object)this.trace)).printStackTrace();
                }
            }
        }

        void dispose() {
            this.retained = true;
            this.used = true;
        }

        void use() {
            if (!this.retained) {
                throw new IllegalStateException("Only retained locks may be used later on");
            }
            if (this.used) {
                throw new IllegalStateException("Lock has already been used");
            }
            this.used = true;
            if (this.write) {
                LockableImpl.this.retainedWriteLocks--;
            } else {
                LockableImpl.this.retainedReadLocks--;
            }
            LockableImpl.this.mutex.notifyAll();
        }
    }
}

