/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.util;

import de.grogra.util.Unit;
import java.util.ArrayList;

public final class Quantity {
    public static final Quantity FRACTION = new Quantity(null, new Unit("%", 0.01, true));
    public static final Quantity TIME = new Quantity(null, new Unit("s", 1.0, true));
    public static final Quantity LENGTH = new Quantity(null, new Unit("m", 1.0, true));
    public static final Quantity MASS = new Quantity(null, new Unit("kg", 1.0, true));
    public static final Quantity ANGLE = new Quantity(null, new Unit("deg", Math.PI / 180, true));
    public static final Quantity POWER = new Quantity(null, new Unit("W", 1.0, true));
    public static final Quantity POWER_PER_AREA = new Quantity(null, new Unit("W/m\u00b2", 1.0, true));
    public static final Quantity TEMPERATURE = new Quantity(null, new Unit("K", 1.0, true));
    private final Quantity base;
    private final Unit preferredUnit;
    private final ArrayList units;

    public static Quantity get(String string) {
        return "TIME".equals(string) ? TIME : ("LENGTH".equals(string) ? LENGTH : ("MASS".equals(string) ? MASS : ("ANGLE".equals(string) ? ANGLE : ("POWER".equals(string) ? POWER : ("POWER_PER_AREA".equals(string) ? POWER_PER_AREA : ("TEMPERATURE".equals(string) ? TEMPERATURE : null))))));
    }

    private Quantity(Quantity quantity, Unit unit) {
        this.base = quantity != null ? quantity.base : null;
        this.preferredUnit = unit;
        this.units = quantity != null ? quantity.units : new ArrayList();
        this.add(unit);
    }

    public Quantity newInstance(Unit unit) {
        return new Quantity(this, unit);
    }

    public Unit getPreferredUnit() {
        return this.preferredUnit;
    }

    public void add(Unit unit) {
        if (!this.units.contains(unit)) {
            this.units.add(unit);
        }
    }

    public void add(String string, double d) {
        this.units.add(new Unit(string, d, true));
    }

    public Unit chooseUnit(float f) {
        float f2;
        Unit unit = this.preferredUnit;
        float f3 = 0.0f;
        for (int i = 0; i < this.units.size(); ++i) {
            float f4;
            Unit unit2 = (Unit)this.units.get(i);
            if (!unit2.checkWhenChoosing() || !((f4 = unit2.getRatio(f)) > f3)) continue;
            unit = unit2;
            f3 = f4;
        }
        if (unit != this.preferredUnit && (f2 = this.preferredUnit.getRatio(f)) > 0.0f && f3 < 10.0f * f2) {
            return this.preferredUnit;
        }
        return unit;
    }

    public Unit[] getUnits() {
        return this.units.toArray(new Unit[this.units.size()]);
    }

    public String toString(float f) {
        return this.chooseUnit(f).toString(f);
    }

    public String toString(double d) {
        return this.chooseUnit((float)d).toString(d);
    }

    public Unit parseUnit(String string, Unit unit) {
        for (int i = 0; i < this.units.size(); ++i) {
            Unit unit2 = (Unit)this.units.get(i);
            if (!unit2.isSpecified(string)) continue;
            return unit2;
        }
        return unit;
    }

    public Unit parseUnit(String string) {
        return this.parseUnit(string, this.preferredUnit);
    }

    public boolean equals(Object object) {
        return object instanceof Quantity && ((Quantity)object).base == this.base;
    }

    public int hashCode() {
        return this.base == this ? super.hashCode() : this.base.hashCode();
    }

    static {
        FRACTION.add("ppm", 1.0E-6);
        LENGTH.add("km", 1000.0);
        LENGTH.add("cm", 0.01);
        LENGTH.add("mm", 0.001);
        LENGTH.add("nm", 1.0E-9);
        MASS.add("g", 0.001);
        MASS.add("t", 1000.0);
        ANGLE.add("arcsec", 4.84813681109536E-6);
        ANGLE.add(new Unit("rad", 1.0, false));
        POWER.add("kW", 1000.0);
        POWER.add("MW", 1000000.0);
    }
}

