/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.xl.util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EHashMap<E extends Entry> {
    private final float loadFactor;
    private int size;
    private int resizeThreshold;
    private int lengthM1;
    private Entry[] table;
    private E first;
    private E last;
    private final Entry[] pool;

    public EHashMap(Entry[] entryArray, int n, float f) {
        int n2;
        this.pool = entryArray;
        this.loadFactor = f;
        n = (int)((float)(n + 1) / f) + 2;
        for (n2 = 1; n2 < n; n2 <<= 1) {
        }
        this.resizeThreshold = (int)((float)n2 * f);
        this.table = new Entry[n2];
        this.lengthM1 = n2 - 1;
        this.size = 0;
    }

    public EHashMap(int n, float f) {
        this(new Entry[1], n, f);
    }

    public EHashMap(int n) {
        this(n, 0.75f);
    }

    public EHashMap() {
        this(16, 0.75f);
    }

    public E popEntryFromPool() {
        Entry entry = this.pool[0];
        if (entry != null) {
            this.pool[0] = entry.listNext;
            entry.listNext = null;
        }
        return (E)entry;
    }

    public void addEntryToPool(E e) {
        ((Entry)e).clear();
        ((Entry)e).listNext = this.pool[0];
        this.pool[0] = e;
    }

    public E getFirstEntry() {
        return this.first;
    }

    public E getLastEntry() {
        return this.last;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public int size() {
        return this.size;
    }

    public void clear() {
        Entry[] entryArray = this.table;
        this.size = 0;
        int n = this.lengthM1;
        Object object = this.first;
        while (object != null) {
            entryArray[((Entry)object).hashCode & n] = null;
            ((Entry)object).next = null;
            ((Entry)object).listPrev = null;
            ((Entry)object).clear();
            object = ((Entry)object).listNext;
        }
        if (this.last != null) {
            ((Entry)this.last).listNext = this.pool[0];
            this.pool[0] = this.first;
            this.first = null;
            this.last = null;
        }
    }

    public E put(E e) {
        int n = ((Entry)e).hashCode;
        Entry entry = this.table[n & this.lengthM1];
        while (entry != null) {
            if (entry.hashCode == n && ((Entry)e).keyEquals(entry)) {
                entry.copyValue((Entry)e);
                ((Entry)e).clear();
                ((Entry)e).listNext = this.pool[0];
                this.pool[0] = e;
                return (E)entry;
            }
            entry = entry.next;
        }
        this.add(e);
        return null;
    }

    public E getOrPut(E e) {
        int n = ((Entry)e).hashCode;
        Entry entry = this.table[n & this.lengthM1];
        while (entry != null) {
            if (entry.hashCode == n && ((Entry)e).keyEquals(entry)) {
                ((Entry)e).clear();
                ((Entry)e).listNext = this.pool[0];
                this.pool[0] = e;
                return (E)entry;
            }
            entry = entry.next;
        }
        this.add(e);
        return null;
    }

    public E get(E e) {
        int n = ((Entry)e).hashCode;
        Entry entry = this.table[n & this.lengthM1];
        while (entry != null) {
            if (entry.hashCode == n && ((Entry)e).keyEquals(entry)) {
                return (E)entry;
            }
            entry = entry.next;
        }
        return null;
    }

    public void add(E object) {
        int n = ((Entry)object).hashCode & this.lengthM1;
        ((Entry)object).next = this.table[n];
        this.table[n] = object;
        if (this.first == null) {
            this.first = object;
        }
        if ((((Entry)object).listPrev = this.last) != null) {
            ((Entry)this.last).listNext = object;
        }
        this.last = object;
        if (++this.size > this.resizeThreshold) {
            Entry[] entryArray = new Entry[this.lengthM1 + 1 << 1];
            Entry[] entryArray2 = this.table;
            int n2 = entryArray.length - 1;
            for (int i = this.lengthM1; i >= 0; --i) {
                Entry entry;
                object = entryArray2[i];
                if (object == null) continue;
                entryArray2[i] = null;
                do {
                    entry = ((Entry)object).next;
                    n = ((Entry)object).hashCode & n2;
                    ((Entry)object).next = entryArray[n];
                    entryArray[n] = object;
                } while ((object = entry) != null);
            }
            this.table = entryArray;
            this.lengthM1 = n2;
            this.resizeThreshold = (int)((float)entryArray.length * this.loadFactor);
        }
    }

    public void makeFirst(E e) {
        if (e != this.first) {
            if (e == this.last) {
                this.last = ((Entry)e).listPrev;
            }
            if ((((Entry)e).listPrev.listNext = ((Entry)e).listNext) != null) {
                ((Entry)e).listNext.listPrev = ((Entry)e).listPrev;
            }
            ((Entry)e).listPrev = null;
            ((Entry)e).listNext = this.first;
            if (((Entry)e).listNext != null) {
                ((Entry)this.first).listPrev = e;
            }
            this.first = e;
        }
    }

    public void remove(E e) {
        int n = ((Entry)e).hashCode;
        Entry entry = this.table[n & this.lengthM1];
        Entry entry2 = null;
        while (entry != null) {
            if (entry == e || entry.hashCode == n && ((Entry)e).keyEquals(entry)) {
                --this.size;
                if (entry2 != null) {
                    entry2.next = entry.next;
                } else {
                    this.table[n & this.lengthM1] = entry.next;
                }
                if (entry == this.last) {
                    this.last = entry.listPrev;
                }
                if (entry == this.first) {
                    this.first = entry.listNext;
                    if (this.first != null) {
                        ((Entry)this.first).listPrev = null;
                    }
                } else {
                    entry.listPrev.listNext = entry.listNext;
                    if (entry.listPrev.listNext != null) {
                        entry.listNext.listPrev = entry.listPrev;
                    }
                    entry.listPrev = null;
                }
                entry.next = null;
                entry.clear();
                entry.listNext = this.pool[0];
                this.pool[0] = entry;
                return;
            }
            entry2 = entry;
            entry = entry.next;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class IdentityEntry<K, V>
    extends ObjectEntry<K, V> {
        @Override
        protected boolean keyEquals(Entry entry) {
            return this.key == ((IdentityEntry)entry).key;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ObjectEntry<K, V>
    extends Entry {
        K key;
        public V value;

        public K getKey() {
            return this.key;
        }

        public void setKey(K k) {
            this.hashCode = k != null ? k.hashCode() : 0;
            this.key = k;
        }

        @Override
        protected boolean keyEquals(Entry entry) {
            return this.key == ((ObjectEntry)entry).key || this.key != null && this.key.equals(((ObjectEntry)entry).key);
        }

        @Override
        protected void copyValue(Entry entry) {
            this.value = ((ObjectEntry)entry).value;
        }

        @Override
        protected void clear() {
            this.key = null;
            this.value = null;
        }
    }

    public static abstract class Entry {
        public Entry listNext;
        public Entry listPrev;
        protected int hashCode;
        Entry next;

        public Entry next() {
            Entry entry = this.next;
            while (entry != null) {
                if (entry.hashCode == this.hashCode && this.keyEquals(entry)) {
                    return entry;
                }
                entry = entry.next;
            }
            return null;
        }

        protected abstract boolean keyEquals(Entry var1);

        protected abstract void copyValue(Entry var1);

        protected abstract void clear();
    }
}

