/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.xl.util;

import de.grogra.xl.lang.ShortConsumer;
import de.grogra.xl.lang.VoidToShortGenerator;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.nio.ShortBuffer;

public class ShortList
implements Cloneable,
Serializable,
ShortConsumer,
VoidToShortGenerator {
    private static final long serialVersionUID = 8420850575012594216L;
    public transient short[] elements;
    public int size = 0;
    private static final short[] EMPTY = new short[0];
    private static final short[] SHORT_NULL = new short[1024];

    public ShortList(int n) {
        this.elements = new short[Math.max(n, 8)];
    }

    public ShortList() {
        this(16);
    }

    public ShortList(short[] sArray) {
        this(sArray.length);
        this.size = sArray.length;
        ShortList.arraycopy(sArray, 0, this.elements, 0, this.size);
    }

    public Object clone() {
        try {
            ShortList shortList = (ShortList)super.clone();
            shortList.elements = new short[Math.max(this.size, 8)];
            ShortList.arraycopy(this.elements, 0, shortList.elements, 0, this.size);
            return shortList;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new AssertionError();
        }
    }

    public void ensureCapacity(int n) {
        if (n > this.elements.length) {
            short[] sArray = new short[Math.max(n, this.elements.length * 2)];
            ShortList.arraycopy(this.elements, 0, sArray, 0, this.size);
            this.elements = sArray;
        }
    }

    public void trimToSize() {
        if (this.size < this.elements.length) {
            if (this.size == 0) {
                this.elements = EMPTY;
            } else {
                this.elements = new short[this.size];
                ShortList.arraycopy(this.elements, 0, this.elements, 0, this.size);
            }
        }
    }

    public final ShortList push(short s) {
        this.add(s);
        return this;
    }

    public final ShortList push(short s, short s2) {
        this.add(s);
        this.add(s2);
        return this;
    }

    public final ShortList push(short s, short s2, short s3) {
        this.add(s);
        this.add(s2);
        this.add(s3);
        return this;
    }

    public boolean add(short s) {
        if (this.size == this.elements.length) {
            this.ensureCapacity(this.size + 1);
        }
        this.elements[this.size] = s;
        ++this.size;
        return true;
    }

    public void add(int n, short s) {
        if (n >= this.size) {
            this.ensureCapacity(n + 1);
            ShortList.clear(this.elements, this.size, n - this.size);
        } else {
            this.ensureCapacity(this.size + 1);
            ShortList.arraycopy(this.elements, n, this.elements, n + 1, this.size - n);
        }
        this.elements[n] = s;
        ++this.size;
    }

    public void addIfNotContained(short s) {
        if (!this.contains(s)) {
            this.add(s);
        }
    }

    public ShortList addAll(ShortList shortList) {
        return this.addAll(shortList.elements, 0, shortList.size);
    }

    public ShortList addAll(short[] sArray, int n, int n2) {
        if (n2 <= 0) {
            return this;
        }
        this.ensureCapacity(this.size + n2);
        ShortList.arraycopy(sArray, n, this.elements, this.size, n2);
        this.size += n2;
        return this;
    }

    public short removeAt(int n) {
        short s = this.elements[n];
        ShortList.arraycopy(this.elements, n + 1, this.elements, n, --this.size - n);
        return s;
    }

    public boolean remove(short s) {
        for (int i = this.size - 1; i >= 0; --i) {
            if (s != this.elements[i]) continue;
            this.removeAt(i);
            return true;
        }
        return false;
    }

    public short set(int n, short s) {
        short s2;
        if (n >= this.size) {
            this.ensureCapacity(n + 1);
            ShortList.clear(this.elements, this.size, n - this.size);
            s2 = this.elements[n];
            this.elements[n] = s;
            this.size = n + 1;
        } else {
            s2 = this.elements[n];
            this.elements[n] = s;
        }
        return s2;
    }

    public short get(int n) {
        return n < this.size ? this.elements[n] : (short)0;
    }

    public short peek(int n) {
        return n > 0 ? this.elements[this.size - n] : (short)0;
    }

    public boolean contains(short s) {
        for (int i = this.size - 1; i >= 0; --i) {
            if (s != this.elements[i]) continue;
            return true;
        }
        return false;
    }

    public int indexOf(short s) {
        for (int i = 0; i < this.size; ++i) {
            if (s != this.elements[i]) continue;
            return i;
        }
        return -1;
    }

    public int lastIndexOf(short s) {
        for (int i = this.size - 1; i >= 0; --i) {
            if (s != this.elements[i]) continue;
            return i;
        }
        return -1;
    }

    public int binarySearch(short s) {
        return ShortList.binarySearch(this.elements, s, 0, this.size);
    }

    public static int binarySearch(short[] sArray, short s) {
        return ShortList.binarySearch(sArray, s, 0, sArray.length);
    }

    public static int binarySearch(short[] sArray, short s, int n, int n2) {
        while (n < n2) {
            int n3 = n + n2 >> 1;
            short s2 = sArray[n3];
            if (s2 < s) {
                n = n3 + 1;
                continue;
            }
            if (s2 > s) {
                n2 = n3;
                continue;
            }
            return n3;
        }
        return ~n;
    }

    public void writeTo(ShortBuffer shortBuffer) {
        shortBuffer.put(this.elements, 0, this.size);
    }

    public void clear() {
        this.size = 0;
    }

    public static void arraycopy(short[] sArray, int n, short[] sArray2, int n2, int n3) {
        if (n3 < 20) {
            if (sArray2 != sArray || n2 > n) {
                while (--n3 >= 0) {
                    sArray2[n2 + n3] = sArray[n + n3];
                }
            } else {
                for (int i = 0; i < n3; ++i) {
                    sArray2[n2 + i] = sArray[n + i];
                }
            }
        } else {
            System.arraycopy(sArray, n, sArray2, n2, n3);
        }
    }

    public static void clear(short[] sArray, int n, int n2) {
        if (n2 < 20) {
            while (--n2 >= 0) {
                sArray[n + n2] = 0;
            }
        } else {
            while (n2 > 0) {
                int n3 = n2 > 1024 ? 1024 : n2;
                ShortList.arraycopy(SHORT_NULL, 0, sArray, n, n3);
                n2 -= n3;
                n += n3;
            }
        }
    }

    public short pop() {
        return this.elements[--this.size];
    }

    public void setSize(int n) {
        if (n > this.size) {
            this.ensureCapacity(n);
        }
        this.size = n;
    }

    public final int size() {
        return this.size;
    }

    public final boolean isEmpty() {
        return this.size == 0;
    }

    public short[] toArray() {
        short[] sArray = new short[this.size];
        ShortList.arraycopy(this.elements, 0, sArray, 0, this.size);
        return sArray;
    }

    public short[] toArray(short[] sArray) {
        int n = sArray.length;
        if (n > this.size) {
            sArray[this.size] = 0;
        } else if (n < this.size) {
            sArray = new short[this.size];
        }
        ShortList.arraycopy(this.elements, 0, sArray, 0, this.size);
        return sArray;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(super.toString()).append('{');
        for (int i = 0; i < this.size; ++i) {
            if (i > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(this.elements[i]);
        }
        return stringBuffer.append('}').toString();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof ShortList)) {
            return false;
        }
        ShortList shortList = (ShortList)object;
        if (this.size != shortList.size()) {
            return false;
        }
        for (int i = 0; i < this.size; ++i) {
            if (this.elements[i] == shortList.get(i)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int n = 1;
        for (int i = 0; i < this.size; ++i) {
            n = 31 * n + this.elements[i];
        }
        return n;
    }

    public void consume(short s) {
        this.add(s);
    }

    public void evaluateShort(ShortConsumer shortConsumer) {
        for (int i = 0; i < this.size; ++i) {
            shortConsumer.consume(this.elements[i]);
        }
    }

    public void values(ShortConsumer shortConsumer) {
        this.evaluateShort(shortConsumer);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        for (int i = 0; i < this.size; ++i) {
            objectOutputStream.writeShort(this.elements[i]);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.elements = new short[this.size];
        short[] sArray = this.elements;
        for (int i = 0; i < this.size; ++i) {
            sArray[i] = objectInputStream.readShort();
        }
    }
}

