/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.retroweaver.runtime.java.lang;

import java.io.InvalidObjectException;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class Enum<E extends Enum<E>>
implements Comparable<E>,
Serializable {
    private static final long serialVersionUID = -1689726118486609581L;
    private final transient int ordinal_;
    private final String name_;
    private static final Map<Class, Object[]> enumValues = new HashMap<Class, Object[]>();

    protected Enum(String string, int n) {
        this.name_ = string;
        this.ordinal_ = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static final void setEnumValues(Object[] objectArray, Class clazz) {
        Map<Class, Object[]> map = enumValues;
        synchronized (map) {
            enumValues.put(clazz, objectArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static final <T> T[] getEnumValues(Class<T> clazz) {
        Map<Class, Object[]> map = enumValues;
        synchronized (map) {
            Object[] objectArray = enumValues.get(clazz);
            if (objectArray != null) {
                return objectArray;
            }
        }
        if (!clazz.isEnum()) {
            return null;
        }
        try {
            Class.forName(clazz.getName(), true, clazz.getClassLoader());
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        map = enumValues;
        synchronized (map) {
            return enumValues.get(clazz);
        }
    }

    protected Object readResolve() throws ObjectStreamException {
        Class<E> clazz = this.getDeclaringClass();
        try {
            return Enum.valueOf(clazz, this.name_);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            InvalidObjectException invalidObjectException = new InvalidObjectException(this.name_ + " is not a valid enum for " + clazz.getName());
            try {
                invalidObjectException.initCause(illegalArgumentException);
            }
            catch (NoSuchMethodError noSuchMethodError) {
                // empty catch block
            }
            throw invalidObjectException;
        }
    }

    public static <T extends Enum<T>> T valueOf(Class<T> clazz, String string) {
        if (clazz == null) {
            throw new NullPointerException("enumType is null");
        }
        if (string == null) {
            throw new NullPointerException("name_ is null");
        }
        Enum[] enumArray = (Enum[])Enum.getEnumValues(clazz);
        if (enumArray != null) {
            for (Enum enum_ : enumArray) {
                if (!enum_.name_.equals(string)) continue;
                return (T)enum_;
            }
        }
        throw new IllegalArgumentException("No enum const " + clazz + "." + string);
    }

    public final boolean equals(Object object) {
        return object == this;
    }

    public final int hashCode() {
        return System.identityHashCode(this);
    }

    public String toString() {
        return this.name_;
    }

    @Override
    public final int compareTo(E e) {
        Class<E> clazz;
        Class<E> clazz2 = this.getDeclaringClass();
        if (clazz2 == (clazz = ((Enum)e).getDeclaringClass())) {
            return this.ordinal_ - ((Enum)e).ordinal_;
        }
        throw new ClassCastException();
    }

    protected final Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    public final String name() {
        return this.name_;
    }

    public final int ordinal() {
        return this.ordinal_;
    }

    public final Class<E> getDeclaringClass() {
        Class<?> clazz = this.getClass();
        Class<?> clazz2 = clazz.getSuperclass();
        if (clazz2 == Enum.class) {
            return clazz;
        }
        return clazz2;
    }
}

