/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.retroweaver.runtime.java.lang;

public class Math_ {
    private static final double LOG10 = Math.log(10.0);

    public static double log10(double d) {
        return Math.log(d) / LOG10;
    }

    public static double signum(double d) {
        if (Double.isNaN(d)) {
            return Double.NaN;
        }
        if (d > 0.0) {
            return 1.0;
        }
        if (d < 0.0) {
            return -1.0;
        }
        return d;
    }

    public static float signum(float f) {
        if (Float.isNaN(f)) {
            return Float.NaN;
        }
        if (f > 0.0f) {
            return 1.0f;
        }
        if (f < 0.0f) {
            return -1.0f;
        }
        return f;
    }

    public static double sinh(double d) {
        if (Double.isNaN(d)) {
            return Double.NaN;
        }
        if (Double.isInfinite(d)) {
            return d;
        }
        if (d == 0.0) {
            return d;
        }
        return (Math.exp(d) - Math.exp(-d)) / 2.0;
    }

    public static double cosh(double d) {
        if (Double.isNaN(d)) {
            return Double.NaN;
        }
        if (Double.isInfinite(d)) {
            return Double.POSITIVE_INFINITY;
        }
        if (d == 0.0) {
            return 1.0;
        }
        return (Math.exp(d) + Math.exp(-d)) / 2.0;
    }

    public static double tanh(double d) {
        if (Double.isNaN(d)) {
            return Double.NaN;
        }
        if (d == 0.0) {
            return d;
        }
        if (d == Double.POSITIVE_INFINITY) {
            return 1.0;
        }
        if (d == Double.NEGATIVE_INFINITY) {
            return -1.0;
        }
        double d2 = Math.exp(d);
        double d3 = Math.exp(-d);
        return (d2 - d3) / (d2 + d3);
    }

    public static double expm1(double d) {
        return Math.exp(d) - 1.0;
    }

    public static double log1p(double d) {
        return Math.log(1.0 + d);
    }
}

