/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.xl.vmx;

import de.grogra.reflect.Type;
import de.grogra.xl.query.AbstractExpressionPattern;
import de.grogra.xl.query.BytecodeSerialization;
import de.grogra.xl.query.Frame;
import de.grogra.xl.query.MatchConsumer;
import de.grogra.xl.query.QueryState;
import de.grogra.xl.query.Utils;
import de.grogra.xl.vmx.Routine;
import de.grogra.xl.vmx.SerializationWithRoutine;
import de.grogra.xl.vmx.VMXState;
import java.io.IOException;

public final class ExpressionPattern
extends AbstractExpressionPattern {
    final Routine routine;

    public ExpressionPattern(Type[] typeArray, int n, int n2, int n3, Routine routine) {
        super(typeArray, n3, n, n2);
        this.routine = routine;
    }

    public void write(BytecodeSerialization bytecodeSerialization) throws IOException {
        bytecodeSerialization.beginMethod(Utils.getConstructor((Object)((Object)this)));
        bytecodeSerialization.beginArray(this.getParameterCount(), Type.TYPE);
        for (int i = 0; i < this.getParameterCount(); ++i) {
            bytecodeSerialization.beginArrayComponent(i);
            bytecodeSerialization.visitType(this.getParameterType(i));
            bytecodeSerialization.endArrayComponent();
        }
        bytecodeSerialization.endArray();
        bytecodeSerialization.visitInt(this.pathIn);
        bytecodeSerialization.visitInt(this.pathOut);
        bytecodeSerialization.visitInt(this.type);
        ((SerializationWithRoutine)bytecodeSerialization).visitRoutine(this.routine);
        bytecodeSerialization.endMethod();
    }

    protected void findMatchesImpl(QueryState queryState, MatchConsumer matchConsumer, int n, Frame frame) {
        int n2;
        VMXState.VMXFrame vMXFrame = (VMXState.VMXFrame)frame;
        VMXState vMXState = vMXFrame.vmx;
        int n3 = this.getParameterCount();
        int n4 = n2 = this.type == 0 ? 1 : 0;
        while (n2 < n3) {
            switch (this.getParameterType(n2).getTypeId()) {
                case 2: {
                    vMXState.ipush(queryState.ibound(n2));
                    break;
                }
                case 3: {
                    vMXState.ipush(queryState.ibound(n2));
                    break;
                }
                case 4: {
                    vMXState.ipush(queryState.ibound(n2));
                    break;
                }
                case 5: {
                    vMXState.ipush(queryState.ibound(n2));
                    break;
                }
                case 6: {
                    vMXState.ipush(queryState.ibound(n2));
                    break;
                }
                case 7: {
                    vMXState.lpush(queryState.lbound(n2));
                    break;
                }
                case 8: {
                    vMXState.fpush(queryState.fbound(n2));
                    break;
                }
                case 9: {
                    vMXState.dpush(queryState.dbound(n2));
                    break;
                }
                case 0: {
                    vMXState.apush(queryState.abound(n2));
                }
            }
            ++n2;
        }
        switch (this.type) {
            case 0: {
                vMXState.apush(queryState);
                vMXState.ipush(0);
                VMXState.MatchConsumerInFrame matchConsumerInFrame = vMXState.invokeInFrame(matchConsumer, frame);
                vMXState.apush(matchConsumerInFrame);
                vMXState.ipush(n);
                vMXState.invoke(this.routine, -1, vMXFrame.auth);
                matchConsumerInFrame.dispose();
                break;
            }
            case 1: {
                if (vMXState.invoke(this.routine, -1, vMXFrame.auth).iget() == 0) break;
                matchConsumer.matchFound(queryState, n);
                break;
            }
            case 2: {
                vMXState.invoke(this.routine, -1, vMXFrame.auth);
                matchConsumer.matchFound(queryState, n);
                break;
            }
            default: {
                throw new AssertionError(this.type);
            }
        }
    }

    protected String paramString() {
        return super.paramString() + ',' + this.type + ',' + this.routine;
    }
}

