/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.imp2d.graphs;

import de.grogra.graph.Attribute;
import de.grogra.imp2d.graphs.CompareValue;
import de.grogra.imp2d.graphs.FilterFolding;
import de.grogra.imp2d.graphs.FilterHide;
import de.grogra.imp2d.graphs.FilterHighlight;
import de.grogra.imp2d.objects.Hexagon;
import de.grogra.imp2d.objects.Octagon;
import de.grogra.imp2d.objects.Rhombus;
import de.grogra.imp2d.objects.Triangle;
import java.awt.Rectangle;
import java.util.Hashtable;
import java.util.LinkedList;
import javax.vecmath.Color3f;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class HighlightFilterData {
    LinkedList fHides = new LinkedList();
    LinkedList fHighlights = new LinkedList();
    LinkedList fFoldings = new LinkedList();
    DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
    DocumentBuilder builder;

    public HighlightFilterData(String string) {
        try {
            Object object;
            LinkedList linkedList;
            int n;
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(string);
            NodeList nodeList = document.getElementsByTagName("Filter_Hide");
            NodeList nodeList2 = document.getElementsByTagName("Filter_Highlight");
            NodeList nodeList3 = document.getElementsByTagName("Filter_Folding");
            for (n = 0; n < nodeList.getLength(); ++n) {
                linkedList = this.getCriteriaForFilter(nodeList.item(n).getChildNodes());
                if (linkedList == null) continue;
                boolean bl = this.getSubnodesForFilter(nodeList.item(n).getChildNodes());
                FilterHide filterHide = new FilterHide();
                filterHide.setHideCriteria(linkedList);
                filterHide.setSubnodes(bl);
                this.fHides.add(filterHide);
            }
            for (n = 0; n < nodeList2.getLength(); ++n) {
                linkedList = this.getCriteriaForFilter(nodeList2.item(n).getChildNodes());
                Hashtable hashtable = this.getResultsForFilter(nodeList2.item(n).getChildNodes());
                boolean bl = this.getSubnodesForFilter(nodeList2.item(n).getChildNodes());
                object = new FilterHighlight();
                ((FilterHighlight)object).setHighlightCriteria(linkedList);
                ((FilterHighlight)object).setSubnodes(bl);
                ((FilterHighlight)object).setHighlightResults(hashtable);
                this.fHighlights.add(object);
            }
            for (n = 0; n < nodeList3.getLength(); ++n) {
                linkedList = this.getCriteriaForFilter(nodeList3.item(n).getChildNodes());
                Hashtable hashtable = this.getResultsForFilter(nodeList3.item(n).getChildNodes());
                boolean bl = this.getSubnodesForFilter(nodeList3.item(n).getChildNodes());
                object = new FilterFolding();
                ((FilterFolding)object).setFoldingCriteria(linkedList);
                ((FilterFolding)object).setSubnodes(bl);
                ((FilterFolding)object).setFoldingNodeAttributes(hashtable);
                this.fFoldings.add(object);
            }
        }
        catch (Exception exception) {
            System.out.println("Error occured: " + exception);
        }
    }

    public void addFilterHide(FilterHide filterHide) {
        this.fHides.add(filterHide);
    }

    public LinkedList getFilterHides() {
        return this.fHides;
    }

    public void addFilterHighlight(FilterHighlight filterHighlight) {
        this.fHighlights.add(filterHighlight);
    }

    public LinkedList getFilterHighlights() {
        return this.fHighlights;
    }

    public void addFilterFolding(FilterFolding filterFolding) {
        this.fFoldings.add(filterFolding);
    }

    public LinkedList getFilterFoldings() {
        return this.fFoldings;
    }

    private Object getStringToObject(Node node) {
        if (Attribute.forName((String)node.getNodeName()).getType().toString().equals("java.lang.String")) {
            return node.getFirstChild().getNodeValue();
        }
        if (Attribute.forName((String)node.getNodeName()).getType().toString().equals("javax.vecmath.Color3f")) {
            String[] stringArray = node.getFirstChild().getNodeValue().split(",");
            return new Color3f(Float.parseFloat(stringArray[0]), Float.parseFloat(stringArray[1]), Float.parseFloat(stringArray[2]));
        }
        if (Attribute.forName((String)node.getNodeName()).getType().toString().equals("int")) {
            return new Integer(Integer.parseInt(node.getFirstChild().getNodeValue()));
        }
        if (Attribute.forName((String)node.getNodeName()).getType().toString().equals("java.awt.Shape")) {
            if (node.getFirstChild().getNodeValue().equals("Octagon")) {
                return new Octagon();
            }
            if (node.getFirstChild().getNodeValue().equals("Rhombus")) {
                return new Rhombus();
            }
            if (node.getFirstChild().getNodeValue().equals("Triangle")) {
                return new Triangle();
            }
            if (node.getFirstChild().getNodeValue().equals("Hexagon")) {
                return new Hexagon();
            }
            if (node.getFirstChild().getNodeValue().equals("Rectangle")) {
                return new Rectangle();
            }
        } else {
            System.out.println("Unknown Type: " + Attribute.forName((String)node.getNodeName()).getType().toString());
        }
        return null;
    }

    private boolean getSubnodesForFilter(NodeList nodeList) {
        for (int i = 0; i < nodeList.getLength(); ++i) {
            if (!nodeList.item(i).getNodeName().equals("Subnodes")) continue;
            return true;
        }
        return false;
    }

    private LinkedList getCriteriaForFilter(NodeList nodeList) {
        LinkedList linkedList = new LinkedList();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            if (!nodeList.item(i).getNodeName().equals("Criterion")) continue;
            Hashtable<String, CompareValue> hashtable = new Hashtable<String, CompareValue>();
            NodeList nodeList2 = nodeList.item(i).getChildNodes();
            for (int j = 0; j < nodeList2.getLength(); ++j) {
                hashtable.put(nodeList2.item(j).getNodeName(), new CompareValue(this.getStringToObject(nodeList2.item(j)), nodeList2.item(j).getAttributes().getNamedItem("compare").getNodeValue().charAt(0)));
            }
            if (hashtable.size() <= 0) continue;
            linkedList.add(hashtable);
        }
        if (linkedList.size() > 0) {
            return linkedList;
        }
        return null;
    }

    private Hashtable getResultsForFilter(NodeList nodeList) {
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            if (!nodeList.item(i).getNodeName().equals("Result") && !nodeList.item(i).getNodeName().equals("FoldedNode")) continue;
            NodeList nodeList2 = nodeList.item(i).getChildNodes();
            for (int j = 0; j < nodeList2.getLength(); ++j) {
                hashtable.put(nodeList2.item(j).getNodeName(), this.getStringToObject(nodeList2.item(j)));
            }
        }
        return hashtable;
    }

    LinkedList getAllChangingAttributesNames() {
        Object object;
        Object object2;
        LinkedList<Object> linkedList = new LinkedList<Object>();
        LinkedList linkedList2 = this.getFilterHighlights();
        for (int i = 0; i < linkedList2.size(); ++i) {
            Hashtable hashtable = ((FilterHighlight)linkedList2.get(i)).getHighlightResults();
            object2 = hashtable.keys();
            while (object2.hasMoreElements()) {
                object = (String)object2.nextElement();
                if (linkedList.contains(object)) continue;
                linkedList.add(object);
            }
        }
        LinkedList linkedList3 = this.getFilterFoldings();
        for (int i = 0; i < linkedList3.size(); ++i) {
            object2 = ((FilterFolding)linkedList3.get(i)).getFoldingNodeAttributes();
            object = ((Hashtable)object2).keys();
            while (object.hasMoreElements()) {
                String string = (String)object.nextElement();
                if (linkedList.contains(string)) continue;
                linkedList.add(string);
            }
        }
        return linkedList;
    }
}

