/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.imp2d.layout;

import de.grogra.imp2d.layout.GraphUtilities;
import de.grogra.imp2d.layout.Layout;
import de.grogra.imp2d.layout.Node;
import de.grogra.persistence.ManageableType;
import de.grogra.persistence.SCOType;
import java.util.LinkedList;

public class CircleGraphLayout
extends Layout {
    private int layerCount = 2;
    private int r;
    private int eachLayerNodes;
    private double phi;
    private double layerDistance = 1.0;
    private double nodeDistance = 1.0;
    public static final Type $TYPE = new Type(CircleGraphLayout.class);
    public static final SCOType.Field layerCount$FIELD = Type._addManagedField($TYPE, "layerCount", 0x200002, de.grogra.reflect.Type.INT, null, 2);
    public static final SCOType.Field layerDistance$FIELD = Type._addManagedField($TYPE, "layerDistance", 0x200002, de.grogra.reflect.Type.DOUBLE, null, 3);
    public static final SCOType.Field nodeDistance$FIELD = Type._addManagedField($TYPE, "nodeDistance", 0x200002, de.grogra.reflect.Type.DOUBLE, null, 4);

    protected Layout.Algorithm createAlgorithm() {
        return new Layout.Algorithm(){

            protected void layout(Node node) {
                double d = 1.0;
                int n = 0;
                Node node2 = node;
                while (node2 != null) {
                    d = (float)Math.max(d, (double)Math.max(node2.height, node2.width));
                    ++n;
                    node2 = node2.next;
                }
                CircleGraphLayout.this.layerDistance = Math.max(d + CircleGraphLayout.this.nodeDistance, CircleGraphLayout.this.layerDistance);
                CircleGraphLayout.this.eachLayerNodes = n / CircleGraphLayout.this.layerCount;
                if (n % CircleGraphLayout.this.layerCount != 0) {
                    CircleGraphLayout.this.eachLayerNodes++;
                }
                CircleGraphLayout.this.r = (int)Math.max((double)CircleGraphLayout.this.eachLayerNodes * d / Math.PI, 1.0);
                CircleGraphLayout.this.phi = Math.PI * 2 / (double)CircleGraphLayout.this.eachLayerNodes;
                int n2 = 0;
                GraphUtilities graphUtilities = new GraphUtilities();
                LinkedList linkedList = graphUtilities.getNodesListDFS(node);
                for (int i = 0; i < linkedList.size(); ++i) {
                    Node node3 = (Node)((Object)linkedList.get(i));
                    if (CircleGraphLayout.this.layerCount > 1 && ++n2 % (CircleGraphLayout.this.eachLayerNodes + 1) == 0) {
                        CircleGraphLayout.this.r = (int)((double)CircleGraphLayout.this.r + CircleGraphLayout.this.layerDistance);
                        n2 = 0;
                    }
                    node3.y = (float)((double)CircleGraphLayout.this.r * Math.cos((double)(n2 - 1) * CircleGraphLayout.this.phi));
                    node3.x = (float)((double)CircleGraphLayout.this.r * Math.sin((double)(n2 - 1) * CircleGraphLayout.this.phi));
                }
            }
        };
    }

    public ManageableType getManageableType() {
        return $TYPE;
    }

    public int getLayerCount() {
        return this.layerCount;
    }

    public void setLayerCount(int n) {
        this.layerCount = n;
    }

    public double getLayerDistance() {
        return this.layerDistance;
    }

    public void setLayerDistance(double d) {
        this.layerDistance = d;
    }

    public double getNodeDistance() {
        return this.nodeDistance;
    }

    public void setNodeDistance(double d) {
        this.nodeDistance = d;
    }

    static {
        $TYPE.validate();
    }

    public static class Type
    extends Layout.Type {
        private static final int SUPER_FIELD_COUNT = 2;
        protected static final int FIELD_COUNT = 5;

        public Type(Class clazz, SCOType sCOType) {
            super(clazz, sCOType);
        }

        public Type(CircleGraphLayout circleGraphLayout, SCOType sCOType) {
            super(circleGraphLayout, sCOType);
        }

        Type(Class clazz) {
            super(clazz, (SCOType)Layout.$TYPE);
        }

        static SCOType.Field _addManagedField(Type type, String string, int n, de.grogra.reflect.Type type2, de.grogra.reflect.Type type3, int n2) {
            return type.addManagedField(string, n, type2, type3, n2);
        }

        protected void setInt(Object object, int n, int n2) {
            switch (n) {
                case 2: {
                    ((CircleGraphLayout)((Object)object)).layerCount = n2;
                    return;
                }
            }
            super.setInt(object, n, n2);
        }

        protected int getInt(Object object, int n) {
            switch (n) {
                case 2: {
                    return ((CircleGraphLayout)((Object)object)).getLayerCount();
                }
            }
            return super.getInt(object, n);
        }

        protected void setDouble(Object object, int n, double d) {
            switch (n) {
                case 3: {
                    ((CircleGraphLayout)((Object)object)).layerDistance = d;
                    return;
                }
                case 4: {
                    ((CircleGraphLayout)((Object)object)).nodeDistance = d;
                    return;
                }
            }
            super.setDouble(object, n, d);
        }

        protected double getDouble(Object object, int n) {
            switch (n) {
                case 3: {
                    return ((CircleGraphLayout)((Object)object)).getLayerDistance();
                }
                case 4: {
                    return ((CircleGraphLayout)((Object)object)).getNodeDistance();
                }
            }
            return super.getDouble(object, n);
        }

        public Object newInstance() {
            return new CircleGraphLayout();
        }
    }
}

