/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.imp2d.layout;

import de.grogra.graph.Attribute;
import de.grogra.graph.Graph;
import de.grogra.graph.GraphState;
import de.grogra.graph.GraphUtils;
import de.grogra.graph.ObjectMap;
import de.grogra.graph.Path;
import de.grogra.graph.Visitor;
import de.grogra.imp2d.BoundedShape;
import de.grogra.imp2d.View2D;
import de.grogra.imp2d.Visitor2D;
import de.grogra.imp2d.layout.Edge;
import de.grogra.imp2d.layout.Node;
import de.grogra.imp2d.objects.Attributes;
import de.grogra.math.Pool;
import de.grogra.math.TMatrix3d;
import de.grogra.math.Transform2D;
import de.grogra.persistence.SCOType;
import de.grogra.persistence.ShareableBase;
import de.grogra.vecmath.Math2;
import de.grogra.xl.util.ObjectList;
import java.awt.Dimension;
import java.awt.geom.Rectangle2D;
import java.util.HashSet;
import javax.vecmath.Matrix3d;
import javax.vecmath.Point2d;
import javax.vecmath.Point2f;
import javax.vecmath.Tuple2d;
import javax.vecmath.Tuple2f;
import javax.vecmath.Vector2d;
import javax.vecmath.Vector3d;

public abstract class Layout
extends ShareableBase {
    boolean isRepositioningNodes = true;
    float scale = 1.0f;
    boolean fit = true;
    int transformationSteps = 1;
    int param = -1;
    String progressText = "";
    boolean redraw = true;
    public static final Type $TYPE = new Type(Layout.class);
    public static final SCOType.Field fit$FIELD = Type._addManagedField($TYPE, "fit", 0x200000, de.grogra.reflect.Type.BOOLEAN, null, 0);
    public static final SCOType.Field transformationSteps$FIELD = Type._addManagedField($TYPE, "transformationSteps", 0x200000, de.grogra.reflect.Type.INT, null, 1);

    public void setParam(int n) {
        this.param = n;
    }

    public int getParam() {
        return this.param;
    }

    protected abstract Algorithm createAlgorithm();

    public Algorithm invoke(View2D view2D, Algorithm algorithm) {
        if (algorithm == null) {
            algorithm = this.createAlgorithm();
        }
        return algorithm.run(view2D) ? algorithm : null;
    }

    public void setRedraw(boolean bl) {
        this.redraw = bl;
    }

    public void setTransformationSteps(int n) {
        this.transformationSteps = n;
    }

    static {
        $TYPE.validate();
    }

    public static class Type
    extends SCOType {
        private static final int SUPER_FIELD_COUNT = 0;
        protected static final int FIELD_COUNT = 2;

        public Type(Class clazz, SCOType sCOType) {
            super(clazz, sCOType);
        }

        public Type(Layout layout, SCOType sCOType) {
            super((Object)layout, sCOType);
        }

        Type(Class clazz) {
            super(clazz, SCOType.$TYPE);
        }

        static SCOType.Field _addManagedField(Type type, String string, int n, de.grogra.reflect.Type type2, de.grogra.reflect.Type type3, int n2) {
            return type.addManagedField(string, n, type2, type3, n2);
        }

        protected void setBoolean(Object object, int n, boolean bl) {
            switch (n) {
                case 0: {
                    ((Layout)((Object)object)).fit = bl;
                    return;
                }
            }
            super.setBoolean(object, n, bl);
        }

        protected boolean getBoolean(Object object, int n) {
            switch (n) {
                case 0: {
                    return ((Layout)((Object)object)).fit;
                }
            }
            return super.getBoolean(object, n);
        }

        protected void setInt(Object object, int n, int n2) {
            switch (n) {
                case 1: {
                    ((Layout)((Object)object)).transformationSteps = n2;
                    return;
                }
            }
            super.setInt(object, n, n2);
        }

        protected int getInt(Object object, int n) {
            switch (n) {
                case 1: {
                    return ((Layout)((Object)object)).transformationSteps;
                }
            }
            return super.getInt(object, n);
        }
    }

    public abstract class Algorithm {
        protected GraphState state;
        protected Graph graph;
        protected Graph finalGraph;
        protected View2D view;
        float epsilon = 1.0E-5f;
        final Point2f globalCenter = new Point2f();
        int globalNodeCount;
        private boolean statusSet;
        private int count;
        HashSet<Object> acceptedNodes;
        Node layoutedList;

        public Algorithm() {
            this.count = Layout.this.transformationSteps;
            this.acceptedNodes = null;
        }

        protected abstract void layout(Node var1);

        protected boolean acceptNode(Object object) {
            int n = 0;
            Object object2 = this.graph.getFirstEdge(object);
            while (object2 != null) {
                if (GraphUtils.testEdgeBits((int)this.graph.getEdgeBits(object2), (int)(object == this.graph.getSourceNode(object2) ? 128 : 1))) {
                    return false;
                }
                if (++n == 2) break;
                object2 = this.graph.getNextEdge(object2, object);
            }
            return this.graph.getAccessor(object, true, (Attribute)Attributes.SHAPE) != null && (object2 = this.graph.getAccessor(object, true, (Attribute)Attributes.TRANSFORM)) != null && object2.isWritable(object, this.state) && this.graph.getLifeCycleState(object, true) != 2;
        }

        public final void invokeLayout(Layout layout, Node node) {
            Algorithm algorithm = layout.createAlgorithm();
            algorithm.state = this.state;
            algorithm.graph = this.graph;
            algorithm.view = this.view;
            algorithm.layout(node);
        }

        protected void setProgress(float f, String string) {
            if (!this.statusSet) {
                this.view.getWorkbench().beginStatus((Object)this);
                this.statusSet = true;
            }
            this.view.getWorkbench().setStatus((Object)this, string, f);
        }

        protected Vector2d getGlobalMaxBounds(Node node) {
            double d = 0.0;
            double d2 = 0.0;
            Node node2 = node;
            while (node2 != null) {
                if (this.acceptedNodes.contains(node2.object)) {
                    Vector3d vector3d = new Vector3d((double)node2.width, (double)node2.height, 0.0);
                    if (Math.abs(vector3d.x) > d) {
                        d = Math.abs(vector3d.x);
                    }
                    if (Math.abs(vector3d.y) > d2) {
                        d2 = Math.abs(vector3d.y);
                    }
                }
                node2 = node2.next;
            }
            return new Vector2d(d, d2);
        }

        protected Vector2d getGlobalMaxDistances(Node node) {
            double d = 0.0;
            double d2 = 0.0;
            Node node2 = node;
            while (node2 != null) {
                if (this.acceptedNodes.contains(node2.object)) {
                    Node node3 = node2.next;
                    while (node3 != null) {
                        if (this.acceptedNodes.contains(node3.object)) {
                            Vector3d vector3d = new Vector3d((double)node2.x, (double)node2.y, 1.0);
                            Vector3d vector3d2 = new Vector3d((double)node3.x, (double)node3.y, 1.0);
                            if (Math.abs(vector3d.x - vector3d2.x) > d) {
                                d = Math.abs(vector3d.x - vector3d2.x);
                            }
                            if (Math.abs(vector3d.y - vector3d2.y) > d2) {
                                d2 = Math.abs(vector3d.y - vector3d2.y);
                            }
                        }
                        node3 = node3.next;
                    }
                }
                node2 = node2.next;
            }
            return new Vector2d(d, d2);
        }

        protected Vector2d getGlobalMaxCoordinates(Node node) {
            double d = 0.0;
            double d2 = 0.0;
            Node node2 = node;
            while (node2 != null) {
                if (this.acceptedNodes.contains(node2.object)) {
                    if ((double)Math.abs(node2.x) > Math.abs(d)) {
                        d = node2.x;
                    }
                    if ((double)Math.abs(node2.y) > Math.abs(d2)) {
                        d2 = node2.y;
                    }
                }
                node2 = node2.next;
            }
            return new Vector2d(d, d2);
        }

        protected Vector2d getGlobalMaxCoordinates(Node node, Node node2) {
            double d = 0.0;
            double d2 = 0.0;
            Node node3 = node;
            while (node3 != null) {
                if (this.acceptedNodes.contains(node3.object)) {
                    if ((double)Math.abs(node3.x - node2.x) > Math.abs(d)) {
                        d = Math.abs(node3.x - node2.x);
                    }
                    if ((double)Math.abs(node3.y - node2.y) > Math.abs(d2)) {
                        d2 = Math.abs(node3.y - node2.y);
                    }
                }
                node3 = node3.next;
            }
            return new Vector2d(d, d2);
        }

        protected void fitLayoutToWindow(Node node, int n) {
            GraphVisitor graphVisitor = new GraphVisitor();
            this.acceptedNodes = new HashSet();
            if (this.graph != null) {
                this.graph.accept(null, (Visitor)graphVisitor, null);
            }
            Dimension dimension = this.view.getSize();
            Matrix3d matrix3d = new Matrix3d();
            double d = 0.0;
            matrix3d.setIdentity();
            Vector2d vector2d = this.getGlobalMaxDistances(node);
            Vector2d vector2d2 = this.getGlobalMaxBounds(node);
            vector2d.x += vector2d2.x;
            vector2d.y += vector2d2.y;
            d = 0.0;
            d = vector2d.x / (double)dimension.width > vector2d.y / (double)dimension.height ? vector2d.x / (double)dimension.width : vector2d.y / (double)dimension.height;
            Matrix3d matrix3d2 = new Matrix3d(d, 0.0, 0.0, 0.0, -d, 0.0, 0.0, 0.0, 1.0);
            matrix3d.mul(matrix3d2);
            Vector2d vector2d3 = this.getGlobalMaxCoordinates(node);
            Vector2d vector2d4 = this.getGlobalMaxDistances(node);
            double d2 = 0.0;
            double d3 = 0.0;
            d2 = vector2d3.x > 0.0 ? vector2d3.x - vector2d4.x / 2.0 : vector2d3.x + vector2d4.x / 2.0;
            d3 = vector2d3.y > 0.0 ? vector2d3.y - vector2d4.y / 2.0 : vector2d3.y + vector2d4.y / 2.0;
            matrix3d.setColumn(2, d2, d3, 1.0);
            matrix3d.invert();
            this.view.setTransformation(matrix3d);
        }

        public String getCommandName() {
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final boolean run(View2D view2D) {
            if (!Layout.this.redraw) {
                return false;
            }
            this.view = view2D;
            this.state = view2D.getWorkbenchGraphState();
            this.graph = this.state.getGraph();
            final ObjectMap objectMap = this.graph.createObjectMap();
            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            class Visitor
            extends Visitor2D {
                private boolean getPositions;
                private int nodeCount = 0;
                private final Point2d tmpPoint = new Point2d();
                private final Point2f tmpPoint2f = new Point2f();
                private final Point2f min = new Point2f();
                private final Point2f max = new Point2f();
                private final Point2f center = new Point2f();
                private final Matrix3d tmpIn = new Matrix3d();
                private final Matrix3d tmpOut = new Matrix3d();
                private final Pool pool = new Pool();
                private final Rectangle2D bounds = new Rectangle2D.Double();
                private final ObjectList modifications = new ObjectList();
                private Node list = null;

                Visitor() {
                }

                void init(Node node) {
                    this.list = node;
                    Node node2 = node;
                    while (node2 != null) {
                        objectMap.putObject(node2.object, true, (Object)node2);
                        node2 = node2.next;
                    }
                }

                Node createLayoutObjects() {
                    this.getPositions = true;
                    Matrix3d matrix3d = new Matrix3d();
                    matrix3d.setIdentity();
                    this.init(Algorithm.this.state, Algorithm.this.graph.getTreePattern(), matrix3d);
                    Algorithm.this.graph.accept(null, (de.grogra.graph.Visitor)this, null);
                    if (this.nodeCount > 0) {
                        Algorithm.this.globalCenter.scale(1.0f / (float)this.nodeCount);
                    }
                    return this.list;
                }

                void write() {
                    this.getPositions = false;
                    Matrix3d matrix3d = new Matrix3d();
                    matrix3d.setIdentity();
                    this.init(Algorithm.this.state, Algorithm.this.graph.getTreePattern(), matrix3d);
                    Algorithm.this.graph.accept(null, (de.grogra.graph.Visitor)this, null);
                    while (!this.modifications.isEmpty()) {
                        Attributes.TRANSFORM.setObject(this.modifications.pop(), true, this.modifications.pop(), this.state);
                    }
                }

                @Override
                protected void visitImpl(Object object, boolean bl, Path path) {
                    if (Layout.this.fit && Layout.this.redraw) {
                        Layout.this.isRepositioningNodes = false;
                    }
                    if (bl && Algorithm.this.acceptNode(object)) {
                        Object object2 = this.state.getObjectDefault(object, true, Attributes.SHAPE, null);
                        if (object2 instanceof BoundedShape) {
                            ((BoundedShape)object2).getBounds(object, true, this.bounds, this.pool, this.state);
                            this.tmpPoint.set(this.bounds.getMinX(), this.bounds.getMinY());
                            Math2.transformPoint((Matrix3d)this.transformation, (Tuple2d)this.tmpPoint);
                            this.min.set((Tuple2d)this.tmpPoint);
                            this.max.set((Tuple2d)this.tmpPoint);
                            this.tmpPoint.set(this.bounds.getMinX(), this.bounds.getMaxY());
                            Math2.transformPoint((Matrix3d)this.transformation, (Tuple2d)this.tmpPoint);
                            this.tmpPoint2f.set((Tuple2d)this.tmpPoint);
                            Math2.min((Tuple2f)this.min, (Tuple2f)this.tmpPoint2f);
                            Math2.max((Tuple2f)this.max, (Tuple2f)this.tmpPoint2f);
                            this.tmpPoint.set(this.bounds.getMaxX(), this.bounds.getMinY());
                            Math2.transformPoint((Matrix3d)this.transformation, (Tuple2d)this.tmpPoint);
                            this.tmpPoint2f.set((Tuple2d)this.tmpPoint);
                            Math2.min((Tuple2f)this.min, (Tuple2f)this.tmpPoint2f);
                            Math2.max((Tuple2f)this.max, (Tuple2f)this.tmpPoint2f);
                            this.tmpPoint.set(this.bounds.getMaxX(), this.bounds.getMaxY());
                            Math2.transformPoint((Matrix3d)this.transformation, (Tuple2d)this.tmpPoint);
                            this.tmpPoint2f.set((Tuple2d)this.tmpPoint);
                            Math2.min((Tuple2f)this.min, (Tuple2f)this.tmpPoint2f);
                            Math2.max((Tuple2f)this.max, (Tuple2f)this.tmpPoint2f);
                            this.center.interpolate((Tuple2f)this.min, (Tuple2f)this.max, 0.5f);
                        } else {
                            this.min.set((float)this.transformation.m02, (float)this.transformation.m12);
                            this.max.set((Tuple2f)this.min);
                            this.center.set((Tuple2f)this.min);
                        }
                        if (this.getPositions) {
                            this.list = new Node(this.list, object);
                            this.list.set((Tuple2f)this.center);
                            this.list.width = this.max.x - this.min.x;
                            this.list.height = this.max.y - this.min.y;
                            objectMap.putObject(object, true, (Object)this.list);
                            Algorithm.this.globalCenter.add((Tuple2f)this.center);
                            ++this.nodeCount;
                        } else {
                            Node node = (Node)((Object)objectMap.getObject(object, true));
                            if (Layout.this.isRepositioningNodes) {
                                this.tmpPoint2f.scaleAdd(Layout.this.scale, (Tuple2f)node, (Tuple2f)Algorithm.this.globalCenter);
                            } else {
                                this.tmpPoint2f.set((Tuple2f)node);
                            }
                            if (!this.tmpPoint2f.epsilonEquals((Tuple2f)this.center, Algorithm.this.epsilon)) {
                                this.tmpPoint2f.sub((Tuple2f)this.center);
                                this.tmpPoint2f.scale(1.0f / (float)Algorithm.this.count);
                                this.tmpPoint.set((Tuple2f)this.tmpPoint2f);
                                Math2.invTransformVector((Matrix3d)this.transformation, (Tuple2d)this.tmpPoint);
                                Transform2D transform2D = (Transform2D)this.state.getObject(object, true, Attributes.TRANSFORM);
                                this.tmpIn.setIdentity();
                                this.tmpOut.setIdentity();
                                if (transform2D != null) {
                                    transform2D.transform(this.tmpIn, this.tmpOut);
                                    Math2.transformPoint((Matrix3d)this.tmpOut, (Tuple2d)this.tmpPoint);
                                    Math2.invertAffine((Matrix3d)this.tmpOut, (Matrix3d)this.tmpIn);
                                }
                                this.tmpOut.m02 = this.tmpPoint.x;
                                this.tmpOut.m12 = this.tmpPoint.y;
                                this.transformation.mul(this.tmpOut);
                                transform2D = TMatrix3d.createTransform((Matrix3d)this.tmpOut);
                                this.transformation.mul(this.tmpOut);
                                this.modifications.push((Object)transform2D).push(object);
                            }
                        }
                    }
                }

                @Override
                public Object visitInstanceEnter() {
                    return STOP;
                }

                @Override
                public boolean visitInstanceLeave(Object object) {
                    return true;
                }
            }
            Visitor visitor = new Visitor();
            try {
                if (this.layoutedList != null) {
                    visitor.init(this.layoutedList);
                    visitor.write();
                } else {
                    Layout.this.progressText = "";
                    this.setProgress(0.5f, "calculating..");
                    Node node = visitor.createLayoutObjects();
                    if (node != null) {
                        this.createEdges(node, objectMap);
                        this.layout(node);
                        if (Layout.this.fit) {
                            this.fitLayoutToWindow(node, Layout.this.param);
                        }
                        double d = this.globalCenter.x;
                        double d2 = this.globalCenter.y;
                        this.globalCenter.set(0.0f, 0.0f);
                        this.globalNodeCount = 0;
                        Node node2 = node;
                        while (node2 != null) {
                            this.globalCenter.add((Tuple2f)node2);
                            ++this.globalNodeCount;
                            node2 = node2.next;
                        }
                        if (!(this.globalNodeCount <= 1 || Float.isNaN(this.globalCenter.x) || Float.isNaN(this.globalCenter.y) || Float.isInfinite(this.globalCenter.x) || Float.isInfinite(this.globalCenter.y))) {
                            this.globalCenter.scale(-Layout.this.scale / (float)this.globalNodeCount);
                            this.globalCenter.x = (float)((double)this.globalCenter.x + d);
                            this.globalCenter.y = (float)((double)this.globalCenter.y + d2);
                            this.epsilon = (float)((double)Layout.this.scale * 1.0E-5);
                            visitor.write();
                        }
                        this.setProgress(0.0f, Layout.this.progressText);
                    }
                    this.layoutedList = node;
                }
            }
            finally {
                objectMap.dispose();
            }
            try {
                Thread.sleep(100L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return --this.count > 0;
        }

        private void createEdges(Node node, ObjectMap objectMap) {
            while (node != null) {
                node.sub((Tuple2f)this.globalCenter);
                node.scale(1.0f / Layout.this.scale);
                Object object = this.graph.getFirstEdge(node.object);
                while (object != null) {
                    Object object2 = this.graph.getTargetNode(object);
                    if (object2 != node.object) {
                        boolean bl;
                        Object object3;
                        if (GraphUtils.testEdgeBits((int)this.graph.getEdgeBits(object), (int)1)) {
                            object3 = object2;
                            bl = true;
                            Object object4 = this.graph.getFirstEdge(object3);
                            while (object4 != null) {
                                object2 = this.graph.getTargetNode(object4);
                                if (object2 == object3 || !GraphUtils.testEdgeBits((int)this.graph.getEdgeBits(object4), (int)128)) {
                                    object4 = this.graph.getNextEdge(object4, object3);
                                    continue;
                                }
                                break block8;
                            }
                        } else {
                            Edge edge;
                            Node node2;
                            block8: {
                                object3 = object;
                                bl = false;
                            }
                            float f = this.state.getFloatDefault(object3, bl, Attributes.WEIGHT, bl ? 1.0f : 0.0f);
                            if (f > 0.0f && (node2 = (Node)((Object)objectMap.getObject(object2, true))) != null && (edge = (Edge)objectMap.getObject(object3, bl)) == null) {
                                edge = node.getOrCreateEdgeTo(node2, object3, bl, f);
                                objectMap.putObject(object3, bl, (Object)edge);
                            }
                        }
                    }
                    object = this.graph.getNextEdge(object, node.object);
                }
                node = node.next;
            }
        }

        class GraphVisitor
        implements Visitor {
            GraphVisitor() {
            }

            public GraphState getGraphState() {
                return Algorithm.this.graph.getMainState();
            }

            public Object visitEnter(Path path, boolean bl) {
                if (bl) {
                    Algorithm.this.acceptedNodes.add(path.getObject(-1));
                }
                return null;
            }

            public Object visitInstanceEnter() {
                return STOP;
            }

            public boolean visitInstanceLeave(Object object) {
                return true;
            }

            public boolean visitLeave(Object object, Path path, boolean bl) {
                return true;
            }
        }
    }
}

