/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import org.gjt.sp.jedit.ActionContext;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.util.Log;

public abstract class EditAction {
    private String name;

    public EditAction(String string) {
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    public final String getLabel() {
        return jEdit.getProperty(this.name + ".label");
    }

    public final String getMouseOverText() {
        return jEdit.getProperty(this.name + ".mouse-over");
    }

    public void invoke(View view) {
    }

    public static View getView(Component component) {
        return GUIUtilities.getView(component);
    }

    public final boolean isToggle() {
        return jEdit.getBooleanProperty(this.name + ".toggle");
    }

    public boolean isSelected(Component component) {
        return false;
    }

    public boolean noRepeat() {
        return false;
    }

    public boolean noRecord() {
        return false;
    }

    public boolean noRememberLast() {
        return false;
    }

    public abstract String getCode();

    public String toString() {
        return this.name;
    }

    public static class Wrapper
    implements ActionListener {
        private ActionContext context;
        private String actionName;

        public Wrapper(ActionContext actionContext, String string) {
            this.context = actionContext;
            this.actionName = string;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            EditAction editAction = this.context.getAction(this.actionName);
            if (editAction == null) {
                Log.log(7, this, "Unknown action: " + this.actionName);
            } else {
                this.context.invokeAction(actionEvent, editAction);
            }
        }
    }
}

