/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit;

import gnu.regexp.RE;
import java.awt.Component;
import java.io.File;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JOptionPane;
import org.gjt.sp.jedit.ActionSet;
import org.gjt.sp.jedit.BeanShell;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.EBComponent;
import org.gjt.sp.jedit.EBMessage;
import org.gjt.sp.jedit.EditAction;
import org.gjt.sp.jedit.EditBus;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.msg.BufferUpdate;
import org.gjt.sp.jedit.msg.DynamicMenuChanged;
import org.gjt.sp.util.Log;

public class Macros {
    private static String systemMacroPath;
    private static String userMacroPath;
    private static ArrayList macroHandlers;
    private static ActionSet macroActionSet;
    private static Vector macroHierarchy;
    private static Hashtable macroHash;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void showRunScriptDialog(View view) {
        String[] stringArray = GUIUtilities.showVFSFileDialog(view, null, 0, true);
        if (stringArray != null) {
            Buffer buffer = view.getBuffer();
            try {
                buffer.beginCompoundEdit();
                for (int i = 0; i < stringArray.length; ++i) {
                    Macros.runScript(view, stringArray[i], false);
                }
            }
            finally {
                buffer.endCompoundEdit();
            }
        }
    }

    public static void runScript(View view, String string, boolean bl) {
        Handler handler = Macros.getHandlerForPathName(string);
        if (handler != null) {
            try {
                Macro macro = handler.createMacro(MiscUtilities.getFileName(string), string);
                macro.invoke(view);
            }
            catch (Exception exception) {
                Log.log(9, Macros.class, exception);
                return;
            }
            return;
        }
        if (bl) {
            Log.log(5, Macros.class, string + ": Cannot find a suitable macro handler");
        } else {
            Log.log(9, Macros.class, string + ": Cannot find a suitable macro handler, " + "assuming BeanShell");
            Macros.getHandler("beanshell").createMacro(string, string).invoke(view);
        }
    }

    public static void message(Component component, String string) {
        GUIUtilities.hideSplashScreen();
        JOptionPane.showMessageDialog(component, string, jEdit.getProperty("macro-message.title"), 1);
    }

    public static void error(Component component, String string) {
        GUIUtilities.hideSplashScreen();
        JOptionPane.showMessageDialog(component, string, jEdit.getProperty("macro-message.title"), 0);
    }

    public static String input(Component component, String string) {
        GUIUtilities.hideSplashScreen();
        return Macros.input(component, string, null);
    }

    public static String input(Component component, String string, String string2) {
        GUIUtilities.hideSplashScreen();
        return (String)JOptionPane.showInputDialog(component, string, jEdit.getProperty("macro-input.title"), 3, null, null, string2);
    }

    public static int confirm(Component component, String string, int n) {
        GUIUtilities.hideSplashScreen();
        return JOptionPane.showConfirmDialog(component, string, jEdit.getProperty("macro-confirm.title"), n, 3);
    }

    public static int confirm(Component component, String string, int n, int n2) {
        GUIUtilities.hideSplashScreen();
        return JOptionPane.showConfirmDialog(component, string, jEdit.getProperty("macro-confirm.title"), n, n2);
    }

    public static void loadMacros() {
        macroActionSet.removeAllActions();
        macroHierarchy.removeAllElements();
        macroHash.clear();
        String string = jEdit.getSettingsDirectory();
        if (string != null) {
            userMacroPath = MiscUtilities.constructPath(string, "macros");
            Macros.loadMacros(macroHierarchy, "", new File(userMacroPath));
        }
        if (jEdit.getJEditHome() != null) {
            systemMacroPath = MiscUtilities.constructPath(jEdit.getJEditHome(), "macros");
            Macros.loadMacros(macroHierarchy, "", new File(systemMacroPath));
        }
        EditBus.send(new DynamicMenuChanged("macros"));
    }

    public static void registerHandler(Handler handler) {
        if (Macros.getHandler(handler.getName()) != null) {
            Log.log(9, Macros.class, "Cannot register more than one macro handler with the same name");
            return;
        }
        Log.log(1, Macros.class, "Registered " + handler.getName() + " macro handler");
        macroHandlers.add(handler);
    }

    public static Handler[] getHandlers() {
        Handler[] handlerArray = new Handler[macroHandlers.size()];
        return macroHandlers.toArray(handlerArray);
    }

    public static Handler getHandlerForPathName(String string) {
        for (int i = 0; i < macroHandlers.size(); ++i) {
            Handler handler = (Handler)macroHandlers.get(i);
            if (!handler.accept(string)) continue;
            return handler;
        }
        return null;
    }

    public static Handler getHandler(String string) {
        Handler handler = null;
        for (int i = 0; i < macroHandlers.size(); ++i) {
            handler = (Handler)macroHandlers.get(i);
            if (!handler.getName().equals(string)) continue;
            return handler;
        }
        return null;
    }

    public static Vector getMacroHierarchy() {
        return macroHierarchy;
    }

    public static ActionSet getMacroActionSet() {
        return macroActionSet;
    }

    public static Macro getMacro(String string) {
        return (Macro)macroHash.get(string);
    }

    public static void recordTemporaryMacro(View view) {
        String string = jEdit.getSettingsDirectory();
        if (string == null) {
            GUIUtilities.error((Component)((Object)view), "no-settings", new String[0]);
            return;
        }
        if (view.getMacroRecorder() != null) {
            GUIUtilities.error((Component)((Object)view), "already-recording", new String[0]);
            return;
        }
        Buffer buffer = jEdit.openFile(null, string + File.separator + "macros", "Temporary_Macro.bsh", true, null);
        if (buffer == null) {
            return;
        }
        buffer.remove(0, buffer.getLength());
        buffer.insert(0, jEdit.getProperty("macro.temp.header"));
        Macros.recordMacro(view, buffer, true);
    }

    public static void recordMacro(View view) {
        String string = jEdit.getSettingsDirectory();
        if (string == null) {
            GUIUtilities.error((Component)((Object)view), "no-settings", new String[0]);
            return;
        }
        if (view.getMacroRecorder() != null) {
            GUIUtilities.error((Component)((Object)view), "already-recording", new String[0]);
            return;
        }
        String string2 = GUIUtilities.input((Component)((Object)view), "record", null);
        if (string2 == null) {
            return;
        }
        Buffer buffer = jEdit.openFile(null, null, MiscUtilities.constructPath(string, "macros", (string2 = string2.replace(' ', '_')) + ".bsh"), true, null);
        if (buffer == null) {
            return;
        }
        buffer.remove(0, buffer.getLength());
        buffer.insert(0, jEdit.getProperty("macro.header"));
        Macros.recordMacro(view, buffer, false);
    }

    public static void stopRecording(View view) {
        Recorder recorder = view.getMacroRecorder();
        if (recorder == null) {
            GUIUtilities.error((Component)((Object)view), "macro-not-recording", null);
        } else {
            view.setMacroRecorder(null);
            if (!recorder.temporary) {
                view.setBuffer(recorder.buffer);
            }
            recorder.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void runTemporaryMacro(View view) {
        String string = jEdit.getSettingsDirectory();
        if (string == null) {
            GUIUtilities.error((Component)((Object)view), "no-settings", null);
            return;
        }
        String string2 = MiscUtilities.constructPath(jEdit.getSettingsDirectory(), "macros", "Temporary_Macro.bsh");
        if (jEdit.getBuffer(string2) == null) {
            GUIUtilities.error((Component)((Object)view), "no-temp-macro", null);
            return;
        }
        Handler handler = Macros.getHandler("beanshell");
        Macro macro = handler.createMacro(string2, string2);
        Buffer buffer = view.getBuffer();
        try {
            buffer.beginCompoundEdit();
            macro.invoke(view);
        }
        finally {
            if (buffer.insideCompoundEdit()) {
                buffer.endCompoundEdit();
            }
        }
    }

    private static void loadMacros(Vector vector, String string, File file) {
        File[] fileArray = file.listFiles();
        if (fileArray == null || fileArray.length == 0) {
            return;
        }
        for (int i = 0; i < fileArray.length; ++i) {
            File file2 = fileArray[i];
            String string2 = file2.getName();
            if (file2.isHidden()) continue;
            if (file2.isDirectory()) {
                String string3 = string2.replace('_', ' ');
                Vector vector2 = null;
                for (int j = 0; j < vector.size(); ++j) {
                    Vector vector3;
                    Object e = vector.get(j);
                    if (!(e instanceof Vector) || !((String)(vector3 = (Vector)e).get(0)).equals(string3)) continue;
                    vector2 = vector3;
                    break;
                }
                if (vector2 == null) {
                    vector2 = new Vector();
                    vector2.addElement(string3);
                    vector.addElement(vector2);
                }
                Macros.loadMacros(vector2, string + string2 + '/', file2);
                continue;
            }
            Macros.addMacro(file2, string, vector);
        }
    }

    private static void addMacro(File file, String string, Vector vector) {
        String string2 = file.getName();
        Handler handler = Macros.getHandlerForPathName(file.getPath());
        if (handler == null) {
            return;
        }
        try {
            String string3 = (string + string2).replace(' ', '_');
            Macro macro = handler.createMacro(string3, file.getPath());
            if (macroHash.get(macro.getName()) != null) {
                return;
            }
            vector.addElement(macro.getName());
            jEdit.setTemporaryProperty(macro.getName() + ".label", macro.label);
            jEdit.setTemporaryProperty(macro.getName() + ".mouse-over", handler.getLabel() + " - " + file.getPath());
            macroActionSet.addAction(macro);
            macroHash.put(macro.getName(), macro);
        }
        catch (Exception exception) {
            Log.log(9, Macros.class, exception);
            macroHandlers.remove(handler);
        }
    }

    private static void recordMacro(View view, Buffer buffer, boolean bl) {
        view.setMacroRecorder(new Recorder(view, buffer, bl));
        view.getStatus().setMessage(null);
    }

    static {
        macroHandlers = new ArrayList();
        Macros.registerHandler(new BeanShellHandler());
        macroActionSet = new ActionSet(jEdit.getProperty("action-set.macros"));
        jEdit.addActionSet(macroActionSet);
        macroHierarchy = new Vector();
        macroHash = new Hashtable();
    }

    static class BeanShellHandler
    extends Handler {
        BeanShellHandler() {
            super("beanshell");
        }

        public Macro createMacro(String string, String string2) {
            string = string.substring(0, string.length() - 4);
            return new Macro(this, string, Macro.macroNameToLabel(string), string2);
        }

        public void runMacro(View view, Macro macro) {
            BeanShell.runScript(view, macro.getPath(), null, true);
        }

        public void runMacro(View view, Macro macro, boolean bl) {
            BeanShell.runScript(view, macro.getPath(), null, bl);
        }
    }

    public static abstract class Handler {
        private String name;
        private String label;
        private RE filter;

        public String getName() {
            return this.name;
        }

        public String getLabel() {
            return this.label;
        }

        public boolean accept(String string) {
            return this.filter.isMatch(MiscUtilities.getFileName(string));
        }

        public abstract Macro createMacro(String var1, String var2);

        public abstract void runMacro(View var1, Macro var2);

        public void runMacro(View view, Macro macro, boolean bl) {
            this.runMacro(view, macro);
        }

        protected Handler(String string) {
            this.name = string;
            this.label = jEdit.getProperty("macro-handler." + string + ".label", string);
            try {
                this.filter = new RE(MiscUtilities.globToRE(jEdit.getProperty("macro-handler." + string + ".glob")));
            }
            catch (Exception exception) {
                throw new InternalError("Missing or invalid glob for handler " + string);
            }
        }
    }

    public static class Recorder
    implements EBComponent {
        View view;
        Buffer buffer;
        boolean temporary;
        boolean lastWasInput;
        boolean lastWasOverwrite;
        int overwriteCount;

        public Recorder(View view, Buffer buffer, boolean bl) {
            this.view = view;
            this.buffer = buffer;
            this.temporary = bl;
            EditBus.addToBus(this);
        }

        public void record(String string) {
            this.flushInput();
            this.append("\n");
            this.append(string);
        }

        public void record(int n, String string) {
            if (n == 1) {
                this.record(string);
            } else {
                this.record("for(int i = 1; i <= " + n + "; i++)\n" + "{\n" + string + "\n" + "}");
            }
        }

        public void recordInput(int n, char c, boolean bl) {
            if (c == '\n') {
                this.record(n, "textArea.userInput('\\n');");
            } else if (c == '\t') {
                this.record(n, "textArea.userInput('\\t');");
            } else {
                StringBuffer stringBuffer = new StringBuffer();
                for (int i = 0; i < n; ++i) {
                    stringBuffer.append(c);
                }
                this.recordInput(stringBuffer.toString(), bl);
            }
        }

        public void recordInput(String string, boolean bl) {
            String string2 = MiscUtilities.charsToEscapes(string);
            if (bl) {
                if (this.lastWasOverwrite) {
                    ++this.overwriteCount;
                    this.append(string2);
                } else {
                    this.flushInput();
                    this.overwriteCount = 1;
                    this.lastWasOverwrite = true;
                    this.append("\ntextArea.setSelectedText(\"" + string2);
                }
            } else if (this.lastWasInput) {
                this.append(string2);
            } else {
                this.flushInput();
                this.lastWasInput = true;
                this.append("\ntextArea.setSelectedText(\"" + string2);
            }
        }

        public void handleMessage(EBMessage eBMessage) {
            BufferUpdate bufferUpdate;
            if (eBMessage instanceof BufferUpdate && (bufferUpdate = (BufferUpdate)eBMessage).getWhat() == BufferUpdate.CLOSED && bufferUpdate.getBuffer() == this.buffer) {
                Macros.stopRecording(this.view);
            }
        }

        private void append(String string) {
            this.buffer.insert(this.buffer.getLength(), string);
        }

        private void dispose() {
            this.flushInput();
            for (int i = 0; i < this.buffer.getLineCount(); ++i) {
                this.buffer.indentLine(i, true);
            }
            EditBus.removeFromBus(this);
            this.view.getStatus().setMessage(null);
        }

        private void flushInput() {
            if (this.lastWasInput) {
                this.lastWasInput = false;
                this.append("\");");
            }
            if (this.lastWasOverwrite) {
                this.lastWasOverwrite = false;
                this.append("\");\n");
                this.append("offset = buffer.getLineEndOffset(textArea.getCaretLine()) - 1;\n");
                this.append("buffer.remove(textArea.getCaretPosition(),Math.min(" + this.overwriteCount + ",offset - " + "textArea.getCaretPosition()));");
            }
        }
    }

    public static class Macro
    extends EditAction {
        private Handler handler;
        private String path;
        String label;

        public Macro(Handler handler, String string, String string2, String string3) {
            super(string);
            this.handler = handler;
            this.label = string2;
            this.path = string3;
        }

        public Handler getHandler() {
            return this.handler;
        }

        public String getPath() {
            return this.path;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void invoke(View view) {
            if (view == null) {
                this.handler.runMacro(null, this);
            } else {
                Buffer buffer = view.getBuffer();
                try {
                    buffer.beginCompoundEdit();
                    this.handler.runMacro(view, this);
                }
                finally {
                    buffer.endCompoundEdit();
                }
            }
        }

        public String getCode() {
            return "Macros.getMacro(\"" + this.getName() + "\").invoke(view);";
        }

        public static String macroNameToLabel(String string) {
            int n = string.lastIndexOf(47);
            return string.substring(n + 1).replace('_', ' ');
        }
    }
}

