/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JMenuItem;
import javax.swing.text.Segment;
import org.gjt.sp.jedit.OperatingSystem;
import org.gjt.sp.jedit.PluginJAR;
import org.gjt.sp.jedit.io.UrlVFS;
import org.gjt.sp.jedit.io.VFS;
import org.gjt.sp.jedit.io.VFSManager;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.util.Log;

public class MiscUtilities {
    public static final String UTF_8_Y = "UTF-8Y";
    public static final DecimalFormat KB_FORMAT = new DecimalFormat("#.# KB");
    public static final DecimalFormat MB_FORMAT = new DecimalFormat("#.# MB");

    public static String canonPath(String string) {
        if (string.length() == 0) {
            return string;
        }
        if (string.startsWith("file://")) {
            string = string.substring("file://".length());
        } else if (string.startsWith("file:")) {
            string = string.substring("file:".length());
        } else if (MiscUtilities.isURL(string)) {
            return string;
        }
        if (File.separatorChar == '\\') {
            string = string.replace('/', '\\');
            int n = string.length();
            while (string.charAt(n - 1) == ' ') {
                --n;
            }
            string = string.substring(0, n);
        } else if (OperatingSystem.isMacOS()) {
            string = string.replace(':', '/');
        }
        if (string.startsWith("~" + File.separator)) {
            string = string.substring(2);
            String string2 = System.getProperty("user.home");
            if (string2.endsWith(File.separator)) {
                return string2 + string;
            }
            return string2 + File.separator + string;
        }
        if (string.equals("~")) {
            return System.getProperty("user.home");
        }
        return string;
    }

    public static String resolveSymlinks(String string) {
        if (MiscUtilities.isURL(string)) {
            return string;
        }
        if (OperatingSystem.isOS2()) {
            return string;
        }
        if (OperatingSystem.isDOSDerived() && (string.length() == 2 || string.length() == 3) && string.charAt(1) == ':') {
            return string;
        }
        try {
            return new File(string).getCanonicalPath();
        }
        catch (IOException iOException) {
            return string;
        }
    }

    public static boolean isAbsolutePath(String string) {
        if (MiscUtilities.isURL(string)) {
            return true;
        }
        if (string.startsWith("~/") || string.startsWith("~" + File.separator) || string.equals("~")) {
            return true;
        }
        if (OperatingSystem.isDOSDerived()) {
            if (string.length() == 2 && string.charAt(1) == ':') {
                return true;
            }
            if (string.length() > 2 && string.charAt(1) == ':' && (string.charAt(2) == '\\' || string.charAt(2) == '/')) {
                return true;
            }
            if (string.startsWith("\\\\") || string.startsWith("//")) {
                return true;
            }
        } else if ((OperatingSystem.isUnix() || OperatingSystem.isVMS()) && string.length() > 0 && string.charAt(0) == '/') {
            return true;
        }
        return false;
    }

    public static String constructPath(String string, String string2) {
        if (MiscUtilities.isAbsolutePath(string2)) {
            return MiscUtilities.canonPath(string2);
        }
        if (OperatingSystem.isDOSDerived()) {
            if (string2.length() == 2 && string2.charAt(1) == ':') {
                return string2;
            }
            if (string2.length() > 2 && string2.charAt(1) == ':' && string2.charAt(2) != '\\') {
                string2 = string2.substring(0, 2) + '\\' + string2.substring(2);
                return MiscUtilities.canonPath(string2);
            }
        }
        String string3 = ".." + File.separator;
        String string4 = "." + File.separator;
        if (string == null) {
            string = System.getProperty("user.dir");
        }
        while (true) {
            if (string2.equals(".")) {
                return string;
            }
            if (string2.equals("..")) {
                return MiscUtilities.getParentOfPath(string);
            }
            if (string2.startsWith(string3) || string2.startsWith("../")) {
                string = MiscUtilities.getParentOfPath(string);
                string2 = string2.substring(3);
                continue;
            }
            if (!string2.startsWith(string4) && !string2.startsWith("./")) break;
            string2 = string2.substring(2);
        }
        if (OperatingSystem.isDOSDerived() && !MiscUtilities.isURL(string) && string2.startsWith("\\")) {
            string = string.substring(0, 2);
        }
        VFS vFS = VFSManager.getVFSForPath(string);
        return MiscUtilities.canonPath(vFS.constructPath(string, string2));
    }

    public static String constructPath(String string, String string2, String string3) {
        return MiscUtilities.constructPath(MiscUtilities.constructPath(string, string2), string3);
    }

    public static String concatPath(String string, String string2) {
        string = MiscUtilities.canonPath(string);
        if ((string2 = MiscUtilities.canonPath(string2)).startsWith(File.separator)) {
            string2 = string2.substring(1);
        } else if (string2.length() >= 3 && string2.charAt(1) == ':') {
            string2 = string2.replace(':', File.separatorChar);
        }
        if (string == null) {
            string = System.getProperty("user.dir");
        }
        if (string.endsWith(File.separator)) {
            return string + string2;
        }
        return string + File.separator + string2;
    }

    public static String getFileExtension(String string) {
        int n = Math.max(string.indexOf(47), string.indexOf(File.separatorChar));
        int n2 = string.indexOf(46, n);
        if (n2 == -1) {
            return "";
        }
        return string.substring(n2);
    }

    public static String getFileName(String string) {
        return VFSManager.getVFSForPath(string).getFileName(string);
    }

    public static String getFileNameNoExtension(String string) {
        String string2 = MiscUtilities.getFileName(string);
        int n = string2.indexOf(46);
        if (n == -1) {
            return string2;
        }
        return string2.substring(0, n);
    }

    public static String getFileParent(String string) {
        return MiscUtilities.getParentOfPath(string);
    }

    public static String getParentOfPath(String string) {
        return VFSManager.getVFSForPath(string).getParentOfPath(string);
    }

    public static String getFileProtocol(String string) {
        return MiscUtilities.getProtocolOfURL(string);
    }

    public static String getProtocolOfURL(String string) {
        return string.substring(0, string.indexOf(58));
    }

    public static boolean isURL(String string) {
        int n = Math.max(string.indexOf(File.separatorChar), string.indexOf(47));
        if (n == 0) {
            return false;
        }
        if (n == 2) {
            return false;
        }
        int n2 = string.indexOf(58);
        if (n2 <= 1) {
            return false;
        }
        String string2 = string.substring(0, n2);
        VFS vFS = VFSManager.getVFSForProtocol(string2);
        if (vFS != null && !(vFS instanceof UrlVFS)) {
            return true;
        }
        try {
            new URL(string);
            return true;
        }
        catch (MalformedURLException malformedURLException) {
            return false;
        }
    }

    public static void saveBackup(File file, int n, String string, String string2, String string3) {
        MiscUtilities.saveBackup(file, n, string, string2, string3, 0);
    }

    public static void saveBackup(File file, int n, String string, String string2, String string3, int n2) {
        if (string == null) {
            string = "";
        }
        if (string2 == null) {
            string2 = "";
        }
        String string4 = file.getName();
        if (n == 1) {
            File file2 = new File(string3, string + string4 + string2);
            long l = file2.lastModified();
            if (System.currentTimeMillis() - l >= (long)n2) {
                file2.delete();
                file.renameTo(file2);
            }
        } else {
            new File(string3, string + string4 + string2 + n + string2).delete();
            File file3 = new File(string3, string + string4 + string2 + "1" + string2);
            long l = file3.lastModified();
            if (System.currentTimeMillis() - l >= (long)n2) {
                for (int i = n - 1; i > 0; --i) {
                    File file4 = new File(string3, string + string4 + string2 + i + string2);
                    file4.renameTo(new File(string3, string + string4 + string2 + (i + 1) + string2));
                }
                file.renameTo(new File(string3, string + string4 + string2 + "1" + string2));
            }
        }
    }

    public static String fileToClass(String string) {
        char[] cArray = string.toCharArray();
        for (int i = cArray.length - 6; i >= 0; --i) {
            if (cArray[i] != '/') continue;
            cArray[i] = 46;
        }
        return new String(cArray, 0, cArray.length - 6);
    }

    public static String classToFile(String string) {
        return string.replace('.', '/').concat(".class");
    }

    public static int getLeadingWhiteSpace(String string) {
        int n;
        block3: for (n = 0; n < string.length(); ++n) {
            switch (string.charAt(n)) {
                case '\t': 
                case ' ': {
                    continue block3;
                }
            }
            break;
        }
        return n;
    }

    public static int getTrailingWhiteSpace(String string) {
        int n = 0;
        block3: for (int i = string.length() - 1; i >= 0; --i) {
            switch (string.charAt(i)) {
                case '\t': 
                case ' ': {
                    ++n;
                    continue block3;
                }
            }
        }
        return n;
    }

    public static int getLeadingWhiteSpaceWidth(String string, int n) {
        int n2 = 0;
        block4: for (int i = 0; i < string.length(); ++i) {
            switch (string.charAt(i)) {
                case ' ': {
                    ++n2;
                    continue block4;
                }
                case '\t': {
                    n2 += n - n2 % n;
                    continue block4;
                }
            }
        }
        return n2;
    }

    public static int getVirtualWidth(Segment segment, int n) {
        int n2 = 0;
        for (int i = 0; i < segment.count; ++i) {
            char c = segment.array[segment.offset + i];
            if (c == '\t') {
                n2 += n - n2 % n;
                continue;
            }
            ++n2;
        }
        return n2;
    }

    public static int getOffsetOfVirtualColumn(Segment segment, int n, int n2, int[] nArray) {
        int n3 = 0;
        for (int i = 0; i < segment.count; ++i) {
            char c = segment.array[segment.offset + i];
            if (c == '\t') {
                int n4 = n - n3 % n;
                if (n3 >= n2) {
                    return i;
                }
                n3 += n4;
                continue;
            }
            if (n3 >= n2) {
                return i;
            }
            ++n3;
        }
        if (nArray != null) {
            nArray[0] = n3;
        }
        return -1;
    }

    public static String createWhiteSpace(int n, int n2) {
        return MiscUtilities.createWhiteSpace(n, n2, 0);
    }

    public static String createWhiteSpace(int n, int n2, int n3) {
        StringBuffer stringBuffer = new StringBuffer();
        if (n2 == 0) {
            while (n-- > 0) {
                stringBuffer.append(' ');
            }
        } else if (n == 1) {
            stringBuffer.append(' ');
        } else {
            int n4 = (n + n3 % n2) / n2;
            if (n4 != 0) {
                n += n3;
            }
            while (n4-- > 0) {
                stringBuffer.append('\t');
            }
            n4 = n % n2;
            while (n4-- > 0) {
                stringBuffer.append(' ');
            }
        }
        return stringBuffer.toString();
    }

    public static String globToRE(String string) {
        Object object = new Object();
        Object object2 = new Object();
        Stack<Object> stack = new Stack<Object>();
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        block10: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (bl) {
                stringBuffer.append('\\');
                stringBuffer.append(c);
                bl = false;
                continue;
            }
            switch (c) {
                case '\\': {
                    bl = true;
                    continue block10;
                }
                case '?': {
                    stringBuffer.append('.');
                    continue block10;
                }
                case '(': 
                case ')': 
                case '+': 
                case '.': {
                    stringBuffer.append('\\');
                    stringBuffer.append(c);
                    continue block10;
                }
                case '*': {
                    stringBuffer.append(".*");
                    continue block10;
                }
                case '|': {
                    if (bl) {
                        stringBuffer.append("\\|");
                        continue block10;
                    }
                    stringBuffer.append('|');
                    continue block10;
                }
                case '{': {
                    stringBuffer.append('(');
                    if (i + 1 != string.length() && string.charAt(i + 1) == '!') {
                        stringBuffer.append('?');
                        stack.push(object);
                        continue block10;
                    }
                    stack.push(object2);
                    continue block10;
                }
                case ',': {
                    if (!stack.isEmpty() && stack.peek() == object2) {
                        stringBuffer.append('|');
                        continue block10;
                    }
                    stringBuffer.append(',');
                    continue block10;
                }
                case '}': {
                    if (!stack.isEmpty()) {
                        stringBuffer.append(")");
                        if (stack.pop() != object) continue block10;
                        stringBuffer.append(".*");
                        continue block10;
                    }
                    stringBuffer.append('}');
                    continue block10;
                }
                default: {
                    stringBuffer.append(c);
                }
            }
        }
        return stringBuffer.toString();
    }

    public static String escapesToChars(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        block7: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '\\': {
                    if (i == string.length() - 1) {
                        stringBuffer.append('\\');
                        continue block7;
                    }
                    c = string.charAt(++i);
                    switch (c) {
                        case 'n': {
                            stringBuffer.append('\n');
                            continue block7;
                        }
                        case 't': {
                            stringBuffer.append('\t');
                            continue block7;
                        }
                    }
                    stringBuffer.append(c);
                    continue block7;
                }
                default: {
                    stringBuffer.append(c);
                }
            }
        }
        return stringBuffer.toString();
    }

    public static String charsToEscapes(String string) {
        return MiscUtilities.charsToEscapes(string, "\n\t\\\"'");
    }

    public static String charsToEscapes(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (string2.indexOf(c) != -1) {
                if (c == '\n') {
                    stringBuffer.append("\\n");
                    continue;
                }
                if (c == '\t') {
                    stringBuffer.append("\\t");
                    continue;
                }
                stringBuffer.append('\\');
                stringBuffer.append(c);
                continue;
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    public static int compareVersions(String string, String string2) {
        return MiscUtilities.compareStrings(string, string2, false);
    }

    public static int compareStrings(String string, String string2, boolean bl) {
        char[] cArray = string.toCharArray();
        char[] cArray2 = string2.toCharArray();
        int n = Math.min(cArray.length, cArray2.length);
        int n2 = 0;
        for (int i = 0; n2 < n && i < n; ++n2, ++i) {
            char c = cArray[n2];
            char c2 = cArray2[i];
            if (Character.isDigit(c) && Character.isDigit(c2) && c != '0' && c2 != '0') {
                int n3;
                int n4 = i + 1;
                for (n3 = n2 + 1; n3 < cArray.length && Character.isDigit(cArray[n3]); ++n3) {
                }
                while (n4 < cArray2.length && Character.isDigit(cArray2[n4])) {
                    ++n4;
                }
                int n5 = n3 - n2;
                int n6 = n4 - i;
                if (n5 > n6) {
                    return 1;
                }
                if (n5 < n6) {
                    return -1;
                }
                for (int j = 0; j < n5; ++j) {
                    c = cArray[n2 + j];
                    c2 = cArray2[i + j];
                    if (c == c2) continue;
                    return c - c2;
                }
                n2 = n3 - 1;
                i = n4 - 1;
                continue;
            }
            if (bl) {
                c = Character.toLowerCase(c);
                c2 = Character.toLowerCase(c2);
            }
            if (c == c2) continue;
            return c - c2;
        }
        return cArray.length - cArray2.length;
    }

    public static boolean stringsEqual(String string, String string2) {
        return MiscUtilities.objectsEqual(string, string2);
    }

    public static boolean objectsEqual(Object object, Object object2) {
        if (object == null) {
            return object2 == null;
        }
        if (object2 == null) {
            return false;
        }
        return object.equals(object2);
    }

    public static String charsToEntities(String string) {
        StringBuffer stringBuffer = new StringBuffer(string.length());
        block5: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '<': {
                    stringBuffer.append("&lt;");
                    continue block5;
                }
                case '>': {
                    stringBuffer.append("&gt;");
                    continue block5;
                }
                case '&': {
                    stringBuffer.append("&amp;");
                    continue block5;
                }
                default: {
                    stringBuffer.append(c);
                }
            }
        }
        return stringBuffer.toString();
    }

    public static String formatFileSize(long l) {
        if (l < 1024L) {
            return l + " bytes";
        }
        if (l < 0x100000L) {
            return KB_FORMAT.format((double)l / 1024.0);
        }
        return MB_FORMAT.format((double)l / 1024.0 / 1024.0);
    }

    public static String getLongestPrefix(List list, boolean bl) {
        String string;
        int n;
        if (list.size() == 0) {
            return "";
        }
        block0: for (n = 0; n < (string = list.get(0).toString()).length(); ++n) {
            char c = string.charAt(n);
            for (int i = 1; i < list.size(); ++i) {
                string = list.get(i).toString();
                if (n >= string.length() || !MiscUtilities.compareChars(string.charAt(n), c, bl)) break block0;
            }
        }
        return list.get(0).toString().substring(0, n);
    }

    public static String getLongestPrefix(String[] stringArray, boolean bl) {
        return MiscUtilities.getLongestPrefix((Object[])stringArray, bl);
    }

    public static String getLongestPrefix(Object[] objectArray, boolean bl) {
        int n;
        if (objectArray.length == 0) {
            return "";
        }
        String string = objectArray[0].toString();
        block0: for (n = 0; n < string.length(); ++n) {
            char c = string.charAt(n);
            for (int i = 1; i < objectArray.length; ++i) {
                String string2 = objectArray[i].toString();
                if (n >= string2.length() || !MiscUtilities.compareChars(string2.charAt(n), c, bl)) break block0;
            }
        }
        return string.substring(0, n);
    }

    public static void quicksort(Object[] objectArray, Comparator comparator) {
        Arrays.sort(objectArray, comparator);
    }

    public static void quicksort(Vector vector, Comparator comparator) {
        Collections.sort(vector, comparator);
    }

    public static void quicksort(List list, Comparator comparator) {
        Collections.sort(list, comparator);
    }

    public static void quicksort(Object[] objectArray, Compare compare) {
        Arrays.sort(objectArray, compare);
    }

    public static void quicksort(Vector vector, Compare compare) {
        Collections.sort(vector, compare);
    }

    public static String buildToVersion(String string) {
        if (string.length() != 11) {
            return "<unknown version: " + string + ">";
        }
        int n = Integer.parseInt(string.substring(0, 2));
        int n2 = Integer.parseInt(string.substring(3, 5));
        int n3 = Integer.parseInt(string.substring(6, 8));
        int n4 = Integer.parseInt(string.substring(9, 11));
        return n + "." + n2 + (n3 != 99 ? "pre" + n3 : (n4 != 0 ? "." + n4 : "final"));
    }

    public static boolean isToolsJarAvailable() {
        Log.log(1, MiscUtilities.class, "Searching for tools.jar...");
        Vector<String> vector = new Vector<String>();
        vector.addElement("System classpath: " + System.getProperty("java.class.path"));
        try {
            try {
                Class.forName("sun.tools.javac.Main");
            }
            catch (ClassNotFoundException classNotFoundException) {
                Class.forName("com.sun.tools.javac.Main");
            }
            Log.log(1, MiscUtilities.class, "- is in classpath. Fine.");
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            String string;
            String string2;
            String string3 = jEdit.getSettingsDirectory();
            if (string3 != null) {
                string2 = MiscUtilities.constructPath(string3, "jars", "tools.jar");
                vector.addElement(string2);
                if (new File(string2).exists()) {
                    Log.log(1, MiscUtilities.class, "- is in the user's jars folder. Fine.");
                    return true;
                }
            }
            if ((string2 = jEdit.getJEditHome()) != null) {
                string = MiscUtilities.constructPath(string2, "jars", "tools.jar");
                vector.addElement(string);
                if (new File(string).exists()) {
                    Log.log(1, MiscUtilities.class, "- is in jEdit's system jars folder. Fine.");
                    return true;
                }
            }
            if ((string = System.getProperty("java.home")).toLowerCase().endsWith(File.separator + "jre")) {
                string = string.substring(0, string.length() - 4);
            }
            string = MiscUtilities.constructPath(string, "lib", "tools.jar");
            vector.addElement(string);
            if (!new File(string).exists()) {
                Log.log(7, MiscUtilities.class, "Could not find tools.jar.\nI checked the following locations:\n" + vector.toString());
                return false;
            }
            PluginJAR pluginJAR = jEdit.getPluginJAR(string);
            if (pluginJAR == null) {
                Log.log(1, MiscUtilities.class, "- adding " + string + " to jEdit plugins.");
                jEdit.addPluginJAR(string);
            } else {
                Log.log(1, MiscUtilities.class, "- has been loaded before.");
            }
            return true;
        }
    }

    public static int parsePermissions(String string) {
        int n = 0;
        if (string.length() == 9) {
            if (string.charAt(0) == 'r') {
                n += 256;
            }
            if (string.charAt(1) == 'w') {
                n += 128;
            }
            if (string.charAt(2) == 'x') {
                n += 64;
            } else if (string.charAt(2) == 's') {
                n += 2112;
            } else if (string.charAt(2) == 'S') {
                n += 2048;
            }
            if (string.charAt(3) == 'r') {
                n += 32;
            }
            if (string.charAt(4) == 'w') {
                n += 16;
            }
            if (string.charAt(5) == 'x') {
                n += 8;
            } else if (string.charAt(5) == 's') {
                n += 1032;
            } else if (string.charAt(5) == 'S') {
                n += 1024;
            }
            if (string.charAt(6) == 'r') {
                n += 4;
            }
            if (string.charAt(7) == 'w') {
                n += 2;
            }
            if (string.charAt(8) == 'x') {
                ++n;
            } else if (string.charAt(8) == 't') {
                n += 513;
            } else if (string.charAt(8) == 'T') {
                n += 512;
            }
        }
        return n;
    }

    public static String[] getEncodings() {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (OperatingSystem.hasJava14()) {
            try {
                Class<?> clazz = Class.forName("java.nio.charset.Charset");
                Method method = clazz.getMethod("availableCharsets", new Class[0]);
                Map map = (Map)method.invoke(null, new Object[0]);
                Iterator iterator = map.keySet().iterator();
                arrayList.add(UTF_8_Y);
                while (iterator.hasNext()) {
                    arrayList.add((String)iterator.next());
                }
            }
            catch (Exception exception) {
                Log.log(9, MiscUtilities.class, exception);
            }
        } else {
            StringTokenizer stringTokenizer = new StringTokenizer(jEdit.getProperty("encodings"));
            while (stringTokenizer.hasMoreTokens()) {
                arrayList.add(stringTokenizer.nextToken());
            }
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public static boolean isSupportedEncoding(String string) {
        if (OperatingSystem.hasJava14()) {
            try {
                Class<?> clazz = Class.forName("java.nio.charset.Charset");
                Method method = clazz.getMethod("isSupported", String.class);
                return (Boolean)method.invoke(null, string);
            }
            catch (Exception exception) {
                Log.log(9, MiscUtilities.class, exception);
            }
        }
        return true;
    }

    public static String throwableToString(Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        throwable.printStackTrace(new PrintWriter(stringWriter));
        return stringWriter.toString();
    }

    private MiscUtilities() {
    }

    private static boolean compareChars(char c, char c2, boolean bl) {
        if (bl) {
            return Character.toUpperCase(c) == Character.toUpperCase(c2);
        }
        return c == c2;
    }

    public static class MenuItemCompare
    implements Compare {
        public int compare(Object object, Object object2) {
            return MiscUtilities.compareStrings(((JMenuItem)object).getText(), ((JMenuItem)object2).getText(), true);
        }
    }

    public static class StringICaseCompare
    implements Compare {
        public int compare(Object object, Object object2) {
            return MiscUtilities.compareStrings(object.toString(), object2.toString(), true);
        }
    }

    public static class StringCompare
    implements Compare {
        public int compare(Object object, Object object2) {
            return MiscUtilities.compareStrings(object.toString(), object2.toString(), false);
        }
    }

    public static interface Compare
    extends Comparator {
        public int compare(Object var1, Object var2);
    }
}

