/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit;

import com.microstar.xml.HandlerBase;
import com.microstar.xml.XmlException;
import com.microstar.xml.XmlParser;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.util.Log;

public class PerspectiveManager {
    private static boolean dirty;

    public static boolean isPerspectiveDirty() {
        return dirty;
    }

    public static void setPerspectiveDirty(boolean bl) {
        dirty = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static View loadPerspective(boolean bl) {
        String string = jEdit.getSettingsDirectory();
        if (string == null) {
            return null;
        }
        File file = new File(MiscUtilities.constructPath(string, "perspective.xml"));
        if (!file.exists()) {
            return null;
        }
        Log.log(3, PerspectiveManager.class, "Loading " + file);
        PerspectiveHandler perspectiveHandler = new PerspectiveHandler(bl);
        XmlParser xmlParser = new XmlParser();
        xmlParser.setHandler(perspectiveHandler);
        Reader reader = null;
        try {
            reader = new BufferedReader(new FileReader(file));
            xmlParser.parse(null, null, reader);
        }
        catch (XmlException xmlException) {
            int n = xmlException.getLine();
            String string2 = xmlException.getMessage();
            Log.log(9, PerspectiveManager.class, file + ":" + n + ": " + string2);
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (Exception exception) {
            Log.log(9, PerspectiveManager.class, exception);
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException iOException) {
                Log.log(9, PerspectiveManager.class, iOException);
            }
        }
        return perspectiveHandler.view;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void savePerspective(boolean bl) {
        String string = jEdit.getSettingsDirectory();
        if (string == null) {
            return;
        }
        if (jEdit.getBufferCount() == 0) {
            return;
        }
        if (!bl) {
            Log.log(3, PerspectiveManager.class, "Saving perspective.xml");
        }
        File file = new File(MiscUtilities.constructPath(string, "#perspective.xml#save#"));
        File file2 = new File(MiscUtilities.constructPath(string, "perspective.xml"));
        String string2 = System.getProperty("line.separator");
        BufferedWriter bufferedWriter = null;
        try {
            bufferedWriter = new BufferedWriter(new FileWriter(file));
            bufferedWriter.write("<?xml version=\"1.0\"?>");
            bufferedWriter.write(string2);
            bufferedWriter.write("<!DOCTYPE PERSPECTIVE SYSTEM \"perspective.dtd\">");
            bufferedWriter.write(string2);
            bufferedWriter.write("<PERSPECTIVE>");
            bufferedWriter.write(string2);
            Buffer[] bufferArray = jEdit.getBuffers();
            for (int i = 0; i < bufferArray.length; ++i) {
                Buffer buffer = bufferArray[i];
                if (buffer.isNewFile()) continue;
                bufferedWriter.write("<BUFFER>");
                bufferedWriter.write(MiscUtilities.charsToEntities(buffer.getPath()));
                bufferedWriter.write("</BUFFER>");
                bufferedWriter.write(string2);
            }
            View[] viewArray = jEdit.getViews();
            for (int i = 0; i < viewArray.length; ++i) {
                Object object;
                Object object2 = viewArray[i];
                if (object2 == jEdit.getActiveView() && i != viewArray.length - 1) {
                    viewArray[i] = object = viewArray[viewArray.length - 1];
                    viewArray[viewArray.length - 1] = object2;
                    object2 = object;
                }
                object = viewArray[i].getViewConfig();
                bufferedWriter.write("<VIEW PLAIN=\"");
                bufferedWriter.write(((View.ViewConfig)object).plainView ? "TRUE" : "FALSE");
                bufferedWriter.write("\">");
                bufferedWriter.write("<PANES>");
                bufferedWriter.write(string2);
                bufferedWriter.write(MiscUtilities.charsToEntities(((View.ViewConfig)object).splitConfig));
                bufferedWriter.write(string2);
                bufferedWriter.write("</PANES>");
                bufferedWriter.write(string2);
                bufferedWriter.write("<GEOMETRY X=\"");
                bufferedWriter.write(String.valueOf(((View.ViewConfig)object).x));
                bufferedWriter.write("\" Y=\"");
                bufferedWriter.write(String.valueOf(((View.ViewConfig)object).y));
                bufferedWriter.write("\" WIDTH=\"");
                bufferedWriter.write(String.valueOf(((View.ViewConfig)object).width));
                bufferedWriter.write("\" HEIGHT=\"");
                bufferedWriter.write(String.valueOf(((View.ViewConfig)object).height));
                bufferedWriter.write("\" EXT_STATE=\"");
                bufferedWriter.write(String.valueOf(((View.ViewConfig)object).extState));
                bufferedWriter.write("\" />");
                bufferedWriter.write(string2);
                bufferedWriter.write("<DOCKING LEFT=\"");
                bufferedWriter.write(((View.ViewConfig)object).left == null ? "" : ((View.ViewConfig)object).left);
                bufferedWriter.write("\" TOP=\"");
                bufferedWriter.write(((View.ViewConfig)object).top == null ? "" : ((View.ViewConfig)object).top);
                bufferedWriter.write("\" RIGHT=\"");
                bufferedWriter.write(((View.ViewConfig)object).right == null ? "" : ((View.ViewConfig)object).right);
                bufferedWriter.write("\" BOTTOM=\"");
                bufferedWriter.write(((View.ViewConfig)object).bottom == null ? "" : ((View.ViewConfig)object).bottom);
                bufferedWriter.write("\" LEFT_POS=\"");
                bufferedWriter.write(String.valueOf(((View.ViewConfig)object).leftPos));
                bufferedWriter.write("\" TOP_POS=\"");
                bufferedWriter.write(String.valueOf(((View.ViewConfig)object).topPos));
                bufferedWriter.write("\" RIGHT_POS=\"");
                bufferedWriter.write(String.valueOf(((View.ViewConfig)object).rightPos));
                bufferedWriter.write("\" BOTTOM_POS=\"");
                bufferedWriter.write(String.valueOf(((View.ViewConfig)object).bottomPos));
                bufferedWriter.write("\" />");
                bufferedWriter.write(string2);
                bufferedWriter.write("</VIEW>");
                bufferedWriter.write(string2);
            }
            bufferedWriter.write("</PERSPECTIVE>");
            bufferedWriter.write(string2);
        }
        catch (IOException iOException) {
            Log.log(9, PerspectiveManager.class, "Error saving " + file);
            Log.log(9, PerspectiveManager.class, iOException);
        }
        finally {
            try {
                if (bufferedWriter != null) {
                    bufferedWriter.close();
                }
            }
            catch (IOException iOException) {}
        }
        file2.delete();
        file.renameTo(file2);
    }

    static class PerspectiveHandler
    extends HandlerBase {
        View view;
        String charData;
        View.ViewConfig config;
        boolean restoreFiles;

        PerspectiveHandler(boolean bl) {
            this.restoreFiles = bl;
            this.config = new View.ViewConfig();
        }

        public Object resolveEntity(String string, String string2) {
            if ("perspective.dtd".equals(string2)) {
                return new StringReader("<!-- -->");
            }
            return null;
        }

        public void doctypeDecl(String string, String string2, String string3) throws Exception {
            if ("PERSPECTIVE".equals(string)) {
                return;
            }
            Log.log(9, this, "perspective.xml: DOCTYPE must be PERSPECTIVE");
        }

        public void attribute(String string, String string2, boolean bl) {
            if (!bl) {
                return;
            }
            if (string.equals("X")) {
                this.config.x = Integer.parseInt(string2);
            } else if (string.equals("Y")) {
                this.config.y = Integer.parseInt(string2);
            } else if (string.equals("WIDTH")) {
                this.config.width = Integer.parseInt(string2);
            } else if (string.equals("HEIGHT")) {
                this.config.height = Integer.parseInt(string2);
            } else if (string.equals("EXT_STATE")) {
                this.config.extState = Integer.parseInt(string2);
            } else if (string.equals("PLAIN")) {
                this.config.plainView = "TRUE".equals(string2);
            } else if (string.equals("TOP")) {
                this.config.top = string2;
            } else if (string.equals("LEFT")) {
                this.config.left = string2;
            } else if (string.equals("BOTTOM")) {
                this.config.bottom = string2;
            } else if (string.equals("RIGHT")) {
                this.config.right = string2;
            } else if (string.equals("TOP_POS")) {
                this.config.topPos = Integer.parseInt(string2);
            } else if (string.equals("LEFT_POS")) {
                this.config.leftPos = Integer.parseInt(string2);
            } else if (string.equals("BOTTOM_POS")) {
                this.config.bottomPos = Integer.parseInt(string2);
            } else if (string.equals("RIGHT_POS")) {
                this.config.rightPos = Integer.parseInt(string2);
            }
        }

        public void endElement(String string) {
            if (string.equals("BUFFER")) {
                if (this.restoreFiles) {
                    jEdit.openFile(null, this.charData);
                }
            } else if (string.equals("PANES")) {
                this.config.splitConfig = this.charData;
            } else if (string.equals("VIEW")) {
                this.view = jEdit.newView(this.view, null, this.config);
                this.config = new View.ViewConfig();
            }
        }

        public void charData(char[] cArray, int n, int n2) {
            this.charData = new String(cArray, n, n2);
        }
    }
}

