/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;

class PropertyManager {
    private Properties system = new Properties();
    private List plugins = new LinkedList();
    private Properties site = new Properties();
    private Properties user = new Properties();

    PropertyManager() {
    }

    Properties getProperties() {
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)this.system);
        Iterator iterator = this.plugins.iterator();
        while (iterator.hasNext()) {
            properties.putAll((Map<?, ?>)((Properties)iterator.next()));
        }
        properties.putAll((Map<?, ?>)this.site);
        properties.putAll((Map<?, ?>)this.user);
        return properties;
    }

    void loadSystemProps(InputStream inputStream) throws IOException {
        this.loadProps(this.system, inputStream);
    }

    void loadSiteProps(InputStream inputStream) throws IOException {
        this.loadProps(this.site, inputStream);
    }

    void loadUserProps(InputStream inputStream) throws IOException {
        this.loadProps(this.user, inputStream);
    }

    void saveUserProps(OutputStream outputStream) throws IOException {
        this.user.store(outputStream, "jEdit properties");
        outputStream.close();
    }

    Properties loadPluginProps(InputStream inputStream) throws IOException {
        Properties properties = new Properties();
        this.loadProps(properties, inputStream);
        this.plugins.add(properties);
        return properties;
    }

    void addPluginProps(Properties properties) {
        this.plugins.add(properties);
    }

    void removePluginProps(Properties properties) {
        this.plugins.remove(properties);
    }

    String getProperty(String string) {
        String string2 = this.user.getProperty(string);
        if (string2 != null) {
            return string2;
        }
        return this.getDefaultProperty(string);
    }

    void setProperty(String string, String string2) {
        String string3 = this.getDefaultProperty(string);
        if (string2 == null) {
            if (string3 == null || string3.length() == 0) {
                this.user.remove(string);
            } else {
                this.user.put(string, "");
            }
        } else if (string2.equals(string3)) {
            this.user.remove(string);
        } else {
            this.user.put(string, string2);
        }
    }

    public void setTemporaryProperty(String string, String string2) {
        this.user.remove(string);
        this.system.put(string, string2);
    }

    void unsetProperty(String string) {
        if (this.getDefaultProperty(string) != null) {
            this.user.put(string, "");
        } else {
            this.user.remove(string);
        }
    }

    public void resetProperty(String string) {
        this.user.remove(string);
    }

    private String getDefaultProperty(String string) {
        String string2 = this.site.getProperty(string);
        if (string2 != null) {
            return string2;
        }
        Iterator iterator = this.plugins.iterator();
        while (iterator.hasNext()) {
            string2 = ((Properties)iterator.next()).getProperty(string);
            if (string2 == null) continue;
            return string2;
        }
        return this.system.getProperty(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadProps(Properties properties, InputStream inputStream) throws IOException {
        try {
            properties.load(inputStream);
        }
        finally {
            inputStream.close();
        }
    }
}

