/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.browser;

import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.font.FontRenderContext;
import java.io.Serializable;
import javax.swing.Icon;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.table.DefaultTableCellRenderer;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.browser.VFSDirectoryEntryTableModel;
import org.gjt.sp.jedit.io.VFS;
import org.gjt.sp.jedit.jEdit;

public class FileCellRenderer
extends DefaultTableCellRenderer {
    public static Icon fileIcon = GUIUtilities.loadIcon("File.png");
    public static Icon openFileIcon = GUIUtilities.loadIcon("OpenFile.png");
    public static Icon dirIcon = GUIUtilities.loadIcon("Folder.png");
    public static Icon openDirIcon = GUIUtilities.loadIcon("OpenFolder.png");
    public static Icon filesystemIcon = GUIUtilities.loadIcon("DriveSmall.png");
    public static Icon loadingIcon = GUIUtilities.loadIcon("ReloadSmall.png");
    Font plainFont = UIManager.getFont("Tree.font");
    Font boldFont;
    boolean showIcons;
    private boolean openBuffer;
    private boolean isSelected;
    private VFS.DirectoryEntry file;

    public FileCellRenderer() {
        if (this.plainFont == null) {
            this.plainFont = jEdit.getFontProperty("metal.secondary.font");
        }
        this.boldFont = this.plainFont.deriveFont(1);
    }

    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
        if (object instanceof VFSDirectoryEntryTableModel.Entry) {
            VFSDirectoryEntryTableModel.Entry entry = (VFSDirectoryEntryTableModel.Entry)object;
            VFS.DirectoryEntry directoryEntry = entry.dirEntry;
            this.setFont(directoryEntry.type == 0 ? this.plainFont : this.boldFont);
            this.isSelected = bl;
            this.file = directoryEntry;
            if (n2 == 0) {
                String string = directoryEntry.symlinkPath == null ? directoryEntry.path : directoryEntry.symlinkPath;
                this.openBuffer = jEdit._getBuffer(string) != null;
                this.setIcon(this.showIcons ? FileCellRenderer.getIconForFile(directoryEntry, entry.expanded, this.openBuffer) : null);
                this.setText(directoryEntry.name);
                int n3 = directoryEntry.type == 0 ? 0 : (entry.expanded ? 2 : 1);
                this.setBorder(new ExpansionToggleBorder(n3, entry.level));
            } else {
                VFSDirectoryEntryTableModel vFSDirectoryEntryTableModel = (VFSDirectoryEntryTableModel)jTable.getModel();
                String string = vFSDirectoryEntryTableModel.getExtendedAttribute(n2 - 1);
                this.openBuffer = false;
                this.setIcon(null);
                this.setText(directoryEntry.getExtendedAttribute(string));
                this.setBorder(new EmptyBorder(1, 1, 1, 1));
            }
        }
        return this;
    }

    public void paintComponent(Graphics graphics) {
        Serializable serializable;
        if (!this.isSelected) {
            serializable = this.file.getColor();
            this.setForeground(serializable == null ? UIManager.getColor("Tree.foreground") : serializable);
        }
        super.paintComponent(graphics);
        if (this.openBuffer) {
            int n;
            int n2;
            serializable = this.getFont();
            FontMetrics fontMetrics = this.getFontMetrics((Font)serializable);
            if (this.getIcon() == null) {
                n2 = 0;
                n = fontMetrics.getAscent() + 2;
            } else {
                n2 = this.getIcon().getIconWidth() + this.getIconTextGap();
                n = Math.max(fontMetrics.getAscent() + 2, 16);
            }
            Insets insets = this.getBorder().getBorderInsets(this);
            graphics.setColor(this.getForeground());
            graphics.drawLine(n2 += insets.left, n, n2 + fontMetrics.stringWidth(this.getText()), n);
        }
    }

    public static Icon getIconForFile(VFS.DirectoryEntry directoryEntry, boolean bl) {
        return FileCellRenderer.getIconForFile(directoryEntry, bl, jEdit._getBuffer(directoryEntry.symlinkPath) != null);
    }

    public static Icon getIconForFile(VFS.DirectoryEntry directoryEntry, boolean bl, boolean bl2) {
        if (directoryEntry.type == 1) {
            return bl ? openDirIcon : dirIcon;
        }
        if (directoryEntry.type == 2) {
            return filesystemIcon;
        }
        if (bl2) {
            return openFileIcon;
        }
        return fileIcon;
    }

    void propertiesChanged() {
        this.showIcons = jEdit.getBooleanProperty("vfs.browser.showIcons");
    }

    int getEntryWidth(VFSDirectoryEntryTableModel.Entry entry, Font font, FontRenderContext fontRenderContext) {
        String string = entry.dirEntry.name;
        int n = (int)font.getStringBounds(string, fontRenderContext).getWidth();
        n += ExpansionToggleBorder.ICON_WIDTH + entry.level * 15 + 3;
        if (this.showIcons) {
            n += fileIcon.getIconWidth();
            n += this.getIconTextGap();
        }
        return n;
    }

    static class ExpansionToggleBorder
    implements Border {
        static final Icon COLLAPSED_ICON = GUIUtilities.loadIcon("arrow1.png");
        static final Icon EXPANDED_ICON = GUIUtilities.loadIcon("arrow2.png");
        static final int ICON_WIDTH = Math.max(COLLAPSED_ICON.getIconWidth(), EXPANDED_ICON.getIconWidth());
        static final int LEVEL_WIDTH = 15;
        static final int STATE_NONE = 0;
        static final int STATE_COLLAPSED = 1;
        static final int STATE_EXPANDED = 2;
        private int state;
        private int level;

        public ExpansionToggleBorder(int n, int n2) {
            this.state = n;
            this.level = n2;
        }

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            switch (this.state) {
                case 1: {
                    COLLAPSED_ICON.paintIcon(component, graphics, n + this.level * 15 + 2, n2 + (n4 - COLLAPSED_ICON.getIconHeight()) / 2);
                    break;
                }
                case 2: {
                    EXPANDED_ICON.paintIcon(component, graphics, n + this.level * 15 + 2, n2 + 2 + (n4 - EXPANDED_ICON.getIconHeight()) / 2);
                }
            }
        }

        public Insets getBorderInsets(Component component) {
            return new Insets(1, this.level * 15 + ICON_WIDTH + 4, 1, 1);
        }

        public boolean isBorderOpaque() {
            return false;
        }

        public static boolean isExpansionToggle(int n, int n2) {
            return n2 >= n * 15 && n2 <= n * 15 + ICON_WIDTH;
        }
    }
}

