/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.browser;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import org.gjt.sp.jedit.io.VFS;
import org.gjt.sp.jedit.io.VFSManager;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.util.Log;

public class VFSDirectoryEntryTableModel
extends AbstractTableModel {
    Entry[] files;
    private List extAttrs = new ArrayList();

    public void setRoot(VFS vFS, ArrayList arrayList) {
        this.extAttrs.clear();
        this.addExtendedAttributes(vFS);
        this.files = new Entry[arrayList.size()];
        for (int i = 0; i < this.files.length; ++i) {
            this.files[i] = new Entry((VFS.DirectoryEntry)arrayList.get(i), 0);
        }
        this.fireTableStructureChanged();
    }

    public int expand(VFS vFS, Entry entry, ArrayList arrayList) {
        int n = -1;
        for (int i = 0; i < this.files.length; ++i) {
            if (this.files[i] != entry) continue;
            n = i;
        }
        this.collapse(vFS, n);
        this.addExtendedAttributes(vFS);
        entry.expanded = true;
        if (arrayList != null) {
            Entry[] entryArray = new Entry[this.files.length + arrayList.size()];
            System.arraycopy(this.files, 0, entryArray, 0, n + 1);
            for (int i = 0; i < arrayList.size(); ++i) {
                entryArray[n + i + 1] = new Entry((VFS.DirectoryEntry)arrayList.get(i), entry.level + 1);
            }
            System.arraycopy(this.files, n + 1, entryArray, n + arrayList.size() + 1, this.files.length - n - 1);
            this.files = entryArray;
        }
        this.fireTableStructureChanged();
        return n;
    }

    public void collapse(VFS vFS, int n) {
        Entry[] entryArray;
        int n2;
        Entry entry = this.files[n];
        if (!entry.expanded) {
            return;
        }
        entry.expanded = false;
        for (n2 = n + 1; n2 < this.files.length; ++n2) {
            entryArray = this.files[n2];
            if (entryArray.level <= entry.level) break;
            if (!entryArray.expanded) continue;
            this.removeExtendedAttributes(VFSManager.getVFSForPath(entryArray.dirEntry.path));
        }
        this.removeExtendedAttributes(vFS);
        entryArray = new Entry[this.files.length - n2 + n + 1];
        System.arraycopy(this.files, 0, entryArray, 0, n + 1);
        System.arraycopy(this.files, n2, entryArray, n + 1, this.files.length - n2);
        this.files = entryArray;
        this.fireTableStructureChanged();
    }

    public int getColumnCount() {
        return 1 + this.extAttrs.size();
    }

    public int getRowCount() {
        if (this.files == null) {
            return 0;
        }
        return this.files.length;
    }

    public String getColumnName(int n) {
        if (n == 0) {
            return jEdit.getProperty("vfs.browser.name");
        }
        return jEdit.getProperty("vfs.browser." + this.getExtendedAttribute(n - 1));
    }

    public Class getColumnClass(int n) {
        return Entry.class;
    }

    public Object getValueAt(int n, int n2) {
        if (this.files == null) {
            return null;
        }
        return this.files[n];
    }

    public String getExtendedAttribute(int n) {
        return ((ExtendedAttribute)this.extAttrs.get((int)n)).name;
    }

    private void addExtendedAttributes(VFS vFS) {
        String[] stringArray = vFS.getExtendedAttributes();
        block0: for (int i = 0; i < stringArray.length; ++i) {
            for (ExtendedAttribute extendedAttribute : this.extAttrs) {
                if (!stringArray[i].equals(extendedAttribute.name)) continue;
                ++extendedAttribute.ref;
                continue block0;
            }
            this.extAttrs.add(new ExtendedAttribute(stringArray[i]));
        }
    }

    private void removeExtendedAttributes(VFS vFS) {
        String[] stringArray = vFS.getExtendedAttributes();
        block0: for (int i = 0; i < stringArray.length; ++i) {
            Iterator iterator = this.extAttrs.iterator();
            while (iterator.hasNext()) {
                ExtendedAttribute extendedAttribute = (ExtendedAttribute)iterator.next();
                if (!stringArray[i].equals(extendedAttribute.name)) continue;
                if (--extendedAttribute.ref != 0) continue block0;
                iterator.remove();
                continue block0;
            }
            Log.log(7, this, "We forgot about " + stringArray[i]);
        }
    }

    static class ExtendedAttribute {
        int ref;
        String name;

        ExtendedAttribute(String string) {
            this.name = string;
            this.ref = 1;
        }
    }

    static class Entry {
        VFS.DirectoryEntry dirEntry;
        boolean expanded;
        int level;

        Entry(VFS.DirectoryEntry directoryEntry, int n) {
            this.dirEntry = directoryEntry;
            this.level = n;
        }
    }
}

