/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.browser;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.io.File;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.OperatingSystem;
import org.gjt.sp.jedit.browser.BrowserView;
import org.gjt.sp.jedit.browser.VFSBrowser;
import org.gjt.sp.jedit.gui.HistoryTextField;
import org.gjt.sp.jedit.io.VFS;
import org.gjt.sp.jedit.io.VFSManager;

class VFSFileNameField
extends HistoryTextField {
    private VFSBrowser browser;

    VFSFileNameField(VFSBrowser vFSBrowser, String string) {
        super(string);
        this.setEnterAddsToHistory(false);
        this.browser = vFSBrowser;
        Dimension dimension = this.getPreferredSize();
        dimension.width = Integer.MAX_VALUE;
        this.setMaximumSize(dimension);
        ActionMap actionMap = this.getActionMap();
        Action action = actionMap.get("delete-previous");
        actionMap.put("delete-previous", new BackspaceAction(action));
    }

    public boolean isManagingFocus() {
        return false;
    }

    public boolean getFocusTraversalKeysEnabled() {
        return false;
    }

    public void processKeyEvent(KeyEvent keyEvent) {
        if (keyEvent.getID() == 401) {
            String string = this.getText();
            switch (keyEvent.getKeyCode()) {
                case 9: {
                    this.doComplete(string);
                    break;
                }
                case 37: {
                    if (this.getCaretPosition() == 0) {
                        this.browser.getBrowserView().getTable().processKeyEvent(keyEvent);
                        break;
                    }
                    super.processKeyEvent(keyEvent);
                    break;
                }
                case 39: {
                    if (this.getCaretPosition() == this.getDocument().getLength()) {
                        this.browser.getBrowserView().getTable().processKeyEvent(keyEvent);
                        break;
                    }
                    super.processKeyEvent(keyEvent);
                    break;
                }
                case 33: 
                case 34: 
                case 38: 
                case 40: {
                    this.browser.getBrowserView().getTable().processKeyEvent(keyEvent);
                    break;
                }
                case 10: {
                    this.browser.filesActivated(keyEvent.isShiftDown() ? 1 : 0, false);
                    this.setText(null);
                    keyEvent.consume();
                    break;
                }
                default: {
                    super.processKeyEvent(keyEvent);
                    break;
                }
            }
        } else if (keyEvent.getID() == 400) {
            char c = keyEvent.getKeyChar();
            if ((c == '/' || c == File.separatorChar) && this.getCaretPosition() == this.getDocument().getLength()) {
                Object object;
                super.processKeyEvent(keyEvent);
                String string = this.getText();
                if (string.length() == 2 && string.charAt(0) == '-') {
                    string = this.browser.getView().getBuffer().getDirectory();
                } else if (string.length() == 3 && string.startsWith("..")) {
                    string = MiscUtilities.getParentOfPath(this.browser.getDirectory());
                    object = VFSManager.getVFSForPath(string);
                    if ((((VFS)object).getCapabilities() & 0x40) != 0) {
                        this.browser.setDirectory(string);
                        VFSManager.waitForRequests();
                        this.setText(null);
                    }
                } else if (!MiscUtilities.isAbsolutePath(string)) {
                    object = this.browser.getBrowserView().getSelectedFiles();
                    if (((VFS.DirectoryEntry[])object).length != 1 || ((VFS.DirectoryEntry)object[0]).type == 0) {
                        return;
                    }
                    string = ((VFS.DirectoryEntry)object[0]).path;
                } else if (OperatingSystem.isDOSDerived() && string.length() == 3 && string.charAt(1) == ':') {
                    this.browser.setDirectory(string);
                    VFSManager.waitForRequests();
                    this.setText(null);
                }
                object = VFSManager.getVFSForPath(string);
                if ((((VFS)object).getCapabilities() & 0x40) != 0) {
                    this.setText(null);
                    this.browser.setDirectory(string);
                    VFSManager.waitForRequests();
                } else if (string.endsWith("/") || string.endsWith(File.separator)) {
                    this.setText(string);
                } else {
                    this.setText(string + ((VFS)object).getFileSeparator());
                }
            } else if (c > ' ' && c != '\u007f' && c != '\u00ff') {
                super.processKeyEvent(keyEvent);
                String string = this.getText();
                BrowserView browserView = this.browser.getBrowserView();
                browserView.selectNone();
                int n = this.browser.getMode();
                browserView.getTable().doTypeSelect(string, n == 3 || n == 1);
            } else {
                super.processKeyEvent(keyEvent);
            }
        }
    }

    private void doComplete(String string) {
        BrowserView browserView = this.browser.getBrowserView();
        browserView.selectNone();
        browserView.getTable().doTypeSelect(string, this.browser.getMode() == 3);
        VFS.DirectoryEntry[] directoryEntryArray = browserView.getSelectedFiles();
        if (directoryEntryArray.length == 0) {
            return;
        }
        String string2 = directoryEntryArray[0].path;
        String string3 = directoryEntryArray[0].name;
        String string4 = MiscUtilities.getParentOfPath(string2);
        String string5 = MiscUtilities.isAbsolutePath(string) && !string.startsWith(this.browser.getDirectory()) ? string2 : (VFSBrowser.pathsEqual(string4, this.browser.getDirectory()) ? string3 : string2);
        this.setText(string5);
    }

    private void goToParent() {
        String string = MiscUtilities.getFileName(this.browser.getDirectory());
        String string2 = MiscUtilities.getParentOfPath(this.browser.getDirectory());
        this.browser.setDirectory(string2);
        VFS vFS = VFSManager.getVFSForPath(string2);
        if ((vFS.getCapabilities() & 0x40) != 0) {
            VFSManager.waitForRequests();
            this.setText(string);
            this.browser.getBrowserView().getTable().doTypeSelect(string, this.browser.getMode() == 3);
        }
    }

    class BackspaceAction
    extends AbstractAction {
        private Action delegate;

        BackspaceAction(Action action) {
            this.delegate = action;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (VFSFileNameField.this.getSelectionStart() == 0 && VFSFileNameField.this.getSelectionEnd() == 0) {
                VFSFileNameField.this.goToParent();
            } else {
                this.delegate.actionPerformed(actionEvent);
                String string = VFSFileNameField.this.getText();
                BrowserView browserView = VFSFileNameField.this.browser.getBrowserView();
                browserView.selectNone();
                int n = VFSFileNameField.this.browser.getMode();
                browserView.getTable().doTypeSelect(string, n == 3 || n == 1);
            }
        }
    }
}

