/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.buffer;

import java.awt.Component;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.CharConversionException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Vector;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.swing.text.Segment;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.Marker;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.io.VFS;
import org.gjt.sp.jedit.io.VFSManager;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.util.IntegerArray;
import org.gjt.sp.util.Log;
import org.gjt.sp.util.SegmentBuffer;
import org.gjt.sp.util.WorkRequest;
import org.gjt.sp.util.WorkThread;

public class BufferIORequest
extends WorkRequest {
    public static final int IOBUFSIZE = 32768;
    public static final int PROGRESS_INTERVAL = 300;
    public static final String LOAD_DATA = "BufferIORequest__loadData";
    public static final String END_OFFSETS = "BufferIORequest__endOffsets";
    public static final String NEW_PATH = "BufferIORequest__newPath";
    public static final String ERROR_OCCURRED = "BufferIORequest__error";
    public static final int LOAD = 0;
    public static final int SAVE = 1;
    public static final int AUTOSAVE = 2;
    public static final int INSERT = 3;
    public static final int GZIP_MAGIC_1 = 31;
    public static final int GZIP_MAGIC_2 = 139;
    public static final int UNICODE_MAGIC_1 = 254;
    public static final int UNICODE_MAGIC_2 = 255;
    public static final int UTF8_MAGIC_1 = 239;
    public static final int UTF8_MAGIC_2 = 187;
    public static final int UTF8_MAGIC_3 = 191;
    public static final int XML_PI_LENGTH = 50;
    private int type;
    private View view;
    private Buffer buffer;
    private Object session;
    private VFS vfs;
    private String path;
    private String markersPath;

    public BufferIORequest(int n, View view, Buffer buffer, Object object, VFS vFS, String string) {
        this.type = n;
        this.view = view;
        this.buffer = buffer;
        this.session = object;
        this.vfs = vFS;
        this.path = string;
        this.markersPath = vFS.getParentOfPath(string) + '.' + vFS.getFileName(string) + ".marks";
    }

    public void run() {
        switch (this.type) {
            case 0: {
                this.load();
                break;
            }
            case 1: {
                this.save();
                break;
            }
            case 2: {
                this.autosave();
                break;
            }
            case 3: {
                this.insert();
                break;
            }
            default: {
                throw new InternalError();
            }
        }
    }

    public String toString() {
        String string;
        switch (this.type) {
            case 0: {
                string = "LOAD";
                break;
            }
            case 1: {
                string = "SAVE";
                break;
            }
            case 2: {
                string = "AUTOSAVE";
                break;
            }
            default: {
                string = "UNKNOWN!!!";
            }
        }
        return this.getClass().getName() + "[type=" + string + ",buffer=" + this.buffer + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void load() {
        block33: {
            Object object;
            InputStream inputStream;
            block32: {
                long l;
                Object[] objectArray;
                block30: {
                    inputStream = null;
                    objectArray = new String[]{this.vfs.getFileName(this.path)};
                    this.setAbortable(true);
                    if (!this.buffer.isTemporary()) {
                        this.setStatus(jEdit.getProperty("vfs.status.load", objectArray));
                        this.setProgressValue(0);
                    }
                    this.path = this.vfs._canonPath(this.session, this.path, (Component)((Object)this.view));
                    object = this.vfs._getDirectoryEntry(this.session, this.path, (Component)((Object)this.view));
                    l = object != null ? object.length : 0L;
                    inputStream = this.vfs._createInputStream(this.session, this.path, false, (Component)((Object)this.view));
                    if (inputStream != null) break block30;
                    try {
                        this.vfs._endVFSSession(this.session, (Component)((Object)this.view));
                    }
                    catch (IOException iOException) {
                        Log.log(9, this, iOException);
                        Object[] objectArray2 = new String[]{iOException.toString()};
                        VFSManager.error((Component)((Object)this.view), this.path, "ioerror.read-error", objectArray2);
                        this.buffer.setBooleanProperty(ERROR_OCCURRED, true);
                    }
                    catch (WorkThread.Abort abort) {
                        this.buffer.setBooleanProperty(ERROR_OCCURRED, true);
                    }
                    return;
                }
                try {
                    this.read(this.autodetect(inputStream), l, false);
                    this.buffer.setNewFile(false);
                }
                catch (CharConversionException charConversionException) {
                    Log.log(9, this, charConversionException);
                    object = new Object[]{this.buffer.getProperty("encoding"), charConversionException.toString()};
                    VFSManager.error((Component)((Object)this.view), this.path, "ioerror.encoding-error", object);
                    this.buffer.setBooleanProperty(ERROR_OCCURRED, true);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    Log.log(9, this, unsupportedEncodingException);
                    object = new Object[]{this.buffer.getProperty("encoding"), unsupportedEncodingException.toString()};
                    VFSManager.error((Component)((Object)this.view), this.path, "ioerror.encoding-error", object);
                    this.buffer.setBooleanProperty(ERROR_OCCURRED, true);
                }
                catch (IOException iOException) {
                    Log.log(9, this, iOException);
                    object = new Object[]{iOException.toString()};
                    VFSManager.error((Component)((Object)this.view), this.path, "ioerror.read-error", object);
                    this.buffer.setBooleanProperty(ERROR_OCCURRED, true);
                }
                catch (OutOfMemoryError outOfMemoryError) {
                    Log.log(9, this, outOfMemoryError);
                    VFSManager.error((Component)((Object)this.view), this.path, "out-of-memory-error", null);
                    this.buffer.setBooleanProperty(ERROR_OCCURRED, true);
                }
                if (!jEdit.getBooleanProperty("persistentMarkers")) break block32;
                try {
                    objectArray = new String[]{this.vfs.getFileName(this.path)};
                    if (!this.buffer.isTemporary()) {
                        this.setStatus(jEdit.getProperty("vfs.status.load-markers", objectArray));
                    }
                    this.setAbortable(true);
                    inputStream = this.vfs._createInputStream(this.session, this.markersPath, true, (Component)((Object)this.view));
                    if (inputStream != null) {
                        this.readMarkers(this.buffer, inputStream);
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            try {
                this.vfs._endVFSSession(this.session, (Component)((Object)this.view));
            }
            catch (IOException iOException) {
                Log.log(9, this, iOException);
                object = new String[]{iOException.toString()};
                VFSManager.error((Component)((Object)this.view), this.path, "ioerror.read-error", object);
                this.buffer.setBooleanProperty(ERROR_OCCURRED, true);
            }
            catch (WorkThread.Abort abort) {
                this.buffer.setBooleanProperty(ERROR_OCCURRED, true);
            }
            break block33;
            catch (WorkThread.Abort abort) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    this.buffer.setBooleanProperty(ERROR_OCCURRED, true);
                }
                catch (Throwable throwable) {
                    try {
                        this.vfs._endVFSSession(this.session, (Component)((Object)this.view));
                    }
                    catch (IOException iOException) {
                        Log.log(9, this, iOException);
                        Object[] objectArray = new String[]{iOException.toString()};
                        VFSManager.error((Component)((Object)this.view), this.path, "ioerror.read-error", objectArray);
                        this.buffer.setBooleanProperty(ERROR_OCCURRED, true);
                    }
                    catch (WorkThread.Abort abort2) {
                        this.buffer.setBooleanProperty(ERROR_OCCURRED, true);
                    }
                    throw throwable;
                }
                try {
                    this.vfs._endVFSSession(this.session, (Component)((Object)this.view));
                }
                catch (IOException iOException) {
                    Log.log(9, this, iOException);
                    object = new String[]{iOException.toString()};
                    VFSManager.error((Component)((Object)this.view), this.path, "ioerror.read-error", object);
                    this.buffer.setBooleanProperty(ERROR_OCCURRED, true);
                }
                catch (WorkThread.Abort abort3) {
                    this.buffer.setBooleanProperty(ERROR_OCCURRED, true);
                }
            }
        }
    }

    private Reader autodetect(InputStream inputStream) throws IOException {
        inputStream = new BufferedInputStream(inputStream);
        String string = this.buffer.getStringProperty("encoding");
        if (!inputStream.markSupported()) {
            Log.log(7, this, "Mark not supported: " + inputStream);
        } else if (this.buffer.getBooleanProperty("encodingAutodetect")) {
            inputStream.mark(50);
            int n = inputStream.read();
            int n2 = inputStream.read();
            int n3 = inputStream.read();
            if (string.equals("UTF-8Y")) {
                if (n != 239 || n2 != 187 || n3 != 191) {
                    inputStream.reset();
                }
                string = "UTF-8";
            } else {
                if (n == 31 && n2 == 139) {
                    inputStream.reset();
                    inputStream = new GZIPInputStream(inputStream);
                    this.buffer.setBooleanProperty("gzipped", true);
                    return this.autodetect(inputStream);
                }
                if (n == 254 && n2 == 255 || n == 255 && n2 == 254) {
                    inputStream.reset();
                    string = "UTF-16";
                    this.buffer.setProperty("encoding", string);
                } else if (n == 239 && n2 == 187 && n3 == 191) {
                    this.buffer.setProperty("encoding", "UTF-8Y");
                    string = "UTF-8";
                } else {
                    int n4;
                    int n5;
                    inputStream.reset();
                    byte[] byArray = new byte[50];
                    int n6 = 0;
                    while ((n5 = inputStream.read(byArray, n6, 50 - n6)) != -1 && (n6 += n5) != 50) {
                    }
                    String string2 = new String(byArray, 0, n6, "ASCII");
                    if (string2.startsWith("<?xml") && (n4 = string2.indexOf("encoding=")) != -1 && n4 + 9 != string2.length()) {
                        char c = string2.charAt(n4 + 9);
                        int n7 = string2.indexOf(c, n4 + 10);
                        string = string2.substring(n4 + 10, n7);
                        if (MiscUtilities.isSupportedEncoding(string)) {
                            this.buffer.setProperty("encoding", string);
                        } else {
                            Log.log(7, this, "XML PI specifies unsupported encoding: " + string);
                        }
                    }
                    inputStream.reset();
                }
            }
        }
        return new InputStreamReader(inputStream, string);
    }

    private SegmentBuffer read(Reader reader, long l, boolean bl) throws IOException {
        char c;
        int n;
        int n2;
        boolean bl2;
        IntegerArray integerArray = new IntegerArray(Math.max(1, (int)(l / 50L)));
        boolean bl3 = bl2 = !this.buffer.isTemporary() && l != 0L;
        if (bl2) {
            this.setProgressValue(0);
            this.setProgressMaximum((int)l);
        }
        if (l == 0L) {
            l = 32768L;
        }
        SegmentBuffer segmentBuffer = new SegmentBuffer((int)l + 1);
        char[] cArray = new char[32768];
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        int n3 = 0;
        while ((n2 = reader.read(cArray, 0, cArray.length)) != -1) {
            int n4 = 0;
            block5: for (n = 0; n < n2; ++n) {
                switch (cArray[n]) {
                    case '\r': {
                        if (bl6) {
                            bl5 = true;
                            bl4 = false;
                        } else {
                            bl6 = true;
                        }
                        segmentBuffer.append(cArray, n4, n - n4);
                        segmentBuffer.append('\n');
                        integerArray.add(segmentBuffer.count);
                        if (bl2 && n3++ % 300 == 0) {
                            this.setProgressValue(segmentBuffer.count);
                        }
                        n4 = n + 1;
                        continue block5;
                    }
                    case '\n': {
                        if (bl6) {
                            bl5 = false;
                            bl4 = true;
                            bl6 = false;
                            n4 = n + 1;
                            continue block5;
                        }
                        bl5 = false;
                        bl4 = false;
                        segmentBuffer.append(cArray, n4, n - n4);
                        segmentBuffer.append('\n');
                        integerArray.add(segmentBuffer.count);
                        if (bl2 && n3++ % 300 == 0) {
                            this.setProgressValue(segmentBuffer.count);
                        }
                        n4 = n + 1;
                        continue block5;
                    }
                    default: {
                        if (!bl6) continue block5;
                        bl5 = true;
                        bl4 = false;
                        bl6 = false;
                    }
                }
            }
            if (bl2) {
                this.setProgressValue(segmentBuffer.count);
            }
            segmentBuffer.append(cArray, n4, n2 - n4);
        }
        this.setAbortable(false);
        String string = segmentBuffer.count == 0 ? jEdit.getProperty("buffer.lineSeparator", System.getProperty("line.separator")) : (bl4 ? "\r\n" : (bl5 ? "\r" : "\n"));
        reader.close();
        n = segmentBuffer.count--;
        if (n == 0 || (c = segmentBuffer.array[n - 1]) == '\u001a') {
            // empty if block
        }
        this.buffer.setBooleanProperty("trailingEOL", false);
        if (n != 0 && jEdit.getBooleanProperty("stripTrailingEOL") && (c = segmentBuffer.array[n - 1]) == '\n') {
            this.buffer.setBooleanProperty("trailingEOL", true);
            --segmentBuffer.count;
            integerArray.setSize(integerArray.getSize() - 1);
        }
        integerArray.add(segmentBuffer.count + 1);
        if (!bl) {
            this.buffer.setProperty(LOAD_DATA, segmentBuffer);
            this.buffer.setProperty(END_OFFSETS, integerArray);
            this.buffer.setProperty(NEW_PATH, this.path);
            if (string != null) {
                this.buffer.setProperty("lineSeparator", string);
            }
        }
        return segmentBuffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readMarkers(Buffer buffer, InputStream inputStream) throws IOException {
        buffer.removeAllMarkers();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        try {
            String string;
            while ((string = bufferedReader.readLine()) != null) {
                if (!string.startsWith("!")) continue;
                char c = string.charAt(1);
                int n = string.indexOf(59);
                int n2 = string.indexOf(59, n + 1);
                int n3 = Integer.parseInt(string.substring(n + 1, n2));
                buffer.addMarker(c, n3);
            }
        }
        finally {
            bufferedReader.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void save() {
        block31: {
            OutputStream outputStream = null;
            Object[] objectArray = new String[]{this.vfs.getFileName(this.path)};
            this.setStatus(jEdit.getProperty("vfs.status.save", objectArray));
            this.setAbortable(true);
            this.path = this.vfs._canonPath(this.session, this.path, (Component)((Object)this.view));
            if (!MiscUtilities.isURL(this.path)) {
                this.path = MiscUtilities.resolveSymlinks(this.path);
            }
            if (this.buffer.getProperty("Buffer__backedUp") == null || jEdit.getBooleanProperty("backupEverySave")) {
                this.vfs._backup(this.session, this.path, (Component)((Object)this.view));
                this.buffer.setBooleanProperty("Buffer__backedUp", true);
            }
            boolean bl = (this.vfs.getCapabilities() & 0x10) != 0 && jEdit.getBooleanProperty("twoStageSave");
            String string = bl ? this.vfs.getTwoStageSaveName(this.path) : this.path;
            outputStream = this.vfs._createOutputStream(this.session, string, (Component)((Object)this.view));
            try {
                this.buffer.readLock();
                if (outputStream != null) {
                    if (string.endsWith(".gz")) {
                        this.buffer.setBooleanProperty("gzipped", true);
                    }
                    if (this.buffer.getBooleanProperty("gzipped")) {
                        outputStream = new GZIPOutputStream(outputStream);
                    }
                    this.write(this.buffer, string, outputStream);
                    if (bl && !this.vfs._rename(this.session, string, this.path, (Component)((Object)this.view))) {
                        throw new IOException("Rename failed: " + string);
                    }
                    if ((this.vfs.getCapabilities() & 8) != 0) {
                        if (jEdit.getBooleanProperty("persistentMarkers") && this.buffer.getMarkers().size() != 0) {
                            this.setStatus(jEdit.getProperty("vfs.status.save-markers", objectArray));
                            this.setProgressValue(0);
                            outputStream = this.vfs._createOutputStream(this.session, this.markersPath, (Component)((Object)this.view));
                            if (outputStream != null) {
                                this.writeMarkers(this.buffer, outputStream);
                            }
                        } else {
                            this.vfs._delete(this.session, this.markersPath, (Component)((Object)this.view));
                        }
                    }
                } else {
                    this.buffer.setBooleanProperty(ERROR_OCCURRED, true);
                }
                if (!bl) {
                    VFSManager.sendVFSUpdate(this.vfs, this.path, true);
                }
                Object var6_9 = null;
                this.buffer.readUnlock();
            }
            catch (Throwable throwable) {
                Object var6_10 = null;
                this.buffer.readUnlock();
                throw throwable;
            }
            Object var8_12 = null;
            try {
                this.vfs._saveComplete(this.session, this.buffer, this.path, (Component)((Object)this.view));
                this.vfs._endVFSSession(this.session, (Component)((Object)this.view));
            }
            catch (IOException iOException) {
                Log.log(9, this, iOException);
                Object[] objectArray2 = new String[]{iOException.toString()};
                VFSManager.error((Component)((Object)this.view), this.path, "ioerror.write-error", objectArray2);
                this.buffer.setBooleanProperty(ERROR_OCCURRED, true);
            }
            catch (WorkThread.Abort abort) {
                this.buffer.setBooleanProperty(ERROR_OCCURRED, true);
            }
            break block31;
            {
                catch (IOException iOException) {
                    Log.log(9, this, iOException);
                    Object[] objectArray3 = new String[]{iOException.toString()};
                    VFSManager.error((Component)((Object)this.view), this.path, "ioerror.write-error", objectArray3);
                    this.buffer.setBooleanProperty(ERROR_OCCURRED, true);
                    Object var8_13 = null;
                    try {
                        this.vfs._saveComplete(this.session, this.buffer, this.path, (Component)((Object)this.view));
                        this.vfs._endVFSSession(this.session, (Component)((Object)this.view));
                    }
                    catch (IOException iOException2) {
                        Log.log(9, this, iOException2);
                        Object[] objectArray4 = new String[]{iOException2.toString()};
                        VFSManager.error((Component)((Object)this.view), this.path, "ioerror.write-error", objectArray4);
                        this.buffer.setBooleanProperty(ERROR_OCCURRED, true);
                    }
                    catch (WorkThread.Abort abort) {
                        this.buffer.setBooleanProperty(ERROR_OCCURRED, true);
                    }
                    break block31;
                }
                catch (WorkThread.Abort abort) {
                    if (outputStream != null) {
                        try {
                            outputStream.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    this.buffer.setBooleanProperty(ERROR_OCCURRED, true);
                    Object var8_14 = null;
                    try {
                        this.vfs._saveComplete(this.session, this.buffer, this.path, (Component)((Object)this.view));
                        this.vfs._endVFSSession(this.session, (Component)((Object)this.view));
                    }
                    catch (IOException iOException) {
                        Log.log(9, this, iOException);
                        Object[] objectArray5 = new String[]{iOException.toString()};
                        VFSManager.error((Component)((Object)this.view), this.path, "ioerror.write-error", objectArray5);
                        this.buffer.setBooleanProperty(ERROR_OCCURRED, true);
                    }
                    catch (WorkThread.Abort abort2) {
                        this.buffer.setBooleanProperty(ERROR_OCCURRED, true);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var8_15 = null;
                try {
                    this.vfs._saveComplete(this.session, this.buffer, this.path, (Component)((Object)this.view));
                    this.vfs._endVFSSession(this.session, (Component)((Object)this.view));
                }
                catch (IOException iOException) {
                    Log.log(9, this, iOException);
                    Object[] objectArray6 = new String[]{iOException.toString()};
                    VFSManager.error((Component)((Object)this.view), this.path, "ioerror.write-error", objectArray6);
                    this.buffer.setBooleanProperty(ERROR_OCCURRED, true);
                }
                catch (WorkThread.Abort abort) {
                    this.buffer.setBooleanProperty(ERROR_OCCURRED, true);
                }
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void autosave() {
        OutputStream outputStream = null;
        try {
            Object[] objectArray = new String[]{this.vfs.getFileName(this.path)};
            this.setStatus(jEdit.getProperty("vfs.status.autosave", objectArray));
            this.setAbortable(true);
            try {
                try {
                    if (!this.buffer.isDirty()) {
                        return;
                    }
                    outputStream = this.vfs._createOutputStream(this.session, this.path, (Component)((Object)this.view));
                    if (outputStream == null) {
                        return;
                    }
                    this.write(this.buffer, this.path, outputStream);
                    return;
                }
                catch (Exception exception) {
                    return;
                }
            }
            catch (Throwable throwable) {
                Object var5_8 = null;
                throw throwable;
            }
        }
        catch (WorkThread.Abort abort) {
            if (outputStream == null) return;
            try {
                outputStream.close();
                return;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void write(Buffer buffer, String string, OutputStream outputStream) throws IOException {
        block8: {
            BufferedWriter bufferedWriter = null;
            try {
                String string2 = buffer.getStringProperty("encoding");
                if (string2.equals("UTF-8Y")) {
                    outputStream.write(239);
                    outputStream.write(187);
                    outputStream.write(191);
                    outputStream.flush();
                    string2 = "UTF-8";
                }
                this.vfs.setEncoding(string, string2);
                bufferedWriter = new BufferedWriter(new OutputStreamWriter(outputStream, string2), 32768);
                Segment segment = new Segment();
                String string3 = buffer.getStringProperty("lineSeparator");
                if (string3 == null) {
                    string3 = System.getProperty("line.separator");
                }
                this.setProgressMaximum(buffer.getLineCount() / 300);
                this.setProgressValue(0);
                int n = 0;
                while (n < buffer.getLineCount()) {
                    buffer.getLineText(n, segment);
                    bufferedWriter.write(segment.array, segment.offset, segment.count);
                    if (n != buffer.getLineCount() - 1) {
                        bufferedWriter.write(string3);
                    }
                    if (++n % 300 != 0) continue;
                    this.setProgressValue(n / 300);
                }
                if (jEdit.getBooleanProperty("stripTrailingEOL") && buffer.getBooleanProperty("trailingEOL")) {
                    bufferedWriter.write(string3);
                }
                Object var10_9 = null;
                if (bufferedWriter == null) break block8;
            }
            catch (Throwable throwable) {
                Object var10_10 = null;
                if (bufferedWriter != null) {
                    bufferedWriter.flush();
                    bufferedWriter.close();
                    throw throwable;
                }
                outputStream.close();
                throw throwable;
            }
            bufferedWriter.flush();
            bufferedWriter.close();
            return;
        }
        outputStream.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeMarkers(Buffer buffer, OutputStream outputStream) throws IOException {
        BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(outputStream));
        try {
            Vector vector = buffer.getMarkers();
            for (int i = 0; i < vector.size(); ++i) {
                Marker marker = (Marker)vector.elementAt(i);
                ((Writer)bufferedWriter).write(33);
                ((Writer)bufferedWriter).write(marker.getShortcut());
                ((Writer)bufferedWriter).write(59);
                String string = String.valueOf(marker.getPosition());
                bufferedWriter.write(string);
                ((Writer)bufferedWriter).write(59);
                bufferedWriter.write(string);
                ((Writer)bufferedWriter).write(10);
            }
            Object var9_8 = null;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            ((Writer)bufferedWriter).close();
            throw throwable;
        }
        ((Writer)bufferedWriter).close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void insert() {
        var1_1 = null;
        try {
            try {
                var2_2 = new String[]{this.vfs.getFileName(this.path)};
                this.setStatus(jEdit.getProperty("vfs.status.load", var2_2));
                this.setAbortable(true);
                this.path = this.vfs._canonPath(this.session, this.path, (Component)this.view);
                var3_5 /* !! */  = this.vfs._getDirectoryEntry(this.session, this.path, (Component)this.view);
                var4_7 = var3_5 /* !! */  != null ? var3_5 /* !! */ .length : 0L;
                var1_1 = this.vfs._createInputStream(this.session, this.path, false, (Component)this.view);
                if (var1_1 == null) {
                }
                ** GOTO lbl-1000
            }
            catch (IOException var2_3) {
                Log.log(9, this, var2_3);
                var3_5 /* !! */  = new String[]{var2_3.toString()};
                VFSManager.error((Component)this.view, this.path, "ioerror.read-error", var3_5 /* !! */ );
                this.buffer.setBooleanProperty("BufferIORequest__error", true);
                ** GOTO lbl76
            }
            var8_8 = null;
            ** GOTO lbl64
lbl-1000:
            // 1 sources

            {
                var6_24 = this.read(this.autodetect(var1_1), var4_7, true);
                VFSManager.runInAWTThread(new Runnable(){

                    public void run() {
                        BufferIORequest.this.view.getTextArea().setSelectedText(var6_24.toString());
                    }
                });
                ** GOTO lbl76
            }
        }
        catch (WorkThread.Abort var2_4) {
            if (var1_1 != null) {
                try {
                    var1_1.close();
                }
                catch (IOException var3_6) {
                    // empty catch block
                }
            }
            this.buffer.setBooleanProperty("BufferIORequest__error", true);
            var8_10 = null;
            try {
                this.vfs._endVFSSession(this.session, (Component)this.view);
                return;
            }
            catch (IOException var9_16) {
                Log.log(9, this, var9_16);
                var10_22 = new String[]{var9_16.toString()};
                VFSManager.error((Component)this.view, this.path, "ioerror.read-error", var10_22);
                this.buffer.setBooleanProperty("BufferIORequest__error", true);
                return;
            }
            catch (WorkThread.Abort var9_17) {
                this.buffer.setBooleanProperty("BufferIORequest__error", true);
                return;
            }
        }
        {
            catch (Throwable var7_25) {
                var8_11 = null;
                ** try [egrp 5[TRYBLOCK] [9, 10 : 243->261)] { 
lbl53:
                // 1 sources

                this.vfs._endVFSSession(this.session, (Component)this.view);
                throw var7_25;
lbl55:
                // 1 sources

                catch (IOException var9_18) {
                    Log.log(9, this, var9_18);
                    var10_23 = new String[]{var9_18.toString()};
                    VFSManager.error((Component)this.view, this.path, "ioerror.read-error", var10_23);
                    this.buffer.setBooleanProperty("BufferIORequest__error", true);
                    throw var7_25;
                }
lbl61:
                // 1 sources

                catch (WorkThread.Abort var9_19) {
                    this.buffer.setBooleanProperty("BufferIORequest__error", true);
                }
                throw var7_25;
            }
lbl64:
            // 1 sources

            ** try [egrp 5[TRYBLOCK] [9, 10 : 243->261)] { 
lbl65:
            // 1 sources

            this.vfs._endVFSSession(this.session, (Component)this.view);
            return;
lbl67:
            // 1 sources

            catch (IOException var9_12) {
                Log.log(9, this, var9_12);
                var10_20 = new String[]{var9_12.toString()};
                VFSManager.error((Component)this.view, this.path, "ioerror.read-error", var10_20);
                this.buffer.setBooleanProperty("BufferIORequest__error", true);
                return;
            }
lbl73:
            // 1 sources

            catch (WorkThread.Abort var9_13) {
                this.buffer.setBooleanProperty("BufferIORequest__error", true);
                return;
            }
lbl76:
            // 2 sources

            var8_9 = null;
            ** try [egrp 5[TRYBLOCK] [9, 10 : 243->261)] { 
lbl78:
            // 1 sources

            this.vfs._endVFSSession(this.session, (Component)this.view);
            return;
lbl80:
            // 1 sources

            catch (IOException var9_14) {
                Log.log(9, this, var9_14);
                var10_21 = new String[]{var9_14.toString()};
                VFSManager.error((Component)this.view, this.path, "ioerror.read-error", var10_21);
                this.buffer.setBooleanProperty("BufferIORequest__error", true);
                return;
            }
lbl86:
            // 1 sources

            catch (WorkThread.Abort var9_15) {}
            this.buffer.setBooleanProperty("BufferIORequest__error", true);
            return;
        }
    }
}

