/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.gui;

import bsh.NameSpace;
import bsh.UtilEvalError;
import com.microstar.xml.HandlerBase;
import com.microstar.xml.XmlException;
import com.microstar.xml.XmlParser;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.LayoutManager2;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import org.gjt.sp.jedit.ActionSet;
import org.gjt.sp.jedit.BeanShell;
import org.gjt.sp.jedit.EBComponent;
import org.gjt.sp.jedit.EBMessage;
import org.gjt.sp.jedit.EditAction;
import org.gjt.sp.jedit.EditBus;
import org.gjt.sp.jedit.PluginJAR;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.gui.DockableWindowContainer;
import org.gjt.sp.jedit.gui.FloatingWindowContainer;
import org.gjt.sp.jedit.gui.PanelWindowContainer;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.msg.DockableWindowUpdate;
import org.gjt.sp.jedit.msg.PluginUpdate;
import org.gjt.sp.jedit.msg.PropertiesChanged;
import org.gjt.sp.util.Log;

public class DockableWindowManager
extends JPanel
implements EBComponent {
    public static final String FLOATING = "floating";
    public static final String TOP = "top";
    public static final String LEFT = "left";
    public static final String BOTTOM = "bottom";
    public static final String RIGHT = "right";
    private static HashMap dockableWindowFactories = new HashMap();
    int resizePos;
    Rectangle resizeRect;
    private View view;
    private Hashtable windows;
    private boolean alternateLayout;
    private PanelWindowContainer left;
    private PanelWindowContainer right;
    private PanelWindowContainer top;
    private PanelWindowContainer bottom;
    private ArrayList clones;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadDockableWindows(PluginJAR pluginJAR, URL uRL, PluginJAR.PluginCacheEntry pluginCacheEntry) {
        Reader reader = null;
        try {
            Log.log(1, DockableWindowManager.class, "Loading dockables from " + uRL);
            DockableListHandler dockableListHandler = new DockableListHandler(pluginJAR, uRL);
            reader = new BufferedReader(new InputStreamReader(uRL.openStream()));
            XmlParser xmlParser = new XmlParser();
            xmlParser.setHandler(dockableListHandler);
            xmlParser.parse(null, null, reader);
            if (pluginCacheEntry != null) {
                pluginCacheEntry.cachedDockableNames = dockableListHandler.getCachedDockableNames();
                pluginCacheEntry.cachedDockableActionFlags = dockableListHandler.getCachedDockableActionFlags();
            }
        }
        catch (XmlException xmlException) {
            int n = xmlException.getLine();
            String string = xmlException.getMessage();
            Log.log(9, DockableWindowManager.class, uRL + ":" + n + ": " + string);
        }
        catch (Exception exception) {
            Log.log(9, DockableWindowManager.class, exception);
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException iOException) {
                Log.log(9, DockableWindowManager.class, iOException);
            }
        }
    }

    public static void unloadDockableWindows(PluginJAR pluginJAR) {
        Iterator iterator = dockableWindowFactories.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            Factory factory = (Factory)entry.getValue();
            if (factory.plugin != pluginJAR) continue;
            iterator.remove();
        }
    }

    public static void cacheDockableWindows(PluginJAR pluginJAR, String[] stringArray, boolean[] blArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            Factory factory = new Factory(pluginJAR, stringArray[i], null, blArray[i]);
            dockableWindowFactories.put(stringArray[i], factory);
        }
    }

    public static void registerDockableWindow(PluginJAR pluginJAR, String string, String string2, boolean bl) {
        Factory factory = (Factory)dockableWindowFactories.get(string);
        if (factory != null) {
            factory.code = string2;
            factory.loaded = true;
        } else {
            factory = new Factory(pluginJAR, string, string2, bl);
            dockableWindowFactories.put(string, factory);
        }
    }

    public static String[] getRegisteredDockableWindows() {
        String[] stringArray = new String[dockableWindowFactories.size()];
        Iterator iterator = dockableWindowFactories.values().iterator();
        int n = 0;
        while (iterator.hasNext()) {
            Factory factory = (Factory)iterator.next();
            stringArray[n++] = factory.name;
        }
        return stringArray;
    }

    public DockableWindowManager(View view, View.ViewConfig viewConfig) {
        this.setLayout(new DockableLayout());
        this.view = view;
        this.windows = new Hashtable();
        this.clones = new ArrayList();
        this.top = new PanelWindowContainer(this, TOP, viewConfig.topPos);
        this.left = new PanelWindowContainer(this, LEFT, viewConfig.leftPos);
        this.bottom = new PanelWindowContainer(this, BOTTOM, viewConfig.bottomPos);
        this.right = new PanelWindowContainer(this, RIGHT, viewConfig.rightPos);
        this.add("top-buttons", this.top.buttonPanel);
        this.add("left-buttons", this.left.buttonPanel);
        this.add("bottom-buttons", this.bottom.buttonPanel);
        this.add("right-buttons", this.right.buttonPanel);
        this.add(TOP, this.top.dockablePanel);
        this.add(LEFT, this.left.dockablePanel);
        this.add(BOTTOM, this.bottom.dockablePanel);
        this.add(RIGHT, this.right.dockablePanel);
    }

    public void init() {
        EditBus.addToBus(this);
        Iterator iterator = dockableWindowFactories.values().iterator();
        while (iterator.hasNext()) {
            this.addEntry((Factory)iterator.next());
        }
        this.propertiesChanged();
    }

    public View getView() {
        return this.view;
    }

    public JComponent floatDockableWindow(String string) {
        Entry entry = (Entry)this.windows.get(string);
        if (entry == null) {
            Log.log(9, this, "Unknown dockable window: " + string);
            return null;
        }
        Entry entry2 = new Entry(entry.factory, FLOATING);
        entry2.win = entry2.factory.createDockableWindow(this.view, FLOATING);
        if (entry2.win != null) {
            entry2.container = new FloatingWindowContainer(this, true);
            entry2.container.register(entry2);
            entry2.container.show(entry2);
        }
        this.clones.add(entry2);
        return entry2.win;
    }

    public void showDockableWindow(String string) {
        Entry entry = (Entry)this.windows.get(string);
        if (entry == null) {
            Log.log(9, this, "Unknown dockable window: " + string);
            return;
        }
        if (entry.win == null) {
            entry.win = entry.factory.createDockableWindow(this.view, entry.position);
        }
        if (entry.win != null) {
            if (entry.position.equals(FLOATING) && entry.container == null) {
                entry.container = new FloatingWindowContainer(this, this.view.isPlainView());
                entry.container.register(entry);
            }
            entry.container.show(entry);
        }
    }

    public void addDockableWindow(String string) {
        this.showDockableWindow(string);
    }

    public void hideDockableWindow(String string) {
        Entry entry = (Entry)this.windows.get(string);
        if (entry == null) {
            Log.log(9, this, "Unknown dockable window: " + string);
            return;
        }
        if (entry.win == null) {
            return;
        }
        entry.container.show(null);
    }

    public void removeDockableWindow(String string) {
        this.hideDockableWindow(string);
    }

    public void toggleDockableWindow(String string) {
        if (this.isDockableWindowVisible(string)) {
            this.removeDockableWindow(string);
        } else {
            this.addDockableWindow(string);
        }
    }

    public JComponent getDockableWindow(String string) {
        return this.getDockable(string);
    }

    public JComponent getDockable(String string) {
        Entry entry = (Entry)this.windows.get(string);
        if (entry == null || entry.win == null) {
            return null;
        }
        return entry.win;
    }

    public String getDockableTitle(String string) {
        String string2 = jEdit.getProperty(string + ".title");
        if (string2 == null) {
            return "NO TITLE PROPERTY: " + string;
        }
        return string2;
    }

    public boolean isDockableWindowVisible(String string) {
        Entry entry = (Entry)this.windows.get(string);
        if (entry == null || entry.win == null) {
            return false;
        }
        return entry.container.isVisible(entry);
    }

    public boolean isDockableWindowDocked(String string) {
        Entry entry = (Entry)this.windows.get(string);
        if (entry == null) {
            return false;
        }
        return !entry.position.equals(FLOATING);
    }

    public void closeCurrentArea() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                for (Component component = DockableWindowManager.this.view.getFocusOwner(); component != null; component = component.getParent()) {
                    if (!(component instanceof PanelWindowContainer.DockablePanel)) continue;
                    PanelWindowContainer panelWindowContainer = ((PanelWindowContainer.DockablePanel)component).getWindowContainer();
                    panelWindowContainer.show(null);
                    return;
                }
                DockableWindowManager.this.getToolkit().beep();
            }
        });
    }

    public void close() {
        EditBus.removeFromBus(this);
        for (Entry entry : this.windows.values()) {
            if (entry.win == null) continue;
            entry.container.unregister(entry);
        }
        for (Entry entry : this.clones) {
            if (entry.win == null) continue;
            entry.container.unregister(entry);
        }
    }

    public PanelWindowContainer getTopDockingArea() {
        return this.top;
    }

    public PanelWindowContainer getLeftDockingArea() {
        return this.left;
    }

    public PanelWindowContainer getBottomDockingArea() {
        return this.bottom;
    }

    public PanelWindowContainer getRightDockingArea() {
        return this.right;
    }

    public JPopupMenu createPopupMenu(final DockableWindowContainer dockableWindowContainer, final String string, final boolean bl) {
        JPopupMenu jPopupMenu = new JPopupMenu();
        if (string == null && dockableWindowContainer instanceof PanelWindowContainer) {
            ActionListener actionListener = new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    DockableWindowManager.this.showDockableWindow(actionEvent.getActionCommand());
                }
            };
            String[] stringArray = ((PanelWindowContainer)dockableWindowContainer).getDockables();
            for (int i = 0; i < stringArray.length; ++i) {
                String string2 = stringArray[i];
                JMenuItem jMenuItem = new JMenuItem(this.getDockableTitle(string2));
                jMenuItem.setActionCommand(string2);
                jMenuItem.addActionListener(actionListener);
                jPopupMenu.add(jMenuItem);
            }
        } else {
            Object object;
            String[] stringArray;
            JMenuItem jMenuItem = new JMenuItem(this.getDockableTitle(string));
            jMenuItem.setEnabled(false);
            jPopupMenu.add(jMenuItem);
            jPopupMenu.addSeparator();
            String string3 = jEdit.getProperty(string + ".dock-position", FLOATING);
            if (!bl) {
                stringArray = new String[]{FLOATING, TOP, LEFT, BOTTOM, RIGHT};
                for (int i = 0; i < stringArray.length; ++i) {
                    object = stringArray[i];
                    if (((String)object).equals(string3)) continue;
                    JMenuItem jMenuItem2 = new JMenuItem(jEdit.getProperty("view.docking.menu-" + (String)object));
                    jMenuItem2.addActionListener(new ActionListener((String)object){
                        final /* synthetic */ String val$pos;
                        {
                            this.val$pos = string2;
                        }

                        public void actionPerformed(ActionEvent actionEvent) {
                            jEdit.setProperty(string + ".dock-position", this.val$pos);
                            EditBus.send(new DockableWindowUpdate(DockableWindowManager.this, DockableWindowUpdate.PROPERTIES_CHANGED, null));
                            DockableWindowManager.this.showDockableWindow(string);
                        }
                    });
                    jPopupMenu.add(jMenuItem2);
                }
                jPopupMenu.addSeparator();
            }
            stringArray = new JMenuItem(jEdit.getProperty("view.docking.menu-clone"));
            stringArray.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    DockableWindowManager.this.floatDockableWindow(string);
                }
            });
            jPopupMenu.add((JMenuItem)stringArray);
            jPopupMenu.addSeparator();
            JMenuItem jMenuItem3 = new JMenuItem(jEdit.getProperty("view.docking.menu-close"));
            jMenuItem3.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (bl) {
                        ((FloatingWindowContainer)dockableWindowContainer).dispose();
                    } else {
                        DockableWindowManager.this.removeDockableWindow(string);
                    }
                }
            });
            jPopupMenu.add(jMenuItem3);
            if (!bl && !string3.equals(FLOATING)) {
                object = new JMenuItem(jEdit.getProperty("view.docking.menu-undock"));
                ((AbstractButton)object).addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        jEdit.setProperty(string + ".dock-position", DockableWindowManager.FLOATING);
                        EditBus.send(new DockableWindowUpdate(DockableWindowManager.this, DockableWindowUpdate.PROPERTIES_CHANGED, null));
                    }
                });
                jPopupMenu.add((JMenuItem)object);
            }
        }
        return jPopupMenu;
    }

    public void paintChildren(Graphics graphics) {
        super.paintChildren(graphics);
        if (this.resizeRect != null) {
            graphics.setColor(Color.darkGray);
            graphics.fillRect(this.resizeRect.x, this.resizeRect.y, this.resizeRect.width, this.resizeRect.height);
        }
    }

    public void handleMessage(EBMessage eBMessage) {
        block10: {
            block11: {
                block9: {
                    if (!(eBMessage instanceof DockableWindowUpdate)) break block9;
                    if (((DockableWindowUpdate)eBMessage).getWhat() != DockableWindowUpdate.PROPERTIES_CHANGED) break block10;
                    this.propertiesChanged();
                    break block10;
                }
                if (!(eBMessage instanceof PropertiesChanged)) break block11;
                this.propertiesChanged();
                break block10;
            }
            if (!(eBMessage instanceof PluginUpdate)) break block10;
            PluginUpdate pluginUpdate = (PluginUpdate)eBMessage;
            if (pluginUpdate.getWhat() == PluginUpdate.LOADED) {
                for (Factory factory : dockableWindowFactories.values()) {
                    if (factory.plugin != pluginUpdate.getPluginJAR()) continue;
                    this.addEntry(factory);
                }
                this.propertiesChanged();
            } else if (!pluginUpdate.isExiting()) {
                if (pluginUpdate.getWhat() == PluginUpdate.DEACTIVATED) {
                    Iterator iterator = this.getAllPluginEntries(pluginUpdate.getPluginJAR(), false);
                    while (iterator.hasNext()) {
                        Entry entry = (Entry)iterator.next();
                        if (entry.container == null) continue;
                        entry.container.remove(entry);
                    }
                } else if (pluginUpdate.getWhat() == PluginUpdate.UNLOADED) {
                    Iterator iterator = this.getAllPluginEntries(pluginUpdate.getPluginJAR(), true);
                    while (iterator.hasNext()) {
                        Entry entry = (Entry)iterator.next();
                        if (entry.container == null) continue;
                        entry.container.unregister(entry);
                        entry.win = null;
                        entry.container = null;
                    }
                }
            }
        }
    }

    void setResizePos(int n, PanelWindowContainer panelWindowContainer) {
        this.resizePos = n;
        if (n < 0) {
            n = 0;
        }
        Rectangle rectangle = new Rectangle(0, 0, 8, 8);
        if (panelWindowContainer == this.top) {
            n = Math.min(n, this.getHeight() - this.top.buttonPanel.getHeight() - this.bottom.dockablePanel.getHeight() - this.bottom.buttonPanel.getHeight() - 10);
            rectangle.x = this.top.dockablePanel.getX() + 1;
            rectangle.y = n + this.top.buttonPanel.getHeight() + 1;
            rectangle.width = this.top.dockablePanel.getWidth() - 2;
        } else if (panelWindowContainer == this.left) {
            n = Math.min(n, this.getWidth() - this.left.buttonPanel.getWidth() - this.right.dockablePanel.getWidth() - this.right.buttonPanel.getWidth() - 10);
            rectangle.x = n + this.left.buttonPanel.getWidth() + 1;
            rectangle.y = this.left.dockablePanel.getY() + 1;
            rectangle.height = this.left.dockablePanel.getHeight() - 2;
        } else if (panelWindowContainer == this.bottom) {
            n = Math.min(n, this.getHeight() - this.bottom.buttonPanel.getHeight() - this.top.dockablePanel.getHeight() - this.top.buttonPanel.getHeight() - 10);
            rectangle.x = this.bottom.dockablePanel.getX() + 1;
            rectangle.y = this.getHeight() - this.bottom.buttonPanel.getHeight() - n - 10 + 2;
            rectangle.width = this.bottom.dockablePanel.getWidth() - 2;
        } else if (panelWindowContainer == this.right) {
            n = Math.min(n, this.getWidth() - this.right.buttonPanel.getWidth() - this.left.dockablePanel.getWidth() - this.left.buttonPanel.getWidth() - 10);
            rectangle.x = this.getWidth() - this.right.buttonPanel.getWidth() - n - 10 + 1;
            rectangle.y = this.right.dockablePanel.getY() + 1;
            rectangle.height = this.right.dockablePanel.getHeight() - 2;
        }
        Rectangle rectangle2 = this.resizeRect == null ? rectangle : this.resizeRect.union(rectangle);
        this.resizeRect = rectangle;
        this.repaint(rectangle2);
    }

    void finishResizing() {
        this.resizeRect = null;
        this.repaint();
    }

    private void propertiesChanged() {
        if (this.view.isPlainView()) {
            return;
        }
        this.alternateLayout = jEdit.getBooleanProperty("view.docking.alternateLayout");
        String[] stringArray = DockableWindowManager.getRegisteredDockableWindows();
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            Entry entry = (Entry)this.windows.get(string);
            String string2 = jEdit.getProperty(string + ".dock-position", FLOATING);
            if (string2.equals(entry.position)) continue;
            entry.position = string2;
            if (entry.container != null) {
                entry.container.unregister(entry);
                entry.container = null;
                entry.win = null;
            }
            if (string2.equals(FLOATING)) continue;
            if (string2.equals(TOP)) {
                entry.container = this.top;
            } else if (string2.equals(LEFT)) {
                entry.container = this.left;
            } else if (string2.equals(BOTTOM)) {
                entry.container = this.bottom;
            } else if (string2.equals(RIGHT)) {
                entry.container = this.right;
            } else {
                Log.log(7, this, "Unknown position: " + string2);
                continue;
            }
            entry.container.register(entry);
        }
        this.top.sortDockables();
        this.left.sortDockables();
        this.bottom.sortDockables();
        this.right.sortDockables();
        this.revalidate();
        this.repaint();
    }

    private void addEntry(Factory factory) {
        Entry entry;
        if (this.view.isPlainView()) {
            entry = new Entry(factory, FLOATING);
        } else {
            entry = new Entry(factory);
            if (!entry.position.equals(FLOATING)) {
                if (entry.position.equals(TOP)) {
                    entry.container = this.top;
                } else if (entry.position.equals(LEFT)) {
                    entry.container = this.left;
                } else if (entry.position.equals(BOTTOM)) {
                    entry.container = this.bottom;
                } else if (entry.position.equals(RIGHT)) {
                    entry.container = this.right;
                } else {
                    Log.log(7, this, "Unknown position: " + entry.position);
                }
            }
            if (entry.container != null) {
                entry.container.register(entry);
            }
        }
        this.windows.put(factory.name, entry);
    }

    private Iterator getAllPluginEntries(PluginJAR pluginJAR, boolean bl) {
        Entry entry;
        LinkedList<Entry> linkedList = new LinkedList<Entry>();
        Iterator<Object> iterator = this.windows.values().iterator();
        while (iterator.hasNext()) {
            entry = (Entry)iterator.next();
            if (entry.factory.plugin != pluginJAR) continue;
            linkedList.add(entry);
            if (!bl) continue;
            iterator.remove();
        }
        iterator = this.clones.iterator();
        while (iterator.hasNext()) {
            entry = (Entry)iterator.next();
            if (entry.factory.plugin != pluginJAR) continue;
            linkedList.add(entry);
            iterator.remove();
        }
        return linkedList.iterator();
    }

    class Entry {
        Factory factory;
        String title;
        String position;
        DockableWindowContainer container;
        JComponent win;
        AbstractButton btn;

        Entry(Factory factory) {
            this(factory, jEdit.getProperty(factory.name + ".dock-position", DockableWindowManager.FLOATING));
        }

        Entry(Factory factory, String string) {
            this.factory = factory;
            this.position = string;
            this.title = DockableWindowManager.this.getDockableTitle(factory.name);
        }
    }

    public class DockableLayout
    implements LayoutManager2 {
        static final String CENTER = "Center";
        public static final String TOP_TOOLBARS = "top-toolbars";
        public static final String BOTTOM_TOOLBARS = "bottom-toolbars";
        static final String TOP_BUTTONS = "top-buttons";
        static final String LEFT_BUTTONS = "left-buttons";
        static final String BOTTOM_BUTTONS = "bottom-buttons";
        static final String RIGHT_BUTTONS = "right-buttons";
        Component topToolbars;
        Component bottomToolbars;
        Component center;
        Component top;
        Component left;
        Component bottom;
        Component right;
        Component topButtons;
        Component leftButtons;
        Component bottomButtons;
        Component rightButtons;

        public void addLayoutComponent(String string, Component component) {
            this.addLayoutComponent(component, string);
        }

        public void addLayoutComponent(Component component, Object object) {
            if (object == null || CENTER.equals(object)) {
                this.center = component;
            } else if (TOP_TOOLBARS.equals(object)) {
                this.topToolbars = component;
            } else if (BOTTOM_TOOLBARS.equals(object)) {
                this.bottomToolbars = component;
            } else if (DockableWindowManager.TOP.equals(object)) {
                this.top = component;
            } else if (DockableWindowManager.LEFT.equals(object)) {
                this.left = component;
            } else if (DockableWindowManager.BOTTOM.equals(object)) {
                this.bottom = component;
            } else if (DockableWindowManager.RIGHT.equals(object)) {
                this.right = component;
            } else if (TOP_BUTTONS.equals(object)) {
                this.topButtons = component;
            } else if (LEFT_BUTTONS.equals(object)) {
                this.leftButtons = component;
            } else if (BOTTOM_BUTTONS.equals(object)) {
                this.bottomButtons = component;
            } else if (RIGHT_BUTTONS.equals(object)) {
                this.rightButtons = component;
            }
        }

        public void removeLayoutComponent(Component component) {
            if (this.center == component) {
                this.center = null;
            }
            if (component == this.topToolbars) {
                this.topToolbars = null;
            }
            if (component == this.bottomToolbars) {
                this.bottomToolbars = null;
            }
        }

        public Dimension preferredLayoutSize(Container container) {
            Dimension dimension = new Dimension(0, 0);
            Dimension dimension2 = this.top.getPreferredSize();
            Dimension dimension3 = this.left.getPreferredSize();
            Dimension dimension4 = this.bottom.getPreferredSize();
            Dimension dimension5 = this.right.getPreferredSize();
            Dimension dimension6 = this.topButtons.getPreferredSize();
            Dimension dimension7 = this.leftButtons.getPreferredSize();
            Dimension dimension8 = this.bottomButtons.getPreferredSize();
            Dimension dimension9 = this.rightButtons.getPreferredSize();
            Dimension dimension10 = this.center == null ? new Dimension(0, 0) : this.center.getPreferredSize();
            Dimension dimension11 = this.topToolbars == null ? new Dimension(0, 0) : this.topToolbars.getPreferredSize();
            Dimension dimension12 = this.bottomToolbars == null ? new Dimension(0, 0) : this.bottomToolbars.getPreferredSize();
            dimension.height = dimension2.height + dimension4.height + dimension10.height + dimension6.height + dimension8.height + dimension11.height + dimension12.height;
            dimension.width = dimension3.width + dimension5.width + Math.max(dimension10.width, Math.max(dimension11.width, dimension12.width)) + dimension7.width + dimension9.width;
            return dimension;
        }

        public Dimension minimumLayoutSize(Container container) {
            return this.preferredLayoutSize(container);
        }

        public Dimension maximumLayoutSize(Container container) {
            return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
        }

        public void layoutContainer(Container container) {
            Dimension dimension = container.getSize();
            Dimension dimension2 = this.topToolbars == null ? new Dimension(0, 0) : this.topToolbars.getPreferredSize();
            Dimension dimension3 = this.bottomToolbars == null ? new Dimension(0, 0) : this.bottomToolbars.getPreferredSize();
            int n = -1;
            int n2 = -1;
            int n3 = -1;
            int n4 = -1;
            Dimension dimension4 = this.top.getPreferredSize();
            Dimension dimension5 = this.left.getPreferredSize();
            Dimension dimension6 = this.bottom.getPreferredSize();
            Dimension dimension7 = this.right.getPreferredSize();
            int n5 = dimension4.height;
            int n6 = dimension6.height;
            int n7 = dimension5.width;
            int n8 = dimension7.width;
            boolean bl = ((Container)this.topButtons).getComponentCount() <= 2;
            boolean bl2 = ((Container)this.leftButtons).getComponentCount() <= 2;
            boolean bl3 = ((Container)this.bottomButtons).getComponentCount() <= 2;
            boolean bl4 = ((Container)this.rightButtons).getComponentCount() <= 2;
            Dimension dimension8 = ((Container)this.topButtons).getComponentCount() == 0 ? new Dimension(0, 0) : ((Container)this.topButtons).getComponent(0).getPreferredSize();
            int n9 = Math.max(dimension8.width, dimension8.height) + 1;
            if (DockableWindowManager.this.alternateLayout) {
                int n10 = dimension.width;
                int n11 = bl2 && bl4 ? 0 : n9;
                n = DockableWindowManager.this.top.getWrappedDimension(n10 - n9 * 2);
                this.topButtons.setBounds(n11, 0, dimension.width - n11 * 2, n);
                n2 = DockableWindowManager.this.bottom.getWrappedDimension(n10);
                this.bottomButtons.setBounds(n11, dimension.height - n2, dimension.width - n11 * 2, n2);
                int n12 = dimension.height - n - n2;
                n3 = DockableWindowManager.this.left.getWrappedDimension(n12);
                this.leftButtons.setBounds(0, n5 + n, n3, n12 - n5 - n6);
                n4 = DockableWindowManager.this.right.getWrappedDimension(n12);
                this.rightButtons.setBounds(dimension.width - n4, n5 + n, n4, n12 - n5 - n6);
                int[] nArray = this.adjustDockingAreasToFit(dimension, n5, n7, n6, n8, n, n3, n2, n4, dimension2, dimension3);
                n5 = nArray[0];
                n7 = nArray[1];
                n6 = nArray[2];
                n8 = nArray[3];
                this.top.setBounds(0, n, dimension.width, n5);
                this.bottom.setBounds(0, dimension.height - n6 - n2, dimension.width, n6);
                this.left.setBounds(n3, n + n5, n7, n12 - n5 - n6);
                this.right.setBounds(n10 - n4 - n8, n + n5, n8, n12 - n5 - n6);
            } else {
                int n13 = dimension.height;
                int n14 = bl && bl3 ? 0 : n9;
                n3 = DockableWindowManager.this.left.getWrappedDimension(n13 - n9 * 2);
                this.leftButtons.setBounds(0, n14, n3, n13 - n14 * 2);
                n4 = DockableWindowManager.this.right.getWrappedDimension(n13);
                this.rightButtons.setBounds(dimension.width - n4, n14, n4, n13 - n14 * 2);
                int n15 = dimension.width - n3 - n4;
                n = DockableWindowManager.this.top.getWrappedDimension(n15);
                this.topButtons.setBounds(n3 + n7, 0, n15 - n7 - n8, n);
                n2 = DockableWindowManager.this.bottom.getWrappedDimension(n15);
                this.bottomButtons.setBounds(n3 + n7, n13 - n2, n15 - n7 - n8, n2);
                int[] nArray = this.adjustDockingAreasToFit(dimension, n5, n7, n6, n8, n, n3, n2, n4, dimension2, dimension3);
                n5 = nArray[0];
                n7 = nArray[1];
                n6 = nArray[2];
                n8 = nArray[3];
                this.top.setBounds(n3 + n7, n, n15 - n7 - n8, n5);
                this.bottom.setBounds(n3 + n7, dimension.height - n6 - n2, n15 - n7 - n8, n6);
                this.left.setBounds(n3, 0, n7, n13);
                this.right.setBounds(dimension.width - n8 - n4, 0, n8, n13);
            }
            if (this.topToolbars != null) {
                this.topToolbars.setBounds(n3 + n7, n + n5, dimension.width - n7 - n8 - n3 - n4, dimension2.height);
            }
            if (this.bottomToolbars != null) {
                this.bottomToolbars.setBounds(n3 + n7, dimension.height - n6 - n2 - dimension3.height + n + n5, dimension.width - n7 - n8 - n3 - n4, dimension3.height);
            }
            if (this.center != null) {
                this.center.setBounds(n3 + n7, n + n5 + dimension2.height, dimension.width - n7 - n8 - n3 - n4, dimension.height - n5 - n - n6 - n2 - dimension2.height - dimension3.height);
            }
        }

        private int[] adjustDockingAreasToFit(Dimension dimension, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, Dimension dimension2, Dimension dimension3) {
            int n9 = dimension.height - n3 - n5 - n7 - dimension2.height - dimension3.height;
            n = Math.min(Math.max(0, n9), n);
            n2 = Math.min(Math.max(0, dimension.width - n6 - n8 - n4), n2);
            int n10 = dimension.height - n - n5 - n7 - dimension2.height - dimension3.height;
            n3 = Math.min(Math.max(0, n10), n3);
            n4 = Math.min(Math.max(0, dimension.width - n6 - n8 - n2), n4);
            DockableWindowManager.this.top.setDimension(n);
            DockableWindowManager.this.left.setDimension(n2);
            DockableWindowManager.this.bottom.setDimension(n3);
            DockableWindowManager.this.right.setDimension(n4);
            return new int[]{n, n2, n3, n4};
        }

        public float getLayoutAlignmentX(Container container) {
            return 0.5f;
        }

        public float getLayoutAlignmentY(Container container) {
            return 0.5f;
        }

        public void invalidateLayout(Container container) {
        }
    }

    static class Factory {
        PluginJAR plugin;
        String name;
        String code;
        boolean loaded;

        Factory(PluginJAR pluginJAR, String string, String string2, boolean bl) {
            this.plugin = pluginJAR;
            this.name = string;
            this.code = string2;
            if (string2 != null) {
                this.loaded = true;
            }
            if (bl) {
                ActionSet actionSet = pluginJAR == null ? jEdit.getBuiltInActionSet() : pluginJAR.getActionSet();
                actionSet.addAction(new OpenAction(string));
                actionSet.addAction(new ToggleAction(string));
                actionSet.addAction(new FloatAction(string));
                String string3 = jEdit.getProperty(string + ".label");
                if (string3 == null) {
                    string3 = "NO LABEL PROPERTY: " + string;
                }
                Object[] objectArray = new String[]{string3};
                jEdit.setTemporaryProperty(string + ".label", string3);
                jEdit.setTemporaryProperty(string + "-toggle.label", jEdit.getProperty("view.docking.toggle.label", objectArray));
                jEdit.setTemporaryProperty(string + "-toggle.toggle", "true");
                jEdit.setTemporaryProperty(string + "-float.label", jEdit.getProperty("view.docking.float.label", objectArray));
            }
        }

        void load() {
            if (this.loaded) {
                return;
            }
            DockableWindowManager.loadDockableWindows(this.plugin, this.plugin.getDockablesURI(), null);
        }

        JComponent createDockableWindow(View view, String string) {
            this.load();
            if (!this.loaded) {
                Log.log(7, this, "Outdated cache");
                return null;
            }
            NameSpace nameSpace = new NameSpace(BeanShell.getNameSpace(), "DockableWindowManager.Factory.createDockableWindow()");
            try {
                nameSpace.setVariable("position", string);
            }
            catch (UtilEvalError utilEvalError) {
                Log.log(9, this, utilEvalError);
            }
            JComponent jComponent = (JComponent)BeanShell.eval(view, nameSpace, this.code);
            return jComponent;
        }

        static class FloatAction
        extends EditAction {
            private String dockable;

            FloatAction(String string) {
                super(string + "-float");
                this.dockable = string;
            }

            public void invoke(View view) {
                view.getDockableWindowManager().floatDockableWindow(this.dockable);
            }

            public String getCode() {
                return "view.getDockableWindowManager().floatDockableWindow(\"" + this.dockable + "\");";
            }
        }

        static class ToggleAction
        extends EditAction {
            private String dockable;

            ToggleAction(String string) {
                super(string + "-toggle");
                this.dockable = string;
            }

            public void invoke(View view) {
                view.getDockableWindowManager().toggleDockableWindow(this.dockable);
            }

            public boolean isSelected(View view) {
                return view.getDockableWindowManager().isDockableWindowVisible(this.dockable);
            }

            public String getCode() {
                return "view.getDockableWindowManager().toggleDockableWindow(\"" + this.dockable + "\");";
            }
        }

        static class OpenAction
        extends EditAction {
            private String dockable;

            OpenAction(String string) {
                super(string);
                this.dockable = string;
            }

            public void invoke(View view) {
                view.getDockableWindowManager().showDockableWindow(this.dockable);
            }

            public String getCode() {
                return "view.getDockableWindowManager().showDockableWindow(\"" + this.dockable + "\");";
            }
        }
    }

    static class DockableListHandler
    extends HandlerBase {
        private PluginJAR plugin;
        private URL uri;
        private List cachedDockableNames;
        private List cachedDockableActionFlags;
        private String dockableName;
        private String code;
        private boolean actions;
        private Stack stateStack;

        DockableListHandler(PluginJAR pluginJAR, URL uRL) {
            this.plugin = pluginJAR;
            this.uri = uRL;
            this.stateStack = new Stack();
            this.actions = true;
            this.cachedDockableNames = new LinkedList();
            this.cachedDockableActionFlags = new LinkedList();
        }

        public Object resolveEntity(String string, String string2) {
            if ("dockables.dtd".equals(string2)) {
                return new StringReader("<!-- -->");
            }
            return null;
        }

        public void attribute(String string, String string2, boolean bl) {
            string = string == null ? null : string.intern();
            String string3 = string2 = string2 == null ? null : string2.intern();
            if (string == "NAME") {
                this.dockableName = string2;
            } else if (string == "NO_ACTIONS") {
                this.actions = string2 == "FALSE";
            }
        }

        public void doctypeDecl(String string, String string2, String string3) throws Exception {
            if ("DOCKABLES".equals(string)) {
                return;
            }
            Log.log(9, this, this.uri + ": DOCTYPE must be DOCKABLES");
        }

        public void charData(char[] cArray, int n, int n2) {
            String string = this.peekElement();
            String string2 = new String(cArray, n, n2);
            if (string == "DOCKABLE") {
                this.code = string2;
            }
        }

        public void startElement(String string) {
            string = this.pushElement(string);
        }

        public void endElement(String string) {
            if (string == null) {
                return;
            }
            String string2 = this.peekElement();
            if (string.equals(string2)) {
                if (string2 == "DOCKABLE") {
                    DockableWindowManager.registerDockableWindow(this.plugin, this.dockableName, this.code, this.actions);
                    this.cachedDockableNames.add(this.dockableName);
                    this.cachedDockableActionFlags.add(new Boolean(this.actions));
                    this.actions = true;
                }
            } else {
                throw new InternalError();
            }
            this.popElement();
        }

        public void startDocument() {
            try {
                this.pushElement(null);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }

        public String[] getCachedDockableNames() {
            return this.cachedDockableNames.toArray(new String[this.cachedDockableNames.size()]);
        }

        public boolean[] getCachedDockableActionFlags() {
            boolean[] blArray = new boolean[this.cachedDockableActionFlags.size()];
            Iterator iterator = this.cachedDockableActionFlags.iterator();
            int n = 0;
            while (iterator.hasNext()) {
                boolean bl = (Boolean)iterator.next();
                blArray[n++] = bl;
            }
            return blArray;
        }

        private String pushElement(String string) {
            string = string == null ? null : string.intern();
            this.stateStack.push(string);
            return string;
        }

        private String peekElement() {
            return (String)this.stateStack.peek();
        }

        private String popElement() {
            return (String)this.stateStack.pop();
        }
    }
}

