/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.border.EmptyBorder;
import org.gjt.sp.jedit.gui.ErrorListDialog;

class ErrorListCellRenderer
extends JComponent
implements ListCellRenderer {
    private String path;
    private String[] messages;
    private Font plainFont = new JLabel().getFont();
    private Font boldFont = new Font(this.plainFont.getName(), 1, this.plainFont.getSize());
    private FontMetrics plainFM = this.getFontMetrics(this.plainFont);
    private FontMetrics boldFM = this.getFontMetrics(this.boldFont);

    ErrorListCellRenderer() {
        this.setBorder(new EmptyBorder(2, 2, 2, 2));
    }

    public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
        ErrorListDialog.ErrorEntry errorEntry = (ErrorListDialog.ErrorEntry)object;
        this.path = errorEntry.path + ":";
        this.messages = errorEntry.messages;
        return this;
    }

    public Dimension getPreferredSize() {
        int n = this.boldFM.stringWidth(this.path);
        int n2 = this.boldFM.getHeight();
        for (int i = 0; i < this.messages.length; ++i) {
            n = Math.max(this.plainFM.stringWidth(this.messages[i]), n);
            n2 += this.plainFM.getHeight();
        }
        Insets insets = this.getBorder().getBorderInsets(this);
        return new Dimension(n += insets.left + insets.right, n2 += insets.top + insets.bottom);
    }

    public void paintComponent(Graphics graphics) {
        Insets insets = this.getBorder().getBorderInsets(this);
        graphics.setFont(this.boldFont);
        graphics.drawString(this.path, insets.left, insets.top + this.boldFM.getAscent());
        int n = insets.top + this.boldFM.getHeight() + 2;
        graphics.setFont(this.plainFont);
        for (int i = 0; i < this.messages.length; ++i) {
            graphics.drawString(this.messages[i], insets.left, n + this.plainFM.getAscent());
            n += this.plainFM.getHeight();
        }
    }
}

