/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.gjt.sp.jedit.gui.EnhancedDialog;
import org.gjt.sp.jedit.gui.FontSelector;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.util.Log;

class FontSelectorDialog
extends EnhancedDialog {
    private FontSelector fontSelector;
    private boolean isOK;
    private JTextField familyField;
    private JList familyList;
    private JTextField sizeField;
    private JList sizeList;
    private JTextField styleField;
    private JList styleList;
    private JLabel preview;
    private JButton ok;
    private JButton cancel;
    private static final String[] HIDEFONTS = new String[]{".bold", ".italic"};

    public FontSelectorDialog(Frame frame, Font font) {
        super(frame, jEdit.getProperty("font-selector.title"), true);
        this.init(font);
    }

    public FontSelectorDialog(Dialog dialog, Font font) {
        super(dialog, jEdit.getProperty("font-selector.title"), true);
        this.init(font);
    }

    public FontSelectorDialog(Frame frame, Font font, FontSelector fontSelector) {
        super(frame, jEdit.getProperty("font-selector.title"), true);
        this.fontSelector = fontSelector;
        this.init(font);
    }

    public FontSelectorDialog(Dialog dialog, Font font, FontSelector fontSelector) {
        super(dialog, jEdit.getProperty("font-selector.title"), true);
        this.fontSelector = fontSelector;
        this.init(font);
    }

    public void ok() {
        this.isOK = true;
        this.dispose();
    }

    public void cancel() {
        this.dispose();
    }

    public Font getSelectedFont() {
        int n;
        if (!this.isOK) {
            return null;
        }
        try {
            n = Integer.parseInt(this.sizeField.getText());
        }
        catch (Exception exception) {
            n = 12;
        }
        return new Font(this.familyField.getText(), this.styleList.getSelectedIndex(), n);
    }

    private void init(Font font) {
        String[] stringArray;
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(new EmptyBorder(12, 12, 12, 12));
        this.setContentPane(jPanel);
        JPanel jPanel2 = new JPanel(new GridLayout(1, 3, 6, 6));
        try {
            stringArray = this.getFontList();
        }
        catch (Exception exception) {
            Log.log(9, this, "Broken Java implementation!");
            Log.log(9, this, exception);
            stringArray = new String[]{"Broken Java implementation!"};
        }
        this.familyField = new JTextField();
        this.familyList = new JList<String>(stringArray);
        JPanel jPanel3 = this.createTextFieldAndListPanel("font-selector.family", this.familyField, this.familyList);
        jPanel2.add(jPanel3);
        String[] stringArray2 = new String[]{"9", "10", "12", "14", "16", "18", "24"};
        this.sizeField = new JTextField();
        this.sizeList = new JList<String>(stringArray2);
        JPanel jPanel4 = this.createTextFieldAndListPanel("font-selector.size", this.sizeField, this.sizeList);
        jPanel2.add(jPanel4);
        String[] stringArray3 = new String[]{jEdit.getProperty("font-selector.plain"), jEdit.getProperty("font-selector.bold"), jEdit.getProperty("font-selector.italic"), jEdit.getProperty("font-selector.bolditalic")};
        this.styleField = new JTextField();
        this.styleList = new JList<String>(stringArray3);
        JPanel jPanel5 = this.createTextFieldAndListPanel("font-selector.style", this.styleField, this.styleList);
        this.styleField.setEditable(false);
        jPanel2.add(jPanel5);
        this.familyList.setSelectedValue(font.getFamily(), true);
        this.familyField.setText(font.getFamily());
        this.sizeList.setSelectedValue(String.valueOf(font.getSize()), true);
        this.sizeField.setText(String.valueOf(font.getSize()));
        this.styleList.setSelectedIndex(font.getStyle());
        this.styleField.setText((String)this.styleList.getSelectedValue());
        ListHandler listHandler = new ListHandler();
        this.familyList.addListSelectionListener(listHandler);
        this.sizeList.addListSelectionListener(listHandler);
        this.styleList.addListSelectionListener(listHandler);
        jPanel.add("North", jPanel2);
        this.preview = new JLabel(jEdit.getProperty("font-selector.long-text")){

            public void paintComponent(Graphics graphics) {
                if (FontSelectorDialog.this.fontSelector != null) {
                    FontSelectorDialog.this.fontSelector.setAntiAliasEnabled(graphics);
                }
                super.paintComponent(graphics);
            }
        };
        this.preview.setBorder(new TitledBorder(jEdit.getProperty("font-selector.preview")));
        this.updatePreview();
        Dimension dimension = this.preview.getPreferredSize();
        dimension.height = 50;
        this.preview.setPreferredSize(dimension);
        jPanel.add("Center", this.preview);
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout(new BoxLayout(jPanel6, 0));
        jPanel6.setBorder(new EmptyBorder(12, 0, 0, 0));
        jPanel6.add(Box.createGlue());
        this.ok = new JButton(jEdit.getProperty("common.ok"));
        this.ok.addActionListener(new ActionHandler());
        this.getRootPane().setDefaultButton(this.ok);
        jPanel6.add(this.ok);
        jPanel6.add(Box.createHorizontalStrut(6));
        this.cancel = new JButton(jEdit.getProperty("common.cancel"));
        this.cancel.addActionListener(new ActionHandler());
        jPanel6.add(this.cancel);
        jPanel6.add(Box.createGlue());
        jPanel.add("South", jPanel6);
        this.pack();
        this.setLocationRelativeTo(this.getParent());
        this.setVisible(true);
    }

    private String[] getFontList() {
        String[] stringArray = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
        Vector<String> vector = new Vector<String>(stringArray.length);
        for (int i = 0; i < stringArray.length; ++i) {
            int n;
            for (n = 0; n < HIDEFONTS.length && stringArray[i].indexOf(HIDEFONTS[n]) < 0; ++n) {
            }
            if (n != HIDEFONTS.length) continue;
            vector.addElement(stringArray[i]);
        }
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    private JPanel createTextFieldAndListPanel(String string, JTextField jTextField, JList jList) {
        GridBagLayout gridBagLayout = new GridBagLayout();
        JPanel jPanel = new JPanel(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        JLabel jLabel = new JLabel(jEdit.getProperty(string));
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel.add(jLabel);
        gridBagConstraints.gridy = 1;
        Component component = Box.createVerticalStrut(6);
        gridBagLayout.setConstraints(component, gridBagConstraints);
        jPanel.add(component);
        gridBagConstraints.gridy = 2;
        gridBagLayout.setConstraints(jTextField, gridBagConstraints);
        jPanel.add(jTextField);
        gridBagConstraints.gridy = 3;
        component = Box.createVerticalStrut(6);
        gridBagLayout.setConstraints(component, gridBagConstraints);
        jPanel.add(component);
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.weighty = 1.0;
        JScrollPane jScrollPane = new JScrollPane(jList);
        gridBagLayout.setConstraints(jScrollPane, gridBagConstraints);
        jPanel.add(jScrollPane);
        return jPanel;
    }

    private void updatePreview() {
        int n;
        String string = this.familyField.getText();
        try {
            n = Integer.parseInt(this.sizeField.getText());
        }
        catch (Exception exception) {
            n = 12;
        }
        int n2 = this.styleList.getSelectedIndex();
        this.preview.setFont(new Font(string, n2, n));
    }

    class ListHandler
    implements ListSelectionListener {
        ListHandler() {
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            String string;
            Object object = listSelectionEvent.getSource();
            if (object == FontSelectorDialog.this.familyList) {
                String string2 = (String)FontSelectorDialog.this.familyList.getSelectedValue();
                if (string2 != null) {
                    FontSelectorDialog.this.familyField.setText(string2);
                }
            } else if (object == FontSelectorDialog.this.sizeList) {
                String string3 = (String)FontSelectorDialog.this.sizeList.getSelectedValue();
                if (string3 != null) {
                    FontSelectorDialog.this.sizeField.setText(string3);
                }
            } else if (object == FontSelectorDialog.this.styleList && (string = (String)FontSelectorDialog.this.styleList.getSelectedValue()) != null) {
                FontSelectorDialog.this.styleField.setText(string);
            }
            FontSelectorDialog.this.updatePreview();
        }
    }

    class ActionHandler
    implements ActionListener {
        ActionHandler() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == FontSelectorDialog.this.ok) {
                FontSelectorDialog.this.ok();
            } else if (actionEvent.getSource() == FontSelectorDialog.this.cancel) {
                FontSelectorDialog.this.cancel();
            }
        }
    }
}

