/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.help;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.PluginJAR;
import org.gjt.sp.jedit.io.VFSManager;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.util.Log;

class HelpIndex {
    private static Object IGNORE = new Object();
    private HashMap words = new HashMap();
    private ArrayList files = new ArrayList();

    public HelpIndex() {
        this.ignoreWord("a");
        this.ignoreWord("an");
        this.ignoreWord("and");
        this.ignoreWord("are");
        this.ignoreWord("as");
        this.ignoreWord("be");
        this.ignoreWord("by");
        this.ignoreWord("can");
        this.ignoreWord("do");
        this.ignoreWord("for");
        this.ignoreWord("from");
        this.ignoreWord("how");
        this.ignoreWord("i");
        this.ignoreWord("if");
        this.ignoreWord("in");
        this.ignoreWord("is");
        this.ignoreWord("it");
        this.ignoreWord("not");
        this.ignoreWord("of");
        this.ignoreWord("on");
        this.ignoreWord("or");
        this.ignoreWord("s");
        this.ignoreWord("that");
        this.ignoreWord("the");
        this.ignoreWord("this");
        this.ignoreWord("to");
        this.ignoreWord("will");
        this.ignoreWord("with");
        this.ignoreWord("you");
    }

    public void indexEditorHelp() {
        PluginJAR[] pluginJARArray;
        try {
            pluginJARArray = jEdit.getJEditHome();
            if (pluginJARArray != null) {
                this.indexDirectory(MiscUtilities.constructPath((String)pluginJARArray, "doc", "users-guide"));
                this.indexDirectory(MiscUtilities.constructPath((String)pluginJARArray, "doc", "FAQ"));
                this.indexDirectory(MiscUtilities.constructPath((String)pluginJARArray, "doc", "news42"));
            }
        }
        catch (Throwable throwable) {
            Log.log(9, this, "Error indexing editor help");
            Log.log(9, this, throwable);
        }
        pluginJARArray = jEdit.getPluginJARs();
        for (int i = 0; i < pluginJARArray.length; ++i) {
            try {
                this.indexJAR(pluginJARArray[i].getZipFile());
                continue;
            }
            catch (Throwable throwable) {
                Log.log(9, this, "Error indexing JAR: " + pluginJARArray[i].getPath());
                Log.log(9, this, throwable);
            }
        }
        Log.log(1, this, "Indexed " + this.words.size() + " words");
    }

    public void indexDirectory(String string) throws Exception {
        String[] stringArray = VFSManager.getFileVFS()._listDirectory(null, string, "*.{html,txt}", true, null);
        for (int i = 0; i < stringArray.length; ++i) {
            this.indexURL(stringArray[i]);
        }
    }

    public void indexJAR(ZipFile zipFile) throws Exception {
        Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
        while (enumeration.hasMoreElements()) {
            ZipEntry zipEntry = enumeration.nextElement();
            String string = zipEntry.getName();
            String string2 = string.toLowerCase();
            if (!string2.endsWith(".html")) continue;
            String string3 = "jeditresource:/" + MiscUtilities.getFileName(zipFile.getName()) + "!/" + string;
            Log.log(1, this, string3);
            this.indexStream(zipFile.getInputStream(zipEntry), string3);
        }
    }

    public void indexURL(String string) throws Exception {
        InputStream inputStream;
        if (MiscUtilities.isURL(string)) {
            inputStream = new URL(string).openStream();
        } else {
            inputStream = new FileInputStream(string);
            string = "file:" + string;
        }
        this.indexStream(inputStream, string);
    }

    public Word lookupWord(String string) {
        Object v = this.words.get(string);
        if (v == IGNORE) {
            return null;
        }
        return (Word)v;
    }

    public HelpFile getFile(int n) {
        return (HelpFile)this.files.get(n);
    }

    private void ignoreWord(String string) {
        this.words.put(string, IGNORE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void indexStream(InputStream inputStream, String string) throws Exception {
        HelpFile helpFile = new HelpFile(string);
        this.files.add(helpFile);
        int n = this.files.size() - 1;
        StringBuffer stringBuffer = new StringBuffer();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        try {
            int n2;
            StringBuffer stringBuffer2 = new StringBuffer();
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = false;
            while ((n2 = bufferedReader.read()) != -1) {
                char c = (char)n2;
                if (bl) {
                    if (c == '>') {
                        if (stringBuffer2.toString().equals("title")) {
                            bl3 = true;
                        }
                        bl = false;
                        stringBuffer2.setLength(0);
                        continue;
                    }
                    stringBuffer2.append(c);
                    continue;
                }
                if (bl2) {
                    if (c != ';') continue;
                    bl2 = false;
                    continue;
                }
                if (c == '<') {
                    if (bl3) {
                        bl3 = false;
                    }
                    if (stringBuffer2.length() != 0) {
                        this.addWord(stringBuffer2.toString(), n, bl3);
                        stringBuffer2.setLength(0);
                    }
                    bl = true;
                    continue;
                }
                if (c == '&') {
                    bl2 = true;
                    continue;
                }
                if (bl3) {
                    stringBuffer.append(c);
                    continue;
                }
                if (!Character.isLetterOrDigit(c)) {
                    if (stringBuffer2.length() == 0) continue;
                    this.addWord(stringBuffer2.toString(), n, bl3);
                    stringBuffer2.setLength(0);
                    continue;
                }
                stringBuffer2.append(c);
            }
            Object var14_13 = null;
        }
        catch (Throwable throwable) {
            Object var14_14 = null;
            bufferedReader.close();
            throw throwable;
        }
        bufferedReader.close();
        helpFile.title = stringBuffer.length() == 0 ? string : stringBuffer.toString();
    }

    private void addWord(String string, int n, boolean bl) {
        Object v = this.words.get(string = string.toLowerCase());
        if (v == IGNORE) {
            return;
        }
        if (v == null) {
            this.words.put(string, new Word(string, n, bl));
        } else {
            ((Word)v).addOccurrence(n, bl);
        }
    }

    static class HelpFile {
        String file;
        String title;

        HelpFile(String string) {
            this.file = string;
        }

        public String toString() {
            return this.title;
        }

        public boolean equals(Object object) {
            if (object instanceof HelpFile) {
                return ((HelpFile)object).file.equals(this.file);
            }
            return false;
        }
    }

    static class Word {
        static final int TITLE_OCCUR = 10;
        String word;
        int occurCount = 0;
        Occurrence[] occurrences;

        Word(String string, int n, boolean bl) {
            this.word = string;
            this.occurrences = new Occurrence[5];
            this.addOccurrence(n, bl);
        }

        void addOccurrence(int n, boolean bl) {
            for (int i = 0; i < this.occurCount; ++i) {
                if (this.occurrences[i].file != n) continue;
                this.occurrences[i].count = this.occurrences[i].count + (bl ? 10 : 1);
                return;
            }
            if (this.occurCount >= this.occurrences.length) {
                Occurrence[] occurrenceArray = new Occurrence[this.occurrences.length * 2];
                System.arraycopy(this.occurrences, 0, occurrenceArray, 0, this.occurCount);
                this.occurrences = occurrenceArray;
            }
            this.occurrences[this.occurCount++] = new Occurrence(n, bl);
        }

        static class Occurrence {
            int file;
            int count;

            Occurrence(int n, boolean bl) {
                this.file = n;
                this.count = bl ? 10 : 1;
            }
        }
    }
}

