/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.help;

import com.microstar.xml.HandlerBase;
import com.microstar.xml.XmlException;
import com.microstar.xml.XmlParser;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.Stack;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.border.EmptyBorder;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import org.gjt.sp.jedit.EditPlugin;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.OperatingSystem;
import org.gjt.sp.jedit.browser.FileCellRenderer;
import org.gjt.sp.jedit.help.HelpViewer;
import org.gjt.sp.jedit.io.VFSManager;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.util.Log;

class HelpTOCPanel
extends JPanel {
    private HelpViewer helpViewer;
    private DefaultTreeModel tocModel;
    private DefaultMutableTreeNode tocRoot;
    private JTree toc;
    private Hashtable nodes;

    HelpTOCPanel(HelpViewer helpViewer) {
        super(new BorderLayout());
        this.helpViewer = helpViewer;
        this.nodes = new Hashtable();
        this.toc = new TOCTree();
        if (!OperatingSystem.isMacOSLF()) {
            this.toc.putClientProperty("JTree.lineStyle", "Angled");
        }
        this.toc.setCellRenderer(new TOCCellRenderer());
        this.toc.setEditable(false);
        this.toc.setShowsRootHandles(true);
        this.add("Center", new JScrollPane(this.toc));
        this.load();
    }

    void selectNode(String string) {
        if (this.tocModel == null) {
            return;
        }
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.nodes.get(string);
        if (defaultMutableTreeNode == null) {
            return;
        }
        TreePath treePath = new TreePath(this.tocModel.getPathToRoot(defaultMutableTreeNode));
        this.toc.expandPath(treePath);
        this.toc.setSelectionPath(treePath);
        this.toc.scrollPathToVisible(treePath);
    }

    void load() {
        DefaultTreeModel defaultTreeModel = new DefaultTreeModel(new DefaultMutableTreeNode(jEdit.getProperty("helpviewer.toc.loading")));
        this.toc.setModel(defaultTreeModel);
        this.toc.setRootVisible(true);
        VFSManager.runInWorkThread(new Runnable(){

            public void run() {
                HelpTOCPanel.this.createTOC();
                HelpTOCPanel.this.tocModel.reload(HelpTOCPanel.this.tocRoot);
                HelpTOCPanel.this.toc.setModel(HelpTOCPanel.this.tocModel);
                HelpTOCPanel.this.toc.setRootVisible(false);
                for (int i = 0; i < HelpTOCPanel.this.tocRoot.getChildCount(); ++i) {
                    DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)HelpTOCPanel.this.tocRoot.getChildAt(i);
                    HelpTOCPanel.this.toc.expandPath(new TreePath(defaultMutableTreeNode.getPath()));
                }
                if (HelpTOCPanel.this.helpViewer.getShortURL() != null) {
                    HelpTOCPanel.this.selectNode(HelpTOCPanel.this.helpViewer.getShortURL());
                }
            }
        });
    }

    private DefaultMutableTreeNode createNode(String string, String string2) {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(new HelpNode(string, string2), true);
        this.nodes.put(string, defaultMutableTreeNode);
        return defaultMutableTreeNode;
    }

    private void createTOC() {
        EditPlugin[] editPluginArray = jEdit.getPlugins();
        Arrays.sort(editPluginArray, new PluginCompare());
        this.tocRoot = new DefaultMutableTreeNode();
        this.tocRoot.add(this.createNode("welcome.html", jEdit.getProperty("helpviewer.toc.welcome")));
        this.tocRoot.add(this.createNode("README.txt", jEdit.getProperty("helpviewer.toc.readme")));
        this.tocRoot.add(this.createNode("CHANGES.txt", jEdit.getProperty("helpviewer.toc.changes")));
        this.tocRoot.add(this.createNode("TODO.txt", jEdit.getProperty("helpviewer.toc.todo")));
        this.tocRoot.add(this.createNode("COPYING.txt", jEdit.getProperty("helpviewer.toc.copying")));
        this.tocRoot.add(this.createNode("COPYING.DOC.txt", jEdit.getProperty("helpviewer.toc.copying-doc")));
        this.tocRoot.add(this.createNode("Apache.LICENSE.txt", jEdit.getProperty("helpviewer.toc.copying-apache")));
        this.tocRoot.add(this.createNode("COPYING.PLUGINS.txt", jEdit.getProperty("helpviewer.toc.copying-plugins")));
        this.loadTOC(this.tocRoot, "news42/toc.xml");
        this.loadTOC(this.tocRoot, "users-guide/toc.xml");
        this.loadTOC(this.tocRoot, "FAQ/toc.xml");
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(jEdit.getProperty("helpviewer.toc.plugins"), true);
        for (int i = 0; i < editPluginArray.length; ++i) {
            EditPlugin editPlugin = editPluginArray[i];
            String string = editPlugin.getClassName();
            String string2 = jEdit.getProperty("plugin." + string + ".docs");
            String string3 = jEdit.getProperty("plugin." + string + ".name");
            if (string2 == null || string3 == null || string2 == null) continue;
            String string4 = editPlugin.getPluginJAR().getClassLoader().getResourceAsPath(string2);
            defaultMutableTreeNode.add(this.createNode(string4, string3));
        }
        if (defaultMutableTreeNode.getChildCount() != 0) {
            this.tocRoot.add(defaultMutableTreeNode);
        } else {
            defaultMutableTreeNode = null;
        }
        this.tocModel = new DefaultTreeModel(this.tocRoot);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void loadTOC(DefaultMutableTreeNode defaultMutableTreeNode, String string) {
        block14: {
            TOCHandler tOCHandler = new TOCHandler(defaultMutableTreeNode, MiscUtilities.getParentOfPath(string));
            XmlParser xmlParser = new XmlParser();
            Reader reader = null;
            xmlParser.setHandler(tOCHandler);
            reader = new InputStreamReader(new URL(this.helpViewer.getBaseURL() + '/' + string).openStream());
            xmlParser.parse(null, null, reader);
            Object var10_6 = null;
            try {
                if (reader != null) {
                    reader.close();
                }
                break block14;
            }
            catch (IOException iOException) {
                Log.log(9, this, iOException);
            }
            break block14;
            {
                catch (XmlException xmlException) {
                    int n = xmlException.getLine();
                    String string2 = xmlException.getMessage();
                    Log.log(9, this, string + ':' + n + ": " + string2);
                    Object var10_7 = null;
                    try {
                        if (reader != null) {
                            reader.close();
                        }
                        break block14;
                    }
                    catch (IOException iOException) {
                        Log.log(9, this, iOException);
                    }
                    break block14;
                }
                catch (Exception exception) {
                    Log.log(9, this, exception);
                    Object var10_8 = null;
                    try {
                        if (reader != null) {
                            reader.close();
                        }
                        break block14;
                    }
                    catch (IOException iOException) {
                        Log.log(9, this, iOException);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var10_9 = null;
                try {
                    if (reader != null) {
                        reader.close();
                    }
                }
                catch (IOException iOException) {
                    Log.log(9, this, iOException);
                }
                throw throwable;
            }
        }
    }

    static class PluginCompare
    implements Comparator {
        PluginCompare() {
        }

        public int compare(Object object, Object object2) {
            EditPlugin editPlugin = (EditPlugin)object;
            EditPlugin editPlugin2 = (EditPlugin)object2;
            return MiscUtilities.compareStrings(jEdit.getProperty("plugin." + editPlugin.getClassName() + ".name"), jEdit.getProperty("plugin." + editPlugin2.getClassName() + ".name"), true);
        }
    }

    class TOCCellRenderer
    extends DefaultTreeCellRenderer {
        EmptyBorder border = new EmptyBorder(1, 0, 1, 1);

        TOCCellRenderer() {
        }

        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
            this.setIcon(bl3 ? FileCellRenderer.fileIcon : (bl2 ? FileCellRenderer.openDirIcon : FileCellRenderer.dirIcon));
            this.setBorder(this.border);
            return this;
        }
    }

    class TOCTree
    extends JTree {
        TOCTree() {
            ToolTipManager.sharedInstance().registerComponent(this);
        }

        public final String getToolTipText(MouseEvent mouseEvent) {
            Rectangle rectangle;
            TreePath treePath = this.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
            if (treePath != null && (rectangle = this.getPathBounds(treePath)) != null && !this.cellRectIsVisible(rectangle)) {
                return treePath.getLastPathComponent().toString();
            }
            return null;
        }

        protected void processMouseEvent(MouseEvent mouseEvent) {
            switch (mouseEvent.getID()) {
                case 500: {
                    TreePath treePath = this.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
                    if (treePath != null) {
                        Object object;
                        if (!this.isPathSelected(treePath)) {
                            this.setSelectionPath(treePath);
                        }
                        if (!((object = ((DefaultMutableTreeNode)treePath.getLastPathComponent()).getUserObject()) instanceof HelpNode)) {
                            this.expandPath(treePath);
                            return;
                        }
                        HelpNode helpNode = (HelpNode)object;
                        HelpTOCPanel.this.helpViewer.gotoURL(helpNode.href, true);
                    }
                    super.processMouseEvent(mouseEvent);
                    break;
                }
                default: {
                    super.processMouseEvent(mouseEvent);
                }
            }
        }

        private boolean cellRectIsVisible(Rectangle rectangle) {
            Rectangle rectangle2 = this.getVisibleRect();
            return rectangle2.contains(rectangle.x, rectangle.y) && rectangle2.contains(rectangle.x + rectangle.width, rectangle.y + rectangle.height);
        }
    }

    class TOCHandler
    extends HandlerBase {
        String dir;
        private String tag;
        private String title;
        private String href;
        private DefaultMutableTreeNode node;
        private Stack nodes = new Stack();

        TOCHandler(DefaultMutableTreeNode defaultMutableTreeNode, String string) {
            this.node = defaultMutableTreeNode;
            this.dir = string;
        }

        public void attribute(String string, String string2, boolean bl) {
            if (string.equals("HREF")) {
                this.href = string2;
            }
        }

        public void charData(char[] cArray, int n, int n2) {
            if (this.tag.equals("TITLE")) {
                StringBuffer stringBuffer = new StringBuffer();
                for (int i = 0; i < n2; ++i) {
                    char c = cArray[n + i];
                    if (c != ' ' && Character.isWhitespace(c)) continue;
                    stringBuffer.append(c);
                }
                this.title = stringBuffer.toString();
            }
        }

        public void startElement(String string) {
            this.tag = string;
        }

        public void endElement(String string) {
            if (string == null) {
                return;
            }
            if (string.equals("TITLE")) {
                DefaultMutableTreeNode defaultMutableTreeNode = HelpTOCPanel.this.createNode(this.dir + this.href, this.title);
                this.node.add(defaultMutableTreeNode);
                this.nodes.push(this.node);
                this.node = defaultMutableTreeNode;
            } else if (string.equals("ENTRY")) {
                this.node = (DefaultMutableTreeNode)this.nodes.pop();
            }
        }
    }

    static class HelpNode {
        String href;
        String title;

        HelpNode(String string, String string2) {
            this.href = string;
            this.title = string2;
        }

        public String toString() {
            return this.title;
        }
    }
}

