/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.io;

import java.awt.Component;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.gjt.sp.jedit.EditBus;
import org.gjt.sp.jedit.io.VFS;
import org.gjt.sp.jedit.io.VFSManager;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.msg.DynamicMenuChanged;

public class FavoritesVFS
extends VFS {
    public static final String PROTOCOL = "favorites";
    private static FavoritesVFS instance;
    private static Object lock;
    private static List favorites;

    public FavoritesVFS() {
        super(PROTOCOL, 72, new String[]{"type"});
        instance = this;
    }

    public String getParentOfPath(String string) {
        return "favorites:";
    }

    public VFS.DirectoryEntry[] _listDirectory(Object object, String string, Component component) {
        return FavoritesVFS.getFavorites();
    }

    public VFS.DirectoryEntry _getDirectoryEntry(Object object, String string, Component component) {
        return new FavoritesEntry(string, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean _delete(Object object, String string, Component component) {
        Object object2 = lock;
        synchronized (object2) {
            string = string.substring(PROTOCOL.length() + 1);
            Iterator iterator = favorites.iterator();
            while (iterator.hasNext()) {
                if (!((FavoritesEntry)iterator.next()).path.equals(string)) continue;
                iterator.remove();
                VFSManager.sendVFSUpdate(this, "favorites:", false);
                EditBus.send(new DynamicMenuChanged(PROTOCOL));
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadFavorites() {
        Object object = lock;
        synchronized (object) {
            String string;
            favorites = new LinkedList();
            int n = 0;
            while ((string = jEdit.getProperty("vfs.favorite." + n)) != null) {
                favorites.add(new FavoritesEntry(string, jEdit.getIntegerProperty("vfs.favorite." + n + ".type", 1)));
                ++n;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addToFavorites(String string, int n) {
        Object object = lock;
        synchronized (object) {
            if (favorites == null) {
                FavoritesVFS.loadFavorites();
            }
            Iterator iterator = favorites.iterator();
            while (iterator.hasNext()) {
                if (!((FavoritesEntry)iterator.next()).path.equals(string)) continue;
                return;
            }
            favorites.add(new FavoritesEntry(string, n));
            VFSManager.sendVFSUpdate(instance, "favorites:", false);
            EditBus.send(new DynamicMenuChanged(PROTOCOL));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveFavorites() {
        Object object = lock;
        synchronized (object) {
            if (favorites == null) {
                return;
            }
            int n = 0;
            for (FavoritesEntry favoritesEntry : favorites) {
                jEdit.setProperty("vfs.favorite." + n, favoritesEntry.path);
                jEdit.setIntegerProperty("vfs.favorite." + n + ".type", favoritesEntry.type);
                ++n;
            }
            jEdit.unsetProperty("vfs.favorite." + favorites.size());
            jEdit.unsetProperty("vfs.favorite." + favorites.size() + ".type");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static VFS.DirectoryEntry[] getFavorites() {
        Object object = lock;
        synchronized (object) {
            if (favorites == null) {
                FavoritesVFS.loadFavorites();
            }
            return favorites.toArray(new VFS.DirectoryEntry[favorites.size()]);
        }
    }

    static {
        lock = new Object();
    }

    static class FavoritesEntry
    extends VFS.DirectoryEntry {
        FavoritesEntry(String string, int n) {
            super(string, string, "favorites:" + string, n, 0L, false);
        }

        public String getExtendedAttribute(String string) {
            if (string.equals("type")) {
                return super.getExtendedAttribute(string);
            }
            return null;
        }
    }
}

