/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.io;

import gnu.regexp.RE;
import gnu.regexp.REException;
import java.awt.Color;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Vector;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.EBComponent;
import org.gjt.sp.jedit.EBMessage;
import org.gjt.sp.jedit.EditBus;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.buffer.BufferIORequest;
import org.gjt.sp.jedit.io.VFSManager;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.msg.PropertiesChanged;
import org.gjt.sp.util.Log;

public abstract class VFS {
    public static final int READ_CAP = 1;
    public static final int WRITE_CAP = 2;
    public static final int BROWSE_CAP = 4;
    public static final int DELETE_CAP = 8;
    public static final int RENAME_CAP = 16;
    public static final int MKDIR_CAP = 32;
    public static final int LOW_LATENCY_CAP = 64;
    public static final int CASE_INSENSITIVE_CAP = 128;
    public static final String EA_TYPE = "type";
    public static final String EA_STATUS = "status";
    public static final String EA_SIZE = "size";
    public static final String EA_MODIFIED = "modified";
    private String name;
    private int caps;
    private String[] extAttrs;
    private static Vector colors;
    private static Object lock;

    public VFS(String string) {
        this(string, 0);
    }

    public VFS(String string, int n) {
        this.name = string;
        this.caps = n;
        this.extAttrs = new String[]{EA_SIZE, EA_TYPE};
    }

    public VFS(String string, int n, String[] stringArray) {
        this.name = string;
        this.caps = n;
        this.extAttrs = stringArray;
    }

    public String getName() {
        return this.name;
    }

    public int getCapabilities() {
        return this.caps;
    }

    public String[] getExtendedAttributes() {
        return this.extAttrs;
    }

    public String showBrowseDialog(Object[] objectArray, Component component) {
        return null;
    }

    public String getFileName(String string) {
        int n;
        if (string.equals("/")) {
            return string;
        }
        if (string.endsWith("/") || string.endsWith(File.separator)) {
            string = string.substring(0, string.length() - 1);
        }
        if ((n = Math.max(string.lastIndexOf(47), string.lastIndexOf(File.separatorChar))) == -1) {
            n = string.indexOf(58);
        }
        if (n == -1 || n == string.length() - 1) {
            return string;
        }
        return string.substring(n + 1);
    }

    public String getParentOfPath(String string) {
        int n = Math.max(0, string.length() - 2);
        int n2 = string.lastIndexOf(File.separatorChar, n);
        if (n2 == -1) {
            n2 = string.lastIndexOf(47, n);
        }
        if (n2 == -1) {
            n2 = string.lastIndexOf(58);
        }
        return string.substring(0, n2 + 1);
    }

    public String constructPath(String string, String string2) {
        return string + string2;
    }

    public char getFileSeparator() {
        return '/';
    }

    public String getTwoStageSaveName(String string) {
        return MiscUtilities.constructPath(this.getParentOfPath(string), '#' + this.getFileName(string) + "#save#");
    }

    public void reloadDirectory(String string) {
    }

    public Object createVFSSession(String string, Component component) {
        return new Object();
    }

    public boolean load(View view, Buffer buffer, String string) {
        if ((this.getCapabilities() & 1) == 0) {
            VFSManager.error((Component)((Object)view), string, "vfs.not-supported.load", new String[]{this.name});
            return false;
        }
        Object object = this.createVFSSession(string, (Component)((Object)view));
        if (object == null) {
            return false;
        }
        if ((this.getCapabilities() & 2) == 0) {
            buffer.setReadOnly(true);
        }
        BufferIORequest bufferIORequest = new BufferIORequest(0, view, buffer, object, this, string);
        if (buffer.isTemporary()) {
            bufferIORequest.run();
        } else {
            VFSManager.runInWorkThread(bufferIORequest);
        }
        return true;
    }

    public boolean save(View view, Buffer buffer, String string) {
        if ((this.getCapabilities() & 2) == 0) {
            VFSManager.error((Component)((Object)view), string, "vfs.not-supported.save", new String[]{this.name});
            return false;
        }
        Object object = this.createVFSSession(string, (Component)((Object)view));
        if (object == null) {
            return false;
        }
        if (!string.equals(buffer.getPath())) {
            buffer.unsetProperty("Buffer__backedUp");
        }
        VFSManager.runInWorkThread(new BufferIORequest(1, view, buffer, object, this, string));
        return true;
    }

    public boolean insert(View view, Buffer buffer, String string) {
        if ((this.getCapabilities() & 1) == 0) {
            VFSManager.error((Component)((Object)view), string, "vfs.not-supported.load", new String[]{this.name});
            return false;
        }
        Object object = this.createVFSSession(string, (Component)((Object)view));
        if (object == null) {
            return false;
        }
        VFSManager.runInWorkThread(new BufferIORequest(3, view, buffer, object, this, string));
        return true;
    }

    public String _canonPath(Object object, String string, Component component) throws IOException {
        return string;
    }

    public String[] _listDirectory(Object object, String string, String string2, boolean bl, Component component) throws IOException {
        RE rE;
        Log.log(1, this, "Listing " + string);
        ArrayList arrayList = new ArrayList(100);
        try {
            rE = new RE(MiscUtilities.globToRE(string2), 2);
        }
        catch (REException rEException) {
            Log.log(9, this, rEException);
            return null;
        }
        this._listDirectory(object, new ArrayList(), arrayList, string, rE, bl, component);
        String[] stringArray = arrayList.toArray(new String[arrayList.size()]);
        Arrays.sort(stringArray, new MiscUtilities.StringICaseCompare());
        return stringArray;
    }

    public DirectoryEntry[] _listDirectory(Object object, String string, Component component) throws IOException {
        VFSManager.error(component, string, "vfs.not-supported.list", new String[]{this.name});
        return null;
    }

    public DirectoryEntry _getDirectoryEntry(Object object, String string, Component component) throws IOException {
        return null;
    }

    public boolean _delete(Object object, String string, Component component) throws IOException {
        return false;
    }

    public boolean _rename(Object object, String string, String string2, Component component) throws IOException {
        return false;
    }

    public boolean _mkdir(Object object, String string, Component component) throws IOException {
        return false;
    }

    public void _backup(Object object, String string, Component component) throws IOException {
    }

    public InputStream _createInputStream(Object object, String string, boolean bl, Component component) throws IOException {
        VFSManager.error(component, string, "vfs.not-supported.load", new String[]{this.name});
        return null;
    }

    public OutputStream _createOutputStream(Object object, String string, Component component) throws IOException {
        VFSManager.error(component, string, "vfs.not-supported.save", new String[]{this.name});
        return null;
    }

    public void _saveComplete(Object object, Buffer buffer, String string, Component component) throws IOException {
    }

    public void _endVFSSession(Object object, Component component) throws IOException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Color getDefaultColorFor(String string) {
        Object object = lock;
        synchronized (object) {
            if (colors == null) {
                VFS.loadColors();
            }
            for (int i = 0; i < colors.size(); ++i) {
                ColorEntry colorEntry = (ColorEntry)colors.elementAt(i);
                if (!colorEntry.re.isMatch(string)) continue;
                return colorEntry.color;
            }
            return null;
        }
    }

    private void _listDirectory(Object object, ArrayList arrayList, ArrayList arrayList2, String string, RE rE, boolean bl, Component component) throws IOException {
        if (arrayList.contains(string)) {
            Log.log(9, this, "Recursion in _listDirectory(): " + string);
            return;
        }
        arrayList.add(string);
        DirectoryEntry[] directoryEntryArray = this._listDirectory(object, string, component);
        if (directoryEntryArray == null || directoryEntryArray.length == 0) {
            return;
        }
        for (int i = 0; i < directoryEntryArray.length; ++i) {
            DirectoryEntry directoryEntry = directoryEntryArray[i];
            if (directoryEntry.type == 1 || directoryEntry.type == 2) {
                if (!bl) continue;
                String string2 = this._canonPath(object, directoryEntry.path, component);
                if (!MiscUtilities.isURL(string2)) {
                    string2 = MiscUtilities.resolveSymlinks(string2);
                }
                this._listDirectory(object, arrayList, arrayList2, string2, rE, bl, component);
                continue;
            }
            if (!rE.isMatch(directoryEntry.name)) continue;
            Log.log(1, this, directoryEntry.path);
            arrayList2.add(directoryEntry.path);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadColors() {
        Object object = lock;
        synchronized (object) {
            String string;
            colors = new Vector();
            if (!jEdit.getBooleanProperty("vfs.browser.colorize")) {
                return;
            }
            int n = 0;
            while ((string = jEdit.getProperty("vfs.browser.colors." + n + ".glob")) != null) {
                try {
                    colors.addElement(new ColorEntry(new RE(MiscUtilities.globToRE(string)), jEdit.getColorProperty("vfs.browser.colors." + n + ".color", Color.black)));
                }
                catch (REException rEException) {
                    Log.log(9, VFS.class, "Invalid regular expression: " + string);
                    Log.log(9, VFS.class, rEException);
                }
                ++n;
            }
        }
    }

    public String getDefaultEncoding(String string) {
        return System.getProperty("file.encoding");
    }

    public void setEncoding(String string, String string2) {
    }

    static {
        lock = new Object();
        EditBus.addToBus(new EBComponent(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void handleMessage(EBMessage eBMessage) {
                if (eBMessage instanceof PropertiesChanged) {
                    Object object = lock;
                    synchronized (object) {
                        colors = null;
                    }
                }
            }
        });
    }

    static class ColorEntry {
        RE re;
        Color color;

        ColorEntry(RE rE, Color color) {
            this.re = rE;
            this.color = color;
        }
    }

    public static class DirectoryEntryCompare
    implements MiscUtilities.Compare {
        private boolean sortIgnoreCase;
        private boolean sortMixFilesAndDirs;

        public DirectoryEntryCompare(boolean bl, boolean bl2) {
            this.sortMixFilesAndDirs = bl;
            this.sortIgnoreCase = bl2;
        }

        public int compare(Object object, Object object2) {
            DirectoryEntry directoryEntry = (DirectoryEntry)object;
            DirectoryEntry directoryEntry2 = (DirectoryEntry)object2;
            if (!this.sortMixFilesAndDirs && directoryEntry.type != directoryEntry2.type) {
                return directoryEntry2.type - directoryEntry.type;
            }
            return MiscUtilities.compareStrings(directoryEntry.name, directoryEntry2.name, this.sortIgnoreCase);
        }
    }

    public static class DirectoryEntry
    implements Serializable {
        public static final int FILE = 0;
        public static final int DIRECTORY = 1;
        public static final int FILESYSTEM = 2;
        public String name;
        public String path;
        public String symlinkPath;
        public String deletePath;
        public int type;
        public long length;
        public boolean hidden;
        public boolean canRead;
        public boolean canWrite;
        protected boolean colorCalculated;
        protected Color color;

        public DirectoryEntry() {
        }

        public DirectoryEntry(String string, String string2, String string3, int n, long l, boolean bl) {
            this.name = string;
            this.path = string2;
            this.deletePath = string3;
            this.symlinkPath = string2;
            this.type = n;
            this.length = l;
            this.hidden = bl;
            if (string2 != null) {
                VFS vFS = VFSManager.getVFSForPath(string2);
                this.canRead = (vFS.getCapabilities() & 1) != 0;
                this.canWrite = (vFS.getCapabilities() & 2) != 0;
            }
        }

        public String getExtendedAttribute(String string) {
            if (string.equals(VFS.EA_TYPE)) {
                switch (this.type) {
                    case 0: {
                        return jEdit.getProperty("vfs.browser.type.file");
                    }
                    case 1: {
                        return jEdit.getProperty("vfs.browser.type.directory");
                    }
                    case 2: {
                        return jEdit.getProperty("vfs.browser.type.filesystem");
                    }
                }
                throw new IllegalArgumentException();
            }
            if (string.equals(VFS.EA_STATUS)) {
                if (this.canRead) {
                    if (this.canWrite) {
                        return jEdit.getProperty("vfs.browser.status.rw");
                    }
                    return jEdit.getProperty("vfs.browser.status.ro");
                }
                if (this.canWrite) {
                    return jEdit.getProperty("vfs.browser.status.append");
                }
                return jEdit.getProperty("vfs.browser.status.no");
            }
            if (string.equals(VFS.EA_SIZE)) {
                if (this.type != 0) {
                    return null;
                }
                return MiscUtilities.formatFileSize(this.length);
            }
            return null;
        }

        public Color getColor() {
            if (!this.colorCalculated) {
                this.colorCalculated = true;
                this.color = VFS.getDefaultColorFor(this.name);
            }
            return this.color;
        }

        public String toString() {
            return this.name;
        }
    }
}

