/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.menu;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import org.gjt.sp.jedit.BufferHistory;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.browser.FileCellRenderer;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.menu.DynamicMenuProvider;

public class RecentFilesProvider
implements DynamicMenuProvider {
    public boolean updateEveryTime() {
        return false;
    }

    public void update(JMenu jMenuItem) {
        JMenuItem jMenuItem2;
        final View view = GUIUtilities.getView(jMenuItem);
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                jEdit.openFile(view, actionEvent.getActionCommand());
                view.getStatus().setMessage(null);
            }
        };
        MouseAdapter mouseAdapter = new MouseAdapter(){

            public void mouseEntered(MouseEvent mouseEvent) {
                view.getStatus().setMessage(((JMenuItem)mouseEvent.getSource()).getActionCommand());
            }

            public void mouseExited(MouseEvent mouseEvent) {
                view.getStatus().setMessage(null);
            }
        };
        List list = BufferHistory.getHistory();
        if (list.size() == 0) {
            JMenuItem jMenuItem3 = new JMenuItem(jEdit.getProperty("no-recent-files.label"));
            jMenuItem3.setEnabled(false);
            ((JMenu)jMenuItem).add(jMenuItem3);
            return;
        }
        Vector<JMenuItem> vector = new Vector<JMenuItem>();
        boolean bl = jEdit.getBooleanProperty("sortRecent");
        int n = jEdit.getIntegerProperty("menu.spillover", 20);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            String string = ((BufferHistory.Entry)iterator.next()).path;
            jMenuItem2 = new JMenuItem(MiscUtilities.getFileName(string));
            jMenuItem2.setActionCommand(string);
            jMenuItem2.addActionListener(actionListener);
            jMenuItem2.addMouseListener(mouseAdapter);
            jMenuItem2.setIcon(FileCellRenderer.fileIcon);
            if (bl) {
                vector.addElement(jMenuItem2);
                continue;
            }
            if (((JMenu)jMenuItem).getMenuComponentCount() >= n && iterator.hasNext()) {
                JMenu jMenu = new JMenu(jEdit.getProperty("common.more"));
                ((JMenu)jMenuItem).add(jMenu);
                jMenuItem = jMenu;
            }
            ((JMenu)jMenuItem).add(jMenuItem2);
        }
        if (bl) {
            MiscUtilities.quicksort(vector, (MiscUtilities.Compare)new MiscUtilities.MenuItemCompare());
            for (int i = 0; i < vector.size(); ++i) {
                if (((JMenu)jMenuItem).getMenuComponentCount() >= n && i != 0) {
                    jMenuItem2 = new JMenu(jEdit.getProperty("common.more"));
                    ((JMenu)jMenuItem).add(jMenuItem2);
                    jMenuItem = jMenuItem2;
                }
                ((JMenu)jMenuItem).add((JMenuItem)vector.elementAt(i));
            }
        }
    }
}

