/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.options;

import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.options.SyntaxHiliteOptionPane;

class BrowserColorsModel
extends AbstractTableModel {
    private ArrayList entries = new ArrayList();

    BrowserColorsModel() {
        String string;
        int n = 0;
        while ((string = jEdit.getProperty("vfs.browser.colors." + n + ".glob")) != null) {
            this.entries.add(new Entry(string, jEdit.getColorProperty("vfs.browser.colors." + n + ".color", Color.black)));
            ++n;
        }
    }

    void add() {
        this.entries.add(new Entry("", UIManager.getColor("Tree.foreground")));
        this.fireTableRowsInserted(this.entries.size() - 1, this.entries.size() - 1);
    }

    void remove(int n) {
        this.entries.remove(n);
        this.fireTableRowsDeleted(this.entries.size(), this.entries.size());
    }

    public void moveUp(int n) {
        Object e = this.entries.get(n);
        this.entries.remove(n);
        this.entries.add(n - 1, e);
        this.fireTableRowsUpdated(n - 1, n);
    }

    public void moveDown(int n) {
        Object e = this.entries.get(n);
        this.entries.remove(n);
        this.entries.add(n + 1, e);
        this.fireTableRowsUpdated(n, n + 1);
    }

    void save() {
        int n;
        for (n = 0; n < this.entries.size(); ++n) {
            Entry entry = (Entry)this.entries.get(n);
            jEdit.setProperty("vfs.browser.colors." + n + ".glob", entry.glob);
            jEdit.setColorProperty("vfs.browser.colors." + n + ".color", entry.color);
        }
        jEdit.unsetProperty("vfs.browser.colors." + n + ".glob");
        jEdit.unsetProperty("vfs.browser.colors." + n + ".color");
    }

    public int getColumnCount() {
        return 2;
    }

    public int getRowCount() {
        return this.entries.size();
    }

    public Object getValueAt(int n, int n2) {
        Entry entry = (Entry)this.entries.get(n);
        switch (n2) {
            case 0: {
                return entry.glob;
            }
            case 1: {
                return entry.color;
            }
        }
        return null;
    }

    public boolean isCellEditable(int n, int n2) {
        return n2 == 0;
    }

    public void setValueAt(Object object, int n, int n2) {
        Entry entry = (Entry)this.entries.get(n);
        if (n2 == 0) {
            entry.glob = (String)object;
        } else {
            entry.color = (Color)object;
        }
        this.fireTableRowsUpdated(n, n);
    }

    public String getColumnName(int n) {
        switch (n) {
            case 0: {
                return jEdit.getProperty("options.browser.colors.glob");
            }
            case 1: {
                return jEdit.getProperty("options.browser.colors.color");
            }
        }
        return null;
    }

    public Class getColumnClass(int n) {
        switch (n) {
            case 0: {
                return String.class;
            }
            case 1: {
                return Color.class;
            }
        }
        throw new InternalError();
    }

    static class ColorRenderer
    extends JLabel
    implements TableCellRenderer {
        public ColorRenderer() {
            this.setOpaque(true);
            this.setBorder(SyntaxHiliteOptionPane.noFocusBorder);
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (bl) {
                this.setBackground(jTable.getSelectionBackground());
                this.setForeground(jTable.getSelectionForeground());
            } else {
                this.setBackground(jTable.getBackground());
                this.setForeground(jTable.getForeground());
            }
            if (object != null) {
                this.setBackground((Color)object);
            }
            this.setBorder(bl2 ? UIManager.getBorder("Table.focusCellHighlightBorder") : SyntaxHiliteOptionPane.noFocusBorder);
            return this;
        }
    }

    static class Entry {
        String glob;
        Color color;

        Entry(String string, Color color) {
            this.glob = string;
            this.color = color;
        }
    }
}

