/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.options;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.gjt.sp.jedit.AbstractOptionPane;
import org.gjt.sp.jedit.options.WindowTableModel;

public class DockingOptionPane
extends AbstractOptionPane {
    private JTable windowTable;
    private WindowTableModel windowModel;

    public DockingOptionPane() {
        super("docking");
    }

    public void _init() {
        this.setLayout(new BorderLayout());
        this.add("Center", this.createWindowTableScroller());
    }

    public void _save() {
        this.windowModel.save();
    }

    private JScrollPane createWindowTableScroller() {
        this.windowModel = this.createWindowModel();
        this.windowTable = new JTable(this.windowModel);
        this.windowTable.getTableHeader().setReorderingAllowed(false);
        this.windowTable.setColumnSelectionAllowed(false);
        this.windowTable.setRowSelectionAllowed(false);
        this.windowTable.setCellSelectionEnabled(false);
        DockPositionCellRenderer dockPositionCellRenderer = new DockPositionCellRenderer();
        this.windowTable.setRowHeight(dockPositionCellRenderer.getPreferredSize().height);
        TableColumn tableColumn = this.windowTable.getColumnModel().getColumn(1);
        tableColumn.setCellRenderer(dockPositionCellRenderer);
        tableColumn.setCellEditor(new DefaultCellEditor(new DockPositionCellRenderer()));
        Dimension dimension = this.windowTable.getPreferredSize();
        dimension.height = Math.min(dimension.height, 50);
        JScrollPane jScrollPane = new JScrollPane(this.windowTable);
        jScrollPane.setPreferredSize(dimension);
        return jScrollPane;
    }

    private WindowTableModel createWindowModel() {
        return new WindowTableModel();
    }

    class DockPositionCellRenderer
    extends JComboBox
    implements TableCellRenderer {
        DockPositionCellRenderer() {
            super(new String[]{"floating", "top", "left", "bottom", "right"});
            this.setRequestFocusEnabled(false);
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            this.setSelectedItem(object);
            return this;
        }
    }
}

