/*
 * Decompiled with CFR 0.152.
 */
package de.onyxbits.giftedmotion;

import de.onyxbits.giftedmotion.FrameSequence;
import de.onyxbits.giftedmotion.FrameSequenceListener;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import javax.swing.JPanel;

public class FrameCanvas
extends JPanel
implements FrameSequenceListener,
MouseListener,
MouseMotionListener {
    private FrameSequence seq;
    private Point offset;

    public FrameCanvas(FrameSequence frameSequence) {
        this.seq = frameSequence;
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        Dimension dimension = this.getSize();
        if (this.seq.selected == null) {
            graphics.clearRect(0, 0, dimension.width, dimension.height);
            return;
        }
        BufferedImage bufferedImage = new BufferedImage(dimension.width, dimension.height, 2);
        block6: for (int i = 0; i < this.seq.frames.length; ++i) {
            this.seq.frames[i].paint(graphics);
            if (this.seq.frames[i] == this.seq.selected) break;
            switch (this.seq.frames[i].dispose) {
                case 0: {
                    continue block6;
                }
                case 1: {
                    Graphics graphics2 = bufferedImage.getGraphics();
                    this.seq.frames[i].paint(graphics2);
                    graphics2.dispose();
                    continue block6;
                }
                case 2: {
                    graphics.clearRect(0, 0, dimension.width, dimension.height);
                    continue block6;
                }
                case 3: {
                    graphics.clearRect(0, 0, dimension.width, dimension.height);
                    graphics.drawImage(bufferedImage, 0, 0, null);
                }
            }
        }
    }

    public Dimension getPreferredSize() {
        return this.seq.getExpansion();
    }

    public void dataChanged(FrameSequence frameSequence) {
        this.repaint();
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (this.seq.selected == null) {
            return;
        }
        Point point = mouseEvent.getPoint();
        this.offset = new Point(point.x - this.seq.selected.position.x, point.y - this.seq.selected.position.y);
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.offset = null;
        this.seq.fireDataChanged();
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.seq.selected == null) {
            return;
        }
        Point point = mouseEvent.getPoint();
        this.seq.selected.position.x = point.x - this.offset.x;
        this.seq.selected.position.y = point.y - this.offset.y;
        this.repaint();
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }
}

