/*
 * Decompiled with CFR 0.152.
 */
package de.onyxbits.giftedmotion;

import de.onyxbits.giftedmotion.Dict;
import de.onyxbits.giftedmotion.FrameSequence;
import de.onyxbits.giftedmotion.FrameSequenceListener;
import de.onyxbits.giftedmotion.IO;
import de.onyxbits.giftedmotion.SingleFrame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.SpinnerListModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class SequenceEditor
extends JInternalFrame
implements ActionListener,
FrameSequenceListener,
ChangeListener,
ListSelectionListener {
    private String[] dcodes = new String[]{Dict.get("sequenceeditor.dcodes.0"), Dict.get("sequenceeditor.dcodes.1"), Dict.get("sequenceeditor.dcodes.2"), Dict.get("sequenceeditor.dcodes.3")};
    private JList frlst;
    private JSpinner xoff = new JSpinner(new SpinnerNumberModel(0, -1000000, 1000000, 1));
    private JSpinner yoff = new JSpinner(new SpinnerNumberModel(0, -1000000, 1000000, 1));
    private JSpinner showtime = new JSpinner(new SpinnerNumberModel(100, 1, 1000000, 10));
    private JSpinner dispose = new JSpinner(new SpinnerListModel(this.dcodes));
    private JButton sooner = new JButton(IO.createIcon("Tango/22x22/actions/go-up.png", Dict.get("sequenceeditor.sooner")));
    private JButton later = new JButton(IO.createIcon("Tango/22x22/actions/go-down.png", Dict.get("sequenceeditor.later")));
    private JButton duplicate = new JButton(IO.createIcon("Tango/22x22/actions/edit-copy.png", Dict.get("sequenceeditor.copy")));
    private JButton delete = new JButton(IO.createIcon("Tango/22x22/actions/edit-delete.png", Dict.get("sequenceeditor.delete")));
    private JCheckBox apply = new JCheckBox(Dict.get("sequenceeditor.apply"), false);
    private FrameSequence seq;

    public SequenceEditor(FrameSequence frameSequence) {
        super(Dict.get("sequenceeditor.sequenceeditor.title"), false, false, false, false);
        this.seq = frameSequence;
        this.frlst = new JList<SingleFrame>(frameSequence.frames);
        this.setContentPane(this.getContent());
        this.pack();
        this.sooner.addActionListener(this);
        this.later.addActionListener(this);
        this.duplicate.addActionListener(this);
        this.delete.addActionListener(this);
        this.dispose.addChangeListener(this);
        this.frlst.addListSelectionListener(this);
        this.showtime.addChangeListener(this);
        this.xoff.addChangeListener(this);
        this.yoff.addChangeListener(this);
        this.apply.setToolTipText(Dict.get("sequenceeditor.sequenceeditor.apply"));
        this.sooner.setToolTipText(Dict.get("sequenceeditor.sequenceeditor.sooner"));
        this.later.setToolTipText(Dict.get("sequenceeditor.sequenceeditor.later"));
        this.duplicate.setToolTipText(Dict.get("sequenceeditor.sequenceeditor.duplicate"));
        this.delete.setToolTipText(Dict.get("sequenceeditor.sequenceeditor.delete"));
        this.dispose.setToolTipText(Dict.get("sequenceeditor.sequenceeditor.dispose"));
        this.showtime.setToolTipText(Dict.get("sequenceeditor.sequenceeditor.showtime"));
        this.xoff.setToolTipText(Dict.get("sequenceeditor.sequenceeditor.xoff"));
        this.yoff.setToolTipText(Dict.get("sequenceeditor.sequenceeditor.yoff"));
        this.dataChanged(frameSequence);
    }

    private JPanel getContent() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.setBorder(BorderFactory.createTitledBorder(Dict.get("sequenceeditor.getcontent.order")));
        JPanel jPanel2 = new JPanel();
        jPanel2.add(this.sooner);
        jPanel2.add(this.later);
        jPanel2.add(Box.createHorizontalGlue());
        jPanel2.add(this.duplicate);
        jPanel2.add(this.delete);
        jPanel.add(new JScrollPane(this.frlst));
        jPanel.add(jPanel2);
        JLabel jLabel = new JLabel(Dict.get("sequenceeditor.getcontent.showtime"));
        JLabel jLabel2 = new JLabel(Dict.get("sequenceeditor.getcontent.dispose"));
        JLabel jLabel3 = new JLabel(Dict.get("sequenceeditor.getcontent.xoff"));
        JLabel jLabel4 = new JLabel(Dict.get("sequenceeditor.getcontent.yoff"));
        JPanel jPanel3 = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        jPanel3.setLayout(gridBagLayout);
        jPanel3.setBorder(BorderFactory.createTitledBorder(Dict.get("sequenceeditor.getcontent.settings")));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 0;
        gridBagConstraints.ipady = 0;
        gridBagConstraints.insets = new Insets(0, 1, 1, 10);
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel3.add(jLabel);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 0;
        gridBagConstraints.ipady = 0;
        gridBagConstraints.insets = new Insets(0, 1, 1, 1);
        gridBagLayout.setConstraints(this.showtime, gridBagConstraints);
        jPanel3.add(this.showtime);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.ipadx = 0;
        gridBagConstraints.ipady = 0;
        gridBagConstraints.insets = new Insets(0, 1, 1, 10);
        gridBagLayout.setConstraints(jLabel2, gridBagConstraints);
        jPanel3.add(jLabel2);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 0;
        gridBagConstraints.ipady = 0;
        gridBagConstraints.insets = new Insets(0, 1, 1, 1);
        gridBagLayout.setConstraints(this.dispose, gridBagConstraints);
        jPanel3.add(this.dispose);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.ipadx = 0;
        gridBagConstraints.ipady = 0;
        gridBagConstraints.insets = new Insets(0, 1, 1, 10);
        gridBagLayout.setConstraints(jLabel3, gridBagConstraints);
        jPanel3.add(jLabel3);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 0;
        gridBagConstraints.ipady = 0;
        gridBagConstraints.insets = new Insets(0, 1, 1, 1);
        gridBagLayout.setConstraints(this.xoff, gridBagConstraints);
        jPanel3.add(this.xoff);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.ipadx = 0;
        gridBagConstraints.ipady = 0;
        gridBagConstraints.insets = new Insets(0, 1, 1, 10);
        gridBagLayout.setConstraints(jLabel4, gridBagConstraints);
        jPanel3.add(jLabel4);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 0;
        gridBagConstraints.ipady = 0;
        gridBagConstraints.insets = new Insets(0, 1, 1, 1);
        gridBagLayout.setConstraints(this.yoff, gridBagConstraints);
        jPanel3.add(this.yoff);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 100.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 0;
        gridBagConstraints.ipadx = 0;
        gridBagConstraints.ipady = 0;
        gridBagConstraints.insets = new Insets(12, 1, 1, 1);
        gridBagLayout.setConstraints(this.apply, gridBagConstraints);
        jPanel3.add(this.apply);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BoxLayout(jPanel4, 1));
        jPanel4.add(jPanel);
        jPanel4.add(jPanel3);
        return jPanel4;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.seq.selected == null) {
            return;
        }
        Object object = actionEvent.getSource();
        if (object == this.dispose) {
            this.seq.selected.dispose = 0;
            for (int i = 0; i < this.dcodes.length; ++i) {
                if (!this.dcodes[i].equals(this.dispose.getValue())) continue;
                this.seq.selected.dispose = i;
            }
            this.seq.fireDataChanged();
        }
        if (object == this.sooner) {
            this.seq.move(this.seq.selected, true);
        }
        if (object == this.later) {
            this.seq.move(this.seq.selected, false);
        }
        if (object == this.duplicate) {
            this.seq.add(new SingleFrame(this.seq.selected), this.seq.getSelectedIndex());
        }
        if (object == this.delete) {
            this.seq.remove(this.seq.selected);
        }
    }

    public void stateChanged(ChangeEvent changeEvent) {
        int n;
        int n2;
        if (this.seq.selected == null) {
            return;
        }
        Object object = changeEvent.getSource();
        if (object == this.showtime) {
            n2 = (Integer)this.showtime.getValue();
            if (this.apply.isSelected()) {
                for (n = 0; n < this.seq.frames.length; ++n) {
                    this.seq.frames[n].showtime = n2;
                }
            } else {
                this.seq.selected.showtime = (Integer)this.showtime.getValue();
            }
            this.seq.fireDataChanged();
        }
        if (object == this.dispose) {
            n2 = 0;
            for (n = 0; n < this.dcodes.length; ++n) {
                if (!this.dcodes[n].equals(this.dispose.getValue())) continue;
                n2 = n;
            }
            if (this.apply.isSelected()) {
                for (n = 0; n < this.seq.frames.length; ++n) {
                    this.seq.frames[n].dispose = n2;
                }
            } else {
                this.seq.selected.dispose = n2;
            }
            this.seq.fireDataChanged();
        }
        if (object == this.xoff || object == this.yoff) {
            n2 = (Integer)this.xoff.getValue();
            n = (Integer)this.yoff.getValue();
            Point point = new Point(n2, n);
            if (this.apply.isSelected()) {
                for (int i = 0; i < this.seq.frames.length; ++i) {
                    this.seq.frames[i].position = point;
                }
            } else {
                this.seq.selected.position = point;
            }
            this.seq.fireDataChanged();
        }
    }

    public void dataChanged(FrameSequence frameSequence) {
        this.frlst.removeListSelectionListener(this);
        this.dispose.removeChangeListener(this);
        this.showtime.removeChangeListener(this);
        this.xoff.removeChangeListener(this);
        this.yoff.removeChangeListener(this);
        this.frlst.setListData(this.seq.frames);
        this.frlst.setSelectedValue(frameSequence.selected, true);
        if (frameSequence.selected != null) {
            this.dispose.setValue(this.dcodes[frameSequence.selected.dispose]);
            this.showtime.setValue(new Integer(frameSequence.selected.showtime));
            this.xoff.setValue(new Integer(frameSequence.selected.position.x));
            this.yoff.setValue(new Integer(frameSequence.selected.position.y));
        }
        this.frlst.addListSelectionListener(this);
        this.dispose.addChangeListener(this);
        this.showtime.addChangeListener(this);
        this.xoff.addChangeListener(this);
        this.yoff.addChangeListener(this);
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        this.seq.selected = (SingleFrame)this.frlst.getSelectedValue();
        this.seq.fireDataChanged();
    }
}

