/*
 * Decompiled with CFR 0.152.
 */
package net.disy.commons.core.text.font;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import net.disy.commons.core.exception.UnreachableCodeReachedException;
import net.disy.commons.core.text.font.FontStyleProperty;
import net.disy.commons.core.text.font.IFontStyleVisitor;
import net.disy.commons.core.util.ObjectUtilities;

public enum FontStyle {
    PLAIN("Plain", new FontStyleProperty[0]){

        @Override
        public void accept(IFontStyleVisitor visitor) {
            visitor.visitPlainFontStyle(this);
        }
    }
    ,
    ITALIC("Italic", new FontStyleProperty[]{FontStyleProperty.ITALICS}){

        @Override
        public void accept(IFontStyleVisitor visitor) {
            visitor.visitItalicFontStyle(this);
        }
    }
    ,
    BOLD("Bold", new FontStyleProperty[]{FontStyleProperty.BOLD}){

        @Override
        public void accept(IFontStyleVisitor visitor) {
            visitor.visitBoldFontStyle(this);
        }
    }
    ,
    BOLD_ITALIC("Bold italic", new FontStyleProperty[]{FontStyleProperty.BOLD, FontStyleProperty.ITALICS}){

        @Override
        public void accept(IFontStyleVisitor visitor) {
            visitor.visitBoldItalicFontStyle(this);
        }
    };

    private final String name;
    private final Set<FontStyleProperty> properties;

    private FontStyle(String name, FontStyleProperty ... properties) {
        this.name = name;
        this.properties = new HashSet<FontStyleProperty>(Arrays.asList(properties));
    }

    public abstract void accept(IFontStyleVisitor var1);

    public boolean isItalic() {
        return this.properties.contains((Object)FontStyleProperty.ITALICS);
    }

    public boolean isBold() {
        return this.properties.contains((Object)FontStyleProperty.BOLD);
    }

    public boolean isPlain() {
        return !this.isBold() && !this.isItalic();
    }

    public String getName() {
        return this.name;
    }

    public static FontStyle getByName(String name) {
        for (FontStyle fontStyle : FontStyle.values()) {
            if (!name.equals(fontStyle.getName())) continue;
            return fontStyle;
        }
        throw new IllegalArgumentException("No font style defined for name " + name);
    }

    public static boolean nameExists(String name) {
        for (FontStyle fontStyle : FontStyle.values()) {
            if (!ObjectUtilities.equals(name, fontStyle.getName())) continue;
            return true;
        }
        return false;
    }

    public static FontStyle getStyle(boolean isBold, boolean isItalic) {
        HashSet<FontStyleProperty> properties = new HashSet<FontStyleProperty>();
        if (isBold) {
            properties.add(FontStyleProperty.BOLD);
        }
        if (isItalic) {
            properties.add(FontStyleProperty.ITALICS);
        }
        return FontStyle.getStyle(properties);
    }

    public static FontStyle getStyle(Set<FontStyleProperty> properties) {
        for (FontStyle style : FontStyle.values()) {
            if (!((Object)style.properties).equals(properties)) continue;
            return style;
        }
        throw new UnreachableCodeReachedException("(ip)");
    }

    public FontStyle derive(FontStyleProperty fontStyle, boolean enabled) {
        HashSet<FontStyleProperty> newProperties = new HashSet<FontStyleProperty>(this.properties);
        if (enabled) {
            newProperties.add(fontStyle);
        } else {
            newProperties.remove((Object)fontStyle);
        }
        return FontStyle.getStyle(newProperties);
    }

    public boolean isEnabled(FontStyleProperty fontStyle) {
        return this.properties.contains((Object)fontStyle);
    }
}

